/*******************************************************************************
 * Copyright 2023 NXP
 * NXP Confidential and Proprietary. This software is owned or controlled by NXP and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.system.browser2;

import org.eclipse.cdt.dsf.debug.service.IRunControl.IContainerSuspendedDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl.ISuspendedDMEvent;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;

/**
* DSF event listener class for the OS System Browser.
* This class calls update.
*/
public class DSFEventListener2 {
	final ContentProviderAutoUpdater2 provider;

	public DSFEventListener2(ContentProviderAutoUpdater2 contentProviderAutoUpdater) {
		provider = contentProviderAutoUpdater;
	}

	@DsfServiceEventHandler
	public void handleEvent(ISuspendedDMEvent event) {
		if (event instanceof IContainerSuspendedDMEvent) {
			provider.invalidate();
		}
	}
}
