/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.volkano.ui;

import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.volkano.VolkanoUtil;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoActivator;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoLoggingVerbosityTypes;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoUIMessage;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoWorkingModes;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VolkanoSettingsDialog
extends Dialog {
    private static final String WORKING_MODE = "WORKING_MODE";
    private static final String SERVER_HOSTNAME = "SERVER_HOSTNAME";
    private static final String SERVER_PORT = "SERVER_PORT";
    private static final String LOGGING_ENABLED = "LOGGING_ENABLED";
    private static final String LOGGING_VERBOSITY = "LOGGING_VERBOSITY";
    private static final String HOST_NAME_FORMAT = "^[a-zA-Z0-9.-]*$";
    private static final String PORT_FORMAT = "^[0-9]*$";
    private static final int MAXIMUM_PORT_VALUE = 65535;
    private static final int MINIMUM_PORT_VALUE = 1024;
    private Text textHostName;
    private Text textPort;
    private Button btnLogging;
    private Combo cmbWorkingMode;
    private Combo cmbLogging;
    private String workingMode;
    private String hostName;
    private String port;
    private String verbosity;
    private String enabled;
    private Path volkanoPath;
    private String volkanoLocation;
    private boolean isCanceled = false;

    public VolkanoSettingsDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Font systemFont = Display.getDefault().getSystemFont();
        FontData[] fontData = systemFont.getFontData();
        int heightHint = 0;
        if (fontData != null && fontData.length > 0) {
            heightHint = fontData[0].getHeight() * 2;
        }
        GridData dataParent = new GridData(4, 4, true, true, 1, 1);
        Composite cmps = new Composite(parent, 0);
        cmps.setLayout((Layout)new GridLayout(3, false));
        cmps.setLayoutData((Object)dataParent);
        GridData dataWorkingModeGroup = new GridData(4, 4, false, true, 1, 1);
        dataWorkingModeGroup.heightHint = heightHint;
        dataWorkingModeGroup.widthHint = 50;
        GridData dataRight = new GridData(4, 4, true, true, 4, 1);
        dataRight.heightHint = heightHint;
        dataRight.widthHint = 250;
        Group groupWorkingMode = new Group(cmps, 0);
        groupWorkingMode.setText("Working mode");
        groupWorkingMode.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        groupWorkingMode.setLayout((Layout)new GridLayout(4, false));
        Label lblWorkingMode = new Label((Composite)groupWorkingMode, 0);
        lblWorkingMode.setText(VolkanoUIMessage.Volkano_label_mode);
        lblWorkingMode.setLayoutData((Object)dataWorkingModeGroup);
        this.cmbWorkingMode = new Combo((Composite)groupWorkingMode, 8);
        this.cmbWorkingMode.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.cmbWorkingMode.setItems(VolkanoWorkingModes.getWorkingModes().toArray(new String[0]));
        this.cmbWorkingMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (VolkanoSettingsDialog.this.cmbWorkingMode.getText().equals(VolkanoWorkingModes.MANAGED_MODE.getName())) {
                    VolkanoSettingsDialog.this.textHostName.setEnabled(false);
                    VolkanoSettingsDialog.this.textPort.setEnabled(false);
                } else {
                    VolkanoSettingsDialog.this.textHostName.setEnabled(true);
                    VolkanoSettingsDialog.this.textPort.setEnabled(true);
                }
            }
        });
        this.volkanoPath = Paths.get(DebuggerUtils.substitute((String)"${S32DS_GDB_SERVER_DIR}/Debugger/Server/CCS/bin/"), "vlk_config.ini");
        this.volkanoLocation = this.volkanoPath.toString();
        Label lblHostName = new Label((Composite)groupWorkingMode, 0);
        lblHostName.setText(VolkanoUIMessage.Volkano_label_host);
        lblHostName.setLayoutData((Object)dataWorkingModeGroup);
        this.textHostName = new Text((Composite)groupWorkingMode, 2048);
        this.textHostName.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.textHostName.setText(VolkanoUtil.getValueFromFile((String)this.volkanoLocation, (String)SERVER_HOSTNAME));
        Label lblPort = new Label((Composite)groupWorkingMode, 0);
        lblPort.setText(VolkanoUIMessage.Volkano_label_port);
        lblPort.setLayoutData((Object)dataWorkingModeGroup);
        this.textPort = new Text((Composite)groupWorkingMode, 2048);
        this.textPort.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.textPort.setText(VolkanoUtil.getValueFromFile((String)this.volkanoLocation, (String)SERVER_PORT));
        String currentWorkingMode = VolkanoUtil.getValueFromFile((String)this.volkanoLocation, (String)WORKING_MODE);
        if (currentWorkingMode.equalsIgnoreCase(VolkanoWorkingModes.MANAGED_MODE.getName())) {
            this.cmbWorkingMode.select(VolkanoWorkingModes.MANAGED_MODE.getIndex());
            this.textHostName.setEnabled(false);
            this.textPort.setEnabled(false);
        } else {
            this.cmbWorkingMode.select(VolkanoWorkingModes.CLIENT_MODE.getIndex());
        }
        Group groupLogging = new Group(cmps, 0);
        groupLogging.setText("Logging");
        groupLogging.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        groupLogging.setLayout((Layout)new GridLayout(4, false));
        GridData dataLoggingGroup = new GridData(4, 4, false, false, 1, 1);
        dataLoggingGroup.heightHint = heightHint;
        dataLoggingGroup.widthHint = 70;
        Label lblLogging = new Label((Composite)groupLogging, 0);
        lblLogging.setText(VolkanoUIMessage.Volkano_label_logging);
        lblLogging.setLayoutData((Object)dataLoggingGroup);
        this.btnLogging = new Button((Composite)groupLogging, 32);
        this.btnLogging.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Label lblVerbosity = new Label((Composite)groupLogging, 0);
        lblVerbosity.setText(VolkanoUIMessage.Volkano_label_verbosity);
        lblVerbosity.setLayoutData((Object)dataLoggingGroup);
        this.cmbLogging = new Combo((Composite)groupLogging, 8);
        this.cmbLogging.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.cmbLogging.setItems(VolkanoLoggingVerbosityTypes.getVerbosityTypes().toArray(new String[0]));
        String verbosityValue = VolkanoUtil.getValueFromFile((String)this.volkanoLocation, (String)LOGGING_VERBOSITY);
        if (verbosityValue.equalsIgnoreCase(VolkanoLoggingVerbosityTypes.ERROR.getName())) {
            this.cmbLogging.select(VolkanoLoggingVerbosityTypes.ERROR.getIndex());
        } else if (verbosityValue.equalsIgnoreCase(VolkanoLoggingVerbosityTypes.DEBUG.getName())) {
            this.cmbLogging.select(VolkanoLoggingVerbosityTypes.DEBUG.getIndex());
        } else {
            this.cmbLogging.select(VolkanoLoggingVerbosityTypes.INFO.getIndex());
        }
        String loggingEnabled = VolkanoUtil.getValueFromFile((String)this.volkanoLocation, (String)LOGGING_ENABLED);
        this.btnLogging.setSelection(loggingEnabled.equalsIgnoreCase("true"));
        this.cmbLogging.setEnabled(loggingEnabled.equalsIgnoreCase("true"));
        this.btnLogging.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VolkanoSettingsDialog.this.cmbLogging.setEnabled(VolkanoSettingsDialog.this.btnLogging.getSelection());
            }
        });
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(VolkanoUIMessage.Volkano_settings_dialog_title);
        Image icon = VolkanoActivator.getBundle().getImage("S32DS_ICON");
        newShell.setImage(icon);
    }

    protected void okPressed() {
        if (this.validateInput()) {
            this.workingMode = this.cmbWorkingMode.getText().toLowerCase();
            this.hostName = this.textHostName.getText();
            this.port = this.textPort.getText();
            this.verbosity = this.cmbLogging.getText();
            this.enabled = String.valueOf(this.btnLogging.getSelection());
            this.updateValuesInConfigFile(this.workingMode, this.hostName, this.port, this.enabled, this.verbosity, this.volkanoLocation);
            this.close();
        }
    }

    private boolean validateInput() {
        this.hostName = this.textHostName.getText();
        this.port = this.textPort.getText();
        if (this.hostName.isEmpty() || this.port.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)VolkanoUIMessage.Volkano_settings_dialog_error_title, (String)VolkanoUIMessage.Volkano_empty_input_fields);
            return false;
        }
        if (!this.hostName.matches(HOST_NAME_FORMAT)) {
            MessageDialog.openError((Shell)this.getShell(), (String)VolkanoUIMessage.Volkano_settings_dialog_error_title, (String)VolkanoUIMessage.Volkano_invalid_host_name_error);
            return false;
        }
        if (!this.port.matches(PORT_FORMAT)) {
            MessageDialog.openError((Shell)this.getShell(), (String)VolkanoUIMessage.Volkano_settings_dialog_error_title, (String)VolkanoUIMessage.Volkano_invalid_port_error);
            return false;
        }
        if (Integer.parseInt(this.port) > 65535 || Integer.parseInt(this.port) < 1024) {
            MessageDialog.openError((Shell)this.getShell(), (String)VolkanoUIMessage.Volkano_settings_dialog_error_title, (String)VolkanoUIMessage.Volkano_port_value_error);
            return false;
        }
        return true;
    }

    private void updateValuesInConfigFile(String workingMode, String host, String port, String enabled, String verbosity, String filePath) {
        LinkedHashMap<String, String> updatedValues = new LinkedHashMap<String, String>();
        updatedValues.put(WORKING_MODE, workingMode);
        updatedValues.put(SERVER_HOSTNAME, host);
        updatedValues.put(SERVER_PORT, port);
        updatedValues.put(LOGGING_ENABLED, enabled);
        updatedValues.put(LOGGING_VERBOSITY, verbosity);
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (FileWriter fileWriter = new FileWriter(filePath);){
                for (String key : updatedValues.keySet()) {
                    fileWriter.write(String.format("%s=%s\n", key, updatedValues.get(key)));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            VolkanoActivator.getBundle().logError(ioe.getMessage());
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

