/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.yaml.converters;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.registers.RegistersFactory;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.model.Messages;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.resources.ProcessorFilterForPeripherals;
import com.nxp.swtools.periphs.model.yaml.PeriphsProfileInfo;
import com.nxp.swtools.periphs.model.yaml.YamlComponentInstance;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsStructuredSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsArraySetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsConfigSet;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsScalarSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsSetSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsStructSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigSet;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.setting.ArraySetting;
import com.nxp.swtools.resourcetables.model.data.setting.EnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.resourcetables.model.data.setting.StructSetting;
import com.nxp.swtools.utils.scripting.FileYamlContent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class YamlStorageConverter {
    private static final Logger LOGGER = LogManager.getLogger(YamlStorageConverter.class);

    public static StoragePeriphsTool toStorage(FileYamlContent<PeriphsProfileInfo, IYamlStorable> fileYamlContent, ISupportedDerivativesForSwTools supportedDerivatives) {
        StoragePeriphsTool storagePeripheralsTool = new StoragePeriphsTool();
        PeriphsProfileInfo profileInfo = (PeriphsProfileInfo)fileYamlContent.getProfileInfo();
        ArrayList yamlFuncGroups = (ArrayList)profileInfo.getFunctionalGroups();
        ArrayList<StoragePeriphsComponent> yamlComponents = new ArrayList<StoragePeriphsComponent>();
        IMcuIdentification mcuIdentification = profileInfo.getMcuIdentification();
        if (mcuIdentification.getMcu().equals("") && mcuIdentification.getPackage().equals("") && mcuIdentification.getSdkVersion().equals("")) {
            LOGGER.severe("[SDK] No MCU was loaded from YAML");
            return new StoragePeriphsTool();
        }
        IRegistersDatabaseAPI registersDb = RegistersFactory.loadRegistersDB((ISupportedDerivativesForSwTools)supportedDerivatives, (IMcuIdentification)mcuIdentification);
        if (registersDb == null) {
            LOGGER.warning(() -> MessageFormat.format("[TOOL] Cannot obtain location of registers for {0}, {1}", supportedDerivatives, mcuIdentification.getMcu()));
        }
        AvailableComponents components = new AvailableComponents(mcuIdentification, registersDb, ProcessorFilterForPeripherals.getInstance());
        for (IYamlStorable function : fileYamlContent.getFunctions()) {
            if (function == null) continue;
            String functionId = function.getYamlId();
            if (functionId.equals("instance")) {
                YamlComponentInstance parsedInstance = YamlStorageConverter.getComponentInstance(function, components);
                String funcGroupName = parsedInstance.getFunctionalGroupName();
                StoragePeriphsComponentInstance componentInstance = parsedInstance.getStorage();
                StoragePeriphsFuncGroup funcGroup = (StoragePeriphsFuncGroup)CollectionsUtils.nullableOptionalGet(yamlFuncGroups.stream().filter(y -> y.getName().equals(funcGroupName)).findAny());
                if (funcGroup != null) {
                    funcGroup.addInstance(componentInstance);
                    continue;
                }
                LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[TOOL] Could not add component instance: {0}. Functional group \"{1}\" was not found.", componentInstance.getName(), funcGroupName));
                continue;
            }
            if (!functionId.equals("component")) continue;
            yamlComponents.add(YamlStorageConverter.getComponent(function, components));
        }
        storagePeripheralsTool.setFuncGroups(yamlFuncGroups);
        storagePeripheralsTool.setComponents(yamlComponents);
        return storagePeripheralsTool;
    }

    public static List<StoragePeriphsFuncGroup> mergeFuncGroupsStorages(List<StoragePeriphsFuncGroup> storageFuncGroups, List<StoragePeriphsFuncGroup> yamlFuncGroups, boolean mergeCompFcGrStorages) {
        Map storageFuncGroupsMap = CollectionsUtils.linkedMapFromList(storageFuncGroups, StorageToolBaseConfiguration::getName);
        Map yamlFuncGroupsMap = CollectionsUtils.linkedMapFromList(yamlFuncGroups, StorageToolBaseConfiguration::getName);
        if (mergeCompFcGrStorages) {
            for (StoragePeriphsFuncGroup storageFnGroup : storageFuncGroupsMap.values()) {
                StoragePeriphsFuncGroup yamlFcGroup = (StoragePeriphsFuncGroup)yamlFuncGroupsMap.get(storageFnGroup.getName());
                if (yamlFcGroup == null || !yamlFcGroup.getSelectedCore().equals(storageFnGroup.getSelectedCore())) continue;
                HashMap<String, StoragePeriphsComponentInstance> components = new HashMap<String, StoragePeriphsComponentInstance>();
                yamlFcGroup.getInstances().forEach(x -> components.put(x.getName(), (StoragePeriphsComponentInstance)x));
                for (StoragePeriphsComponentInstance storagePeriphCompInst : storageFnGroup.getInstances()) {
                    if (components.get(storagePeriphCompInst.getName()) == null) {
                        components.put(storagePeriphCompInst.getName(), storagePeriphCompInst);
                        continue;
                    }
                    LOGGER.log(Level.WARNING, () -> MessageFormat.format("[TOOL] Previous configuration for \"{0}\" from the functional group \"{1}\" will be rewritten.", storagePeriphCompInst.getName(), storageFnGroup.getName()));
                }
                storageFnGroup.setInstances(new ArrayList(components.values()));
                storageFnGroup.setUUID(yamlFcGroup.getUUID());
                yamlFuncGroupsMap.remove(storageFnGroup.getName());
            }
        }
        storageFuncGroupsMap.putAll(yamlFuncGroupsMap);
        return CollectionsUtils.listFromMapValues((Map)storageFuncGroupsMap);
    }

    public static ArrayList<StoragePeriphsComponent> mergeComponentsStorages(ArrayList<StoragePeriphsComponent> storageComponents, List<StoragePeriphsComponent> yamlComponents, @Nullable Logger userLogger) {
        Map storageComponentsMap = CollectionsUtils.linkedMapFromList(storageComponents, AStoragePeriphsComponent::getName);
        Map yamlComponentsMap = CollectionsUtils.linkedMapFromList(yamlComponents, AStoragePeriphsComponent::getName);
        HashSet intersection = new HashSet(yamlComponentsMap.keySet());
        intersection.retainAll(storageComponentsMap.keySet());
        if (!intersection.isEmpty()) {
            String overwritenComps = intersection.stream().collect(Collectors.joining(", "));
            String errMsg = "[TOOL] Components: " + overwritenComps + " are overridden by imported components from YAML";
            LOGGER.log(Level.WARNING, errMsg);
            if (userLogger != null) {
                String localizedMessage = MessageFormat.format(UtilsText.safeString((String)Messages.get().YamlStorageConverter_OverridingComponentsByImport), overwritenComps);
                userLogger.log(Level.WARNING, localizedMessage);
            }
        }
        storageComponentsMap.putAll(yamlComponentsMap);
        return (ArrayList)CollectionsUtils.listFromMapValues((Map)storageComponentsMap);
    }

    public static YamlComponentInstance getComponentInstance(IYamlStorable yamlStorable, AvailableComponents components) {
        String funcGroup;
        StoragePeriphsComponentInstance storage;
        block41: {
            block38: {
                if (yamlStorable instanceof YamlStorableList) {
                    yamlStorable = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)yamlStorable));
                }
                storage = new StoragePeriphsComponentInstance();
                funcGroup = "";
                Collection yamlChildren = yamlStorable.getYamlChildren();
                if (yamlChildren == null) break block38;
                for (IYamlStorable item : yamlChildren) {
                    block39: {
                        String itemId;
                        if (item instanceof YamlStorableList) {
                            item = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)item));
                        }
                        if (!(item instanceof YamlStorableValue)) break block39;
                        String value = item.getYamlValue();
                        switch (itemId = item.getYamlId()) {
                            case "name": {
                                storage.setName(value);
                                break;
                            }
                            case "custom_name_enabled": {
                                storage.setCustomNameEnabled(Boolean.parseBoolean(value));
                                break;
                            }
                            case "type": {
                                storage.setType(value);
                                break;
                            }
                            case "mode": {
                                storage.setMode(value);
                                break;
                            }
                            case "peripheral": {
                                storage.setPeripheral(value);
                                break;
                            }
                            case "functional_group": {
                                funcGroup = value;
                                break;
                            }
                            case "type_id": {
                                storage.setType_id(value);
                                break;
                            }
                            case "editing_lock": {
                                storage.setEditingLockState(Boolean.parseBoolean(value));
                                break;
                            }
                            case "comment": {
                                storage.setComment(value.replaceAll("\\\\n", "\n"));
                                break;
                            }
                            case "from_use_case": {
                                storage.setOriginalUseCase(value);
                                break;
                            }
                        }
                        continue;
                    }
                    if (!(item instanceof YamlStorableList)) continue;
                    String confCompType = storage.getType_id();
                    ConfigurationComponentTypeId confComp = components.getConfigCompTypeId(confCompType);
                    if (confComp != null) {
                        CopyOnWriteArrayList<StoragePeriphsConfigSet> configSets = YamlStorageConverter.getConfigSets((YamlStorableList<? extends IYamlStorable>)((YamlStorableList)item), confComp.getConfigurationComponent());
                        storage.setConfig_sets(configSets);
                        continue;
                    }
                    LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] Could not parse YAML. Component with type ID \"{0}\" not found.", confCompType));
                }
                break block41;
            }
            LOGGER.log(Level.WARNING, "[TOOL] Could not parse incomplete YAML.");
        }
        return new YamlComponentInstance(storage, storage.getType_id(), funcGroup, storage.getType());
    }

    public static StoragePeriphsComponent getComponent(IYamlStorable yamlStorable, AvailableComponents components) {
        StoragePeriphsComponent storage;
        block14: {
            if (yamlStorable instanceof YamlStorableList) {
                yamlStorable = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)yamlStorable));
            }
            storage = new StoragePeriphsComponent();
            Collection yamlChildren = yamlStorable.getYamlChildren();
            if (yamlChildren == null) break block14;
            for (IYamlStorable item : yamlChildren) {
                block15: {
                    String itemId;
                    if (item instanceof YamlStorableList) {
                        item = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)item));
                    }
                    if (!(item instanceof YamlStorableValue)) break block15;
                    String value = item.getYamlValue();
                    switch (itemId = item.getYamlId()) {
                        case "type": {
                            storage.setName(value);
                            break;
                        }
                        case "type_id": {
                            storage.setTypeId(value);
                        }
                    }
                    continue;
                }
                if (!(item instanceof YamlStorableList)) continue;
                String confCompType = storage.getTypeId();
                ConfigurationComponentTypeId configCompTypeId = components.getBestMatchingConfigCompTypeId(storage);
                if (configCompTypeId != null) {
                    IConfigurationComponent confComp = configCompTypeId.getConfigurationComponent();
                    StoragePeriphsConfigSet storageConfigSet = YamlStorageConverter.getConfigSet(item, confComp);
                    storage.setConfig_set_global(storageConfigSet);
                    continue;
                }
                LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] Could not parse YAML. Component with type ID \"{0}\" not found.", confCompType));
            }
        }
        return storage;
    }

    private static CopyOnWriteArrayList<StoragePeriphsConfigSet> getConfigSets(YamlStorableList<? extends IYamlStorable> yamlConfigSets, IConfigurationComponent confComp) {
        CopyOnWriteArrayList<StoragePeriphsConfigSet> storageConfigSets = new CopyOnWriteArrayList<StoragePeriphsConfigSet>();
        IYamlStorable iYamlConfigSets = YamlStorableHelper.skipMapLayer(yamlConfigSets);
        Collection configSets = iYamlConfigSets.getYamlChildren();
        if (configSets != null) {
            for (IYamlStorable yamlConfigSet : configSets) {
                StoragePeriphsConfigSet storageConfigSet;
                if (yamlConfigSet == null) continue;
                if (yamlConfigSet instanceof YamlStorableList) {
                    yamlConfigSet = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)yamlConfigSet));
                }
                if ((storageConfigSet = YamlStorageConverter.getConfigSet(yamlConfigSet, confComp)) == null) continue;
                storageConfigSets.add(storageConfigSet);
            }
        }
        return storageConfigSets;
    }

    private static @Nullable StoragePeriphsConfigSet getConfigSet(IYamlStorable yamlConfigSet, IConfigurationComponent confComp) {
        if (yamlConfigSet instanceof YamlStorableList) {
            yamlConfigSet = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)yamlConfigSet));
        }
        StoragePeriphsConfigSet storageConfigSet = new StoragePeriphsConfigSet();
        IConfigSet configSet = confComp.findConfigSet(yamlConfigSet.getYamlId());
        if (configSet != null) {
            storageConfigSet.setName(yamlConfigSet.getYamlId());
            Collection settings = yamlConfigSet.getYamlChildren();
            if (settings != null) {
                for (IYamlStorable settingStorable : settings) {
                    if (settingStorable instanceof YamlStorableList) {
                        settingStorable = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)settingStorable));
                    }
                    if (settingStorable == null) continue;
                    if (settingStorable.getYamlId().equals("quick_selection")) {
                        storageConfigSet.setQuick_selection(settingStorable.getYamlValue());
                        continue;
                    }
                    AStoragePeriphsSetting newSetting = YamlStorageConverter.getSetting(settingStorable, configSet, new ArrayList<String>());
                    if (newSetting == null) continue;
                    storageConfigSet.addSetting(newSetting);
                }
            }
        } else {
            LOGGER.log(Level.SEVERE, MessageFormat.format("[TOOL] Could not parse YAML. Config set \"{0}\" was not found", yamlConfigSet.getYamlId()));
            return null;
        }
        return storageConfigSet;
    }

    private static @Nullable AStoragePeriphsSetting getSetting(IYamlStorable yamlStorable, IConfigSet configSet, ArrayList<String> parents) {
        if (yamlStorable instanceof YamlStorableList) {
            yamlStorable = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)yamlStorable));
        }
        StoragePeriphsArraySetting newSetting = null;
        if (yamlStorable instanceof YamlStorableList) {
            ISetting setting;
            String settingId = yamlStorable.getYamlId();
            String[] settingFullId = parents.toArray(new String[parents.size() + 1]);
            settingFullId[parents.size()] = settingId;
            ISetting iSetting = setting = parents.isEmpty() ? configSet.find(new String[]{settingId}) : configSet.find(settingFullId);
            if (setting != null) {
                if (setting instanceof ArraySetting) {
                    newSetting = new StoragePeriphsArraySetting();
                } else if (setting instanceof StructSetting) {
                    newSetting = new StoragePeriphsStructSetting();
                } else if (setting instanceof ConfigSet) {
                    newSetting = new StoragePeriphsConfigSet();
                } else {
                    LOGGER.log(Level.SEVERE, MessageFormat.format("[TOOL] Could not create storage for setting: {0}", setting.getId()));
                    return null;
                }
                Collection settings = yamlStorable.getYamlChildren();
                if (settings != null) {
                    parents.add(settingId);
                    for (IYamlStorable settingStorable : settings) {
                        if (settingStorable == null) continue;
                        if (settingStorable instanceof YamlStorableList) {
                            settingStorable = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)settingStorable));
                        }
                        if ("quick_selection".equals(settingStorable.getYamlId())) {
                            ((StoragePeriphsStructSetting)newSetting).setQuickSelection(settingStorable.getYamlValue());
                            continue;
                        }
                        AStoragePeriphsSetting newSettingFromYaml = YamlStorageConverter.getSetting(settingStorable, configSet, parents);
                        if (newSettingFromYaml == null) continue;
                        ((AStoragePeriphsStructuredSetting)newSetting).addSetting(newSettingFromYaml);
                    }
                    parents.remove(parents.size() - 1);
                }
                newSetting.setName(yamlStorable.getYamlId());
                return newSetting;
            }
            LOGGER.log(Level.WARNING, MessageFormat.format("[TOOL] Could not find setting: {0}", settingId));
        } else if (yamlStorable instanceof YamlStorableValue) {
            ISetting setting;
            String settingId = yamlStorable.getYamlId();
            String[] settingFullId = parents.toArray(new String[parents.size() + 1]);
            settingFullId[parents.size()] = settingId;
            ISetting iSetting = setting = parents.isEmpty() ? configSet.find(new String[]{settingId}) : configSet.find(settingFullId);
            if (setting != null) {
                if (setting instanceof SetSetting && !(setting instanceof EnumSetting)) {
                    newSetting = new StoragePeriphsSetSetting();
                    List<String> selected = Arrays.asList(yamlStorable.getYamlValue().split(" "));
                    if (!selected.isEmpty() && !selected.get(0).isEmpty()) {
                        ((StoragePeriphsSetSetting)newSetting).setSelected(new ArrayList<String>(Arrays.asList(yamlStorable.getYamlValue().split(" "))));
                    }
                    ((StoragePeriphsSetSetting)newSetting).setName(yamlStorable.getYamlId());
                } else {
                    newSetting = new StoragePeriphsScalarSetting();
                    ((StoragePeriphsScalarSetting)newSetting).setValue(yamlStorable.getYamlValue());
                    ((StoragePeriphsScalarSetting)newSetting).setName(yamlStorable.getYamlId());
                }
            } else {
                LOGGER.log(Level.WARNING, MessageFormat.format("[TOOL] Could not find setting: {0}", settingId));
            }
        }
        return newSetting;
    }
}

