/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.templates.component;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.ComponentInfo;
import com.nxp.swtools.kex.api.IComponentReference;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplate;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Version;

public class ComponentTemplateProperties {
    public static final String FILENAME_OF_TEMPLATE_PROPERTIES = "usecase.properties";
    public static final String ATTRIBUTE_TYPE_ID = "type_id";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_ORIGINAL_PACKAGE = "original_package";
    public static final String ATTRIBUTE_ORIGINAL_CORE = "original_core";
    public static final String ATTRIBUTE_SW_COMP_REFS = "sw_comp_refs";
    private static final Logger LOGGER = LogManager.getLogger(ComponentTemplateProperties.class);
    private String name;
    private String description;
    private String type;
    private String typeid;
    private String originalPackage;
    private String originalCore;
    private String folderPath;
    private List<SWComponent> swCompRefs = Collections.emptyList();

    public ComponentTemplateProperties(String name, String description, String type, String typeid, String originalPackage, String originalCore, String folderPath, List<SWComponent> swCompRefs) {
        this.name = name;
        this.description = description.replaceAll("\\r\\n|\\n", "\\\\n");
        this.type = type;
        this.typeid = typeid;
        this.originalPackage = originalPackage;
        this.originalCore = originalCore;
        this.folderPath = folderPath;
        this.swCompRefs = swCompRefs;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description.replaceAll("\\\\n", "\n");
    }

    private String getDescriptionWithoutFormatting() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeId() {
        return this.typeid;
    }

    public String getOriginalPackage() {
        return this.originalPackage;
    }

    public String getOriginalCore() {
        return this.originalCore;
    }

    public List<SWComponent> getSwCompRefs() {
        return this.swCompRefs;
    }

    public String getNameWithTypeId() {
        return String.valueOf(this.name) + "_" + this.typeid;
    }

    public @Nullable ComponentTemplate getTemplate() {
        return ComponentTemplate.loadTemplateFromFile(new File(this.folderPath, "component.usecase"));
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.type, this.typeid, this.originalPackage, this.originalCore, this.swCompRefs);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ComponentTemplateProperties)) {
            return false;
        }
        ComponentTemplateProperties other = (ComponentTemplateProperties)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.typeid, other.typeid)) {
            return false;
        }
        if (!Objects.equals(this.originalPackage, other.originalPackage)) {
            return false;
        }
        if (!Objects.equals(this.originalCore, other.originalCore)) {
            return false;
        }
        return Objects.equals(this.swCompRefs, other.swCompRefs);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable ComponentTemplateProperties loadFromFile(File file) {
        name = "";
        description = "";
        type = "";
        typeid = "";
        originalPackage = "";
        originalCore = "";
        swCompRefs = new ArrayList<SWComponent>();
        try {
            var8_8 = null;
            var9_11 = null;
            try {
                reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
                try {
                    while (true) lbl-1000:
                    // 10 sources

                    {
                        if ((line = reader.readLine()) == null) {
                            if (!"".equals(name)) break;
                            return null;
                        }
                        splitLine = line.split("=");
                        if (splitLine.length != 2) continue;
                        property = splitLine[0];
                        value = splitLine[1];
                        var15_18 = property;
                        tmp = -1;
                        switch (var15_18.hashCode()) {
                            case -1724546052: {
                                if (!var15_18.equals("description")) break;
                                tmp = 1;
                                break;
                            }
                            case -853090240: {
                                if (!var15_18.equals("type_id")) break;
                                tmp = 2;
                                break;
                            }
                            case -32714411: {
                                if (!var15_18.equals("sw_comp_refs")) break;
                                tmp = 3;
                                break;
                            }
                            case 3373707: {
                                if (!var15_18.equals("name")) break;
                                tmp = 4;
                                break;
                            }
                            case 3575610: {
                                if (!var15_18.equals("type")) break;
                                tmp = 5;
                                break;
                            }
                            case 132973528: {
                                if (!var15_18.equals("original_package")) break;
                                tmp = 6;
                                break;
                            }
                            case 1862883661: {
                                if (!var15_18.equals("original_core")) break;
                                tmp = 7;
                                break;
                            }
                        }
                        switch (tmp) {
                            case 4: {
                                name = value;
                                ** break;
                            }
                            case 1: {
                                description = value;
                                ** break;
                            }
                            case 5: {
                                type = value;
                                ** break;
                            }
                            case 2: {
                                typeid = value;
                                ** break;
                            }
                            case 6: {
                                originalPackage = value;
                                ** break;
                            }
                            case 7: {
                                originalCore = value;
                                ** break;
                            }
                            case 3: {
                                parsedReferences = ComponentInfo.parseReferences((String)value, (String)name);
                                var18_21 = parsedReferences.iterator();
                                while (true) {
                                    if (!var18_21.hasNext()) ** break;
                                    ref = (IComponentReference)var18_21.next();
                                    matchString = ref.getDriverMatch();
                                    sdkComponentMatch = SWComponent.Match.getMatchByName((String)matchString);
                                    if (sdkComponentMatch == null) {
                                        sdkComponentMatch = SWComponent.Match.EQUIVALENT;
                                    }
                                    swCompRefs.add(new SWComponent(ref.getDriverName(), Version.parseVersion((String)ref.getDriverVersion()), sdkComponentMatch, null, ref.isDriverRequired()));
                                }
                            }
                        }
                    }
                    if ("".equals(type)) {
                        return null;
                    }
                    if ("".equals(typeid) == false) return new ComponentTemplateProperties(name, description, type, typeid, originalPackage, originalCore, UtilsText.safeString((String)file.getAbsoluteFile().getParent()), swCompRefs);
                    return null;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable var9_12) {
                if (var8_8 == null) {
                    var8_8 = var9_12;
                    throw var8_8;
                }
                if (var8_8 == var9_12) throw var8_8;
                var8_8.addSuppressed(var9_12);
                throw var8_8;
            }
        }
        catch (FileNotFoundException v0) {
            ComponentTemplateProperties.LOGGER.log(Level.SEVERE, "Given file \"{0}\" was not found", file.getAbsolutePath());
            return null;
        }
        catch (IOException e) {
            ComponentTemplateProperties.LOGGER.log(Level.SEVERE, "I/O exception occurred during loading of component template properties: {0}", e.getLocalizedMessage());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean saveToFile(ComponentTemplateProperties properties, File file) {
        StringJoiner builder = new StringJoiner("\r\n");
        builder.add("name=" + properties.getName());
        builder.add("description=" + properties.getDescriptionWithoutFormatting());
        builder.add("type=" + properties.getType());
        builder.add("type_id=" + properties.getTypeId());
        builder.add("original_package=" + properties.getOriginalPackage());
        builder.add("original_core=" + properties.getOriginalCore());
        StringJoiner propertyJoiner = new StringJoiner(",");
        for (SWComponent sWComponent : properties.getSwCompRefs()) {
            StringJoiner swCompRefJoiner = new StringJoiner(";");
            swCompRefJoiner.add(sWComponent.getName());
            swCompRefJoiner.add(sWComponent.getVersionStr());
            swCompRefJoiner.add(sWComponent.getMatchString());
            swCompRefJoiner.add(String.valueOf(sWComponent.getRequired()));
            propertyJoiner.add(swCompRefJoiner.toString());
        }
        builder.add("sw_comp_refs=" + propertyJoiner.toString());
        try {
            Throwable throwable = null;
            Iterator<SWComponent> iterator = null;
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(builder.toString());
            }
            catch (Throwable throwable2) {
                void var4_10;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var4_10;
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Writing component template properties file failed because of: {0}", iOException.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public static ComponentTemplateProperties createPropertiesFromTemplate(ComponentTemplate template, String pathToFolder) {
        return new ComponentTemplateProperties(template.getName(), template.getDescription(), template.getType(), template.getTypeId(), template.getOriginalPackage(), template.getOriginalCore(), pathToFolder, template.getSwCompRefs());
    }
}

