/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.emit;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.WrappedContext;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.ActiveComponents;
import com.nxp.swtools.periphs.model.data.AssertFragment;
import com.nxp.swtools.periphs.model.data.BrFragment;
import com.nxp.swtools.periphs.model.data.Code;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.data.Def;
import com.nxp.swtools.periphs.model.data.ExprFragment;
import com.nxp.swtools.periphs.model.data.Fragment;
import com.nxp.swtools.periphs.model.data.FragmentDefs;
import com.nxp.swtools.periphs.model.data.From;
import com.nxp.swtools.periphs.model.data.IFragment;
import com.nxp.swtools.periphs.model.data.IfFragment;
import com.nxp.swtools.periphs.model.data.Import;
import com.nxp.swtools.periphs.model.data.Param;
import com.nxp.swtools.periphs.model.data.Section;
import com.nxp.swtools.periphs.model.data.TextFragment;
import com.nxp.swtools.resourcetables.model.config.ExpressionFunctions;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.data.IConfigSet;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.emit.ICodeEmitter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeEmitter
implements ICodeEmitter {
    private static final Logger LOGGER = LogManager.getLogger(CodeEmitter.class);
    public static final String PARAM_PREFIX = "$param.";
    private static final Pattern PTRN_TEXT = Pattern.compile("(?:\\$\\{(\\w+)\\})");
    private static final int GROUP_TEXT_FRAG_ID = 1;
    private static final String SETTING_INDEX = "_index";
    private static final String SETTING_LAST = "_last";
    private ConfigSetConfig config;
    private String currentConfigSetId;
    private FragmentDefContext localSearchCtx;

    public CodeEmitter(ConfigSetConfig config) {
        this.config = config;
        this.currentConfigSetId = config.getConfigSet().getId();
        this.localSearchCtx = new FragmentDefContext(config);
    }

    private static String settingName(String paramId) {
        return PARAM_PREFIX + paramId;
    }

    private void defineSetting(Param param, WrappedContext ctx, FragmentDefContext searchCtx) {
        String settingName = PARAM_PREFIX + param.getId();
        Expression expr = param.getExpr();
        if (expr != null) {
            ctx.defineSetting(settingName, expr.resolve((IContext)ctx).getValue());
            return;
        }
        String value = this.emit(param.getValue(), ctx, searchCtx).toString();
        ctx.defineSetting(settingName, (Object)value);
    }

    private void defineSettings(Fragment frag, WrappedContext ctx, FragmentDefContext searchCtx) {
        Collection<Param> params = frag.getParams().values();
        FragmentDefContext paramSearchCtx = searchCtx.makeCopy();
        for (Param param : params) {
            if (param == null) continue;
            this.defineSetting(param, ctx, paramSearchCtx);
            paramSearchCtx.adopt(searchCtx);
        }
    }

    public StringBuffer emit(String target) {
        this.currentConfigSetId = this.config.getConfigSet().getId();
        Code code = ((ConfigSet)this.config.getConfigSet()).getCode();
        Section section = code.getSection(target);
        if (section != null) {
            return this.emit(section);
        }
        return new StringBuffer();
    }

    private StringBuffer emit(Section section) throws IllegalArgumentException {
        StringBuffer result = new StringBuffer();
        WrappedContext cCtx = new WrappedContext(this.config.getExpressionContext());
        FragmentDefContext fSearchCtx = this.localSearchCtx.makeCopy();
        try {
            for (IFragment f : section.getFragments()) {
                this.emitFragmentInto(result, f, cCtx, fSearchCtx);
                fSearchCtx.adopt(this.localSearchCtx);
                cCtx.resetSettings();
            }
        }
        catch (Exception e) {
            ExpressionException exception = new ExpressionException("CodeEmitter.emit() failed due to the inner exception: ", (Throwable)e, CodeEmitter.class);
            exception.addContext((IContext)cCtx);
            throw exception;
        }
        return result;
    }

    private static String emit(BrFragment frag) {
        return frag.toString();
    }

    private static String emit(ExprFragment frag, IContext cCtx) {
        if (!CodeEmitter.evaluateIfExpr(frag.getIfExpr(), cCtx)) {
            return "";
        }
        return CodeEmitter.evaluateExpr(frag.getExpr(), cCtx);
    }

    private StringBuffer emit(Fragment frag, WrappedContext cCtx, FragmentDefContext searchCtx) throws IllegalArgumentException {
        StringBuffer result;
        if (!CodeEmitter.evaluateIfExpr(frag.getIfExpr(), (IContext)cCtx)) {
            return new StringBuffer();
        }
        IContext prevSource = cCtx.getSource();
        if (!frag.getApplyTo().isEmpty()) {
            Object reference = Expression.create((String)frag.getApplyTo()).resolve((IContext)cCtx).getValue();
            if (reference instanceof ISettingConfig) {
                cCtx.setSource(((ISettingConfig)reference).getExpressionContext());
            } else {
                throw new IllegalArgumentException(String.format("Invalid apply_to \"%1s\" for fragment id: %2s", frag.getApplyTo(), frag.getId()));
            }
        }
        if (!frag.getForElementsOf().isEmpty()) {
            result = new StringBuffer();
            Object reference = Expression.create((String)frag.getForElementsOf()).resolve((IContext)cCtx).getValue();
            List elements = ExpressionFunctions.listAdapter((Object)reference);
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Invalid for_elements_of \"%1s\" for fragment id: %2s", frag.getForElementsOf(), frag.getId()));
            }
            int lastIndex = elements.size() - 1;
            int index = 0;
            FragmentDefContext elementSearchCtx = searchCtx.makeCopy();
            for (Object element : elements) {
                if (element instanceof IChild) {
                    IChild settingConfig = (IChild)element;
                    if (settingConfig.isAvailable()) {
                        Map backup = cCtx.exportPersistentSettings();
                        cCtx.definePersistentSetting(CodeEmitter.settingName(SETTING_INDEX), (Object)index);
                        cCtx.definePersistentSetting(CodeEmitter.settingName(SETTING_LAST), (Object)(index == lastIndex ? 1 : 0));
                        cCtx.setSource(settingConfig.getExpressionContext());
                        result.append(this.emitRecursively(frag, cCtx, elementSearchCtx));
                        elementSearchCtx.adopt(searchCtx);
                        cCtx.importPersistentSettings(backup);
                    }
                } else {
                    throw new IllegalArgumentException(String.format("Invalid element in for_elements_of \"%1s\" for fragment id: %2s", frag.getForElementsOf(), frag.getId()));
                }
                ++index;
            }
            cCtx.setSource(prevSource);
            return result;
        }
        result = this.emitRecursively(frag, cCtx, searchCtx);
        cCtx.setSource(prevSource);
        return result;
    }

    private StringBuffer emit(TextFragment frag, WrappedContext cCtx, FragmentDefContext searchCtx) throws IllegalArgumentException {
        if (!CodeEmitter.evaluateIfExpr(frag.getIfExpr(), (IContext)cCtx)) {
            return new StringBuffer();
        }
        return this.emit(frag.getText(), cCtx, searchCtx);
    }

    private StringBuffer emit(String text, WrappedContext cCtx, FragmentDefContext searchCtx) throws IllegalArgumentException {
        StringBuffer result = new StringBuffer();
        Matcher matcher = PTRN_TEXT.matcher(text);
        FragmentDefContext iSearchCtx = searchCtx.makeCopy();
        while (matcher.find()) {
            @Nullable String fragId = matcher.group(1);
            matcher.appendReplacement(result, "");
            if (fragId == null) continue;
            Def def = this.findFragmentDef(fragId, (IContext)cCtx, iSearchCtx);
            if (def == null) {
                throw new IllegalArgumentException(String.format("Invalid fragment id: %1s", fragId));
            }
            def.getFragments().forEach(f -> this.emitFragmentInto(result, (IFragment)f, cCtx, iSearchCtx));
            searchCtx.adopt(searchCtx);
        }
        matcher.appendTail(result);
        return result;
    }

    private void emitFragmentInto(StringBuffer result, IFragment frag, WrappedContext cCtx, FragmentDefContext searchCtx) throws IllegalArgumentException {
        if (frag instanceof IfFragment) {
            IfFragment ifFrag = (IfFragment)frag;
            if (!CodeEmitter.evaluateIfExpr(ifFrag.getIfExpr(), (IContext)cCtx)) {
                return;
            }
            FragmentDefContext fSearchCtx = searchCtx.makeCopy();
            for (IFragment f : ifFrag.getFragments()) {
                this.emitFragmentInto(result, f, cCtx, fSearchCtx);
                fSearchCtx.adopt(searchCtx);
            }
        } else if (frag instanceof AssertFragment) {
            AssertFragment assFrag = (AssertFragment)frag;
            if (SWToolsProperties.isVerificationOn() && !CodeEmitter.evaluateIfExpr(assFrag.getExpr(), (IContext)cCtx)) {
                Expression expr = assFrag.getMessageExpr();
                String message = expr != null ? expr.resolve((IContext)cCtx).getString() : assFrag.getMessage();
                LOGGER.log(Level.SEVERE, String.format("[DATA] Assertion failed in configuration set with ID '%1s': %2s", this.currentConfigSetId, message.isEmpty() ? assFrag.toString() : message));
            }
        } else if (frag instanceof BrFragment) {
            result.append(CodeEmitter.emit((BrFragment)frag));
        } else if (frag instanceof ExprFragment) {
            result.append(CodeEmitter.emit((ExprFragment)frag, (IContext)cCtx));
        } else if (frag instanceof Fragment) {
            result.append(this.emit((Fragment)frag, cCtx, searchCtx));
        } else if (frag instanceof TextFragment) {
            result.append(this.emit((TextFragment)frag, cCtx, searchCtx));
        } else {
            throw new IllegalArgumentException("Section contains unknown fragments");
        }
    }

    private StringBuffer emitRecursively(Fragment frag, WrappedContext cCtx, FragmentDefContext searchCtx) throws IllegalArgumentException {
        StringBuffer result = new StringBuffer();
        Def def = this.findFragmentDef(frag.getId(), (IContext)cCtx, searchCtx);
        if (def == null) {
            throw new IllegalArgumentException(String.format("Invalid fragment id: %1s", frag.getId()));
        }
        FragmentDefContext fSearchCtx = searchCtx.makeCopy();
        for (IFragment f : def.getFragments()) {
            Map backup = cCtx.exportSettings();
            this.defineSettings(frag, cCtx, fSearchCtx);
            this.emitFragmentInto(result, f, cCtx, fSearchCtx);
            fSearchCtx.adopt(searchCtx);
            cCtx.importSettings(backup);
        }
        return result;
    }

    private static String evaluateExpr(@Nullable Expression expr, IContext ctx) {
        if (expr == null) {
            return "";
        }
        try {
            return expr.resolve(ctx).getString();
        }
        catch (Exception e) {
            ExpressionException exception = new ExpressionException("CodeEmitter.evaluateExpr() failed due to the inner exception", (Throwable)e, CodeEmitter.class);
            exception.addContext(ctx);
            throw exception;
        }
    }

    private static boolean evaluateIfExpr(@Nullable Expression expr, IContext ifCtx) {
        if (expr == null) {
            return true;
        }
        return expr.resolve(ifCtx).getBoolean();
    }

    private @Nullable Def findFragmentDef(String fragment, IContext ctx, FragmentDefContext searchCtx) throws IllegalArgumentException {
        FragmentDefs defs = ((ConfigSet)searchCtx.getConfigSet()).getFragmentDefs();
        Def local = CodeEmitter.findFragmentDef(fragment, defs);
        if (local != null) {
            return local;
        }
        Import imports = defs.getImport();
        if (imports != null) {
            for (From f : imports.getFroms()) {
                IConfigSet importSet;
                IConfigurationComponent importComp;
                IValue value;
                Expression ifExpr = f.getIfExpr();
                if (ifExpr != null && (value = ifExpr.resolve(ctx)).getValue().equals(Boolean.FALSE)) continue;
                String importCompId = f.getComponentRefID();
                if (importCompId != null) {
                    importComp = searchCtx.getActiveComponents().getConfigComp(importCompId);
                    if (importComp == null) {
                        throw new IllegalArgumentException(String.format("Invalid component id: %1s", importCompId));
                    }
                } else {
                    importComp = searchCtx.getConfigurationComponent();
                    importCompId = importComp.getId();
                }
                if ((importSet = importComp.getConfigSet(f.getConfigSetRefID())) == null) {
                    throw new IllegalArgumentException(String.format("Invalid config_set id: %1s", f.getConfigSetRefID()));
                }
                FragmentDefContext importCtx = new FragmentDefContext(importSet, importComp, searchCtx.getActiveComponents());
                Def imported = this.findFragmentDef(fragment, ctx, importCtx);
                if (imported == null) continue;
                if (!CodeEmitter.canImport(imported, f, searchCtx.getConfigurationComponent().getId(), ctx)) {
                    LOGGER.log(Level.SEVERE, String.format("[DATA] Cannot import %1s declared in %2s since it's not public in the provided %3s", f.toString(), imported.toString(), ctx.getClass().getName()));
                    return null;
                }
                this.currentConfigSetId = importSet.getId();
                searchCtx.adopt(importCtx);
                return imported;
            }
        }
        return null;
    }

    private static boolean canImport(Def targetDef, From targetComp, String parentCompId, IContext ctx) {
        boolean externComp;
        String compId = targetComp.getComponentRefID();
        boolean bl = externComp = compId != null && !parentCompId.equals(compId);
        return !externComp || targetDef.isPublic(ctx);
    }

    private static @Nullable Def findFragmentDef(String fragment, FragmentDefs defs) {
        return defs.getDef(fragment);
    }

    public IConfigSetConfig getConfig() {
        return this.config;
    }

    static class FragmentDefContext {
        private IConfigSet configSet;
        private IConfigurationComponent configComp;
        private ActiveComponents activeComps;

        FragmentDefContext(IConfigSet configSet, IConfigurationComponent configComp, ActiveComponents activeComps) {
            this.configSet = configSet;
            this.configComp = configComp;
            this.activeComps = activeComps;
        }

        FragmentDefContext(IConfigSetConfig config) {
            this(config.getConfigSet(), FragmentDefContext.getConfigComp(config), ((PeriphsProfile)config.getChildContext().getRoot()).getActiveComponents());
        }

        private static IConfigurationComponent getConfigComp(IConfigSetConfig config) {
            IComponentConfig compConf = config.getChildContext().getComponentConfig();
            assert (compConf != null);
            return compConf.getComponent();
        }

        public void adopt(FragmentDefContext other) {
            this.configSet = other.configSet;
            this.configComp = other.configComp;
            this.activeComps = other.activeComps;
        }

        public IConfigSet getConfigSet() {
            return this.configSet;
        }

        public ActiveComponents getActiveComponents() {
            return this.activeComps;
        }

        public IConfigurationComponent getConfigurationComponent() {
            return this.configComp;
        }

        public FragmentDefContext makeCopy() {
            return new FragmentDefContext(this.configSet, this.configComp, this.activeComps);
        }
    }
}

