/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="processor_restrictions", strict=false)
@Namespace(prefix="restrictions")
public class ProcessorRestrictions {
    public static final String FILE_EXTENSION = ".restrictions";
    private static final Logger LOGGER = LogManager.getLogger(ProcessorRestrictions.class);
    @Attribute(name="type", required=true)
    private RestrictionsType type = RestrictionsType.blacklist;
    @ElementList(inline=true, required=false, entry="processor")
    private List<String> processors = new ArrayList<String>();

    public RestrictionsType getType() {
        return this.type;
    }

    public List<String> getProcessors() {
        return this.processors;
    }

    public boolean isAllowed(String processor) {
        switch (this.type) {
            case blacklist: {
                return !this.containsRestrictionFor(processor);
            }
            case whitelist: {
                return this.containsRestrictionFor(processor);
            }
        }
        LOGGER.severe(MessageFormat.format("[DATA] Unknown type of processor restrictions: {0}", new Object[]{this.type}));
        return false;
    }

    private boolean containsRestrictionFor(String processor) {
        return this.getProcessors().stream().anyMatch(r -> processor.matches((String)r));
    }

    public static @Nullable ProcessorRestrictions loadFromFile(File source) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = UtilsDecryption.getFileInputStream((File)source);){
                return (ProcessorRestrictions)new Persister().read(ProcessorRestrictions.class, is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] Error loading procesor restrictions file: {0}", source.getAbsolutePath()), e);
            return null;
        }
    }

    public static enum RestrictionsType {
        blacklist,
        whitelist;

    }
}

