/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.xml.UtilsXML;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.data.InitializationPrioritiesGroup;
import com.nxp.swtools.periphs.model.data.XMLConstants;
import com.nxp.swtools.resourcetables.model.XSDUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import org.xml.sax.SAXException;

@Root(name="priorities", strict=false)
@Namespace(prefix="priorities", reference="http://swtools.freescale.net/XSD/categories/1.0")
public class InitializationPriorities {
    private static final Logger LOGGER = LogManager.getLogger(InitializationPriorities.class);
    private static final String LOCAL_SCHEMA = XMLConstants.INITIALIZATION_PRIORITIES_SCHEMA_FILENAME;
    public static final String DEFAULT_FILE_NAME = "initialization_priorities.xml";
    @Attribute(name="schemaLocation", required=false)
    @Namespace(prefix="xsi", reference="http://www.w3.org/2001/XMLSchema-instance")
    private String schemaLocation = XMLConstants.INITIALIZATION_PRIORITIES_SCHEMA_LOC;
    @Attribute(name="default_group")
    private String defaultGroupName = "";
    @ElementList(inline=true, required=false)
    private List<InitializationPrioritiesGroup> groups = new ArrayList<InitializationPrioritiesGroup>();

    @Deprecated
    public InitializationPriorities() {
    }

    public InitializationPriorities(String defaultGroup, List<InitializationPrioritiesGroup> groups) {
        this.defaultGroupName = defaultGroup;
        this.groups = groups;
    }

    public String getDefaultGroupName() {
        return this.defaultGroupName;
    }

    public List<InitializationPrioritiesGroup> getGroups() {
        return CollectionsUtils.unmodifiableList(this.groups);
    }

    public List<InitializationPrioritiesGroup> getSortedGroups() {
        return (List)this.groups.stream().sorted((group1, group2) -> (int)(group2.getPriority() - group1.getPriority())).collect(CollectorsUtils.toList());
    }

    public String getSchemaLocation() {
        String[] locPair = this.schemaLocation.split(" ");
        if (2 != locPair.length) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe(MessageFormat.format("[DATA] Initialization priorities specifies an invalid schema location {0}", this.schemaLocation));
            }
            return "";
        }
        return locPair[1];
    }

    public static @Nullable InitializationPriorities loadPrioritiesFromFile(File source) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream prioritiesStream = UtilsDecryption.getFileInputStream((File)source);){
                Persister serializer = new Persister();
                InitializationPriorities result = (InitializationPriorities)serializer.read(InitializationPriorities.class, prioritiesStream);
                if (SWToolsProperties.isVerificationOn()) {
                    try {
                        URL schema;
                        try {
                            schema = new URL(result.getSchemaLocation());
                            XSDUtils.verifySchemaVersion((URL)schema, (File)source);
                        }
                        catch (MalformedURLException e) {
                            LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] Invalid schema URL in initialization priorities file {0}", source.getAbsolutePath()), e);
                            schema = null;
                        }
                        UtilsXML.validXml((InputStream)UtilsDecryption.getFileInputStream((File)source), (URL)schema, (Path)InitializationPriorities.getFallbackSchemaLocation());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] Missing schema for initialization priorities file {0}", source.getAbsolutePath()), e);
                    }
                    catch (SAXException e) {
                        LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] Invalid initialization priorities file {0}", source.getAbsolutePath()), e);
                    }
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] Error loading initialization priorities file {0}", source.getAbsolutePath()), e);
            return null;
        }
    }

    private static Path getFallbackSchemaLocation() {
        return Paths.get(Platform.isRunning() ? PEConfiguration.getSystemDirectory() : "", "initialization_priorities", "schemas", LOCAL_SCHEMA);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitializationPriorities other = (InitializationPriorities)obj;
        if (!Objects.equals(this.groups, other.groups)) {
            return false;
        }
        return Objects.equals(this.defaultGroupName, other.defaultGroupName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hash(this.defaultGroupName, this.groups);
        return result;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[defaultGroupName=" + this.defaultGroupName + ", groups={" + this.groups + "}]";
    }
}

