/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.resources.AProcessorFilterForPeripherals;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.resourcetables.model.config.EmptyRoot;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.data.AvailableResourceTablesRefResolver;
import com.nxp.swtools.resourcetables.model.data.IActiveContextRefContainer;
import com.nxp.swtools.resourcetables.model.data.McuResourceTables;
import com.nxp.swtools.resourcetables.model.data.ResourceTable;
import com.nxp.swtools.resourcetables.model.data.ResourceTableInfo;
import com.nxp.swtools.resourcetables.model.data.ResourceTablesProvider;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class AvailableResourceTables
implements IActiveContextRefContainer {
    private static final Logger LOGGER = LogManager.getLogger(AvailableResourceTables.class);
    protected Map<String, ResourceTableInfo> resourceTableInfos;
    protected Map<ResourceTable, Map<String, ISettingConfig>> configs;

    public AvailableResourceTables(McuResourceTables mcuResourceTables, AvailableComponents activeComponents, AProcessorFilterForPeripherals toolFilter) {
        this.resourceTableInfos = this.loadResourceTables(mcuResourceTables, activeComponents, toolFilter);
        new AvailableResourceTablesRefResolver((IActiveContextRefContainer)this).resolve();
        this.configs = new HashMap<ResourceTable, Map<String, ISettingConfig>>();
    }

    public void associateResources(ICommonMcu mcu) {
        this.configs.clear();
        for (ResourceTableInfo info : this.resourceTableInfos.values()) {
            HashMap<String, ISettingConfig> resources = new HashMap<String, ISettingConfig>();
            AvailableResourceTables.associateResources(resources, info, mcu);
            this.configs.put(info.getResourceTable(), resources);
        }
    }

    private static void associateResources(Map<String, ISettingConfig> resources, ResourceTableInfo info, ICommonMcu mcu) {
        EmptyRoot root = new EmptyRoot(mcu);
        ResourceTable table = info.getResourceTable();
        for (ISetting setting : table.getDefinition().values()) {
            AStoragePeriphsSetting data = table.getData().find(setting.getId());
            if (data == null) {
                LOGGER.severe(String.format("[DATA] Missing resource setting data for ID '%1s' in %2s", setting.getId(), info.getFileName()));
                continue;
            }
            ISettingConfig config = root.getConfigFactory().createSettingConfig(setting.getId(), setting, root.getChildContext(), data, mcu);
            config.initValue();
            resources.put(config.getId(), config);
        }
    }

    public @Nullable ISettingConfig getResource(String tableId, String definitionId) {
        ResourceTable table = this.getResourceTable(tableId);
        if (table != null) {
            return this.getSettingInResourceTable(definitionId, table);
        }
        return null;
    }

    private @Nullable ISettingConfig getSettingInResourceTable(String definitionId, ResourceTable table) {
        Map<String, ISettingConfig> resources = this.configs.get(table);
        if (resources != null) {
            return resources.get(definitionId);
        }
        return null;
    }

    public @Nullable ISettingConfig getResource(String tableId, String definitionId, String component) {
        ResourceTable table = this.getResourceTable(tableId, component);
        if (table != null) {
            return this.getSettingInResourceTable(definitionId, table);
        }
        return null;
    }

    public Collection<ResourceTableInfo> getResourceTableInfos() {
        return CollectionsUtils.unmodifiableCollection(this.resourceTableInfos.values());
    }

    public Collection<ResourceTable> getResourceTables() {
        return CollectionsUtils.unmodifiableCollection((Collection)((Collection)this.resourceTableInfos.values().stream().map(x -> x.getResourceTable()).collect(CollectorsUtils.toList())));
    }

    public @Nullable ResourceTable getResourceTable(String id) {
        ResourceTableInfo resourceTableInfo = this.resourceTableInfos.get(id);
        if (resourceTableInfo != null) {
            return resourceTableInfo.getResourceTable();
        }
        return null;
    }

    public @Nullable ResourceTable getResourceTable(String id, String component) {
        String fileLocationSuffix = String.valueOf(component) + File.separator + id + "." + "resource";
        ResourceTableInfo resourceTableInfo = this.resourceTableInfos.get(id);
        if (resourceTableInfo != null && resourceTableInfo.getFileName().endsWith(fileLocationSuffix)) {
            return resourceTableInfo.getResourceTable();
        }
        return null;
    }

    protected Map<String, ResourceTableInfo> loadResourceTables(McuResourceTables mcuResourceTables, AvailableComponents activeComponents, AProcessorFilterForPeripherals toolFilter) {
        HashMap<String, ResourceTableInfo> result = new HashMap<String, ResourceTableInfo>();
        mcuResourceTables.getResourceTableInfos().forEach(resTableInfo -> {
            ResourceTableInfo resourceTableInfo = result.put(resTableInfo.getResourceTable().getId(), (ResourceTableInfo)resTableInfo);
        });
        if (result.isEmpty()) {
            return result;
        }
        String componentsDir = toolFilter.getPeripheralsComponentsDir(activeComponents.getMcu());
        activeComponents.getConfigCompTypeIds().stream().map(comp -> comp.getTypeId()).forEach(typeId -> {
            Collection componentResourceTable = ResourceTablesProvider.getResourceTablesOfComponent((String)(String.valueOf(componentsDir) + File.separator + typeId));
            componentResourceTable.forEach(resTableInfo -> {
                ResourceTableInfo resourceTableInfo = result.put(resTableInfo.getResourceTable().getId(), (ResourceTableInfo)resTableInfo);
            });
        });
        return result;
    }

    public void dispose() {
        this.configs.clear();
        this.resourceTableInfos.clear();
    }
}

