/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.mcu.EmptyMcu;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.resourcetables.model.config.ExpressionContext;
import com.nxp.swtools.resourcetables.model.data.IActiveContextRefResolver;
import com.nxp.swtools.resourcetables.model.data.IConfigSet;
import com.nxp.swtools.resourcetables.model.data.IConfigSetReference;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.IReferenceSettingResolver;
import com.nxp.swtools.resourcetables.model.data.ReferenceResolverHelper;
import com.nxp.swtools.resourcetables.model.data.setting.IID;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AvailableComponentsRefResolver
implements IActiveContextRefResolver {
    private static final Logger LOGGER = LogManager.getLogger(AvailableComponentsRefResolver.class);
    private AvailableComponents activeComponents;
    private static ExpressionContext emptyContext = new ExpressionContext(new PeriphsProfile(new EmptyMcu("empty"), SharedConfigurationFactory.createSharedConfiguration()).getChildContext(), (ICommonMcu)new EmptyMcu("empty"));

    public AvailableComponentsRefResolver(AvailableComponents activeComponents) {
        this.activeComponents = activeComponents;
    }

    public void resolve() {
        for (IConfigurationComponent component : this.activeComponents.getConfigComps()) {
            for (IConfigSetReference reference : component.getConfigSetReferences()) {
                IConfigSet resolvedConfigSet = this.resolveConfigSetReference(reference, component);
                if (resolvedConfigSet == null) continue;
                component.addConfigSet(resolvedConfigSet);
            }
            component.updateGlobalConfigSetFromReference();
            component.clearConfigSetReferences();
            for (IConfigSet configSet : component.getConfigSets()) {
                String setID = configSet.getId();
                configSet.resolve((IActiveContextRefResolver)this, component, setID);
                LinkedHashMap allRelSettings = new LinkedHashMap();
                configSet.resolveRelatedSettings((IActiveContextRefResolver)this, component, setID, allRelSettings);
                configSet.setAllRelatedSettings(allRelSettings);
            }
        }
    }

    private @Nullable IConfigSet resolveConfigSetReference(IConfigSetReference reference, IConfigurationComponent component) {
        String componentId = reference.getComponent();
        IConfigurationComponent referencedComponent = AvailableComponentsRefResolver.getRefComponent(this.activeComponents, componentId, reference.getId(), component);
        if (referencedComponent == null) {
            LOGGER.log(Level.SEVERE, "[DATA] Component \"{0}\" specified in config_set_reference could not be found", componentId);
            return null;
        }
        String configSetId = reference.getConfigSetId();
        IConfigSet referencedConfigSet = this.getConfigSet(referencedComponent, configSetId);
        if (referencedConfigSet == null) {
            LOGGER.log(Level.SEVERE, "[DATA] Config set \"{0}\" specified in config_set_reference could not be found", configSetId);
            return null;
        }
        IConfigSet resolvedConfigSet = referencedConfigSet.createCopy(reference.getId(), reference.getUINameString(), reference.getUINameExprString(), reference.getSource(), reference.getAvailableExprString(), reference.getEnableExprString());
        resolvedConfigSet.mergeWith((IConfigSet)reference);
        return resolvedConfigSet;
    }

    public @Nullable Triplet<ISetting, IConfigSet, IConfigurationComponent> find(@Nullable IConfigurationComponent confComp, String confSetID, ReferenceSetting r) {
        IConfigurationComponent refComponent = AvailableComponentsRefResolver.getRefComponent(this.activeComponents, r, confComp);
        if (refComponent == null) {
            return null;
        }
        return this.activeComponents.findSetting(refComponent, ReferenceResolverHelper.getRefConfigSet((ReferenceSetting)r, (String)confSetID), r.getReferenceID(), true);
    }

    public void resolve(IID caller, Map<String, ISetting> where, @Nullable IConfigurationComponent comp, String setID) {
        for (ISetting sett : where.values()) {
            if (!(sett instanceof IReferenceSettingResolver)) continue;
            ((IReferenceSettingResolver)sett).resolve((IActiveContextRefResolver)this, comp, setID);
        }
        for (ISetting sett : where.values()) {
            if (!(sett instanceof ReferenceSetting)) continue;
            ReferenceSetting rs = (ReferenceSetting)sett;
            Triplet<ISetting, IConfigSet, IConfigurationComponent> target = this.find(comp, setID, rs);
            if (target == null) {
                LOGGER.severe(MessageFormat.format("[DATA] An instance of {0} with ID \"{1}\" contains an unresolvable reference with ID \"{2}\" to a setting in component with ID \"{3}\" and config-set with ID \"{4}\"", caller.getClass().getSimpleName(), caller.getId(), rs.getId(), comp == null ? null : comp.getId(), setID));
                continue;
            }
            ISetting targetSett = (ISetting)target.getFirst();
            IConfigSet targetSet = (IConfigSet)target.getSecond();
            IConfigurationComponent targetComp = (IConfigurationComponent)target.getThird();
            if (comp != null && !comp.getId().equals(targetComp.getId()) && !targetComp.getComponents().isEmpty()) {
                LOGGER.severe(MessageFormat.format("[DATA] Cannot resolve {0} since component with ID \"{1}\" contains {2}", rs.toString(), targetComp.getId(), targetComp.getComponents()));
                continue;
            }
            if (!AvailableComponentsRefResolver.canImport(targetSett, targetComp, comp)) {
                LOGGER.severe(MessageFormat.format("[DATA] Cannot resolve {0} since \"{1}\" is not public", rs.toString(), rs.getReferenceID()));
                continue;
            }
            if (targetSett instanceof IReferenceSettingResolver) {
                ((IReferenceSettingResolver)targetSett).resolve((IActiveContextRefResolver)this, targetComp, targetSet.getId());
            }
            ISetting fromReference = targetSett.fromReference(rs);
            where.put(fromReference.getId(), fromReference);
        }
    }

    public static boolean canImport(ISetting targetSett, @Nullable IConfigurationComponent targetComp, @Nullable IConfigurationComponent parentComp) {
        boolean externComp;
        if (targetComp == null) {
            return false;
        }
        boolean bl = externComp = parentComp == null || !parentComp.getId().equals(targetComp.getId());
        return !externComp || targetSett.isPublic((IContext)emptyContext);
    }

    public static @Nullable IConfigurationComponent getRefComponent(AvailableComponents availableComponents, ReferenceSetting r, @Nullable IConfigurationComponent parentComp) {
        return AvailableComponentsRefResolver.getRefComponent(availableComponents, r.getComponentRefID(), r.getId(), parentComp);
    }

    public static @Nullable IConfigurationComponent getRefComponent(AvailableComponents availableComponents, @Nullable String componentId, String id, @Nullable IConfigurationComponent parentComp) {
        if (componentId != null) {
            List<IConfigurationComponent> configComps = availableComponents.getConfigComps(componentId);
            if (configComps != null && !configComps.isEmpty()) {
                boolean allComponentsAreGlobal = configComps.stream().allMatch(c -> c.isGlobalOnly());
                if (!allComponentsAreGlobal) {
                    String compId = parentComp != null ? parentComp.getId() : "";
                    LOGGER.severe(MessageFormat.format("[DATA] You should not reference non-global component \"{0}\"! See attribute {1} of reference setting \"{2}\" in component: {3}", componentId, "component_id", id, compId));
                }
                if (parentComp != null && parentComp.getId().equals(componentId)) {
                    LOGGER.info("[DATA] You are referencing to the same component ID that current component has. Current component will be used");
                    return parentComp;
                }
                return configComps.get(0);
            }
            LOGGER.severe(MessageFormat.format("[DATA] Component not found: {0}", componentId));
        }
        return parentComp;
    }

    public void setCaller(@NonNull Object caller) {
    }
}

