/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.periphs.model.Messages;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.yaml.PeripheralsYamlConverter;
import com.nxp.swtools.periphs.model.yaml.converters.StorageYamlConverter;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsConfigSet;
import com.nxp.swtools.resourcetables.model.config.AssignConfig;
import com.nxp.swtools.resourcetables.model.config.CacheHelper;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.DependencyResponseConfig;
import com.nxp.swtools.resourcetables.model.config.DumpFormatOptions;
import com.nxp.swtools.resourcetables.model.config.DumpHelper;
import com.nxp.swtools.resourcetables.model.config.ExpressionContext;
import com.nxp.swtools.resourcetables.model.config.ICacheable;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.RegisterConfig;
import com.nxp.swtools.resourcetables.model.config.RegistersModelSingleton;
import com.nxp.swtools.resourcetables.model.config.SetConfig;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigSet;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.Level;
import com.nxp.swtools.resourcetables.model.data.MasterPeripheral;
import com.nxp.swtools.resourcetables.model.data.Mode;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class ComponentInstanceConfig
implements IComponentInstanceConfig {
    private static final Logger LOGGER = LogManager.getLogger(IComponentInstanceConfig.class);
    private String name;
    private String uuid;
    private boolean customNameEnabled;
    private String comment;
    private final IConfigurationComponent component;
    private final StoragePeriphsComponentInstance storageComponent;
    private Mode mode;
    @Nullable
    private String peripheral;
    private final Map<String, IConfigSetConfig> configSets = new HashMap<String, IConfigSetConfig>();
    protected final ChildContext childContext;
    protected final ExpressionContext expressionContext;
    protected final ICommonMcu mcu;
    private boolean enabled = true;
    protected final Map<String, Object> cache = new HashMap<String, Object>();
    protected final CollectionMap<String, CollectionsUtils.Pair<String, ICacheable>> dependencies = new CollectionMap();
    private boolean editingLockFlag = false;
    @Nullable
    private String fromUseCase;
    private boolean disposed = false;

    public String @Nullable [] getOwnProblems(Level level) {
        if (this.disposed) {
            return null;
        }
        if (this.isEnabled() && this.mcu instanceof IMcu) {
            if (level == Level.INFO) {
                ArrayList<String> infos = new ArrayList<String>();
                if (!((IMcu)this.mcu).getAvailableComponents().getReplacementsForTypeId(this.getComponentTypeId()).isEmpty()) {
                    infos.add(Messages.get().ComponentInstanceConfig_ComponentHasNewerVersionAvailable);
                }
                if (!infos.isEmpty()) {
                    return infos.toArray(new String[infos.size()]);
                }
            }
            if (level == Level.ERROR) {
                ArrayList<String> result = new ArrayList<String>();
                String unavailablePeripheralError = this.getPeripheralsUnavailableForCoreError();
                String usedPeripheralError = this.getMoreInstancesOnSamePeripheralError();
                String uniquenesOfNameError = this.getNotUniqueNameError();
                String peripheralNotUsableForModeError = this.getPeripheralNotUsableForModeError();
                if (unavailablePeripheralError != null) {
                    result.add(unavailablePeripheralError);
                }
                if (usedPeripheralError != null) {
                    result.add(usedPeripheralError);
                }
                if (uniquenesOfNameError != null) {
                    result.add(uniquenesOfNameError);
                }
                if (peripheralNotUsableForModeError != null) {
                    result.add(peripheralNotUsableForModeError);
                }
                return result.toArray(new String[result.size()]);
            }
        }
        return null;
    }

    public boolean isOptionSet(String option) {
        return this.component.isOptionSet(option) && this.isOptionAvailable(option);
    }

    public boolean isOptionAvailable(String option) {
        return this.component.isOptionAvailable(option, (IContext)this.expressionContext);
    }

    public @Nullable Object getOptionValue(String option) {
        return this.component.getOptionValue(option, (IContext)this.expressionContext);
    }

    public Collection<String> getErroneousPeripherals() {
        if (this.isEnabled()) {
            Collection<String> result = this.getErroneousUnavailablePeripherals();
            result.addAll(this.getErroneousPeripheralsUsedMultipleTimes().keySet());
            return result;
        }
        return new ArrayList<String>(0);
    }

    private CollectionMap<String, IComponentInstanceConfig> getErroneousPeripheralsUsedMultipleTimes() {
        Supplier<CollectionMap> valueSupplier = () -> {
            CollectionMap result = new CollectionMap();
            IFunctionalGroup functionalGroup = ComponentInstanceConfig.getFunctionalGroup(this.childContext);
            if (functionalGroup != null) {
                IFunctionalGroup nonNullFunctionalGroup = functionalGroup;
                Map instances = nonNullFunctionalGroup.getInstances();
                ArrayList<String> exlusivePeripherals = new ArrayList<String>();
                ArrayList<String> nonExclusivePeripherals = new ArrayList<String>();
                String selectedPeripheral = this.getPeripheral();
                if (selectedPeripheral != null) {
                    MasterPeripheral masterPeripheral = this.getMode().getMasterPeripheral();
                    if (masterPeripheral != null) {
                        if (masterPeripheral.isExclusive()) {
                            exlusivePeripherals.add(selectedPeripheral);
                        } else {
                            nonExclusivePeripherals.add(selectedPeripheral);
                        }
                    }
                    nonExclusivePeripherals.addAll(this.getSlavePeripherals());
                }
                for (IComponentInstanceConfig instance : instances.values()) {
                    if (this == instance || !instance.isEnabled()) continue;
                    for (String peripheralLoc : exlusivePeripherals) {
                        if (!instance.isPeripheralUsed(peripheralLoc)) continue;
                        result.add((Object)peripheralLoc, (Object)instance);
                    }
                    for (String peripheralLoc : nonExclusivePeripherals) {
                        if (!instance.isPeripheralUsedExlusively(peripheralLoc)) continue;
                        result.add((Object)peripheralLoc, (Object)instance);
                    }
                }
            }
            return result;
        };
        return (CollectionMap)CacheHelper.getValueCaching((ICacheable)this, (String)"*multiusage_peripherals", valueSupplier);
    }

    private Collection<String> getErroneousUnavailablePeripherals() {
        ArrayList<String> result = new ArrayList<String>();
        IFunctionalGroup functionalGroup = ComponentInstanceConfig.getFunctionalGroup(this.getChildContext());
        if (functionalGroup != null) {
            for (String peripheralLoc : this.getPeripherals()) {
                if (this.mcu.isPeripheralAvailableForCore(functionalGroup.getCore(), peripheralLoc)) continue;
                result.add(peripheralLoc);
            }
        }
        return result;
    }

    private @Nullable String getMoreInstancesOnSamePeripheralError() {
        CollectionMap<String, IComponentInstanceConfig> erroneousPeripherals = this.getErroneousPeripheralsUsedMultipleTimes();
        if (!erroneousPeripherals.isEmpty()) {
            String instancesString = CollectionsUtils.formatList((Collection)erroneousPeripherals.flatValuesSet(), (String)", ", c -> c.getName());
            String peripheralsString = CollectionsUtils.formatList((Collection)erroneousPeripherals.keySet(), (String)", ", null);
            return MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentInstanceConfig_MultipleInstancesOnPeripheral), peripheralsString, instancesString);
        }
        return null;
    }

    public @Nullable String getNotUniqueNameError() {
        if (this.isEnabled()) {
            IFunctionalGroup functionalGroup = ComponentInstanceConfig.getFunctionalGroup(this.childContext);
            if (functionalGroup == null) {
                return null;
            }
            IRoot profile = this.getPeriphsProfile();
            if (profile != null) {
                String identifier = functionalGroup.createIdentifier(this.getId());
                if (profile.countSameIdentifierOccurences(functionalGroup.getIdPrefix(), identifier) > 1) {
                    return this.getNameConflictErrorInternal(this, this.getId());
                }
            }
        }
        return null;
    }

    public @Nullable String getNameConflictErrorInternal(IComponentInstanceConfig instance, String nameToTest) {
        return ComponentInstanceConfig.getNameConflictError(instance, nameToTest);
    }

    public static @Nullable String getNameConflictError(IComponentInstanceConfig instance, String nameToTest) {
        IRoot profile = ComponentInstanceConfig.getPeriphsProfile(instance);
        if (profile != null && profile.isFunctionalGroupSynchronizationEnabled()) {
            return null;
        }
        String error = null;
        IFunctionalGroup functionalGroup = ComponentInstanceConfig.getFunctionalGroup(instance.getChildContext());
        if (functionalGroup != null && profile != null) {
            List groupsContainingNewName = profile.getGroupsContainingIdentifier(functionalGroup.getIdPrefix(), functionalGroup.createIdentifier(nameToTest));
            groupsContainingNewName.remove(functionalGroup);
            if (!groupsContainingNewName.isEmpty()) {
                String groupNames = UtilsText.join(groupsContainingNewName.stream().map(x -> x.getUiName()), (String)", ");
                error = MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentInstanceConfig_NameIsNotUniqueOtherGroup), nameToTest, groupNames, functionalGroup.getUiName());
            } else {
                error = MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentInstanceConfig_NameIsNotUnique), nameToTest);
            }
        }
        return error;
    }

    public @Nullable String getMasterPeripheralError() {
        if (this.isEnabled()) {
            CollectionMap<String, IComponentInstanceConfig> erroneousPeripherals = this.getErroneousPeripheralsUsedMultipleTimes();
            String masterPeripheral = this.getPeripheral();
            Collection conflictInstances = erroneousPeripherals.get((Object)masterPeripheral);
            if (masterPeripheral != null && conflictInstances != null && !conflictInstances.isEmpty()) {
                String instancesString = CollectionsUtils.formatList((Collection)conflictInstances, (String)", ", c -> c.getName());
                return MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentInstanceConfig_MultipleInstancesOnPeripheral), masterPeripheral, instancesString);
            }
            IFunctionalGroup functionalGroup = ComponentInstanceConfig.getFunctionalGroup(this.getChildContext());
            if (functionalGroup != null && masterPeripheral != null && this.getErroneousUnavailablePeripherals().contains(masterPeripheral)) {
                String unformattedMessage = Messages.get().ComponentInstanceConfig_ComponentPeripheralsUnavailableForCore;
                return MessageFormat.format(UtilsText.safeString((String)unformattedMessage), masterPeripheral, functionalGroup.getCore());
            }
            String peripheralNotUsableForModeError = this.getPeripheralNotUsableForModeError();
            if (peripheralNotUsableForModeError != null) {
                return peripheralNotUsableForModeError;
            }
        }
        return null;
    }

    private @Nullable String getPeripheralNotUsableForModeError() {
        boolean isPeripheralUsableInMode;
        MasterPeripheral selectedModeMasterPeripheral = this.getMode().getMasterPeripheral();
        String selectedPeripheral = this.getPeripheral();
        if (selectedModeMasterPeripheral != null && !(isPeripheralUsableInMode = selectedModeMasterPeripheral.getPeripherals().stream().flatMap(type -> this.mcu.getPeripherals(type).stream()).anyMatch(p -> p.equals(selectedPeripheral)))) {
            return MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentInstanceConfig_PeripheralNotUsableInMode), this.getMode().getUIName((IContext)this.expressionContext), UtilsText.safeString((String)selectedPeripheral));
        }
        return null;
    }

    public @Nullable String getPeripheralsError() {
        if (this.isEnabled()) {
            String unavailableError = this.getPeripheralsUnavailableForCoreError();
            String moreInstancesError = this.getMoreInstancesOnSamePeripheralError();
            if (unavailableError == null) {
                return moreInstancesError;
            }
            if (moreInstancesError == null) {
                return unavailableError;
            }
            return String.valueOf(unavailableError) + "\r\n" + moreInstancesError;
        }
        return null;
    }

    private @Nullable String getPeripheralsUnavailableForCoreError() {
        IFunctionalGroup functionalGroup = ComponentInstanceConfig.getFunctionalGroup(this.getChildContext());
        Collection<String> unavailablePeripherals = this.getErroneousUnavailablePeripherals();
        String unavailablePeripheralsText = CollectionsUtils.formatList(unavailablePeripherals, (String)", ", null);
        if (!unavailablePeripheralsText.isEmpty() && functionalGroup != null) {
            String unformattedMessage = UtilsText.safeString((String)Messages.get().ComponentInstanceConfig_ComponentPeripheralsUnavailableForCore);
            return MessageFormat.format(unformattedMessage, unavailablePeripheralsText, functionalGroup.getCore());
        }
        return null;
    }

    public ComponentInstanceConfig(IConfigurationComponent component, IFunctionalGroup group, String name, Mode mode, Map<String, ConfigSetConfig> configSets, @Nullable String peripheral, ChildContext parentContext, ICommonMcu mcu, String uuid, boolean customNameEnabled) {
        this.mcu = mcu;
        this.name = name;
        this.comment = "";
        this.uuid = uuid;
        this.customNameEnabled = customNameEnabled;
        this.component = component;
        this.childContext = this.createChildContext(parentContext);
        this.childContext.setGroup(group);
        this.expressionContext = new ExpressionContext(this.childContext, mcu);
        this.mode = mode;
        this.storageComponent = new StoragePeriphsComponentInstance();
        this.storageComponent.setEnabled(this.isEnabled());
        this.peripheral = peripheral;
        this.configSets.putAll(configSets);
        group.addInstance((IComponentInstanceConfig)this);
        this.addRequiredConfigSets();
        this.registerAllAssigns(group);
        this.updateStorage();
    }

    public ComponentInstanceConfig(ComponentInstanceConfig original, IFunctionalGroup functionalGroup, boolean registerAssigns) {
        this.mcu = original.mcu;
        this.name = original.name;
        this.comment = "";
        this.uuid = original.uuid;
        this.customNameEnabled = original.customNameEnabled;
        this.component = original.component;
        this.childContext = this.createChildContext(functionalGroup.getChildContext());
        this.childContext.setGroup(functionalGroup);
        this.expressionContext = new ExpressionContext(this.childContext, this.mcu);
        this.mode = original.mode;
        this.storageComponent = new StoragePeriphsComponentInstance(original.getStorageComponent());
        this.storageComponent.setEnabled(this.isEnabled());
        this.peripheral = original.peripheral;
        CopyOnWriteArrayList storageConfigSets = this.storageComponent.getConfig_sets();
        for (Map.Entry<String, IConfigSetConfig> entry : original.getConfigSets().entrySet()) {
            IConfigSetConfig originalConfigSetConfig = entry.getValue();
            IConfigSet originalConfigSet = originalConfigSetConfig.getConfigSet();
            String originalConfigSetConfigName = originalConfigSetConfig.getName();
            StoragePeriphsConfigSet storage = (StoragePeriphsConfigSet)CollectionsUtils.nullableOptionalGet(storageConfigSets.stream().filter(x -> x.getName().equals(originalConfigSetConfigName)).findAny());
            if (storage == null) {
                LOGGER.log(java.util.logging.Level.SEVERE, MessageFormat.format("[TOOL] [INSTANCE_DUPLICATION] Storage for config set {0} was no found", originalConfigSetConfigName));
                continue;
            }
            ConfigSetConfig newConfigSetConfig = new ConfigSetConfig(originalConfigSetConfigName, originalConfigSet, storage, this.getChildContext(), this.mcu, false);
            this.configSets.put(entry.getKey(), newConfigSetConfig);
        }
        if (registerAssigns) {
            this.registerAllAssigns(functionalGroup);
        }
        this.updateStorage();
    }

    public ComponentInstanceConfig(IConfigurationComponent component, IFunctionalGroup functionalGroup, String name, Mode mode, @Nullable String peripheral, ChildContext parentContext, ICommonMcu mcu, String uuid) {
        this(component, functionalGroup, name, mode, Collections.emptyMap(), peripheral, parentContext, mcu, uuid, false);
    }

    public ComponentInstanceConfig(IConfigurationComponent component, IFunctionalGroup functionalGroup, String name, Mode mode, @Nullable String peripheral, ChildContext parentContext, ICommonMcu mcu) {
        this(component, functionalGroup, name, mode, Collections.emptyMap(), peripheral, parentContext, mcu, "", false);
    }

    public ComponentInstanceConfig(IConfigurationComponent component, IFunctionalGroup group, StoragePeriphsComponentInstance storageComponent, ChildContext parentContext, ICommonMcu mcu) {
        this.mcu = mcu;
        this.name = storageComponent.getName();
        this.uuid = storageComponent.getUUID();
        this.comment = storageComponent.getComment();
        this.customNameEnabled = storageComponent.isCustomName();
        this.storageComponent = storageComponent;
        this.setEnabled(storageComponent.isEnabled());
        this.component = component;
        this.fromUseCase = storageComponent.getOriginalUseCase();
        this.editingLockFlag = storageComponent.isEditingLocked();
        this.childContext = this.createChildContext(parentContext);
        this.childContext.setGroup(group);
        group.addInstance((IComponentInstanceConfig)this);
        this.expressionContext = new ExpressionContext(this.childContext, mcu);
        Mode modeLoc = component.getMode(storageComponent.getMode());
        if (modeLoc == null) {
            LOGGER.severe(MessageFormat.format("[TOOL] Mode from MEX was not found: {0}", storageComponent.getMode()));
            modeLoc = (Mode)component.getScenarios().get(0);
        }
        this.mode = modeLoc;
        this.peripheral = storageComponent.getPeripheral();
        for (StoragePeriphsConfigSet storageConfigSet : storageComponent.getConfig_sets()) {
            String configSetId = storageConfigSet.getName();
            IConfigSet configSet = component.getConfigSet(configSetId);
            if (configSet == null) {
                LOGGER.severe(MessageFormat.format("[DATA] Component with ID \"{0}\" does not contain a config-set with ID \"{1}\" referenced in {2} with name {3} which was loaded from MEX", component.getId(), configSetId, storageComponent.getClass().getSimpleName(), storageComponent.getName()));
                continue;
            }
            this.configSets.put(configSetId, new ConfigSetConfig(configSet.getId(), configSet, storageConfigSet, this.childContext, mcu, false));
        }
    }

    public void initializeAfterCreatedFromStorage() {
        ArrayList<IConfigSetConfig> createdConfigSets = new ArrayList<IConfigSetConfig>(this.configSets.values());
        this.addRequiredConfigSets();
        createdConfigSets.forEach(cs -> cs.applySelectedQuickSelection());
        IFunctionalGroup functionalGroup = this.getChildContext().getFunctionalGroup();
        if (functionalGroup != null) {
            this.registerAllAssigns(functionalGroup);
        } else {
            LOGGER.log(java.util.logging.Level.SEVERE, "[TOOL] Functional group of instance \"{0}\" is null and assigns will not be resolved", this.getId());
        }
        this.updateStorage();
    }

    private void registerAllAssigns(IFunctionalGroup group) {
        RegistersModelSingleton.getInstance().getAssignCreationLatch().waitOnSemaphore();
        List<AssignConfig> assigns = this.getAllAssigns();
        if (this.getComponent().isRegistersInitialization() && assigns.isEmpty()) {
            LOGGER.log(java.util.logging.Level.SEVERE, "[DATA] Component is marked as register initialization, but there are no assigns");
        }
        for (AssignConfig assignConfig : assigns) {
            if (this.getComponent().isRegistersInitialization() && assignConfig.getParent().isAvailable() && assignConfig.getParent().isEnabled() && assignConfig.isEnabled()) {
                RegistersModelSingleton.verifyAssignValidity((AssignConfig)assignConfig);
            }
            for (RegisterConfig register : assignConfig.getRegisters()) {
                RegistersModelSingleton.getInstance().registerAssign(group, register, assignConfig);
            }
        }
    }

    public List<AssignConfig> getAllAssigns() {
        ArrayList<AssignConfig> assigns = new ArrayList<AssignConfig>();
        for (IConfigSetConfig configSet : this.getChildren()) {
            List allSettings = ChildProviderHelper.getAllSettings((IChildProvidable)configSet);
            for (ISettingConfig setting : allSettings) {
                assigns.addAll(setting.getAssignConfigs());
                if (!(setting instanceof SetConfig)) continue;
                for (SetConfig.SetPresence presence : ((SetConfig)setting).getChildren()) {
                    assigns.addAll(presence.getAssignConfigs());
                }
            }
        }
        return assigns;
    }

    private final ChildContext createChildContext(ChildContext parentContext) {
        ChildContext ctx = parentContext.createForChild((IChild)this);
        ctx.setComponentInstanceConfig((IComponentInstanceConfig)this);
        IRoot profile = ComponentInstanceConfig.getPeriphsProfile(ctx);
        if (profile != null) {
            IComponentConfig componentConfig = profile.getComponent(this.component.getId());
            if (componentConfig == null) {
                LOGGER.severe(MessageFormat.format("[TOOL] Cannot create valid child-context for the component instance {0} of type {1}, because there is no component configuration of that type in the profile.At first add component configuration to the profile.", this.getName(), this.component.getId()));
            }
            ctx.setComponentConfig(componentConfig);
        }
        return ctx;
    }

    private void updateStorage() {
        this.storageComponent.setType(this.component.getId());
        IComponentConfig componentConfig = this.childContext.getComponentConfig();
        if (componentConfig != null) {
            this.storageComponent.setType_id(componentConfig.getComponentTypeId());
        }
        this.storageComponent.setName(this.name);
        this.storageComponent.setMode(this.mode.getId());
        this.storageComponent.setPeripheral(this.peripheral);
        this.storageComponent.setEnabled(this.enabled);
        this.storageComponent.setUUID(this.uuid);
        this.storageComponent.setComment(this.comment);
        this.storageComponent.setCustomNameEnabled(this.customNameEnabled);
        this.storageComponent.getConfig_sets().clear();
        this.configSets.values().forEach(x -> {
            boolean bl = this.storageComponent.getConfig_sets().add(x.getStorageConfigSet());
        });
        this.updateStorageAvailability();
    }

    public Map<String, Object> getCache() {
        return this.cache;
    }

    public CollectionMap<String, CollectionsUtils.Pair<String, ICacheable>> getDependencyMap() {
        return this.dependencies;
    }

    public IConfigurationComponent getComponent() {
        return this.component;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public String getUUID() {
        return this.uuid;
    }

    public boolean isCustomNameEnabled() {
        return this.customNameEnabled;
    }

    public void setName(String name) {
        this.name = name;
        this.storageComponent.setName(name);
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.storageComponent.setComment(comment);
    }

    public void setUUID(String uuidString) {
        this.uuid = uuidString;
        this.storageComponent.setUUID(uuidString);
    }

    public void setIsCustomName(boolean isCustomName) {
        this.customNameEnabled = isCustomName;
        this.storageComponent.setCustomNameEnabled(isCustomName);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void changeMode(Mode newMode) {
        this.mode = newMode;
        this.storageComponent.setMode(newMode.getId());
        this.addRequiredConfigSets();
        this.updateStorage();
    }

    private boolean addRequiredConfigSets() {
        ArrayList<ConfigSetConfig> addedConfigSets = new ArrayList<ConfigSetConfig>();
        for (String configSetId : this.mode.getConfigSetRefs()) {
            if (this.configSets.containsKey(configSetId)) continue;
            IConfigSet configSet = this.component.getConfigSet(configSetId);
            if (configSet == null) {
                LOGGER.severe(MessageFormat.format("[DATA] Component with ID \"{0}\" does not contain a config-set with ID \"{1}\" referenced in mode with ID \"{2}\"", this.component.getId(), configSetId, this.mode.getId()));
                continue;
            }
            ConfigSetConfig configSetConfig = new ConfigSetConfig(configSet.getId(), configSet, this.childContext, this.mcu, false);
            this.configSets.put(configSetId, configSetConfig);
            addedConfigSets.add(configSetConfig);
        }
        addedConfigSets.forEach(cs -> cs.applySelectedQuickSelection());
        addedConfigSets.forEach(cs -> cs.handleUniqueIntegers());
        return !addedConfigSets.isEmpty();
    }

    public boolean isPeripheralUsed(String peripheralInstance) {
        return this.getPeripherals().contains(peripheralInstance);
    }

    public boolean isPeripheralUsedExlusively(String peripheralInstance) {
        MasterPeripheral masterPeripheral = this.mode.getMasterPeripheral();
        return peripheralInstance.equals(this.peripheral) && masterPeripheral != null && masterPeripheral.isExclusive();
    }

    public @Nullable String getPeripheral() {
        return this.peripheral;
    }

    public List<String> getSlavePeripherals() {
        return (List)CacheHelper.getValueCaching((ICacheable)this, (String)"*nested_peripherals", () -> {
            ArrayList<String> result = new ArrayList<String>();
            LinkedList<@Nullable E> queue = new LinkedList(CollectionsUtils.asList((Object)this));
            while (!queue.isEmpty()) {
                IChild child = (IChild)queue.poll();
                if (child == null) continue;
                if (child instanceof IChildProvidable) {
                    queue.addAll(((IChildProvidable)child).getChildren());
                }
                if (!child.isAvailable() || !child.isEnabled() || !child.isOptionSet("FEATURE_PERIPHERAL_SELECT")) continue;
                result.add(UtilsText.safeString((String)child.getValue().toString()));
            }
            return CollectionsUtils.unmodifiableList(result);
        });
    }

    public List<String> getPeripherals() {
        ArrayList<String> result = new ArrayList<String>(this.getSlavePeripherals());
        String masterPeripheral = this.getPeripheral();
        if (masterPeripheral != null) {
            result.add(masterPeripheral);
        }
        return result;
    }

    public void setPeripheral(@Nullable String peripheral) {
        this.peripheral = peripheral;
        this.storageComponent.setPeripheral(peripheral);
    }

    public Map<String, IConfigSetConfig> getConfigSets() {
        return CollectionsUtils.unmodifiableMap(this.configSets);
    }

    public @Nullable IChild getChildById(String id) {
        return ChildProviderHelper.getChildRelative((IChildProvidable)this, (String)id);
    }

    public Object getValue() {
        return CacheHelper.getValueCaching((ICacheable)this, (String)(String.valueOf(this.getId()) + "*value"), () -> this);
    }

    public @Nullable IConfigSetConfig getChild(String childName) {
        return this.configSets.get(childName);
    }

    public List<IConfigSetConfig> getChildren() {
        ArrayList<IConfigSetConfig> result = new ArrayList<IConfigSetConfig>();
        for (String configSetId : this.mode.getConfigSetRefs()) {
            IConfigSetConfig configSetConfig = this.configSets.get(configSetId);
            if (configSetConfig == null) {
                LOGGER.severe(MessageFormat.format("[DATA] Configuration not found for config-set with ID \"{0}\" referenced in mode with ID \"{1}\" of component with ID \"{2}\"", configSetId, this.mode.getId(), this.component.getId()));
                continue;
            }
            result.add(configSetConfig);
        }
        return result;
    }

    public StoragePeriphsComponentInstance getStorageComponent() {
        return this.storageComponent;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.name;
    }

    public String getType() {
        return this.component.getId();
    }

    public @Nullable String getTypeName() {
        return this.getType();
    }

    public String getUiName() {
        return this.name;
    }

    public @Nullable String getDescription() {
        return this.component.getResolvedDescription((IContext)this.expressionContext);
    }

    public ChildContext getChildContext() {
        return this.childContext;
    }

    public ConfigurationComponentTypeId getConfigCompTypeId() {
        IComponentConfig config = this.childContext.getComponentConfig();
        assert (config != null);
        return config.getConfigCompTypeId();
    }

    public String getComponentTypeId() {
        return this.getConfigCompTypeId().getTypeId();
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public ICommonMcu getMcu() {
        return this.mcu;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.storageComponent.setEnabled(enabled);
    }

    public @Nullable String getYaml() {
        IRoot profile = this.getPeriphsProfile();
        if (profile != null && profile.isYamlEnabled()) {
            IFunctionalGroup functionalGroup = this.childContext.getFunctionalGroup();
            String functionalGroupName = functionalGroup == null ? null : functionalGroup.getName();
            IComponentConfig componentConfig = this.childContext.getComponentConfig();
            String componentTypeId = componentConfig == null ? null : componentConfig.getComponentTypeId();
            IYamlStorable yamlStorable = StorageYamlConverter.toYamlStorable(this.storageComponent, functionalGroupName, componentTypeId);
            return new PeripheralsYamlConverter().createYamlFunction(yamlStorable);
        }
        return null;
    }

    public void updateStorageAvailability() {
        CopyOnWriteArrayList configSetsList = this.storageComponent.getConfig_sets();
        configSetsList.clear();
        List configSetRefs = this.mode.getConfigSetRefs();
        for (IConfigSetConfig cs : this.configSets.values()) {
            if (!cs.isAvailable() || !configSetRefs.contains(cs.getConfigSet().getId())) continue;
            configSetsList.add(cs.getStorageConfigSet());
            cs.updateStorageAvailability();
        }
    }

    public void clearCache() {
        this.getCache().clear();
        this.getDependencyMap().clear();
        this.configSets.values().forEach(x -> {
            x.getCache().clear();
            x.getDependencyMap().clear();
        });
    }

    public String readComponentFile(String filePath) {
        IComponentConfig componentConfig = this.getChildContext().getComponentConfig();
        if (componentConfig != null) {
            return componentConfig.readComponentFile(filePath);
        }
        LOGGER.log(java.util.logging.Level.SEVERE, "[TOOL] Cannot find component config for this instance!");
        return "";
    }

    public String getScriptFile() {
        IComponentConfig componentConfig = this.getChildContext().getComponentConfig();
        if (componentConfig != null) {
            return componentConfig.getScriptFile();
        }
        LOGGER.log(java.util.logging.Level.SEVERE, "[TOOL] Cannot find component config for this instance!");
        return "";
    }

    public @Nullable String getError() {
        return (String)CacheHelper.getValueCaching((ICacheable)this, (String)"*error", () -> this.getProblems(Level.ERROR));
    }

    public @Nullable String getWarning() {
        return (String)CacheHelper.getValueCaching((ICacheable)this, (String)"*warning", () -> this.getProblems(Level.WARNING));
    }

    public @Nullable String getInfo() {
        return (String)CacheHelper.getValueCaching((ICacheable)this, (String)"*info", () -> this.getProblems(Level.INFO));
    }

    public String toString() {
        return "ComponentInstance: [Type: " + this.getType() + ", Name: " + this.getName() + "]";
    }

    private static @Nullable IFunctionalGroup getFunctionalGroup(ChildContext childContext) {
        IFunctionalGroup group = childContext.getFunctionalGroup();
        if (group != null) {
            return group;
        }
        return null;
    }

    private static @Nullable IRoot getPeriphsProfile(ChildContext childContext) {
        return childContext.getRoot();
    }

    private static @Nullable IRoot getPeriphsProfile(IComponentInstanceConfig instance) {
        return instance.getChildContext().getRoot();
    }

    private @Nullable IRoot getPeriphsProfile() {
        return ComponentInstanceConfig.getPeriphsProfile(this);
    }

    public List<DependencyResponseConfig> getDependencyResponses() {
        return (List)CacheHelper.getValueCaching((ICacheable)this, (String)(String.valueOf(this.getId()) + "*dependency_responses"), () -> {
            ArrayList list = new ArrayList();
            for (IConfigSetConfig configSet : this.getChildren()) {
                list.addAll(configSet.getDependencyResponses());
            }
            return list;
        });
    }

    public boolean isEditingLocked() {
        return this.editingLockFlag;
    }

    public void setEditingLockState(boolean state) {
        this.editingLockFlag = state;
        this.storageComponent.setEditingLockState(state);
    }

    public @Nullable String getOriginalUseCase() {
        return this.fromUseCase;
    }

    public void setOriginalUseCase(String useCaseName) {
        this.fromUseCase = useCaseName;
        this.storageComponent.setOriginalUseCase(useCaseName);
    }

    public void synchronizeValue(@Nullable IChild config) {
        this.getChildren().forEach(x -> x.synchronizeValue(null));
    }

    public boolean isSynchronizationEnabled() {
        return this.isOptionAvailable("SYNC_VALUE");
    }

    public boolean hasAutomaticMigration() {
        return this.component.hasAutomaticMigration();
    }

    public List<String> getAutomaticMigrations() {
        return this.component.getAutomaticMigrations();
    }

    public void dispose() {
        this.disposed = true;
        for (IConfigSetConfig configSet : this.configSets.values()) {
            configSet.dispose();
        }
        this.configSets.clear();
        this.cache.clear();
        this.dependencies.clear();
        this.childContext.dispose();
    }

    public StringBuilder dump(StringBuilder builder, DumpFormatOptions options) {
        return DumpHelper.dump((StringBuilder)builder, (DumpFormatOptions)options, (IChildProvidable)this);
    }

    public @NonNull String getFullId() {
        StringBuilder builder = new StringBuilder();
        IFunctionalGroup functionalGroup = this.getChildContext().getFunctionalGroup();
        if (functionalGroup != null) {
            builder.append(functionalGroup.getName()).append(".");
        } else {
            LOGGER.log(java.util.logging.Level.SEVERE, "[TOOL] Trying to construct full ID of instance which is not in functional group");
        }
        builder.append(this.getName());
        return builder.toString();
    }

    public boolean isNoInit() {
        return this.getConfigCompTypeId().getConfigurationComponent().isNoInit();
    }
}

