/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.periphs.model.yaml.PeripheralsYamlConverter;
import com.nxp.swtools.periphs.model.yaml.converters.StorageYamlConverter;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsConfigSet;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.DumpFormatOptions;
import com.nxp.swtools.resourcetables.model.config.ExpressionContext;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigSet;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.Script;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ComponentConfig
implements IComponentConfig {
    private static final Logger LOGGER = LogManager.getLogger(ComponentConfig.class);
    private final StoragePeriphsComponent storageComponent;
    private final ConfigurationComponentTypeId configCompTypeId;
    @Nullable
    protected IConfigSetConfig globalConfigSet;
    protected final ChildContext childContext;
    protected final ExpressionContext expressionContext;
    protected final ICommonMcu mcu;

    public ComponentConfig(ConfigurationComponentTypeId configCompTypeId, StoragePeriphsComponent storageComponent, ChildContext parentContext, ICommonMcu mcu) {
        this.mcu = mcu;
        this.childContext = parentContext.createForChild((IChild)this);
        this.childContext.setComponentConfig((IComponentConfig)this);
        this.expressionContext = new ExpressionContext(this.childContext, this.mcu);
        this.configCompTypeId = configCompTypeId;
        IConfigurationComponent component = configCompTypeId.getConfigurationComponent();
        this.storageComponent = storageComponent;
        this.storageComponent.setName(component.getId());
    }

    public ComponentConfig(ConfigurationComponentTypeId configCompTypeId, ChildContext parentContext, ICommonMcu mcu) {
        this.mcu = mcu;
        this.childContext = parentContext.createForChild((IChild)this);
        this.childContext.setComponentConfig((IComponentConfig)this);
        this.expressionContext = new ExpressionContext(this.childContext, this.mcu);
        this.configCompTypeId = configCompTypeId;
        IConfigurationComponent component = configCompTypeId.getConfigurationComponent();
        this.storageComponent = new StoragePeriphsComponent();
        this.storageComponent.setName(component.getId());
        this.storageComponent.setTypeId(configCompTypeId.getTypeId());
        IConfigSet configSet = component.getGlobalConfigSet();
        if (configSet == null) {
            this.globalConfigSet = null;
        } else {
            ConfigSetConfig configSetConfig = new ConfigSetConfig(configSet.getId(), configSet, this.childContext, mcu, true);
            this.globalConfigSet = configSetConfig;
            this.storageComponent.setConfig_set_global(configSetConfig.getStorageConfigSet());
            configSetConfig.applySelectedQuickSelection();
        }
    }

    public StoragePeriphsComponent getStorageComponent() {
        return this.storageComponent;
    }

    public IConfigurationComponent getComponent() {
        return this.configCompTypeId.getConfigurationComponent();
    }

    public String getType() {
        return this.configCompTypeId.getConfigurationComponent().getId();
    }

    public @NonNull String getTypeName() {
        return this.getType();
    }

    public @Nullable IConfigSetConfig getGlobalConfigSet() {
        return this.globalConfigSet;
    }

    public String getId() {
        return this.configCompTypeId.getConfigurationComponent().getId();
    }

    public Object getValue() {
        return this;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public @Nullable IChild getChildById(String id) {
        return ChildProviderHelper.getChildRelative((IChildProvidable)this, (String)id);
    }

    public @Nullable IChild getChild(String name) {
        IConfigSetConfig globalConfigSetLoc = this.globalConfigSet;
        if (globalConfigSetLoc != null && globalConfigSetLoc.getName().equals(name)) {
            return globalConfigSetLoc;
        }
        return null;
    }

    public List<? extends IChild> getChildren() {
        ArrayList<IConfigSetConfig> result = new ArrayList<IConfigSetConfig>();
        IConfigSetConfig globalConfigSetLoc = this.globalConfigSet;
        if (globalConfigSetLoc != null) {
            result.add(globalConfigSetLoc);
        }
        return result;
    }

    public String getName() {
        return this.configCompTypeId.getConfigurationComponent().getId();
    }

    public String getUiName() {
        return this.configCompTypeId.getConfigurationComponent().getLabel((IContext)this.expressionContext);
    }

    public @Nullable String getDescription() {
        return this.configCompTypeId.getConfigurationComponent().getResolvedDescription((IContext)this.expressionContext);
    }

    public ChildContext getChildContext() {
        return this.childContext;
    }

    public IContext getExpressionContext() {
        return this.expressionContext;
    }

    public ICommonMcu getMcu() {
        return this.mcu;
    }

    public ConfigurationComponentTypeId getConfigCompTypeId() {
        return this.configCompTypeId;
    }

    public String getComponentTypeId() {
        return this.configCompTypeId.getTypeId();
    }

    public String getScriptFile() {
        Script script = this.configCompTypeId.getConfigurationComponent().getScript();
        if (script == null) {
            return "";
        }
        Path dir = this.configCompTypeId.getFileLocation();
        return UtilsText.safeString((String)dir.resolve(script.getFile()).toString());
    }

    public @Nullable String getYaml() {
        IRoot profile = this.childContext.getRoot();
        if (profile.isYamlEnabled()) {
            IConfigSetConfig globalConfigSetLoc;
            if ((this.getComponent().isAutoAdding() || this.getComponent().getId().equals("system")) && (globalConfigSetLoc = this.getGlobalConfigSet()) != null && globalConfigSetLoc.getAllStorableSettings().isEmpty()) {
                return null;
            }
            IYamlStorable yamlStorable = StorageYamlConverter.toYamlStorable(this.storageComponent);
            return new PeripheralsYamlConverter().createYamlFunction(yamlStorable);
        }
        return null;
    }

    public void updateStorageAvailability() {
        if (this.globalConfigSet != null) {
            this.globalConfigSet.updateStorageAvailability();
        }
    }

    public void clearCache() {
        IConfigSetConfig globalConfigSetLoc = this.globalConfigSet;
        if (globalConfigSetLoc != null) {
            globalConfigSetLoc.getCache().clear();
            globalConfigSetLoc.getDependencyMap().clear();
        }
    }

    public String readComponentFile(String filePath) {
        String finalPath = String.valueOf(UtilsText.safeString((String)this.configCompTypeId.getFileLocation().toString())) + "\\" + filePath;
        return UtilsText.safeString((String)UtilsFile.readFileToString((String)finalPath, null));
    }

    public long getAutoAddInstancesExpressionResult(IContext context) {
        Expression expression = this.configCompTypeId.getConfigurationComponent().getAutoAddInstancesExpression();
        return expression != null ? expression.resolve(context).getLong() : 0L;
    }

    public void dispose() {
        this.globalConfigSet = null;
        this.childContext.dispose();
    }

    public void initializeGlobalConfigSet() {
        StoragePeriphsConfigSet configSetStorage = this.storageComponent.getConfig_set_global();
        IConfigurationComponent component = this.configCompTypeId.getConfigurationComponent();
        IConfigSet configSet = component.getGlobalConfigSet();
        if (configSet != null) {
            ConfigSetConfig configSetConfig = configSetStorage != null ? new ConfigSetConfig(configSet.getId(), configSet, configSetStorage, this.childContext, this.mcu, true) : new ConfigSetConfig(configSet.getId(), configSet, this.childContext, this.mcu, true);
            this.globalConfigSet = configSetConfig;
            this.storageComponent.setConfig_set_global(configSetConfig.getStorageConfigSet());
            configSetConfig.applySelectedQuickSelection();
        } else {
            this.globalConfigSet = null;
            if (configSetStorage != null) {
                LOGGER.severe(MessageFormat.format("[DATA] Component with ID \"{0}\" does not contain a global config-set, but one was loaded from MEX", component.getId()));
            }
        }
        this.updateStorageAvailability();
    }

    public StringBuilder dump(StringBuilder builder, DumpFormatOptions options) {
        DumpFormatOptions optionsForChildren = new DumpFormatOptions(options).indentation(options.getIndentation() + 1);
        builder.append("[").append(this.getClass().getSimpleName()).append(" id: ").append(this.getId()).append(", ").append("settings: ");
        IConfigSetConfig globalConfigSetLoc = this.globalConfigSet;
        if (globalConfigSetLoc != null) {
            globalConfigSetLoc.dump(builder, optionsForChildren);
        } else {
            builder.append("[").append("]");
        }
        builder.append("]");
        return builder;
    }
}

