/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.sdk.ISdkFileProvider;
import com.nxp.swtools.sdkmanifest.consts.SdkConsts;
import com.nxp.swtools.sdkmanifest.descriptors.CompilerDefineSymbol;
import com.nxp.swtools.sdkmanifest.descriptors.CoreBootRole;
import com.nxp.swtools.sdkmanifest.descriptors.SdkBoardExample;
import com.nxp.swtools.sdkmanifest.descriptors.SdkBoardsDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkComponentDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkComponentsDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceCore;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDevicesDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkIncludePath;
import com.nxp.swtools.sdkmanifest.descriptors.SdkMetaData;
import com.nxp.swtools.sdkmanifest.descriptors.SdkOptionBase;
import com.nxp.swtools.sdkmanifest.descriptors.SdkSourceFile;
import com.nxp.swtools.sdkmanifest.descriptors.SdkTagContentVersion;
import com.nxp.swtools.sdkmanifest.descriptors.SdkToolchain;
import com.nxp.swtools.sdkmanifest.descriptors.SdkToolchainsSettingsDescriptor;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoader;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import com.nxp.swtools.sdkmanifest.loader.MultipleManifestLoader;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkManifestDescriptor {
    @NonNull
    public static final String WEB_SDK_PATH = "sdk_on_web:\\";
    @NonNull
    private static final Pattern DOLLAR_DEVICE_PATTERN = Pattern.compile("\\$(\\|device\\||\\[device\\])");
    @NonNull
    private static final Pattern DOLLAR_DEVICE_FULL_NAME_PATTERN = Pattern.compile("\\$(\\|device_full_name\\||\\[device_full_name\\])");
    @NonNull
    private static final Pattern DOLLAR_COMPILER_PATTERN = Pattern.compile("\\$(\\|compiler\\||\\[compiler\\])");
    @NonNull
    private static final Pattern DOLLAR_TOOLCHAIN_PATTERN = Pattern.compile("\\$(\\|toolchain\\||\\[toolchain\\])");
    @NonNull
    private static final Pattern DOLLAR_CORE_PATTERN = Pattern.compile("\\$(\\|core\\||\\[core\\])");
    @NonNull
    private static final Pattern DOLLAR_CORE_NAME_PATTERN = Pattern.compile("\\$\\|core_name\\|");
    @NonNull
    private static final Pattern DOLLAR_CORE_TYPE_PATTERN = Pattern.compile("\\$\\|core_type\\|");
    @NonNull
    private static final Pattern DOLLAR_PACKAGE_PATTERN = Pattern.compile("\\$(\\|package\\||\\[package\\])");
    @NonNull
    private static final Pattern DOLLAR_ANYTHING_PATTERN = Pattern.compile("\\$(\\|.*?\\||\\[.*?\\])");
    @NonNull
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    @NonNull
    private static final Pattern ASTERISK_PATTERN = Pattern.compile("\\*");
    @NonNull
    private static final Pattern QUESTION_MARK_PATTERN = Pattern.compile("\\?");
    @NonNull
    private final Map<String, String> compilersMap;
    @NonNull
    private final @NonNull Collection<@NonNull SdkToolchain> toolchains;
    @NonNull
    private final SdkComponentsDescriptor sdkComponentsDescriptor;
    @NonNull
    private final SdkDevicesDescriptor sdkDevicesDescriptor;
    @NonNull
    private final SdkBoardsDescriptor sdkBoardsDescriptor;
    @NonNull
    private final SdkToolchainsSettingsDescriptor sdkToolchainSettingsDescriptor;
    @NonNull
    private final @NonNull Collection<@NonNull CompilerDefineSymbol> defines;
    @Nullable
    private final String sdkVersionNumber;
    @Nullable
    private final SdkVersion sdkVersion;
    @Nullable
    private final String sdkBuildVersionValue;
    @NonNull
    private final String manifestFormatVersionText;
    private final Version formatVersion;
    @NonNull
    private final String cfgHash;
    @Nullable
    private final String sdkRootDirectory;
    @NonNull
    public static final String GCC_COMPILER = "gcc";
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SdkManifestDescriptor.class);
    @NonNull
    private static final @NonNull Set<@NonNull String> SUPPORTED_TOOLCHAINS;
    @NonNull
    private static final @NonNull Set<@NonNull String> TOOLCHAINS_CAPABLE_CLONE;

    static {
        HashSet<@NonNull String> supportedToolchains = new HashSet<String>();
        supportedToolchains.add("armgcc");
        supportedToolchains.add("iar");
        supportedToolchains.add("mdk");
        supportedToolchains.add("dsmdk");
        supportedToolchains.add("cwmcu");
        if (Rap.isActive() || SWToolsProperties.isHeadlessOn()) {
            supportedToolchains.add("kds");
        }
        SUPPORTED_TOOLCHAINS = CollectionsUtils.unmodifiableSet(supportedToolchains);
        HashSet<@NonNull String> cloningCapableToolchains = new HashSet<String>();
        cloningCapableToolchains.add("kds");
        cloningCapableToolchains.add("mcuxpresso");
        TOOLCHAINS_CAPABLE_CLONE = CollectionsUtils.unmodifiableSet(cloningCapableToolchains);
    }

    SdkManifestDescriptor(@Nullable String rootDir, @NonNull String manifestFormatVersionText, Version formatVersion, @Nullable String versionNumber, @Nullable String buildVersion, @NonNull String cfgHash, @NonNull Collection<@NonNull SdkToolchain> toolchains, @NonNull Map<String, String> compilersMap, @NonNull SdkComponentsDescriptor compsDescriptor, @NonNull SdkDevicesDescriptor devicesDescriptor, @NonNull SdkBoardsDescriptor boardsDescriptor, @NonNull SdkToolchainsSettingsDescriptor toolchainsDescriptor, @NonNull Collection<@NonNull CompilerDefineSymbol> defines) {
        this.sdkRootDirectory = rootDir;
        this.manifestFormatVersionText = manifestFormatVersionText;
        this.formatVersion = formatVersion;
        this.cfgHash = cfgHash;
        this.sdkVersionNumber = versionNumber;
        this.sdkVersion = versionNumber == null ? null : new SdkVersion(versionNumber);
        this.sdkBuildVersionValue = buildVersion;
        toolchains.removeIf(t -> !SdkManifestDescriptor.isToolchainSupportedInTheTool(t.getId()) && !SdkManifestDescriptor.isToolchainCapableClonePrjNatively(t.getId()));
        this.toolchains = CollectionsUtils.unmodifiableCollection(toolchains);
        this.compilersMap = compilersMap;
        this.sdkComponentsDescriptor = compsDescriptor;
        this.sdkDevicesDescriptor = devicesDescriptor;
        this.sdkBoardsDescriptor = boardsDescriptor;
        this.sdkToolchainSettingsDescriptor = toolchainsDescriptor;
        this.defines = defines;
    }

    public @NonNull String getSdkConfigurationHash() {
        return this.cfgHash;
    }

    public static @NonNull String regexFromFileMask(@NonNull String fileMask, @NonNull SdkDeviceDescriptor device, @NonNull SdkDeviceCore core, @NonNull String compilerMacroValue, @NonNull String toolchainId, @Nullable String packageName) {
        return SdkManifestDescriptor.regexFromFileMask(fileMask, device.getName(), device.getFullName(), core, compilerMacroValue, toolchainId, packageName);
    }

    public static @NonNull String regexFromFileMask(@NonNull String fileMask, @Nullable String device, @Nullable String deviceFullName, @Nullable SdkDeviceCore core, @Nullable String compilerMacroValue, @Nullable String toolchainId, @Nullable String packageName) {
        String localFileMask = SdkManifestDescriptor.resolveVariables(fileMask, device, deviceFullName, core, compilerMacroValue, toolchainId, packageName);
        localFileMask = UtilsText.safeString((String)DOT_PATTERN.matcher(localFileMask).replaceAll("\\\\."));
        localFileMask = UtilsText.safeString((String)ASTERISK_PATTERN.matcher(localFileMask).replaceAll(".*"));
        localFileMask = UtilsText.safeString((String)QUESTION_MARK_PATTERN.matcher(localFileMask).replaceAll("."));
        return localFileMask;
    }

    public static boolean containsUnresolvedVariable(@NonNull String input) {
        return DOLLAR_ANYTHING_PATTERN.matcher(input).find();
    }

    public static @NonNull Collection<String> resolveVariables(@NonNull Collection<String> inputs, @NonNull SdkDeviceDescriptor device, @NonNull SdkDeviceCore core, @NonNull String compilerMacroValue, @NonNull String toolchainId, @Nullable String packageName) {
        ArrayList<String> result = new ArrayList<String>();
        for (String input : inputs) {
            if (input != null) {
                result.add(SdkManifestDescriptor.resolveVariables(input, device, core, compilerMacroValue, toolchainId, packageName));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public static @NonNull String resolveVariables(@NonNull String input, @NonNull SdkDeviceDescriptor device, @NonNull SdkDeviceCore core, @NonNull String compilerMacroValue, @NonNull String toolchainId, @Nullable String packageName) {
        return SdkManifestDescriptor.resolveVariables(input, device.getName(), device.getFullName(), core, compilerMacroValue, toolchainId, packageName);
    }

    public static @NonNull String resolveVariables(@NonNull String input, @Nullable String device, @Nullable String deviceFullName, @Nullable SdkDeviceCore core, @Nullable String compilerMacroValue, @Nullable String toolchainId, @Nullable String packageName) {
        String output = input;
        if (device != null) {
            output = SdkManifestDescriptor.resolveVariable(DOLLAR_DEVICE_PATTERN, device, output);
        }
        if (deviceFullName != null) {
            output = SdkManifestDescriptor.resolveVariable(DOLLAR_DEVICE_FULL_NAME_PATTERN, deviceFullName, output);
        }
        if (compilerMacroValue != null) {
            output = SdkManifestDescriptor.resolveVariable(DOLLAR_COMPILER_PATTERN, compilerMacroValue, output);
        }
        if (toolchainId != null) {
            output = SdkManifestDescriptor.resolveVariable(DOLLAR_TOOLCHAIN_PATTERN, toolchainId, output);
        }
        if (core != null) {
            output = SdkManifestDescriptor.resolveVariable(DOLLAR_CORE_PATTERN, core.getCoreType(), output);
            output = SdkManifestDescriptor.resolveVariable(DOLLAR_CORE_NAME_PATTERN, core.getCoreName(), output);
            output = SdkManifestDescriptor.resolveVariable(DOLLAR_CORE_TYPE_PATTERN, core.getCoreType(), output);
        }
        if (packageName != null) {
            output = SdkManifestDescriptor.resolveVariable(DOLLAR_PACKAGE_PATTERN, packageName, output);
        }
        return output;
    }

    private static @NonNull String resolveVariable(@NonNull Pattern pattern, @NonNull String variableValue, @NonNull String input) {
        return UtilsText.safeString((String)pattern.matcher(input).replaceAll(variableValue));
    }

    public @NonNull SdkComponentsDescriptor getSdkComponentsDescriptor() {
        return this.sdkComponentsDescriptor;
    }

    public @NonNull SdkDevicesDescriptor getSdkDevicesDescriptor() {
        return this.sdkDevicesDescriptor;
    }

    public @NonNull SdkBoardsDescriptor getSdkBoardsDescriptor() {
        return this.sdkBoardsDescriptor;
    }

    public @NonNull SdkToolchainsSettingsDescriptor getSdkToolchainSettingsDescriptor() {
        return this.sdkToolchainSettingsDescriptor;
    }

    public @Nullable SdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    public @Nullable String getSdkVersionNumber() {
        return this.sdkVersionNumber;
    }

    public @Nullable String getSdkRootDirectory() {
        return this.sdkRootDirectory;
    }

    public @Nullable String getSdkBuildVersionValue() {
        return this.sdkBuildVersionValue;
    }

    public @NonNull String getManifestFormatVersionText() {
        return this.manifestFormatVersionText;
    }

    public Version getFormatVersion() {
        return this.formatVersion;
    }

    public boolean isFormatVersionLowerThan(@NonNull Version compareVersion) {
        return this.getFormatVersion().compareTo(compareVersion) < 0;
    }

    public @NonNull Map<String, String> getCompilersMap() {
        return CollectionsUtils.unmodifiableMap(this.compilersMap);
    }

    public static boolean isToolchainSupportedInTheTool(@NonNull String toolchainId) {
        return SUPPORTED_TOOLCHAINS.contains(toolchainId);
    }

    public static boolean isToolchainCapableClonePrjNatively(@NonNull String toolchainId) {
        return TOOLCHAINS_CAPABLE_CLONE.contains(toolchainId);
    }

    public @NonNull Collection<@NonNull SdkToolchain> getToolchains() {
        return this.toolchains;
    }

    public @Nullable SdkDeviceDescriptor getDeviceByPackageName(@NonNull String packageName) {
        return this.sdkDevicesDescriptor.getSdkDeviceDescriptorByPackageName(packageName);
    }

    public @Nullable SdkDeviceDescriptor getDeviceByPackageId(@NonNull String packageId) {
        return this.sdkDevicesDescriptor.getSdkDeviceDescriptorByPackageId(packageId);
    }

    public @Nullable SdkDeviceDescriptor getDeviceByFullName(@NonNull String fullName) {
        return this.sdkDevicesDescriptor.getSdkDeviceDescriptorByFullName(fullName);
    }

    public @Nullable SdkDeviceDescriptor getDeviceById(@NonNull String id) {
        return this.sdkDevicesDescriptor.getSdkDeviceDescriptorById(id);
    }

    public @NonNull ManifestHelper getManifestHelper(@NonNull String cpu, @NonNull String compilerMacroValue, @NonNull String toolchainId) {
        return new ManifestHelper(cpu, compilerMacroValue, toolchainId, this);
    }

    public @NonNull ManifestHelper getManifestHelper(@NonNull SdkDeviceDescriptor device, @NonNull SdkDeviceCore core, @NonNull String compilerMacroValue, @NonNull String toolchainId, @Nullable String packageName) {
        ManifestHelper helper = new ManifestHelper(device, core, compilerMacroValue, toolchainId, this);
        if (packageName != null && !device.getPackageNames().contains(packageName)) {
            if (!device.getPackages().containsKey(packageName)) {
                throw new IllegalArgumentException(UtilsText.format((String)"Selected device `{0}` does not contain selected package `{1}`", (Object[])new Object[]{device.getFullName(), packageName}));
            }
            packageName = device.getPackages().get(packageName);
        }
        helper.setPackageName(packageName);
        return helper;
    }

    private int compareSdkVersionTo(@NonNull String version) {
        SdkVersion sdkVersionLoc = this.sdkVersion;
        if (sdkVersionLoc == null) {
            throw new IllegalStateException("Manifest SDK version is null");
        }
        return sdkVersionLoc.compareTo(new SdkVersion(version));
    }

    private int compareSdkVersionTo(@NonNull SdkVersion version) {
        SdkVersion sdkVersionLoc = this.sdkVersion;
        if (sdkVersionLoc == null) {
            throw new IllegalStateException("Manifest SDK version is null");
        }
        return sdkVersionLoc.compareTo(version);
    }

    public boolean isSdkVersionLowerOrEqual(@NonNull SdkVersion version) {
        return this.compareSdkVersionTo(version) <= 0;
    }

    public boolean isSdkVersionLower(@NonNull SdkVersion version) {
        return this.compareSdkVersionTo(version) < 0;
    }

    public boolean isSdkVersionEqualTo(@NonNull SdkVersion version) {
        return this.compareSdkVersionTo(version) == 0;
    }

    public boolean isSdkVersionGreater(@NonNull SdkVersion version) {
        return this.compareSdkVersionTo(version) > 0;
    }

    public boolean isSdkVersionGreaterOrEqual(@NonNull SdkVersion version) {
        return this.compareSdkVersionTo(version) >= 0;
    }

    public boolean isSdkVersionLowerOrEqual(@NonNull String version) {
        return this.compareSdkVersionTo(version) <= 0;
    }

    public boolean isSdkVersionLower(@NonNull String version) {
        return this.compareSdkVersionTo(version) < 0;
    }

    public boolean isSdkVersionEqualTo(@NonNull String version) {
        return this.compareSdkVersionTo(version) == 0;
    }

    public boolean isSdkVersionGreater(@NonNull String version) {
        return this.compareSdkVersionTo(version) > 0;
    }

    public boolean isSdkVersionGreaterOrEqual(@NonNull String version) {
        return this.compareSdkVersionTo(version) >= 0;
    }

    public @NonNull Collection<@NonNull String> getRtosNames() {
        return (Collection)this.getRtosComponents().stream().map(m -> m.getName()).collect(CollectorsUtils.toList());
    }

    public @NonNull Collection<@NonNull SdkComponentDescriptor> getRtosComponents() {
        HashSet<@NonNull SdkComponentDescriptor> result = new HashSet<SdkComponentDescriptor>();
        for (SdkComponentDescriptor compDescr : this.getSdkComponentsDescriptor().getSdkComponents()) {
            if (!"OS".equals(compDescr.getType()) || "ucosii".equals(compDescr.getName()) || "ucosiii".equals(compDescr.getName())) continue;
            result.add(compDescr);
        }
        return result;
    }

    public @NonNull Collection<@NonNull CompilerDefineSymbol> getDefines() {
        return this.defines;
    }

    public static @Nullable SdkBoardExample loadExample(@NonNull Element exampleElem, @NonNull String boardSubDir, @Nullable SdkBoardExample parentExample, @NonNull Version manifestFormatVersion) {
        String id = exampleElem.getAttribute("id");
        String name = exampleElem.getAttribute("name");
        String category = exampleElem.getAttribute("category");
        String path = exampleElem.hasAttribute("path") ? exampleElem.getAttribute("path") : (parentExample != null ? parentExample.getSdkRelPath() : "boards" + File.separator + boardSubDir + File.separator + category + File.separator + name);
        if (!name.isEmpty()) {
            Collection compilers;
            Collection toolchains;
            boolean loadToolchains;
            Collection<Object> devices;
            if (parentExample != null) {
                if (!name.equals(parentExample.getName())) {
                    LOGGER.log(Level.SEVERE, UtilsText.format((String)"Example `{0}` name does not match with example.xml", (Object[])new Object[]{String.valueOf(parentExample.getName()) + '/' + name}));
                    return null;
                }
                if (!category.equals(parentExample.getCategory())) {
                    LOGGER.log(Level.SEVERE, UtilsText.format((String)"Example `{0}` category does not match with example.xml: {1}", (Object[])new Object[]{name, String.valueOf(category) + '/' + parentExample.getCategory()}));
                    if (category.isEmpty()) {
                        category = parentExample.getCategory();
                    }
                }
            }
            String description = exampleElem.hasAttribute("brief") ? exampleElem.getAttribute("brief") : (exampleElem.hasAttribute("description") ? exampleElem.getAttribute("description") : (parentExample != null ? parentExample.getDescription() : null));
            String dependencyStr = exampleElem.hasAttribute("dependency") ? exampleElem.getAttribute("dependency") : "";
            if (exampleElem.hasAttribute("devices")) {
                String devicesStr = exampleElem.getAttribute("devices");
                devices = Arrays.asList(devicesStr.split(" "));
            } else if (exampleElem.hasAttribute("device")) {
                devices = new ArrayList();
                devices.add(exampleElem.getAttribute("device"));
            } else {
                devices = parentExample != null ? parentExample.getDevices() : null;
            }
            boolean bl = loadToolchains = parentExample == null || manifestFormatVersion.compareTo(SdkConsts.MANIFEST_FORMAT_VERSION_3_4) < 0;
            if (exampleElem.hasAttribute("toolchain") && loadToolchains) {
                Collection<String> parToolchains;
                String toochainsStr = exampleElem.getAttribute("toolchain");
                List<@NonNull String> t = Arrays.asList(toochainsStr.split(" "));
                Collection<String> collection = parToolchains = parentExample != null ? parentExample.getToolchains() : null;
                if (parToolchains != null) {
                    HashSet<@NonNull String> interSect = new HashSet<String>(t);
                    interSect.retainAll(parToolchains);
                    toolchains = CollectionsUtils.unmodifiableCollection(new ArrayList<String>(interSect));
                    assert (parentExample != null);
                    parentExample.setToolchains(toolchains);
                } else {
                    toolchains = t;
                }
            } else {
                toolchains = parentExample != null ? parentExample.getToolchains() : null;
            }
            if (exampleElem.hasAttribute("compiler")) {
                Collection<String> parCompilers;
                String compilersStr = exampleElem.getAttribute("compiler");
                List<@NonNull String> cmplrs = Arrays.asList(compilersStr.split(" "));
                Collection<String> collection = parCompilers = parentExample != null ? parentExample.getCompilers() : null;
                if (parCompilers != null) {
                    HashSet<String> interSect = new HashSet<String>(cmplrs);
                    interSect.retainAll(parCompilers);
                    compilers = CollectionsUtils.unmodifiableCollection(new ArrayList(interSect));
                    assert (parentExample != null);
                    parentExample.setCompilers(compilers);
                } else {
                    compilers = cmplrs;
                }
            } else {
                compilers = parentExample != null ? parentExample.getCompilers() : null;
            }
            String mcuXpressoExmplRelPath = null;
            List<Element> externalElems = ManifestLoaderUtils.getChildrenElements(exampleElem, "external");
            for (Element externalElem : externalElems) {
                String fileName;
                if (!"xml".equals(externalElem.getAttribute("type"))) continue;
                String xmlPath = externalElem.getAttribute("path");
                Element filesElem = ManifestLoaderUtils.getChildElementByName(externalElem, "files");
                if (filesElem == null || xmlPath.isEmpty() || (fileName = filesElem.getAttribute("mask")).isEmpty()) continue;
                assert (mcuXpressoExmplRelPath == null);
                mcuXpressoExmplRelPath = String.valueOf(xmlPath.replace('/', File.separatorChar)) + File.separator + fileName;
            }
            if (mcuXpressoExmplRelPath == null && parentExample != null) {
                mcuXpressoExmplRelPath = parentExample.getMcuXpressoExamplePrjRelPath();
            }
            List<@NonNull SdkSourceFile> exampleSrcFiles = manifestFormatVersion.compareTo(SdkConsts.MANIFEST_FORMAT_VERSION_3_8) < 0 ? SdkSourceFile.loadOldCompExamSourceFiles_manifest3_7(exampleElem, manifestFormatVersion, false) : SdkSourceFile.loadExampleSourceFiles(exampleElem, false, manifestFormatVersion, path);
            @NonNull String[] depArr = dependencyStr.split(" ");
            assert (depArr != null);
            List<@NonNull String> depList = Arrays.asList(depArr);
            assert (depList != null);
            if (depList.contains("")) {
                depList = new ArrayList<String>(depList);
                ListIterator<String> depIter = depList.listIterator();
                while (depIter.hasNext()) {
                    String elem = depIter.next();
                    if (!elem.isEmpty()) continue;
                    depIter.remove();
                }
            }
            List<@NonNull SdkIncludePath> includePaths = manifestFormatVersion.compareTo(SdkConsts.MANIFEST_FORMAT_VERSION_3_8) < 0 ? SdkIncludePath.loadOldCompExamIncludePath_manifest3_7(exampleElem) : SdkIncludePath.loadExamIncludePath(exampleElem);
            String deviceCoreId = exampleElem.hasAttribute("device_core") ? exampleElem.getAttribute("device_core") : null;
            String linkedProject = exampleElem.hasAttribute("linked_projects") ? exampleElem.getAttribute("linked_projects") : (parentExample != null ? parentExample.getLinkedProjectIdsString() : null);
            return new SdkBoardExample(id, name, category, path, description, exampleSrcFiles, includePaths, depList, devices, toolchains, compilers, mcuXpressoExmplRelPath, deviceCoreId, linkedProject);
        }
        LOGGER.log(Level.SEVERE, "name or category bot defined in example element, example ignored");
        return null;
    }

    public static @Nullable Collection<@NonNull SdkBoardExample> loadExamples(@Nullable Element examplesElem, @NonNull String boardSubDir, @NonNull Version manifestFormatVersion) {
        if (examplesElem == null) {
            return null;
        }
        List<Element> exampleNodeList = ManifestLoaderUtils.getChildrenElements(examplesElem, "example");
        if (exampleNodeList.isEmpty()) {
            return null;
        }
        ArrayList<@NonNull SdkBoardExample> result = new ArrayList<SdkBoardExample>();
        for (Element exampleElem : exampleNodeList) {
            assert (exampleElem != null);
            SdkBoardExample loadedExample = SdkManifestDescriptor.loadExample(exampleElem, boardSubDir, null, manifestFormatVersion);
            if (loadedExample == null) continue;
            result.add(loadedExample);
        }
        return result;
    }

    static String @NonNull [] loadComponentDependencies(@NonNull Element compElem) {
        Element depnedenciesConditionElement;
        String @NonNull [] deps = new String[]{};
        Element dependenciesElement = ManifestLoaderUtils.getChildElementByName(compElem, "dependencies");
        if (dependenciesElement != null && (depnedenciesConditionElement = ManifestLoaderUtils.getChildElementByName(dependenciesElement, "all")) != null) {
            List<@NonNull Element> depenfecyElements = ManifestLoaderUtils.getChildrenElements(depnedenciesConditionElement, "component_dependency");
            deps = (String[])depenfecyElements.stream().map(e -> e.getAttribute("value")).toArray(String[]::new);
        }
        return deps;
    }

    public String toString() {
        return UtilsText.safeString((String)this.sdkRootDirectory);
    }

    public static class Builder {
        @NonNull
        private Map<String, String> compilersMap = new HashMap<String, String>();
        @NonNull
        private @NonNull Set<@NonNull SdkToolchain> toolchains = new HashSet<SdkToolchain>();
        @NonNull
        private SdkComponentsDescriptor sdkComponentsDescriptor = new SdkComponentsDescriptor(new ArrayList<SdkComponentDescriptor>());
        @NonNull
        private SdkDevicesDescriptor sdkDevicesDescriptor = new SdkDevicesDescriptor(new HashMap<String, SdkDeviceDescriptor>());
        @NonNull
        private SdkBoardsDescriptor sdkBoardsDescriptor = new SdkBoardsDescriptor();
        @NonNull
        private SdkToolchainsSettingsDescriptor sdkToolchainsDescriptor = new SdkToolchainsSettingsDescriptor();
        @Nullable
        private String sdkVersionNumber;
        @Nullable
        private String sdkBuildVersionValue;
        @NonNull
        private String manifestFormatVersionText = "0";
        @NonNull
        private Version manifestFormatVersion = Version.emptyVersion;
        @NonNull
        String cfgHash = "";
        @Nullable
        private String sdkRootDirectory;
        @NonNull
        private @NonNull Collection<@NonNull CompilerDefineSymbol> defines = new ArrayList<CompilerDefineSymbol>();

        public @NonNull Builder addCompiler(@NonNull String compilerId, @NonNull String compilerMacroSymbol) {
            this.compilersMap.put(compilerId, compilerMacroSymbol);
            return this;
        }

        public @NonNull Builder setCompilersMap(@NonNull Map<String, String> compilersMap) {
            this.compilersMap.clear();
            this.compilersMap.putAll(compilersMap);
            return this;
        }

        public void addToolchain(@NonNull SdkToolchain toolchain) {
            this.toolchains.add(toolchain);
        }

        public @NonNull Builder setSdkBuildVersionValue(@Nullable String sdkBuildVersionValue) {
            this.sdkBuildVersionValue = sdkBuildVersionValue;
            return this;
        }

        public @NonNull Builder setSdkRootDirectory(@Nullable String sdkRootDirectory) {
            this.sdkRootDirectory = sdkRootDirectory;
            return this;
        }

        public @NonNull Builder setSdkComponentsDescriptor(@NonNull SdkComponentsDescriptor sdkComponentsDescriptor) {
            this.sdkComponentsDescriptor = sdkComponentsDescriptor;
            return this;
        }

        public @NonNull Builder setSdkDevicesDescriptor(@NonNull SdkDevicesDescriptor sdkDevicesDescriptor) {
            this.sdkDevicesDescriptor = sdkDevicesDescriptor;
            return this;
        }

        public @NonNull Builder setSdkBoardsDescriptor(@NonNull SdkBoardsDescriptor sdkBoardsDescriptor) {
            this.sdkBoardsDescriptor = sdkBoardsDescriptor;
            return this;
        }

        public @NonNull Builder setSdkToolchainsDescriptor(@NonNull SdkToolchainsSettingsDescriptor sdkToolchainsDescriptor) {
            this.sdkToolchainsDescriptor = sdkToolchainsDescriptor;
            return this;
        }

        public @NonNull Builder setSdkVersionNumber(@Nullable String sdkVersionNumber) {
            this.sdkVersionNumber = sdkVersionNumber;
            return this;
        }

        public @NonNull Builder setManifestFormatVersion(@NonNull String manifestFormatVersion) {
            assert (!manifestFormatVersion.isEmpty() && (manifestFormatVersion.startsWith("1.") || manifestFormatVersion.startsWith("2.") || manifestFormatVersion.startsWith("3.")));
            this.manifestFormatVersionText = manifestFormatVersion;
            this.manifestFormatVersion = ManifestLoader.decodeManifestFormatVersion(manifestFormatVersion);
            return this;
        }

        public @NonNull Version getManifestFormatVersion() {
            return this.manifestFormatVersion;
        }

        public void setSdkConfigurationHash(@NonNull String hash) {
            this.cfgHash = hash;
        }

        public void addCompilerDefineSymbols(@NonNull Collection<@NonNull CompilerDefineSymbol> addDefines) {
            this.defines.addAll(addDefines);
        }

        public @NonNull SdkManifestDescriptor build() {
            this.sdkBoardsDescriptor.resolveBoardProcessors(this.sdkDevicesDescriptor);
            SdkManifestDescriptor sdkManifestDescriptor = new SdkManifestDescriptor(this.sdkRootDirectory, this.manifestFormatVersionText, this.manifestFormatVersion, this.sdkVersionNumber, this.sdkBuildVersionValue, this.cfgHash, this.toolchains, this.compilersMap, this.sdkComponentsDescriptor, this.sdkDevicesDescriptor, this.sdkBoardsDescriptor, this.sdkToolchainsDescriptor, this.defines);
            return sdkManifestDescriptor;
        }

        private static void loadCompilers(@Nullable Element compilersElem, @NonNull Builder sdkManifestDescriptorBuilder) {
            if (compilersElem != null) {
                List<Element> compilersNodeList = ManifestLoaderUtils.getChildrenElements(compilersElem, "compiler");
                for (Element elem : compilersNodeList) {
                    String compilerMacroSymbol;
                    String compilerId;
                    if (elem.hasAttribute("id")) {
                        compilerId = UtilsText.safeString((String)elem.getAttribute("id"));
                        compilerMacroSymbol = UtilsText.safeString((String)elem.getAttribute("name"));
                    } else if (elem.hasAttribute("name")) {
                        compilerMacroSymbol = compilerId = UtilsText.safeString((String)elem.getAttribute("name"));
                    } else {
                        compilerId = "";
                        compilerMacroSymbol = "";
                    }
                    if (compilerId.isEmpty() || compilerMacroSymbol.isEmpty()) continue;
                    sdkManifestDescriptorBuilder.addCompiler(compilerId, compilerMacroSymbol);
                }
            }
        }

        private static void loadToolchains(@Nullable Element toolchainElem, @NonNull Builder sdkManifestDescriptorBuilder) {
            if (toolchainElem != null) {
                List<Element> toolchainsNodeList = ManifestLoaderUtils.getChildrenElements(toolchainElem, sdkManifestDescriptorBuilder.isManifestFormateVersionLowerThat3() ? "tool" : "toolchain");
                for (Element elem : toolchainsNodeList) {
                    String compilerTag;
                    String name;
                    String id = elem.getAttribute("id");
                    if (!ManifestLoaderUtils.isKnownToolchain(id)) {
                        LOGGER.severe("Uknown toolchain ID in the Manifest: " + id);
                    }
                    if ((name = elem.getAttribute("full_name")).isEmpty()) {
                        if (MultipleManifestLoader.getMinFormatVersion() >= 3.0) {
                            LOGGER.log(Level.SEVERE, "Toolchain full_name attribute is not defined");
                        }
                        name = UtilsText.safeString((String)elem.getAttribute("name"));
                    }
                    if ((compilerTag = elem.getAttribute("compiler")).isEmpty() && sdkManifestDescriptorBuilder.isManifestFormateVersionLowerThat3() && "kds".equals(id)) {
                        compilerTag = SdkManifestDescriptor.GCC_COMPILER;
                    }
                    List<String> compilersIds = Arrays.asList(compilerTag.split(" "));
                    String vendor = UtilsText.safeString((String)elem.getAttribute("vendor"));
                    String url = UtilsText.safeString((String)elem.getAttribute("vendor_url"));
                    if (!(id.isEmpty() || compilersIds.isEmpty() || name.isEmpty())) {
                        sdkManifestDescriptorBuilder.addToolchain(new SdkToolchain(id, compilersIds, name, vendor, url));
                        continue;
                    }
                    if (!(MultipleManifestLoader.getMinFormatVersion() >= 3.0)) continue;
                    LOGGER.log(Level.SEVERE, "Invalid toolchain declaration - ignored");
                }
            }
        }

        private void loadDevices(@Nullable Element devices, @NonNull SdkDevicesDescriptor.Builder sdkDevicesDescriptorBuilder, @NonNull SdkToolchainsSettingsDescriptor.Builder glbToolchainsDescriptorBuilder) {
            if (devices == null) {
                return;
            }
            List<Element> deviceElems = ManifestLoaderUtils.getChildrenElements(devices, "device");
            for (Element deviceElem : deviceElems) {
                assert (deviceElem != null);
                String deviceName = deviceElem.getAttribute("name");
                if (!deviceName.isEmpty()) {
                    String deviceID = deviceElem.getAttribute("id");
                    if (deviceID.isEmpty()) {
                        deviceID = deviceName;
                    }
                    HashMap<@NonNull String, @NonNull String> packageList = new HashMap<String, String>();
                    ArrayList<@NonNull String> evalBoards = new ArrayList<String>();
                    ArrayList<@NonNull SdkDeviceCore> cores = new ArrayList<SdkDeviceCore>();
                    List<Element> packageElems = ManifestLoaderUtils.getChildrenElements(deviceElem, "package");
                    for (Element elemPackage : packageElems) {
                        if (!elemPackage.hasAttribute("name")) continue;
                        String name = elemPackage.getAttribute("name");
                        String id = elemPackage.getAttribute("id");
                        packageList.put(id.isEmpty() ? name : id, name);
                    }
                    Element evalBrdsElem = ManifestLoaderUtils.getChildElementByName(deviceElem, "evaluation_boards");
                    if (evalBrdsElem != null) {
                        List<Element> evalBrdElems = ManifestLoaderUtils.getChildrenElements(evalBrdsElem, "evaluation_board");
                        for (Element element : evalBrdElems) {
                            if (!element.hasAttribute("name")) continue;
                            evalBoards.add(UtilsText.safeString((String)element.getAttribute("name")));
                        }
                    }
                    List<@NonNull Element> coreElems = ManifestLoaderUtils.getChildrenElements(deviceElem, "core");
                    for (Element coreElem : coreElems) {
                        try {
                            cores.add(new SdkDeviceCore(coreElem));
                        }
                        catch (IllegalArgumentException e) {
                            LOGGER.log(Level.WARNING, "Invalid content of the core element in " + deviceID, e);
                        }
                    }
                    if (cores.isEmpty()) {
                        LOGGER.log(Level.WARNING, "There are no cores specified for the device: " + deviceID);
                        cores.add(new SdkDeviceCore("UNKNOWN_CORE_ID", "UNKNOWN_CORE_NAME", "UNKNOWN_CORE_TYPE", true, SdkDeviceCore.DEFAULT_BOOT_ROLES, null));
                    }
                    if (!packageList.isEmpty() && !cores.isEmpty()) {
                        String deviceFullName = deviceElem.getAttribute("full_name");
                        if (deviceFullName.isEmpty()) continue;
                        SdkToolchainsSettingsDescriptor.Builder builder = new SdkToolchainsSettingsDescriptor.Builder();
                        String tag = this.isManifestFormateVersionLowerThat3() ? "toolchains" : "toolchainSettings";
                        this.loadSpecificToolchainSettings(ManifestLoaderUtils.getChildElementByName(deviceElem, tag), builder, glbToolchainsDescriptorBuilder);
                        SdkToolchainsSettingsDescriptor toolChainsDescr = builder.build();
                        Collection<CompilerDefineSymbol> loc_defines = CompilerDefineSymbol.readDefinesFromXml(deviceElem);
                        SdkTagContentVersion ver = SdkTagContentVersion.valueOf(deviceElem);
                        SdkMetaData metaData = SdkMetaData.valueOf(deviceElem);
                        SdkDeviceDescriptor.Builder deviceBuilder = new SdkDeviceDescriptor.Builder(deviceID, deviceFullName, deviceName, cores, toolChainsDescr, ver, metaData, loc_defines, this.manifestFormatVersion.getMajor(), packageList, evalBoards);
                        sdkDevicesDescriptorBuilder.addSdkDeviceDescriptor(deviceBuilder.build());
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "No packages specified for the device. It is ignored");
                    continue;
                }
                LOGGER.log(Level.WARNING, "No name attribute listed for the device. It is ignored");
            }
        }

        private void loadBoards(@Nullable Element boards, @NonNull SdkBoardsDescriptor.Builder boardsBuilder, @NonNull ISdkFileProvider sdkFileProvider) {
            if (boards != null) {
                List<Element> boardsNodeList = ManifestLoaderUtils.getChildrenElements(boards, "board");
                for (Element boardElem : boardsNodeList) {
                    String id = boardElem.getAttribute("id");
                    String name = boardElem.getAttribute("name");
                    String subDir = this.isManifestFormateVersionLowerThat3() ? name : id;
                    String packageName = boardElem.getAttribute("package");
                    if (name.isEmpty() || packageName.isEmpty()) continue;
                    Element examplesElem = ManifestLoaderUtils.getChildElementByName(boardElem, "examples");
                    Collection<@NonNull SdkBoardExample> examples = SdkManifestDescriptor.loadExamples(examplesElem, subDir, this.getManifestFormatVersion());
                    String captionAttrName = this.isManifestFormateVersionLowerThat3() ? "user_name" : "full_name";
                    String userName = boardElem.hasAttribute(captionAttrName) ? boardElem.getAttribute(captionAttrName) : null;
                    Collection<CompilerDefineSymbol> loc_defines = CompilerDefineSymbol.readDefinesFromXml(boardElem);
                    boolean kit = "kit".equals(boardElem.getAttribute("type"));
                    SdkMetaData metaData = SdkMetaData.valueOf(boardElem);
                    SdkTagContentVersion tagVersion = SdkTagContentVersion.valueOf(boardElem);
                    SdkBoardsDescriptor.SdkBoardDescriptor.BoardBuilder board = new SdkBoardsDescriptor.SdkBoardDescriptor.BoardBuilder(id, name, subDir, packageName, tagVersion, examples, sdkFileProvider, loc_defines, this.manifestFormatVersion, kit, metaData);
                    board.setUserName(userName);
                    boardsBuilder.addBoard(board);
                }
            }
        }

        private @NonNull Collection<SdkOptionBase> loadOptions(@Nullable Element optionsElement) {
            ArrayList<SdkOptionBase> options = new ArrayList<SdkOptionBase>();
            if (optionsElement != null) {
                List<Element> optionNodeList = ManifestLoaderUtils.getChildrenElements(optionsElement, "option");
                for (Element optionElement : optionNodeList) {
                    String captionAttrName = this.isManifestFormateVersionLowerThat3() ? "user_name" : "full_name";
                    String optionName = UtilsText.safeString((String)optionElement.getAttribute(captionAttrName));
                    String optionId = UtilsText.safeString((String)optionElement.getAttribute("id"));
                    String optionType = UtilsText.safeString((String)optionElement.getAttribute("type"));
                    String optionVariantList = optionElement.getAttribute("variants");
                    List<Element> valueElements = ManifestLoaderUtils.getChildrenElements(optionElement, "value");
                    ArrayList<@NonNull String> values = new ArrayList<String>();
                    int i = 0;
                    while (i < valueElements.size()) {
                        values.add(UtilsText.safeString((String)valueElements.get(i).getTextContent()));
                        ++i;
                    }
                    String[] variants = optionVariantList.split(" ");
                    if (optionId.isEmpty() || optionType.isEmpty() || values.isEmpty()) continue;
                    SdkOptionBase option = SdkOptionBase.createSdkOption(optionId, optionName, values, optionType, variants);
                    options.add(option);
                }
            }
            return options;
        }

        private void loadToolchainSettingsDef(@Nullable Element toolchainsElem, @NonNull SdkToolchainsSettingsDescriptor.Builder toolchainsBuilder) {
            if (toolchainsElem == null) {
                return;
            }
            String settingsTag = this.isManifestFormateVersionLowerThat3() ? "toolchain" : "toolchainSetting";
            List<Element> toolchainElems = ManifestLoaderUtils.getChildrenElements(toolchainsElem, settingsTag);
            for (Element elem : toolchainElems) {
                String name = elem.getAttribute("name");
                if (name.isEmpty()) continue;
                String id = elem.getAttribute("id");
                if (id.isEmpty()) {
                    id = name;
                }
                String captionAttrName = this.isManifestFormateVersionLowerThat3() ? "user_name" : "full_name";
                String fullName = elem.getAttribute(captionAttrName);
                assert (fullName != null);
                String compiler = elem.getAttribute("compiler");
                assert (compiler != null);
                String toolchainId = elem.getAttribute("toolchain");
                assert (toolchainId != null);
                if (id.isEmpty() || (fullName.isEmpty() || compiler.isEmpty()) && toolchainId.isEmpty()) continue;
                Collection<@NonNull CompilerDefineSymbol> loc_defines = CompilerDefineSymbol.readDefinesFromXml(elem);
                SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor.Builder toolchain = new SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor.Builder(id, name, toolchainId, compiler, fullName, loc_defines, SdkTagContentVersion.valueOf("1.0", ""));
                Collection<SdkOptionBase> options = this.loadOptions(elem);
                toolchain.addOptions(options);
                toolchainsBuilder.addSdkToolchain(toolchain);
            }
        }

        private void loadSpecificToolchainSettings(@Nullable Element toolchainsElem, @NonNull SdkToolchainsSettingsDescriptor.Builder toolchainsBuilder, @NonNull SdkToolchainsSettingsDescriptor.Builder glbToolchainsBuilder) {
            if (toolchainsElem == null) {
                return;
            }
            SdkToolchainsSettingsDescriptor glbToolchains = glbToolchainsBuilder.build();
            String settingsTag = this.isManifestFormateVersionLowerThat3() ? "toolchain" : "toolchainSetting";
            List<Element> toolchainElems = ManifestLoaderUtils.getChildrenElements(toolchainsElem, settingsTag);
            for (Element elem : toolchainElems) {
                String idRef = elem.getAttribute("id_ref");
                if (idRef.isEmpty() && (idRef = elem.getAttribute("id_refs")).isEmpty()) {
                    String name = elem.getAttribute("name");
                    if (name.isEmpty()) continue;
                    SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor glbToolchain = glbToolchains.getSdkToolchainSettingsDescrByName(name);
                    if (glbToolchain == null) {
                        LOGGER.log(Level.WARNING, "Invalid reference to toolchain (name): " + name);
                    } else {
                        idRef = glbToolchain.getId();
                    }
                }
                if (idRef.isEmpty()) continue;
                SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor glbToolchain = glbToolchains.getSdkToolchainSettingsDescrById(idRef);
                if (glbToolchain == null) {
                    LOGGER.log(Level.WARNING, "Invalid reference to toolchain (idRef): " + idRef);
                    continue;
                }
                String fullName = glbToolchain.getCaption();
                String compiler = glbToolchain.getCompiler();
                String name = glbToolchain.getName();
                String toolchainId = glbToolchain.getToolchainId();
                SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor.Builder toolchain = new SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor.Builder(idRef, name, toolchainId, compiler, fullName, glbToolchain.getDefines(), SdkTagContentVersion.valueOf("1.0", ""));
                Collection<SdkOptionBase> options = this.loadOptions(elem);
                toolchain.addOptions(options);
                toolchainsBuilder.addSdkToolchain(toolchain);
            }
        }

        private static @Nullable Set<@NonNull String> loadOptionalSetFromAttr(@NonNull Element compElem, @NonNull String attrName) {
            if (!compElem.hasAttribute(attrName)) {
                return null;
            }
            @NonNull String attrVal = UtilsText.safeString((String)compElem.getAttribute(attrName));
            if (attrVal.isEmpty()) {
                return null;
            }
            @NonNull String @NonNull [] split = attrVal.split(" ");
            return CollectionsUtils.unmodifiableSet(new HashSet<String>(Arrays.asList(split)));
        }

        private void loadComponents(@Nullable Element components, @NonNull SdkComponentsDescriptor.Builder sdkComponentsDescriptorBuilder) {
            if (components != null) {
                List<Element> componentsNodeList = ManifestLoaderUtils.getChildrenElements(components, "component");
                for (Element compElem : componentsNodeList) {
                    Set<CoreBootRole> reqCoreBootRoles;
                    String[] depArr;
                    List<Object> devices = null;
                    String compDependency = "";
                    String compId = compElem.getAttribute("id");
                    if (compId.isEmpty()) {
                        compId = null;
                    }
                    String compName = compElem.getAttribute("name");
                    String fullName = UtilsText.safeString((String)compElem.getAttribute("full_name"));
                    String compType = compElem.getAttribute("type");
                    if (compElem.hasAttribute("devices")) {
                        String devicesStr = compElem.getAttribute("devices");
                        @NonNull String[] arr = devicesStr.split(" ");
                        devices = Arrays.asList(arr);
                        if (devices.isEmpty()) {
                            devices = null;
                        }
                    } else if (compElem.hasAttribute("device")) {
                        devices = new ArrayList<String>();
                        devices.add(UtilsText.safeString((String)compElem.getAttribute("device")));
                    }
                    if (compElem.hasAttribute("dependency")) {
                        compDependency = compElem.getAttribute("dependency");
                    }
                    SdkTagContentVersion elemVersion = SdkTagContentVersion.valueOf(compElem);
                    boolean applyFreeRTOSheapExcludeWorkaround = "freertos".equals(compName) && "OS".equals(compType);
                    List<@NonNull SdkSourceFile> componentSources = this.getManifestFormatVersion().compareTo(SdkConsts.MANIFEST_FORMAT_VERSION_3_8) < 0 ? SdkSourceFile.loadOldCompExamSourceFiles_manifest3_7(compElem, this.getManifestFormatVersion(), applyFreeRTOSheapExcludeWorkaround) : SdkSourceFile.loadComponentSourceFiles(compElem, applyFreeRTOSheapExcludeWorkaround);
                    SdkToolchainsSettingsDescriptor.Builder componentToolchainsBuilder = new SdkToolchainsSettingsDescriptor.Builder();
                    String tag = this.isManifestFormateVersionLowerThat3() ? "toolchains" : "toolchainSettings";
                    this.loadToolchainSettingsDef(ManifestLoaderUtils.getChildElementByName(compElem, tag), componentToolchainsBuilder);
                    SdkToolchainsSettingsDescriptor componentToolchains = componentToolchainsBuilder.build();
                    SdkToolchainsSettingsDescriptor componentToolchainsOrNull = componentToolchains.getSdkToolchainSettingsDescr().isEmpty() ? null : componentToolchains;
                    Collection<CompilerDefineSymbol> loc_defines = CompilerDefineSymbol.readDefinesFromXml(compElem);
                    List<@NonNull SdkIncludePath> includePath = this.getManifestFormatVersion().compareTo(SdkConsts.MANIFEST_FORMAT_VERSION_3_8) < 0 ? SdkIncludePath.loadOldCompExamIncludePath_manifest3_7(compElem) : SdkIncludePath.loadCompIncludePath(compElem);
                    if (this.getManifestFormatVersion().compareTo(SdkConsts.MANIFEST_FORMAT_VERSION_3_6) >= 0) {
                        if ("project_template".equals(compType)) {
                            Object[] deps = SdkManifestDescriptor.loadComponentDependencies(compElem);
                            if (!compDependency.isEmpty() && deps.length > 0) {
                                LOGGER.severe("Component depentecy define diplicitly in element" + Arrays.toString(deps) + " and attribute" + compDependency);
                            }
                            depArr = deps;
                        } else {
                            depArr = new String[]{};
                        }
                    } else {
                        depArr = compDependency.split(" ");
                        assert (depArr != null);
                    }
                    String[] rolesArr = UtilsText.safeString((String)compElem.getAttribute("core_bool_roles")).split(" ");
                    if (rolesArr.length > 0) {
                        reqCoreBootRoles = EnumSet.noneOf(CoreBootRole.class);
                        String[] stringArray = rolesArr;
                        int n = rolesArr.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String roleId = stringArray[n2];
                            assert (roleId != null);
                            if (!roleId.isEmpty()) {
                                CoreBootRole role = CoreBootRole.getRole(roleId);
                                if (role == null) {
                                    LOGGER.log(Level.SEVERE, "Invalid required core boot role ID: " + roleId);
                                } else {
                                    reqCoreBootRoles.add(role);
                                }
                            }
                            ++n2;
                        }
                        reqCoreBootRoles = Collections.unmodifiableSet(reqCoreBootRoles);
                    } else {
                        reqCoreBootRoles = null;
                    }
                    Set<@NonNull String> compToolchains = Builder.loadOptionalSetFromAttr(compElem, "toolchain");
                    Set<@NonNull String> compilers = Builder.loadOptionalSetFromAttr(compElem, "compiler");
                    Set<@NonNull String> deviceCores = Builder.loadOptionalSetFromAttr(compElem, "device_cores");
                    String category = compElem.hasAttribute("category") ? compElem.getAttribute("category") : null;
                    String brief = UtilsText.safeString((String)compElem.getAttribute("brief"));
                    sdkComponentsDescriptorBuilder.addNewSdkComponentDescriptor(compId, compName, fullName, brief, compType, category, devices, componentSources, componentToolchainsOrNull, elemVersion, depArr, loc_defines, includePath, reqCoreBootRoles, compToolchains, compilers, deviceCores);
                }
            }
        }

        public void loadElements(@NonNull Document doc, @NonNull ISdkFileProvider sdkFileProvider, @NonNull Builder manifestDescriptorBuilder, @NonNull SdkDevicesDescriptor.Builder devicesDescriptorBuilder, @NonNull SdkComponentsDescriptor.Builder componentsDescriptorBuilder, @NonNull SdkBoardsDescriptor.Builder boardsDescriptorBuilder, @NonNull SdkToolchainsSettingsDescriptor.Builder toolchainsDescriptorBuilder) {
            String settingsTag;
            Element root = doc.getDocumentElement();
            assert (root != null);
            Element element = ManifestLoaderUtils.getChildElementByName(root, "components");
            if (element != null) {
                this.loadComponents(element, componentsDescriptorBuilder);
            }
            if ((element = ManifestLoaderUtils.getChildElementByName(root, "compilers")) != null) {
                Builder.loadCompilers(element, manifestDescriptorBuilder);
            }
            if ((element = ManifestLoaderUtils.getChildElementByName(root, this.isManifestFormateVersionLowerThat3() ? "tools" : "toolchains")) != null) {
                Builder.loadToolchains(element, manifestDescriptorBuilder);
            }
            if ((element = ManifestLoaderUtils.getChildElementByName(root, settingsTag = this.isManifestFormateVersionLowerThat3() ? "toolchains" : "toolchainSettings")) != null) {
                this.loadToolchainSettingsDef(element, toolchainsDescriptorBuilder);
            }
            if ((element = ManifestLoaderUtils.getChildElementByName(root, "devices")) != null) {
                this.loadDevices(element, devicesDescriptorBuilder, toolchainsDescriptorBuilder);
            }
            if ((element = ManifestLoaderUtils.getChildElementByName(root, "boards")) != null) {
                this.loadBoards(element, boardsDescriptorBuilder, sdkFileProvider);
            }
            Collection<@NonNull CompilerDefineSymbol> glbDefines = CompilerDefineSymbol.readDefinesFromXml(root);
            manifestDescriptorBuilder.addCompilerDefineSymbols(glbDefines);
        }

        public boolean isManifestFormateVersionLowerThat3() {
            return this.getManifestFormatVersion().compareTo(SdkConsts.MANIFEST_FORMAT_VERSION_3_0) < 0;
        }
    }

    public static class ManifestHelper {
        @NonNull
        private SdkDeviceDescriptor device;
        @NonNull
        private SdkDeviceCore core;
        @NonNull
        private final String compilerMacroValue;
        @NonNull
        private final String toolchainId;
        @Nullable
        private String packageName;
        @NonNull
        private SdkManifestDescriptor manifest;

        ManifestHelper(@NonNull String cpu, @NonNull String compilerMacroValue, @NonNull String toolchainId, @NonNull SdkManifestDescriptor manifest) {
            this.toolchainId = toolchainId;
            this.compilerMacroValue = compilerMacroValue;
            SdkDeviceDescriptor foundDevice = manifest.getDeviceByPackageName(cpu);
            if (foundDevice == null) {
                throw new IllegalArgumentException();
            }
            this.device = foundDevice;
            SdkDeviceCore aCore = foundDevice.getFirstCortexMCore();
            assert (aCore != null);
            this.core = aCore;
            this.manifest = manifest;
            this.packageName = cpu;
        }

        ManifestHelper(@NonNull SdkDeviceDescriptor device, @NonNull SdkDeviceCore core, @NonNull String compilerMacroValue, @NonNull String toolchainId, @NonNull SdkManifestDescriptor manifest) {
            this.compilerMacroValue = compilerMacroValue;
            this.toolchainId = toolchainId;
            this.device = device;
            this.core = core;
            this.manifest = manifest;
        }

        public void setPackageName(@Nullable String packageName) {
            this.packageName = packageName;
        }

        public @NonNull String resolveVariables(@NonNull String input) {
            return SdkManifestDescriptor.resolveVariables(input, this.device, this.core, this.compilerMacroValue, this.toolchainId, this.packageName);
        }

        public @NonNull SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor resolveVariables(@NonNull SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor toolchain) {
            String id = toolchain.getId();
            String name = toolchain.getName();
            String compilerLoc = toolchain.getCompiler();
            String caption = toolchain.getCaption();
            Collection<SdkOptionBase> options = toolchain.getOptions();
            Collection<SdkOptionBase> resolvedOptions = this.resolveVariablesForOptions(options);
            return new SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor(id, name, toolchain.getToolchainId(), compilerLoc, caption, resolvedOptions, toolchain.getDefines(), toolchain.getVersion());
        }

        public @NonNull Collection<SdkOptionBase> resolveVariablesForOptions(@NonNull Collection<SdkOptionBase> options) {
            ArrayList<SdkOptionBase> result = new ArrayList<SdkOptionBase>(options.size());
            for (SdkOptionBase option : options) {
                if (option == null) {
                    result.add(null);
                    continue;
                }
                result.add(option.resolveVariables(this));
            }
            return result;
        }

        public @NonNull SdkManifestDescriptor resolveVariables() {
            SdkComponentsDescriptor components = this.manifest.getSdkComponentsDescriptor();
            ArrayList<SdkComponentDescriptor> resolvedComponents = new ArrayList<SdkComponentDescriptor>();
            for (SdkComponentDescriptor component : components.getSdkComponents()) {
                assert (component != null);
                SdkComponentDescriptor resolvedComponent = this.resolveVariables(component);
                resolvedComponents.add(resolvedComponent);
            }
            SdkComponentsDescriptor resolvedComponentsDescr = new SdkComponentsDescriptor(resolvedComponents);
            SdkDevicesDescriptor devices = this.manifest.getSdkDevicesDescriptor();
            SdkBoardsDescriptor boards = this.manifest.getSdkBoardsDescriptor();
            SdkToolchainsSettingsDescriptor toolchainsDescr = this.manifest.getSdkToolchainSettingsDescriptor();
            HashMap<String, SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor> resolvedToolchainsMap = new HashMap<String, SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor>();
            for (String toolchainName : toolchainsDescr.getSdkToolchainSettingsNames()) {
                SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor toolchain = toolchainsDescr.getSdkToolchainSettingsDescrByName(toolchainName);
                assert (toolchain != null);
                SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor resolvedToolchain = this.resolveVariables(toolchain);
                resolvedToolchainsMap.put(toolchainName, resolvedToolchain);
            }
            SdkToolchainsSettingsDescriptor resolvedToolchains = new SdkToolchainsSettingsDescriptor(resolvedToolchainsMap);
            Builder manifestBuilder = new Builder();
            manifestBuilder.setCompilersMap(this.manifest.getCompilersMap());
            for (SdkToolchain curToolchain : this.manifest.getToolchains()) {
                assert (curToolchain != null);
                manifestBuilder.addToolchain(curToolchain);
            }
            manifestBuilder.setSdkConfigurationHash(this.manifest.getSdkConfigurationHash());
            manifestBuilder.setManifestFormatVersion(this.manifest.getManifestFormatVersionText());
            manifestBuilder.setSdkBoardsDescriptor(boards);
            manifestBuilder.setSdkBuildVersionValue(this.manifest.getSdkBuildVersionValue());
            manifestBuilder.setSdkComponentsDescriptor(resolvedComponentsDescr);
            manifestBuilder.setSdkDevicesDescriptor(devices);
            manifestBuilder.setSdkRootDirectory(this.manifest.getSdkRootDirectory());
            manifestBuilder.setSdkToolchainsDescriptor(resolvedToolchains);
            manifestBuilder.setSdkVersionNumber(this.manifest.getSdkVersionNumber());
            manifestBuilder.addCompilerDefineSymbols(this.manifest.getDefines());
            return manifestBuilder.build();
        }

        public @NonNull SdkComponentDescriptor resolveVariables(@NonNull SdkComponentDescriptor component) {
            SdkToolchainsSettingsDescriptor toolchainsDescr;
            ArrayList<@NonNull SdkSourceFile> resolvedSources = new ArrayList<SdkSourceFile>();
            for (SdkSourceFile source : component.getSources()) {
                resolvedSources.add(new SdkSourceFile(source, this));
            }
            SdkToolchainsSettingsDescriptor resolvedToolchains = toolchainsDescr = component.getSdkToolchainsSettingsDescriptor();
            if (toolchainsDescr != null) {
                HashMap<String, SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor> resolvedToolchainsMap = new HashMap<String, SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor>();
                for (String toolchainName : toolchainsDescr.getSdkToolchainSettingsNames()) {
                    SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor toolchain = toolchainsDescr.getSdkToolchainSettingsDescrByName(toolchainName);
                    assert (toolchain != null);
                    SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor resolvedToolchain = this.resolveVariables(toolchain);
                    resolvedToolchainsMap.put(toolchainName, resolvedToolchain);
                }
                resolvedToolchains = new SdkToolchainsSettingsDescriptor(resolvedToolchainsMap);
            }
            return new SdkComponentDescriptor(component.getId(), component.getName(), component.getFullName(), component.getBrief(), component.getType(), component.getCategory(), component.getDevices(), resolvedSources, resolvedToolchains, component.getVersion(), component.getDependencySet(), component.getDefines(), component.getIncludePaths(), component.getReqCoreBootRoles(), component.getToolchains(), component.getCompilers(), component.getDeviceCores());
        }

        public @NonNull SdkManifestDescriptor getSdkManifestDescriptor() {
            return this.manifest;
        }

        public @NonNull Collection<@NonNull SdkSourceFile> getComponentSources(@NonNull SdkComponentDescriptor component) {
            return component.getSources(this.device);
        }

        public @NonNull SdkDeviceDescriptor getDevice() {
            return this.device;
        }
    }

    public static final class SdkVersion
    implements Comparable<SdkVersion> {
        @NonNull
        private static final Pattern SECOND_PART_PATTERN = Pattern.compile("(GA|ga|RC|rc|)(\\d*)");
        private int @NonNull [] firstPart;
        @NonNull
        String secondPart;
        private int thirdPart;

        public SdkVersion(@NonNull String version) {
            @NonNull String[] splittedVersion = version.split("-");
            String[] firstPartAsStrings = splittedVersion[0].split("\\.");
            this.firstPart = new int[firstPartAsStrings.length];
            int i = 0;
            while (i < firstPartAsStrings.length) {
                try {
                    String firstPartString = firstPartAsStrings[i];
                    if (firstPartString.isEmpty()) {
                        firstPartString = "0";
                    }
                    this.firstPart[i] = Integer.parseInt(firstPartString);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.log(Level.SEVERE, MessageFormat.format("Wrong SDK version format: {0}, expected: (\\d*\\.)*-(GA|RC)?\\d*(-.*)?", version));
                }
                ++i;
            }
            if (splittedVersion.length > 1) {
                Matcher matcher = SECOND_PART_PATTERN.matcher(splittedVersion[1]);
                if (matcher.matches()) {
                    this.secondPart = UtilsText.safeString((String)matcher.group(1));
                    String thirdPartString = matcher.group(2);
                    if (thirdPartString == null || thirdPartString.isEmpty()) {
                        thirdPartString = "0";
                    }
                    this.thirdPart = Integer.parseInt(thirdPartString);
                } else {
                    this.secondPart = "";
                }
            } else {
                this.secondPart = "";
            }
        }

        public static SdkVersion parseSdkVersion(@NonNull String version) {
            return new SdkVersion(version);
        }

        @Override
        public int compareTo(@Nullable SdkVersion other) {
            if (other == null) {
                return 1;
            }
            int i = 0;
            while (i < Math.min(this.firstPart.length, other.firstPart.length)) {
                if (this.firstPart[i] > other.firstPart[i]) {
                    return 1;
                }
                if (this.firstPart[i] < other.firstPart[i]) {
                    return -1;
                }
                ++i;
            }
            if (this.firstPart.length > other.firstPart.length) {
                i = other.firstPart.length;
                while (i < this.firstPart.length) {
                    if (this.firstPart[i] > 0) {
                        return 1;
                    }
                    ++i;
                }
            } else if (this.firstPart.length < other.firstPart.length) {
                i = this.firstPart.length;
                while (i < other.firstPart.length) {
                    if (other.firstPart[i] > 0) {
                        return -1;
                    }
                    ++i;
                }
            }
            if (this.getSecondPartOrderNumber() > other.getSecondPartOrderNumber()) {
                return 1;
            }
            if (this.getSecondPartOrderNumber() < other.getSecondPartOrderNumber()) {
                return -1;
            }
            return this.thirdPart - other.thirdPart;
        }

        private int getSecondPartOrderNumber() {
            String secondPartLowerCase = this.secondPart.toLowerCase();
            if ("ga".equals(secondPartLowerCase)) {
                return 2;
            }
            if ("rc".equals(secondPartLowerCase)) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            int result = 1;
            int[] nArray = this.firstPart;
            int n = this.firstPart.length;
            int n2 = 0;
            while (n2 < n) {
                int firstPartValue = nArray[n2];
                if (firstPartValue != 0) {
                    result = 31 * result + firstPartValue;
                }
                ++n2;
            }
            result = 31 * result + this.secondPart.toLowerCase().hashCode();
            result = 31 * result + this.thirdPart;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SdkVersion)) {
                return false;
            }
            return this.compareTo((SdkVersion)obj) == 0;
        }

        public static int compare(@Nullable SdkVersion version1, @Nullable SdkVersion version2) {
            if (version1 == null) {
                if (version2 == null) {
                    return 0;
                }
                return -1;
            }
            if (version2 == null) {
                return 1;
            }
            return version1.compareTo(version2);
        }
    }
}

