/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ADivMul;
import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.GeometricTimingScale;
import com.nxp.swtools.clocks.model.LinearTimingScale;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.Iterator;

public class Multiplier
extends ADivMul {
    public Multiplier(@NonNull String id, @NonNull TimingScale scaler) {
        super(id, ENodeType.Multiplier, scaler);
    }

    public Multiplier(@NonNull String id, @NonNull TimingScale scaler, @NonNull BigRational defaultScale) {
        super(id, ENodeType.Multiplier, scaler, defaultScale);
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        BigRational xxOutputClock;
        BigRational xxSetScale;
        if (!this.enabled) {
            return true;
        }
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.wasComputed = true;
        boolean res = true;
        this.inputClock = clock;
        if (!this.checkInputFreq(this.inputClock)) {
            res = false;
        }
        if ((xxSetScale = this.setScale) != null) {
            xxOutputClock = clock.multiply(xxSetScale);
        } else {
            assert (this.useDefaults) : "Default scale value used even if forbidden in " + this.id;
            BigRational xxDefaultScale = this.defaultScale;
            assert (xxDefaultScale != null) : "Wrong device settings, compuation failed";
            xxOutputClock = clock.multiply(xxDefaultScale);
        }
        if (!this.checkOutputFreq(xxOutputClock)) {
            res = false;
        }
        this.outputClock = xxOutputClock;
        if (this.child.compute(this, xxOutputClock)) {
            return res;
        }
        return false;
    }

    @Override
    protected @NonNull BigRational getCScale(@NonNull BigRational inClock, @NonNull BigRational outClock) {
        BigRational k = outClock.divide(inClock);
        @NonNull BigRational tmpTo = this.scaler.to;
        @NonNull BigRational tmpFrm = this.scaler.from;
        BigRational res = k.compareTo(tmpTo) > 0 ? tmpTo : (k.compareTo(tmpFrm) < 0 ? tmpFrm : this.scaler.closest(k));
        return res;
    }

    @Override
    protected @NonNull BigRational evalOp(@NonNull BigInteger k, @NonNull BigRational in) {
        return in.multiply(k);
    }

    @Override
    protected @NonNull BigRational evalOp(@NonNull BigRational k, @NonNull BigRational in) {
        return in.multiply(k);
    }

    @Override
    protected @NonNull BigRational evalInverseOp(@NonNull BigInteger k, @NonNull BigRational out) {
        return out.divide(k);
    }

    @Override
    protected @NonNull BigRational evalInverseOp(@NonNull BigRational k, @NonNull BigRational out) {
        return out.divide(k);
    }

    private @NonNull EErrorType computeAutoWithMiddleSearch(@NonNull BigRational clock) {
        TimingScale.IntervalNarrowingContext interval = this.scaler.getInitialMiddle();
        TimingScale.INextVal nextVal = this.scaler.getNextValFun();
        assert (nextVal != null);
        TimingScale.INextVal prevVal = this.scaler.getPrevValFun();
        assert (prevVal != null);
        @NonNull BigRational xxCompScale = interval.midVal;
        @NonNull BigRational newClock = BigRational.ZERO;
        @NonNull EErrorType subResult = EErrorType.None;
        BigRational xxDefaultScale = this.defaultScale;
        if (xxDefaultScale != null && xxDefaultScale.compareTo(xxCompScale) != 0 && (subResult = this.testOutputFreq(newClock = clock.multiply(xxDefaultScale))) == EErrorType.None) {
            this.lastComp = ECompState.OnceSatisfied;
            subResult = this.child.computeAutoWR(this, newClock);
            if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                this.outputClock = newClock;
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxDefaultScale;
                return EErrorType.None;
            }
        }
        newClock = clock.multiply(xxCompScale);
        subResult = this.testOutputFreq(newClock);
        EErrorType rangeError = EErrorType.None;
        while (true) {
            if (subResult == EErrorType.None) {
                this.lastComp = ECompState.OnceSatisfied;
                subResult = this.child.computeAutoWR(this, newClock);
                if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                    this.outputClock = newClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    this.compScale = xxCompScale;
                    return EErrorType.None;
                }
            }
            if (subResult == EErrorType.TooSlow) {
                if (rangeError == EErrorType.None) {
                    rangeError = EErrorType.TooSlow;
                }
                if (rangeError == EErrorType.TooFast) {
                    rangeError = EErrorType.CannotSetup;
                }
                interval.halfTotalValHigh();
                interval.fromVal = nextVal.op(interval.midVal);
            } else {
                if (subResult != EErrorType.TooFast) break;
                if (rangeError == EErrorType.None) {
                    rangeError = EErrorType.TooFast;
                }
                if (rangeError == EErrorType.TooSlow) {
                    rangeError = EErrorType.CannotSetup;
                }
                interval.halfTotalValLow();
                interval.toVal = prevVal.op(interval.midVal);
            }
            if (interval.toVal.compareTo(interval.fromVal) < 0) {
                return rangeError;
            }
            interval = this.scaler.getValInMiddleR(interval);
            xxCompScale = interval.midVal;
            newClock = clock.multiply(xxCompScale);
            subResult = this.testOutputFreq(newClock);
        }
        if (subResult == EErrorType.BothFastSlow) {
            return subResult;
        }
        xxCompScale = interval.fromVal;
        while (xxCompScale.compareTo(interval.toVal) <= 0) {
            newClock = clock.multiply(xxCompScale);
            subResult = this.testOutputFreq(newClock);
            if (subResult == EErrorType.None) {
                this.lastComp = ECompState.OnceSatisfied;
                subResult = this.child.computeAutoWR(this, newClock);
                if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                    this.outputClock = newClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    this.compScale = xxCompScale;
                    return EErrorType.None;
                }
            }
            if (subResult == EErrorType.TooFast) {
                return EErrorType.CannotSetup;
            }
            xxCompScale = nextVal.op(xxCompScale);
        }
        return EErrorType.CannotSetup;
    }

    private @NonNull EErrorType computeAutoWithDefaultAll(@NonNull BigRational clock) {
        BigRational xxCompScale2 = this.defaultScale;
        assert (xxCompScale2 != null);
        @NonNull BigRational newClock = clock.multiply(xxCompScale2);
        EErrorType sbr = this.testOutputFreq(newClock);
        @NonNull BigRational fromValue = this.scaler.from;
        @NonNull BigRational toValue = this.scaler.to;
        if (sbr == EErrorType.None) {
            this.lastComp = ECompState.OnceSatisfied;
            sbr = this.child.computeAutoWR(this, newClock);
            if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                this.outputClock = newClock;
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale2;
                return EErrorType.None;
            }
        }
        if (sbr == EErrorType.TooFast) {
            toValue = xxCompScale2;
        } else if (sbr == EErrorType.TooSlow) {
            fromValue = xxCompScale2;
        }
        boolean thisTimeSatisfied = false;
        EErrorType searchError = EErrorType.None;
        for (BigRational xxCompScale2 : this.scaler) {
            assert (xxCompScale2 != null);
            if (xxCompScale2.compareTo(fromValue) < 0) continue;
            if (xxCompScale2.compareTo(toValue) > 0) break;
            newClock = clock.multiply(xxCompScale2);
            sbr = this.testOutputFreq(newClock);
            if (sbr == EErrorType.TooSlow) {
                searchError = sbr;
                continue;
            }
            if (sbr == EErrorType.TooFast) {
                if (searchError == EErrorType.None) {
                    searchError = sbr;
                    break;
                }
                searchError = EErrorType.CannotSetup;
                break;
            }
            thisTimeSatisfied = true;
            this.lastComp = ECompState.OnceSatisfied;
            sbr = this.child.computeAutoWR(this, newClock);
            if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                this.outputClock = newClock;
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale2;
                return EErrorType.None;
            }
            if (sbr != EErrorType.TooFast) continue;
            if (xxCompScale2.compareTo(fromValue) == 0) {
                return EErrorType.TooFast;
            }
            return EErrorType.CannotSetup;
        }
        if (searchError == EErrorType.None || searchError == EErrorType.CannotSetup) {
            return EErrorType.CannotSetup;
        }
        if (!thisTimeSatisfied) {
            return searchError;
        }
        return EErrorType.CannotSetup;
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        EErrorType sbr;
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        if ((sbr = this.testInputFreq(clock)) != EErrorType.None) {
            return sbr;
        }
        this.inputClock = clock;
        assert (this.scaler != null) : "Null scaler in multiplier " + this.id;
        assert (this.child != null) : "Null child in multiplier " + this.id;
        Object xxCompScale = this.setScale != null ? this.setScale : (this.useDefaults && this.defaultScale != null ? this.defaultScale : null);
        if (xxCompScale != null) {
            BigRational newClock = clock.multiply(xxCompScale);
            sbr = this.testOutputFreq(newClock);
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.outputClock = newClock;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, newClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                return EErrorType.None;
            }
            return nres;
        }
        BigRational xxSetOutputFreq = this.setOutputFreq;
        if (xxSetOutputFreq != null) {
            if (clock.multiply(this.scaler.from).compareTo(xxSetOutputFreq.multiply(BigRational.ONE.add(this.accuracy))) > 0) {
                return EErrorType.TooFast;
            }
            if (clock.multiply(this.scaler.to).compareTo(xxSetOutputFreq.divide(BigRational.ONE.add(this.accuracy))) < 0) {
                return EErrorType.TooSlow;
            }
            xxCompScale = this.getCScale(clock, xxSetOutputFreq);
            BigRational newClock = clock.multiply(xxCompScale);
            BigRational ac = xxSetOutputFreq.compareTo(newClock) < 0 ? newClock.divide(xxSetOutputFreq).subtract(BigRational.ONE) : xxSetOutputFreq.divide(newClock).subtract(BigRational.ONE);
            if (ac.compareTo(this.accuracy) > 0) {
                return EErrorType.CannotSetup;
            }
            sbr = this.testOutputFreq(newClock);
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.outputClock = newClock;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, newClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                return EErrorType.None;
            }
            return nres;
        }
        if (this.scaler instanceof LinearTimingScale || this.scaler instanceof GeometricTimingScale) {
            return this.computeAutoWithMiddleSearch(clock);
        }
        xxCompScale = this.scaler.from;
        BigRational xxDefaultScale = this.defaultScale;
        if (xxDefaultScale != null && xxDefaultScale.compareTo(xxCompScale) != 0) {
            return this.computeAutoWithDefaultAll(clock);
        }
        BigRational newClock = clock.multiply(xxCompScale);
        sbr = this.testOutputFreq(newClock);
        if (sbr == EErrorType.TooFast) {
            return sbr;
        }
        if (sbr == EErrorType.TooSlow) {
            Iterator<BigRational> its = this.scaler.iterator();
            its.next();
            while (its.hasNext()) {
                xxCompScale = its.next();
                assert (xxCompScale != null) : "computation failed";
                newClock = clock.multiply(xxCompScale);
                sbr = this.testOutputFreq(newClock);
                if (sbr != EErrorType.TooSlow) break;
            }
            if (sbr != EErrorType.None) {
                if (sbr == EErrorType.TooSlow) {
                    return sbr;
                }
                return EErrorType.CannotSetup;
            }
            do {
                this.lastComp = ECompState.OnceSatisfied;
                sbr = this.child.computeAutoWR(this, newClock);
                if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                    this.outputClock = newClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    this.compScale = xxCompScale;
                    return EErrorType.None;
                }
                if (sbr == EErrorType.TooFast) {
                    return EErrorType.CannotSetup;
                }
                if (!its.hasNext()) {
                    return sbr;
                }
                xxCompScale = its.next();
                assert (xxCompScale != null) : "computation failed";
            } while ((sbr = this.testOutputFreq(newClock = clock.multiply(xxCompScale))) == EErrorType.None);
            return sbr;
        }
        this.lastComp = ECompState.OnceSatisfied;
        sbr = this.child.computeAutoWR(this, newClock);
        if (sbr == EErrorType.TooFast) {
            return sbr;
        }
        if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
            this.outputClock = newClock;
            this.lastComp = ECompState.OnceSubtreeOK;
            this.compScale = xxCompScale;
            return EErrorType.None;
        }
        xxCompScale = this.scaler.to;
        assert (xxCompScale != null) : "computation failed";
        newClock = clock.multiply(xxCompScale);
        sbr = this.testOutputFreq(newClock);
        if (sbr != EErrorType.TooFast) {
            sbr = this.child.computeAutoWR(this, newClock);
            if (sbr == EErrorType.TooSlow) {
                return sbr;
            }
            if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                this.outputClock = newClock;
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                return EErrorType.None;
            }
        }
        Iterator<BigRational> its = this.scaler.iterator();
        its.next();
        while (its.hasNext()) {
            xxCompScale = its.next();
            assert (xxCompScale != null) : "computation failed";
            newClock = clock.multiply(xxCompScale);
            sbr = this.testOutputFreq(newClock);
            if (sbr != EErrorType.None) {
                return EErrorType.CannotSetup;
            }
            sbr = this.child.computeAutoWR(this, newClock);
            if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                this.outputClock = newClock;
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                return EErrorType.None;
            }
            if (sbr == EErrorType.TooFast) break;
        }
        return EErrorType.CannotSetup;
    }
}

