/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.NodeHidden;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.util.ArrayList;
import java.util.List;

public class Multiplexer
extends NodeHidden {
    private ArrayList<@NonNull NodeHidden> children = null;
    private ArrayList<@NonNull NodeHidden> preds = null;
    @Nullable
    private NodeHidden selected = null;
    @Nullable
    private NodeHidden defaultSelected = null;
    @Nullable
    private BigRational inputClock = null;
    private boolean useDefaults;
    private boolean fstTrack = true;
    private ArrayList<@NonNull NodeHidden> usedInput = null;
    private boolean doAutoSelect = false;
    @Nullable
    private NodeHidden compSelected = null;

    public Multiplexer(@NonNull String id) {
        super(id, ENodeType.Multiplexer);
    }

    @Override
    public void includeDefaults() {
        this.useDefaults = true;
    }

    @Override
    public void excludeDefaults() {
        this.useDefaults = false;
    }

    @Override
    public void addChild(@NonNull Node child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (!(child instanceof NodeHidden)) {
            throw new UnsupportedOperationException("Method addChild can be used only for ancestors of NodeHidden class. Node id: " + child.getID());
        }
        this.children.add((NodeHidden)child);
    }

    @Override
    public void addPred(@NonNull Node pred) {
        if (this.preds == null) {
            this.preds = new ArrayList();
        }
        if (!(pred instanceof NodeHidden)) {
            throw new UnsupportedOperationException("Method addPred can be used only for ancestors of NodeHidden class. Node id: " + pred.getID());
        }
        this.preds.add((NodeHidden)pred);
    }

    @Override
    public void setSelected(@Nullable Node node) {
        if (node == null) {
            this.selected = null;
        } else {
            assert (this.preds != null);
            assert (this.preds.contains(node));
            if (node instanceof NodeHidden) {
                this.selected = (NodeHidden)node;
            } else {
                throw new UnsupportedOperationException("Method setSelected can be used only for ancestors of NodeHidden class. Node id: " + node.getID());
            }
        }
    }

    @Override
    public void setDefaultSelected(@Nullable Node node) {
        if (node == null) {
            this.defaultSelected = null;
        } else {
            assert (this.preds != null);
            assert (this.preds.contains(node));
            if (node instanceof NodeHidden) {
                this.defaultSelected = (NodeHidden)node;
            } else {
                throw new UnsupportedOperationException("Method setSelected can be used only for ancestors of NodeHidden class. Node id: " + node.getID());
            }
        }
    }

    @Override
    public void enableMultiplexerAutoSelect() {
        this.doAutoSelect = true;
    }

    @Override
    public void disableMultiplexerAutoSelect() {
        this.doAutoSelect = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        void var5_10;
        String ps = null;
        if (this.preds == null) {
            ps = "MUX with no preds!";
        } else {
            for (Node node : this.preds) {
                String psel = this.selected == node ? String.valueOf('[') + node.id + ']' : node.id;
                ps = ps == null ? psel : String.valueOf(ps) + "/" + psel;
            }
        }
        Object var5_7 = null;
        if (this.inputClock == null) {
            String string = "";
        } else {
            String string = "@" + this.inputClock;
        }
        System.out.println(String.valueOf(pref) + "$" + this.id + "(" + ps + ")" + (String)var5_10);
        if (this.children != null) {
            NodeHidden last = null;
            for (NodeHidden child : this.children) {
                if (last == null) {
                    last = child;
                    continue;
                }
                last.printT(this, pref, "");
                last = child;
            }
            if (last != null) {
                last.printT(this, prefLast, prefLast);
            }
        }
    }

    @Override
    public @NonNull StringBuffer stringT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        StringBuffer ps = null;
        if (this.preds == null) {
            ps = new StringBuffer("MUX with no preds!");
        } else {
            for (Node node : this.preds) {
                StringBuffer psel;
                if (this.selected == node) {
                    psel = new StringBuffer(91);
                    psel.append(node.id);
                    psel.append(']');
                } else {
                    psel = new StringBuffer(node.id);
                }
                if (ps == null) {
                    ps = new StringBuffer(psel);
                    continue;
                }
                ps.append('/');
                ps.append(psel);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.inputClock != null) {
            stringBuffer.append('@');
            stringBuffer.append(this.inputClock);
        }
        StringBuffer res = new StringBuffer(pref);
        res.append('$');
        res.append(this.id);
        res.append('(');
        res.append(ps);
        res.append(')');
        res.append(stringBuffer);
        res.append('\n');
        if (this.children != null) {
            NodeHidden last = null;
            for (NodeHidden child : this.children) {
                if (last == null) {
                    last = child;
                    continue;
                }
                res.append(last.stringT(this, pref, ""));
                last = child;
            }
            if (last != null) {
                res.append(last.stringT(this, prefLast, prefLast));
            }
        }
        return res;
    }

    @Override
    public boolean isSet(@NonNull List<@NonNull Node> unset) {
        if (this.selected != null) {
            return true;
        }
        unset.add(this);
        return false;
    }

    @Override
    public boolean isSetOrDefault(@NonNull List<@NonNull Node> unset) {
        if (this.selected != null || this.defaultSelected != null) {
            return true;
        }
        unset.add(this);
        return false;
    }

    @Override
    public void setScaleComputed() {
        if (this.doAutoSelect) {
            this.selected = this.compSelected;
        }
    }

    @Override
    public void setTreeScaleComputed(@NonNull Node callee) {
        if (!this.enabled) {
            return;
        }
        this.setScaleComputed();
        if (this.selected == callee || this.useDefaults && this.defaultSelected == callee) {
            for (NodeHidden node : this.children) {
                node.setTreeScaleComputed(this);
            }
        }
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        if (!this.enabled) {
            return true;
        }
        if (this.selected != null) {
            if (callee != this.selected) {
                return true;
            }
        } else {
            assert (this.useDefaults) : "Used default value even if not allowed in " + this.id;
            if (callee != this.defaultSelected) {
                return true;
            }
        }
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.wasComputed = true;
        boolean res = true;
        this.inputClock = clock;
        if (!this.checkInputFreq(this.inputClock)) {
            res = false;
        }
        if (!this.checkOutputFreq(clock)) {
            res = false;
        }
        for (NodeHidden node : this.children) {
            if (node.compute(this, clock)) continue;
            res = false;
        }
        return res;
    }

    @Override
    public BigRational[] prepareAuto(@NonNull Node callee, boolean sendFreq) {
        if (!this.enabled) {
            if (!this.called) {
                this.called = true;
                for (NodeHidden node : this.children) {
                    node.prepareAuto(this, false);
                }
            }
            return null;
        }
        if (this.selected != null) {
            if (callee != this.selected) {
                return null;
            }
        } else {
            assert (this.useDefaults) : "Used default value even if not allowed in " + this.id;
            if (callee != this.defaultSelected) {
                return null;
            }
        }
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        if (!sendFreq) {
            for (NodeHidden node : this.children) {
                node.prepareAuto(this, false);
            }
            return null;
        }
        BigRational[] res = null;
        boolean check = true;
        for (NodeHidden child : this.children) {
            if (!check) {
                child.prepareAuto(this, false);
                continue;
            }
            BigRational[] tmp = child.prepareAuto(this, true);
            if (tmp == null) continue;
            if (res == null) {
                res = tmp;
                continue;
            }
            if (tmp[0].equals((Object)res[0])) {
                if (tmp[1].compareTo(res[1]) >= 0) continue;
                res[1] = tmp[1];
                continue;
            }
            res = null;
            check = false;
        }
        return res;
    }

    @Override
    public @Nullable BigRational getOutputClock() {
        return this.inputClock;
    }

    @Override
    public @Nullable BigRational getInputClock() {
        return this.inputClock;
    }

    @Override
    public void resetFirstTrackFlag() {
        this.fstTrack = true;
    }

    @Override
    public void trackAutoWR(@NonNull Node callee) {
        if (!this.enabled) {
            return;
        }
        if (this.doAutoSelect) {
            this.compSelected = null;
        }
        if (this.fstTrack) {
            this.fstTrack = false;
            if (this.usedInput == null) {
                this.usedInput = new ArrayList(this.preds.size());
            } else {
                this.usedInput.clear();
            }
            for (NodeHidden node : this.children) {
                node.trackAutoWR(this);
            }
        }
        if (!(callee instanceof NodeHidden)) {
            throw new UnsupportedOperationException("Method trackAutoWR can be used only for ancestors of NodeHidden class. Node id: " + callee.getID());
        }
        if (!this.usedInput.contains(callee)) {
            this.usedInput.add((NodeHidden)callee);
        }
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        this.fstTrack = true;
        assert (this.usedInput != null) : "No active input (null) in multiplexer " + this.id;
        assert (this.usedInput.size() > 0) : "No active input (size==0) in multiplexer" + this.id;
        assert (this.usedInput.contains(callee)) : "Callee is not active in multiplexer" + this.id;
        if (!(callee instanceof NodeHidden)) {
            throw new UnsupportedOperationException("Method trackAutoWR can be used only for ancestors of NodeHidden class. Node id: " + callee.getID());
        }
        if (this.doAutoSelect) {
            if (this.compSelected != null) {
                return EErrorType.None;
            }
            this.inputClock = clock;
            EErrorType res = this.testInputFreq(clock);
            if (res != EErrorType.None) {
                return res;
            }
            res = this.testOutputFreq(clock);
            if (res != EErrorType.None) {
                return res;
            }
            assert (this.children != null) : "No output connection (null) for multiplexer " + this.id;
            assert (this.children.size() == 1) : "Incorrect number of output connections (" + this.children.size() + " in " + this.id;
            this.lastComp = ECompState.OnceSatisfied;
            res = this.children.get(0).computeAutoWR(this, clock);
            if (res == EErrorType.None || res == EErrorType.NotEnabled) {
                this.compSelected = (NodeHidden)callee;
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            return res;
        }
        if (this.selected != null) {
            if (this.selected != callee) {
                return EErrorType.None;
            }
        } else if (this.useDefaults && this.defaultSelected != null) {
            if (this.defaultSelected != callee) {
                return EErrorType.None;
            }
        } else {
            throw new UnsupportedOperationException("Method computeAutoWR cannot be used for disconnected multiplexer.");
        }
        this.inputClock = clock;
        EErrorType res = this.testInputFreq(clock);
        if (res != EErrorType.None) {
            return res;
        }
        res = this.testOutputFreq(clock);
        if (res != EErrorType.None) {
            return res;
        }
        assert (this.children != null) : "No output connection (null) for multiplexer " + this.id;
        assert (this.children.size() == 1) : "Incorrect number of output connections (" + this.children.size() + ") in " + this.id;
        this.lastComp = ECompState.OnceSatisfied;
        res = this.children.get(0).computeAutoWR(this, clock);
        if (res == EErrorType.None || res == EErrorType.NotEnabled) {
            this.lastComp = ECompState.OnceSubtreeOK;
            return EErrorType.None;
        }
        return res;
    }

    @Override
    public boolean getReversePath(@NonNull Node callee, @NonNull List<@NonNull Node> path) {
        path.add(this);
        NodeHidden locSelected = this.selected;
        if (locSelected == null) {
            return false;
        }
        return locSelected.getReversePath(this, path);
    }

    @Override
    public @NonNull List<@NonNull Node> getDirectlyConnectedTo(@NonNull Node callee, @NonNull Node node) {
        assert (this.children != null) : "Null children in multiplexer " + this.id;
        assert (this.children.size() > 0) : "Empty children in mutliplexer " + this.id;
        @NonNull ArrayList<@NonNull Node> res = new ArrayList<Node>();
        if (callee != this.selected) {
            return res;
        }
        for (NodeHidden child : this.children) {
            res.addAll(child.getDirectlyConnectedTo(this, node));
        }
        if (this == node) {
            res.add(this);
        }
        return res;
    }

    @Override
    public void resetInputOutputClock() {
        this.inputClock = null;
    }
}

