/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.util.Objects;

public class FrequencyRange {
    @NonNull
    private BigRational lowerBound;
    @NonNull
    private BigRational upperBound;

    public FrequencyRange(@NonNull BigRational min, @NonNull BigRational max) {
        this.lowerBound = min;
        this.upperBound = max;
        assert (min.compareTo(max) <= 0);
    }

    public boolean isInRange(@NonNull BigRational value) {
        return this.lowerBound.compareTo(value) <= 0 && this.upperBound.compareTo(value) >= 0;
    }

    public @NonNull BigRational getMinimalFrequency() {
        return this.lowerBound;
    }

    public @NonNull BigRational getMaximalFrequency() {
        return this.upperBound;
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FrequencyRange other = (FrequencyRange)obj;
        return Objects.equals(this.lowerBound, other.lowerBound) && Objects.equals(this.upperBound, other.upperBound);
    }

    public static @NonNull FrequencyRange modifyByAccuracy(@NonNull FrequencyRange range, @NonNull BigRational accuracy) {
        return new FrequencyRange(range.lowerBound.multiply(BigRational.ONE.subtract(accuracy)), range.upperBound.multiply(BigRational.ONE.add(accuracy)));
    }
}

