/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.NodeSimpleCon;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.List;

public class Clock
extends NodeSimpleCon {
    protected BigRational freq = null;
    private boolean importedFreq = false;

    public Clock(@NonNull String id) {
        super(id, ENodeType.Clock);
    }

    protected Clock(@NonNull String id, @NonNull ENodeType type) {
        super(id, type);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigRational freq) {
        this.freq = freq;
        return this.checkOutputFreq(freq);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigInteger freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(byte freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(short freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(int freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(long freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public @Nullable BigRational getFrequency() {
        return this.freq;
    }

    @Override
    public void printT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        String ps = null;
        ps = this.pred != null ? this.pred.id : "";
        String fs = null;
        fs = this.freq != null ? "&" + this.freq : "";
        System.out.println(String.valueOf(pref) + "+--" + this.id + "(" + ps + ")" + fs);
        if (this.child != null) {
            if ("".equals(prefLast)) {
                this.child.printT(this, String.valueOf(pref) + "|    ", String.valueOf(pref) + "|    ");
            } else {
                this.child.printT(this, String.valueOf(prefLast) + "     ", String.valueOf(prefLast) + "     ");
            }
        }
    }

    @Override
    public @NonNull StringBuffer stringT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        StringBuffer ps = new StringBuffer();
        if (this.pred != null) {
            ps.append(this.pred.id);
        }
        StringBuffer fs = new StringBuffer();
        if (this.freq != null) {
            fs.append('&');
            fs.append(this.freq);
        }
        StringBuffer res = new StringBuffer(pref);
        res.append("+--");
        res.append(this.id);
        res.append('(');
        res.append(ps);
        res.append(')');
        res.append(fs);
        res.append('\n');
        if (this.child != null) {
            if ("".equals(prefLast)) {
                res.append(this.child.stringT(this, String.valueOf(pref) + "|    ", String.valueOf(pref) + "|    "));
            } else {
                res.append(this.child.stringT(this, String.valueOf(prefLast) + "     ", String.valueOf(prefLast) + "     "));
            }
        }
        return res;
    }

    @Override
    public boolean isSet(@NonNull List<@NonNull Node> unset) {
        if (this.freq != null) {
            return true;
        }
        unset.add(this);
        return false;
    }

    @Override
    public boolean isSetOrDefault(@NonNull List<@NonNull Node> unset) {
        return this.isSet(unset);
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        if (!this.enabled) {
            return true;
        }
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.wasComputed = true;
        BigRational locFreq = this.freq;
        assert (locFreq != null) : "Clock " + this.id + "not initialized properly";
        return this.child.compute(this, locFreq);
    }

    @Override
    public BigRational[] prepareAuto(@NonNull Node callee, boolean sendFreq) {
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        if (!this.enabled || !sendFreq) {
            return this.child.prepareAuto(this, false);
        }
        if (this.type == ENodeType.ClockFixed || this.freq != null) {
            return this.child.prepareAuto(this, false);
        }
        BigRational[] val = this.child.prepareAuto(this, true);
        if (val != null) {
            this.importedFreq = true;
            this.freq = val[0];
        }
        return null;
    }

    @Override
    public void closeAuto() {
        if (this.importedFreq) {
            this.importedFreq = false;
            this.freq = null;
        }
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        BigRational locFreq;
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        if ((locFreq = this.freq) == null) {
            return EErrorType.ClockNotSet;
        }
        assert (this.child != null) : "Null child in clock source " + this.id;
        this.wasComputed = true;
        this.lastComp = ECompState.OnceSatisfied;
        EErrorType res = this.child.computeAutoWR(this, locFreq);
        if (res == EErrorType.None || res == EErrorType.NotEnabled) {
            this.lastComp = ECompState.OnceSubtreeOK;
            return EErrorType.None;
        }
        return res;
    }

    @Override
    public @NonNull List<@NonNull Node> getDirectlyConnectedTo(@NonNull Node callee, @NonNull Node node) {
        assert (this.child != null) : "Null child in clock source " + this.id;
        @NonNull List<@NonNull Node> res = this.child.getDirectlyConnectedTo(this, node);
        if (res.size() > 0) {
            if (this == node) {
                res.add(this);
            } else if (!res.contains(node)) {
                res.clear();
            }
        }
        return res;
    }
}

