/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.gui.utils;

import com.nxp.swtools.common.uct.controls.IRefreshableBaseControl;
import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.expert.processordb.ExternalMcuDataHelper;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controls.GridPaneStructNode;
import com.nxp.swtools.gtm.controls.StructSettingNode;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class GtmToolActions {
    private static final Pattern SET_VISIBLE_REGEX = Pattern.compile("(setVisible)\\((.*)\\)", 8);
    public static final Pattern OPEN_DOCUMENTATION_REGEX = Pattern.compile("(openDocumentation)\\((.*)\\)", 8);

    public static void removeRefreshListeners(String action) {
        Node node;
        String controlID;
        Matcher setVisibleControlActionMatcher = SET_VISIBLE_REGEX.matcher(action);
        if (setVisibleControlActionMatcher.find() && setVisibleControlActionMatcher.groupCount() == 2 && (controlID = setVisibleControlActionMatcher.group(2)) != null && (node = GtmSceneCreator.getNodeById(controlID)) != null && node instanceof IRefreshableBaseControl) {
            ((IRefreshableBaseControl)node).removeRefreshListeners();
        }
    }

    public static void executeAction(String action) {
        Matcher setVisibleControlActionMatcher = SET_VISIBLE_REGEX.matcher(action);
        if (setVisibleControlActionMatcher.find() && setVisibleControlActionMatcher.groupCount() == 2) {
            GtmToolActions.setVisibleControlAction(setVisibleControlActionMatcher);
        } else {
            Matcher openDocumentationMatcher = OPEN_DOCUMENTATION_REGEX.matcher(action);
            if (openDocumentationMatcher.find() && openDocumentationMatcher.groupCount() == 2) {
                GtmToolActions.openDocumentationAction(openDocumentationMatcher);
            }
        }
    }

    private static void setVisibleControlAction(Matcher actionMatcher) {
        ABaseUIComponentSetting componentSetting;
        String controlID = actionMatcher.group(2);
        if (controlID != null && (componentSetting = UctUtils.getComponentSettingById((IMcu)GtmController.getInstance().getGtmMcu(), (String)controlID)) instanceof GtmStructSetting) {
            GtmStructSetting gtmStructSetting = (GtmStructSetting)componentSetting;
            Node node = GtmSceneCreator.getNodeById(controlID);
            if (node == null) {
                Node parentNode;
                String parentId = GtmToolActions.getParentId(GtmController.getInstance().getGtmMcu().getGtmLayoutContent(), controlID);
                if (parentId != null && (parentNode = GtmSceneCreator.getNodeById(parentId)) instanceof GridPaneStructNode) {
                    GridPaneStructNode gpNode = (GridPaneStructNode)parentNode;
                    GtmController.getInstance().markCurrentPanelSetting(gtmStructSetting);
                    GtmController.getInstance().checkRemainingVisibleSettings();
                    gtmStructSetting.setVisibleState(true);
                    StructSettingNode stSetting = new StructSettingNode(gtmStructSetting);
                    UctLayoutUtils.updateNodeState((Node)stSetting.getRegion(), (ABaseUIComponentSetting)gtmStructSetting);
                    gpNode.getChildren().add((Object)stSetting.getRegion());
                    GridPane.setFillWidth((Node)stSetting.getRegion(), (Boolean)Boolean.TRUE);
                    GridPane.setFillHeight((Node)stSetting.getRegion(), (Boolean)Boolean.TRUE);
                    GridPane.setValignment((Node)stSetting.getRegion(), (VPos)VPos.TOP);
                }
            } else {
                GtmController.getInstance().markCurrentPanelSetting(gtmStructSetting);
                GtmController.getInstance().checkRemainingVisibleSettings();
                gtmStructSetting.setVisibleState(true);
                UctLayoutUtils.updateNodeState((Node)node, (ABaseUIComponentSetting)componentSetting);
                if (node instanceof IRefreshableBaseControl) {
                    ((IRefreshableBaseControl)node).refresh();
                    ((IRefreshableBaseControl)node).addRefreshListeners();
                }
            }
        }
    }

    private static @Nullable String getParentId(GtmStructSetting gtmLayoutContentStruct, String childId) {
        for (GtmStructSetting struct : gtmLayoutContentStruct.getStructSettings()) {
            if (struct.getStructSettingById(childId) != null) {
                return struct.getId();
            }
            GtmToolActions.getParentId(struct, childId);
        }
        return null;
    }

    private static void loadDocumentation(String documentationPath, Region region) {
        if (region instanceof GridPaneStructNode) {
            GridPaneStructNode gpNode = (GridPaneStructNode)region;
            gpNode.getChildren().clear();
            WebView wView = new WebView();
            wView.addEventFilter(ScrollEvent.SCROLL, e -> {
                double deltaY = e.getDeltaY();
                if (e.isControlDown() && deltaY > 0.0) {
                    wView.setZoom(wView.getZoom() * 1.1);
                    e.consume();
                } else if (e.isControlDown() && deltaY < 0.0) {
                    wView.setZoom(wView.getZoom() / 1.1);
                    e.consume();
                }
            });
            WebEngine webEngine = wView.getEngine();
            gpNode.getChildren().add((Object)wView);
            File f = new File(documentationPath);
            if (f.exists()) {
                webEngine.load(f.toURI().toString());
            }
        }
    }

    private static void openDocumentationAction(Matcher actionMatcher) {
        String[] components;
        String documentationToOpen = actionMatcher.group(2);
        if (documentationToOpen != null && (components = documentationToOpen.split(",")).length == 2) {
            IGtmMcu mcu = GtmController.getInstance().getGtmMcu();
            String componentId = components[0];
            String dataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcu.getMcu(), mcu.getSdkVersion(), "GTM");
            String gtmModelFolder = DataDirectoryUtils.getDbFile((IMcuIdentification)mcu, (String)"gtm_model");
            Node node = GtmSceneCreator.getNodeById(componentId);
            ABaseUIComponentSetting componentSetting = UctUtils.getComponentSettingById((IMcu)mcu, (String)componentId);
            String docFullPath = String.valueOf(dataDir) + File.separator + gtmModelFolder + File.separator + components[1];
            if (node == null) {
                Node parentNode;
                String parentId = GtmToolActions.getParentId(GtmController.getInstance().getGtmMcu().getGtmLayoutContent(), componentId);
                if (parentId != null && (parentNode = GtmSceneCreator.getNodeById(parentId)) instanceof GridPaneStructNode && componentSetting != null) {
                    GridPaneStructNode gpNode = (GridPaneStructNode)parentNode;
                    StructSettingNode stSetting = new StructSettingNode((GtmStructSetting)componentSetting);
                    componentSetting.setVisibleState(true);
                    UctLayoutUtils.updateNodeState((Node)stSetting.getRegion(), (ABaseUIComponentSetting)componentSetting);
                    gpNode.getChildren().add((Object)stSetting.getRegion());
                    GridPane.setFillWidth((Node)stSetting.getRegion(), (Boolean)Boolean.TRUE);
                    GridPane.setFillHeight((Node)stSetting.getRegion(), (Boolean)Boolean.TRUE);
                    GridPane.setValignment((Node)stSetting.getRegion(), (VPos)VPos.TOP);
                    GtmToolActions.loadDocumentation(docFullPath, stSetting.getRegion());
                }
            } else if (node instanceof GridPaneStructNode && componentSetting != null) {
                GridPaneStructNode gpNode = (GridPaneStructNode)node;
                componentSetting.setVisibleState(true);
                UctLayoutUtils.updateNodeState((Node)gpNode, (ABaseUIComponentSetting)componentSetting);
                GtmToolActions.loadDocumentation(docFullPath, (Region)gpNode);
            }
        }
    }
}

