/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.TreeItemSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.TreeStructSetting;
import com.nxp.swtools.common.uct.utils.UctXmlSettingsUtils;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.ExternalMcuDataHelper;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.Messages;
import com.nxp.swtools.gtm.gui.utils.GtmLayoutUtils;
import com.nxp.swtools.gtm.gui.utils.GtmToolActions;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmConfiguration;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmTool;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import com.nxp.swtools.utils.resources.IToolsImages;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Callback;
import org.eclipse.ui.services.IDisposable;

public class TreeStructSettingNode
extends TreeView<String>
implements IBaseControl,
IDisposable {
    private static final Logger LOGGER = LogManager.getLogger(TreeStructSettingNode.class);
    private TreeStructSetting treeStruct;
    private ChangeListener<TreeItem<String>> selectionListener;

    public TreeStructSettingNode(TreeStructSetting treeStruct) {
        this.treeStruct = treeStruct;
        this.selectionListener = this.createSelectionListener();
        this.create();
    }

    public void create() {
        TreeItem rootItem = new TreeItem((Object)this.treeStruct.getLabel());
        for (TreeItemSetting treeItemSettingInStruct : this.treeStruct.getTreeItems()) {
            TreeItem treeItemInStruct = new TreeItem((Object)treeItemSettingInStruct.getLabel());
            treeItemInStruct.setExpanded(true);
            for (TreeItemSetting childTreeItemSetting1 : treeItemSettingInStruct.getTreeItems()) {
                TreeItem childTreeItem1 = new TreeItem((Object)childTreeItemSetting1.getLabel());
                childTreeItem1.setExpanded(true);
                for (TreeItemSetting childTreeItemSetting2 : childTreeItemSetting1.getTreeItems()) {
                    TreeItem childTreeItem2 = new TreeItem((Object)childTreeItemSetting2.getLabel());
                    childTreeItem1.getChildren().add((Object)childTreeItem2);
                }
                treeItemInStruct.getChildren().add((Object)childTreeItem1);
            }
            rootItem.getChildren().add((Object)treeItemInStruct);
        }
        this.setRoot(rootItem);
        this.setShowRoot(false);
        this.getRoot().setExpanded(true);
        this.setCellFactory(this.createTreeViewCellFactory());
        this.getSelectionModel().selectedItemProperty().addListener(this.selectionListener);
    }

    private Callback<TreeView<String>, TreeCell<String>> createTreeViewCellFactory() {
        return new Callback<TreeView<String>, TreeCell<String>>(){

            public TreeCell<String> call(TreeView<String> p) {
                TreeCell<String> cell = new TreeCell<String>(){

                    protected void updateItem(String label, boolean empty) {
                        super.updateItem((Object)label, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(label);
                            TreeItemSetting treeItemSetting = TreeStructSettingNode.this.getTreeItemSettingByLabel(label);
                            if (treeItemSetting != null) {
                                TreeStructSettingNode.createTreeItemIcon(treeItemSetting, this);
                                ContextMenu contextMenu = new ContextMenu();
                                TreeStructSettingNode.createOpenDocumentationMenuItem(treeItemSetting, contextMenu);
                                TreeStructSettingNode.createOpenUseCasesMenuItem(treeItemSetting, contextMenu);
                                this.setOnContextMenuRequested(e -> contextMenu.show((Node)this, e.getScreenX(), e.getScreenY()));
                            }
                        }
                    }
                };
                return cell;
            }
        };
    }

    protected @Nullable TreeItemSetting getTreeItemSettingByLabel(String label) {
        for (TreeItemSetting treeItemSettingInStruct : this.treeStruct.getTreeItems()) {
            if (treeItemSettingInStruct.getLabel().equals(label)) {
                return treeItemSettingInStruct;
            }
            for (TreeItemSetting childTreeItemSetting1 : treeItemSettingInStruct.getTreeItems()) {
                if (childTreeItemSetting1.getLabel().equals(label)) {
                    return childTreeItemSetting1;
                }
                for (TreeItemSetting childTreeItemSetting2 : childTreeItemSetting1.getTreeItems()) {
                    if (!childTreeItemSetting2.getLabel().equals(label)) continue;
                    return childTreeItemSetting2;
                }
            }
        }
        return null;
    }

    protected static void createTreeItemIcon(TreeItemSetting treeItemSetting, TreeCell<String> treeCell) {
        String treeItemIcon = treeItemSetting.getIcon();
        if (!treeItemIcon.isEmpty()) {
            Image showContentImage = new Image(IToolsImages.getIconUrl((String)treeItemIcon).toExternalForm());
            treeCell.setGraphic((Node)new ImageView(showContentImage));
        }
    }

    protected static void createOpenUseCasesMenuItem(TreeItemSetting treeItemSetting, ContextMenu contextMenu) {
        String useCases = treeItemSetting.getUseCases();
        if (!useCases.isEmpty()) {
            Menu menu = new Menu(Messages.ApplyUseCase);
            String[] useCasesArr = useCases.split(",");
            int i = 0;
            while (i < useCasesArr.length) {
                String[] useCaseComponents = useCasesArr[i].split("=");
                if (useCaseComponents.length == 2) {
                    String useCaseLabel = useCaseComponents[0];
                    String useCaseMexRelPath = useCaseComponents[1];
                    MenuItem menuItem = new MenuItem(useCaseLabel);
                    menuItem.setOnAction(e -> {
                        IGtmMcu mcu = GtmController.getInstance().getGtmMcu();
                        String dataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcu.getMcu(), mcu.getSdkVersion(), "GTM");
                        String gtmModelFolder = DataDirectoryUtils.getDbFile((IMcuIdentification)mcu, (String)"gtm_model");
                        String useCaseMexFullPath = String.valueOf(dataDir) + File.separator + gtmModelFolder + File.separator + useCaseMexRelPath;
                        File mexFile = new File(useCaseMexFullPath);
                        if (mexFile.exists() && mexFile.isFile()) {
                            try {
                                Throwable throwable = null;
                                Object var8_10 = null;
                                try (FileInputStream is = new FileInputStream(mexFile);){
                                    StorageGtmConfiguration stGtmConfiguration;
                                    ISharedConfiguration sharedCfg = SharedConfigurationFactory.loadSharedConfigurationFromXml((InputStream)is);
                                    StorageGtmTool stGtmTool = sharedCfg.getTools().getGtmTool();
                                    if (stGtmTool != null && (stGtmConfiguration = stGtmTool.getGtmConfiguration()) != null) {
                                        GtmController.getInstance().loadGtmSettingsFromContainers((List)stGtmConfiguration.getContainers());
                                        GtmController.getInstance().handleSettingChange(16, (Object)SharedConfigurationFactory.getSharedConfigurationSingleton(), null, null);
                                        GtmController.getInstance().requestRegenerateCode();
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (Exception ex) {
                                LOGGER.warning(ex.getLocalizedMessage());
                            }
                        }
                    });
                    menu.getItems().add((Object)menuItem);
                }
                ++i;
            }
            contextMenu.getItems().add((Object)menu);
        }
    }

    protected static void createOpenDocumentationMenuItem(TreeItemSetting treeItemSetting, ContextMenu contextMenu) {
        Matcher openDocumentationMatcher = GtmToolActions.OPEN_DOCUMENTATION_REGEX.matcher(treeItemSetting.getAction());
        if (openDocumentationMatcher.find() && openDocumentationMatcher.groupCount() == 2) {
            MenuItem openDocMenuItem = new MenuItem(Messages.OpenDocumentationInBrowser);
            openDocMenuItem.setOnAction(e -> TreeStructSettingNode.openDocumentation(openDocumentationMatcher));
            contextMenu.getItems().add((Object)openDocMenuItem);
        }
    }

    private static void openDocumentation(Matcher openDocumentationMatcher) {
        String[] components;
        String documentationToOpen = openDocumentationMatcher.group(2);
        if (documentationToOpen != null && (components = documentationToOpen.split(",")).length == 2) {
            IGtmMcu mcu = GtmController.getInstance().getGtmMcu();
            String docRelPath = components[1];
            String dataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcu.getMcu(), mcu.getSdkVersion(), "GTM");
            String gtmModelFolder = DataDirectoryUtils.getDbFile((IMcuIdentification)mcu, (String)"gtm_model");
            String docFullPath = String.valueOf(dataDir) + File.separator + gtmModelFolder + File.separator + docRelPath;
            if (new File(docFullPath).exists()) {
                SWTFactoryProxy.INSTANCE.openFileInExternalApp(docFullPath);
            }
        }
    }

    private ChangeListener<TreeItem<String>> createSelectionListener() {
        return (observable, oldValue, newValue) -> {
            TreeItemSetting newItemSetting;
            TreeItemSetting oldItemSetting;
            GtmController.getInstance().changeInTreePane();
            if (oldValue != null && (oldItemSetting = UctXmlSettingsUtils.getTreeItemByLabel((TreeStructSetting)this.getTreeStruct(), (String)((String)oldValue.getValue()))) != null && !oldItemSetting.getAction().isEmpty()) {
                GtmToolActions.removeRefreshListeners(oldItemSetting.getAction());
            }
            if ((newItemSetting = UctXmlSettingsUtils.getTreeItemByLabel((TreeStructSetting)this.getTreeStruct(), (String)((String)newValue.getValue()))) != null) {
                GtmLayoutUtils.resetAllStructSettingsState();
                if (!newItemSetting.getAction().isEmpty()) {
                    GtmToolActions.executeAction(newItemSetting.getAction());
                }
            }
            GtmController.getInstance().updateConstraintsDeque();
        };
    }

    public ChangeListener<TreeItem<String>> getSelectionListener() {
        return this.selectionListener;
    }

    protected void refreshScene() {
        Scene scene = this.getScene();
        if (scene != null) {
            GtmLayoutUtils.refreshUI(scene);
        }
    }

    public void dispose() {
        MultipleSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            selectionModel.selectedItemProperty().removeListener(this.selectionListener);
        }
        this.getChildren().clear();
    }

    public TreeStructSetting getTreeStruct() {
        return this.treeStruct;
    }
}

