/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.controls.IRefreshableBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.BoolSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.gtm.controls.BoolSettingControl;
import com.nxp.swtools.gtm.controls.EnumSettingControl;
import com.nxp.swtools.gtm.controls.IntegerSettingControl;
import com.nxp.swtools.gtm.controls.StructSettingNode;
import com.nxp.swtools.gtm.controls.TextSettingControl;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.model.xml.settings.GtmBoolSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmEnumSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmTextSetting;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Font;
import org.eclipse.ui.services.IDisposable;

public class TitledPaneStructNode
extends TitledPane
implements IRefreshableBaseControl,
IDisposable {
    private GtmStructSetting structSetting;
    private GridPane content;

    public TitledPaneStructNode(GtmStructSetting structSetting) {
        this.structSetting = structSetting;
        this.content = new GridPane();
        this.create();
    }

    public void create() {
        ColumnConstraints cc = new ColumnConstraints();
        cc.setHgrow(Priority.ALWAYS);
        this.content.getColumnConstraints().add((Object)cc);
        RowConstraints rc = new RowConstraints();
        rc.setVgrow(Priority.ALWAYS);
        this.content.getRowConstraints().add((Object)rc);
        this.setId(this.structSetting.getId());
        this.setAlignment(Pos.TOP_CENTER);
        this.setContentDisplay(ContentDisplay.TOP);
        if (this.structSetting.getLabel().isEmpty()) {
            this.setFont(new Font(0.0));
        } else {
            this.setText(this.structSetting.getLabel());
            this.setFont(new Font("System Bold", 15.0));
        }
        this.setExpanded(this.structSetting.getLayoutSetting().isExpanded());
        this.setCollapsible(this.structSetting.getLayoutSetting().isCollapsible());
        GridPane.setFillWidth((Node)this, (Boolean)Boolean.TRUE);
        GridPane.setFillHeight((Node)this, (Boolean)Boolean.TRUE);
        for (GtmStructSetting childStructSetting : this.structSetting.getStructSettings()) {
            if (!childStructSetting.getInitVisibleState()) continue;
            StructSettingNode childStructSettingNode = new StructSettingNode(childStructSetting);
            this.content.add((Node)childStructSettingNode.getRegion(), childStructSetting.getColumn(), childStructSetting.getRow());
            GridPane.setFillWidth((Node)childStructSettingNode.getRegion(), (Boolean)Boolean.TRUE);
            GridPane.setFillHeight((Node)childStructSettingNode.getRegion(), (Boolean)Boolean.TRUE);
            GridPane.setValignment((Node)childStructSettingNode.getRegion(), (VPos)VPos.TOP);
            childStructSettingNode.getRegion().prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
            childStructSettingNode.getRegion().prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
            UctLayoutUtils.updateNodeState((Node)childStructSettingNode.getRegion(), (ABaseUIComponentSetting)childStructSetting);
        }
        for (GtmTextSetting textSetting : this.structSetting.getTextSettings()) {
            TextSettingControl textSettingControl = new TextSettingControl(textSetting, (Parent)this);
            this.content.add((Node)textSettingControl, textSetting.getColumn(), textSetting.getRow());
        }
        for (GtmBoolSetting boolSetting : this.structSetting.getBoolSettings()) {
            BoolSettingControl boolSettingControl = new BoolSettingControl((BoolSetting)boolSetting, (Parent)this);
            this.content.add((Node)boolSettingControl, boolSetting.getColumn(), boolSetting.getRow());
        }
        for (GtmEnumSetting enumSetting : this.structSetting.getEnumSettings()) {
            EnumSettingControl enumSettingControl = new EnumSettingControl(enumSetting, (Parent)this);
            this.content.add((Node)enumSettingControl, enumSetting.getColumn(), enumSetting.getRow());
        }
        for (GtmIntegerSetting integerSetting : this.structSetting.getIntegerSettings()) {
            IntegerSettingControl integerSettingControl = new IntegerSettingControl(integerSetting, (Parent)this);
            this.content.add((Node)integerSettingControl, integerSetting.getColumn(), integerSetting.getRow());
        }
        this.setContent((Node)this.content);
        GtmSceneCreator.getNodes().add((Node)this);
        GtmSceneCreator.getNodes().add((Node)this.content);
    }

    public void refresh() {
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        for (Node node : this.content.getChildren()) {
            if (!(node instanceof IBaseControl)) continue;
            ((IBaseControl)node).refresh();
        }
    }

    public void addRefreshListeners() {
        for (Node childNode : this.content.getChildren()) {
            if (!(childNode instanceof IRefreshableBaseControl)) continue;
            ((IRefreshableBaseControl)childNode).addRefreshListeners();
        }
    }

    public void removeRefreshListeners() {
        for (Node childNode : this.content.getChildren()) {
            if (!(childNode instanceof IRefreshableBaseControl)) continue;
            ((IRefreshableBaseControl)childNode).removeRefreshListeners();
        }
    }

    public void dispose() {
        for (Node node : this.content.getChildren()) {
            if (!(node instanceof IDisposable)) continue;
            ((IDisposable)node).dispose();
        }
        GtmSceneCreator.getNodes().remove((Object)this);
        GtmSceneCreator.getNodes().remove(this.content);
        this.getChildren().clear();
        this.content.getChildren().clear();
    }
}

