/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dcd.model.settings;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import com.nxp.swtools.dcd.model.settings.ABaseAttributes;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Validate;

@Root(name="tag", strict=false)
public class Tag
extends ABaseAttributes {
    private static final Logger LOGGER = LogManager.getLogger(Tag.class);
    @Attribute(name="value")
    private String value;
    private byte[] valueBytes;
    private BigInteger valueBigInt;

    public Tag(int size, String value, int startPosition) {
        super(size, startPosition);
        this.value = value;
        this.valueBytes = new byte[size];
        Arrays.fill(this.valueBytes, (byte)0);
        this.valueBigInt = BigInteger.ZERO;
    }

    public Tag() {
        this(0, "", 0);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public byte[] getValueBytes() {
        return this.valueBytes;
    }

    public BigInteger getValueBigInt() {
        return this.valueBigInt;
    }

    @Validate
    public void validate() {
        this.valueBytes = NumberFormatter.getValueBytes((String)this.value, (int)this.size);
        try {
            this.valueBigInt = NumberFormatter.getBigIntegerWithSuffix((String)this.value);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.severe(MessageFormat.format("Invalid tag {0}", this.value));
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return Objects.equals(this.value, other.value);
    }
}

