/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.model.ContextType;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.data.CoreTypeData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.data.TemplateData;
import java.util.List;

public class LibraryContext
extends CProjectMasterContext {
    public LibraryContext(CoreNatureConfiguration cConfiguration, ProcessorContext parent) {
        super(cConfiguration, ContextType.PROJECT_LIBRARY, parent);
        List<AbstractContext> cs = parent.getChildren();
        if (!cs.isEmpty()) {
            boolean isThisFirst = this.equals(cs.get(0));
            this.setActive(isThisFirst);
        }
    }

    @Override
    public boolean isAutoStart() {
        return false;
    }

    @Override
    public CoreTypeData getCoreNature() {
        return (CoreTypeData)super.getCoreNature();
    }

    @Override
    public CoreTypeData getRootData() {
        return (CoreTypeData)super.getRootData();
    }

    @Override
    public String getTargetTemplateId() {
        TemplateData t = this.getConfiguration().getTemplate();
        return t != null ? t.getLibraryTemplateId() : null;
    }

    public String getCoreType() {
        GeneralContext genContext = super.getGeneralContext();
        if (genContext == null) {
            return "";
        }
        CoreNatureConfiguration cn = super.getConfiguration();
        CoreTypeData coreType = cn.getCoreNature().getCoreType();
        if (coreType == null) {
            return "";
        }
        String coreTypeName = coreType.getName();
        ProcessorData processor = genContext.getCurrentProcessorConfiguration().getProcessor();
        String family = "";
        if (processor.getFamily() != null) {
            family = processor.getFamily().getName();
        }
        return String.format("%s_%s", family, coreTypeName);
    }
}

