/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.makegen.gnu;

import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GnuLinkOutputNameProvider
implements IManagedOutputNameProvider {
    @Override
    public IPath[] getOutputNames(ITool tool, IPath[] primaryInputNames) {
        IOption optSOName2;
        IOption optShared;
        IPath[] name = new IPath[1];
        String fileName = "default";
        if (primaryInputNames != null && primaryInputNames.length > 0 && (fileName = primaryInputNames[0].removeFileExtension().lastSegment()).startsWith("$(") && fileName.endsWith(")")) {
            fileName = fileName.substring(2, fileName.length() - 1);
        }
        boolean isSO = false;
        String soName = "";
        if (this.hasAncestor(tool, "cdt.managedbuild.tool.gnu.c.linker")) {
            optShared = tool.getOptionBySuperClassId("gnu.c.link.option.shared");
            if (optShared != null) {
                try {
                    isSO = optShared.getBooleanValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isSO && (optSOName2 = tool.getOptionBySuperClassId("gnu.c.link.option.soname")) != null) {
                try {
                    soName = optSOName2.getStringValue();
                }
                catch (Exception exception) {}
            }
        } else if (this.hasAncestor(tool, "cdt.managedbuild.tool.gnu.cpp.linker")) {
            optShared = tool.getOptionBySuperClassId("gnu.cpp.link.option.shared");
            if (optShared != null) {
                try {
                    isSO = optShared.getBooleanValue();
                }
                catch (Exception optSOName2) {
                    // empty catch block
                }
            }
            if (isSO && (optSOName2 = tool.getOptionBySuperClassId("gnu.cpp.link.option.soname")) != null) {
                try {
                    soName = optSOName2.getStringValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (isSO && soName != null && soName.length() > 0) {
            fileName = soName;
        } else {
            String[] exts;
            String outputPrefix = tool.getPrimaryOutputType().getOutputPrefix();
            IBuildObject toolParent = tool.getParent();
            IConfiguration config = null;
            if (toolParent instanceof IConfiguration) {
                config = (IConfiguration)toolParent;
            } else if (toolParent instanceof IToolChain) {
                config = ((IToolChain)toolParent).getParent();
            } else if (toolParent instanceof IResourceConfiguration) {
                config = ((IResourceConfiguration)toolParent).getParent();
            } else {
                throw new AssertionError((Object)ManagedMakeMessages.getResourceString("GnuLinkOutputNameProvider.0"));
            }
            if (config != null) {
                boolean explicitRuleRequired = false;
                int k = 0;
                while (k < primaryInputNames.length) {
                    if (primaryInputNames[k].toString().indexOf(" ") != -1) {
                        explicitRuleRequired = true;
                    }
                    ++k;
                }
                try {
                    outputPrefix = explicitRuleRequired ? ManagedBuildManager.getBuildMacroProvider().resolveValue(outputPrefix, "", " ", 3, config) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputPrefix, "", " ", 3, config);
                }
                catch (BuildMacroException buildMacroException) {
                    // empty catch block
                }
            }
            if (outputPrefix != null && outputPrefix.length() > 0) {
                fileName = String.valueOf(outputPrefix) + fileName;
            }
            if ((exts = tool.getPrimaryOutputType().getOutputExtensions(tool)) != null && exts[0].length() > 0) {
                fileName = String.valueOf(fileName) + "." + exts[0];
            }
        }
        name[0] = Path.fromOSString((String)fileName);
        return name;
    }

    protected boolean hasAncestor(ITool tool, String id) {
        do {
            if (!id.equals(tool.getId())) continue;
            return true;
        } while ((tool = tool.getSuperClass()) != null);
        return false;
    }
}

