/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controller;

import com.nxp.swtools.codemanager.ICodeGenerator;
import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.efuse.controller.Messages;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controller.utils.StorageEfuseUtils;
import com.nxp.swtools.efuse.controller.validation.EfuseProblemsManager;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.EfuseEmptyMcu;
import com.nxp.swtools.efuse.model.mcu.IEfuseMcu;
import com.nxp.swtools.efuse.model.mcu.McuFactory;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.xml.settings.EfuseXmlConfiguration;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.helper.CommonConfigImpl;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageEfuseConfiguration;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageEfuseTool;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageFuseField;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageFuseWord;
import com.nxp.swtools.utils.events.ToolEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;

public class EfuseController
extends AUctController
implements ICodeGenerator {
    private static final Logger LOGGER = LogManager.getLogger(EfuseController.class);
    @Nullable
    private ISharedConfigurationListener sharedConfigListener;
    private IEfuseMcu eFuseMcu;
    @Nullable
    private Display display = SWToolsProperties.isHeadlessOn() ? null : Display.getCurrent();
    private EfuseXmlConfiguration eFuseXmlConfig;
    private List<FuseField> hiddenBootInterfaceFuseField = new ArrayList<FuseField>();

    private EfuseController() {
        this.eFuseMcu = this.getMcuFromSharedConfig(this.getSharedConfig());
        this.setMcu((IMcu)this.eFuseMcu);
        this.eFuseXmlConfig = this.eFuseMcu.getEfuseXmlConfig();
        this.problemsManager = new EfuseProblemsManager();
        this.storeTool();
        this.reloadFromSharedConfig(this.getSharedConfig(), ConfigChangeReason.UNKNOWN);
        this.sharedConfigListener = new SharedConfigurationAdapter(){

            public void configurationReloaded(@NonNull ISharedConfiguration sharedConfiguration, @NonNull ConfigChangeReason reason) {
                if (reason.equals((Object)ConfigChangeReason.LOAD_CONFIG) || reason.equals((Object)ConfigChangeReason.RELOAD)) {
                    EfuseControllerUtils.clearAdvancedFusesArray();
                }
                EfuseController.this.reloadFromSharedConfig(sharedConfiguration, reason);
            }

            public void commonConfigurationChanged(@NonNull ISharedConfiguration sharedConfiguration) {
                IMcu currentMcu = EfuseController.this.getMcu();
                if (currentMcu != null && !sharedConfiguration.getCommonConfig().getMcuIdentification().equals(currentMcu.getMcuIdentification())) {
                    this.configurationReloaded(EfuseController.this.getSharedConfig(), ConfigChangeReason.UNKNOWN);
                }
            }

            public void configurationChanged(@NonNull ISharedConfiguration sharedConfiguration, @NonNull IConfigChangeContext changeContext) {
                CommonConfigImpl commonConfigImpl;
                ProcessorCore selectedCore;
                Object source = changeContext.getSource();
                if (source instanceof StorageEfuseTool) {
                    if (((StorageEfuseTool)source).isEnabled() != EfuseController.this.isToolEnabled().get()) {
                        this.configurationReloaded(sharedConfiguration, ConfigChangeReason.UNKNOWN);
                    }
                } else if (source instanceof CommonConfigImpl && (selectedCore = (commonConfigImpl = (CommonConfigImpl)source).getSelectedCore()) != null) {
                    EfuseController.this.handleSettingChange(4, EfuseController.this.getSharedConfig(), null, null);
                }
            }
        };
        this.getSharedConfig().addListener(Objects.requireNonNull(this.sharedConfigListener));
    }

    public static EfuseController getInstance() {
        try {
            EfuseController controller = (EfuseController)((Object)SWTFactoryProxy.INSTANCE.getSingletonInstance(EfuseController.class));
            if (controller.isDisposed().get()) {
                throw new IllegalStateException("eFUSE Controller is disposed");
            }
            return controller;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain user-singleton instance of: " + EfuseController.class.getSimpleName(), e);
        }
    }

    protected IEfuseMcu getMcuFromSharedConfig(ISharedConfiguration sharedConfiguration) {
        ICommonConfig commonConfig = sharedConfiguration.getCommonConfig();
        EfuseEmptyMcu selectedMcu = null;
        if (!commonConfig.getMcu().isEmpty()) {
            IEfuseMcu currentMcu = (IEfuseMcu)this.getMcu();
            if (currentMcu != null && commonConfig.getMcuIdentification().equals(currentMcu.getMcuIdentification()) && !SWToolsProperties.isVerificationOn() && !(currentMcu instanceof EfuseEmptyMcu)) {
                selectedMcu = currentMcu;
            } else {
                ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
                selectedMcu = McuFactory.create((ISupportedDerivativesForSwTools)derivatives, (ICommonConfig)commonConfig);
            }
        } else {
            selectedMcu = new EfuseEmptyMcu(UtilsText.safeString((String)com.nxp.swtools.common.uct.utils.Messages.Msg_NoMcuSelected));
        }
        return selectedMcu == null ? new EfuseEmptyMcu(UtilsText.safeString((String)com.nxp.swtools.common.uct.utils.Messages.Msg_CorruptedMcuData)) : selectedMcu;
    }

    protected void reloadFromSharedConfig(ISharedConfiguration sharedConfiguration, ConfigChangeReason reason) {
        if (this.getSharedConfig() != sharedConfiguration) {
            LOGGER.log(Level.SEVERE, "Unexpected change of shared configuration for eFUSE tool");
            throw new IllegalArgumentException("Unexpected change of shared configuration");
        }
        this.eFuseMcu = this.getMcuFromSharedConfig(sharedConfiguration);
        this.setMcu((IMcu)this.eFuseMcu);
        this.setEfuseXmlConfig();
        this.getProblemsManager().clearAllProblems();
        StorageEfuseTool stEfuseTool = sharedConfiguration.getTools().getEfuseTool();
        this.setToolEnabled(stEfuseTool == null || stEfuseTool.isEnabled());
        if (this.isToolEnabled().get()) {
            this.storeTool();
            this.loadEfuseConfiguration(reason);
        } else {
            this.eFuseMcu = new EfuseEmptyMcu(Messages.Msg_ToolDisabled);
            this.setMcu((IMcu)this.eFuseMcu);
        }
        this.handleSettingChange(2, this.getSharedConfig(), null, null);
    }

    private void loadEfuseConfiguration(ConfigChangeReason reason) {
        EfuseControllerUtils.associateUISettingsWithFusesElements(this.eFuseMcu);
        EfuseControllerUtils.initAllComponentsState(this.eFuseMcu);
        StorageEfuseTool stEfuseTool = this.getSharedConfig().getTools().getEfuseTool();
        if (stEfuseTool != null) {
            StorageEfuseConfiguration stEfuseConfig = stEfuseTool.getEfuseConfiguration();
            if (stEfuseConfig == null || reason.equals((Object)ConfigChangeReason.CLEAR_CONFIG)) {
                EfuseControllerUtils.initAllComponentsValues(this.eFuseMcu);
                stEfuseConfig = new StorageEfuseConfiguration();
                stEfuseTool.setEfuseConfiguration(stEfuseConfig);
            } else {
                this.loadFuseWordsFromStorage(stEfuseConfig.getFuseWords());
            }
            EfuseControllerUtils.computeAllGuiComponentsExpressions(this.eFuseMcu);
            EfuseControllerUtils.initAllComponentsState(this.eFuseMcu);
            EfuseControllerUtils.calculateAllFuseWordsValues(this.eFuseMcu);
            StorageEfuseUtils.initializeAllStorageFuseWords(this.eFuseMcu, stEfuseTool);
        }
        if (reason.equals((Object)ConfigChangeReason.UNDO_REDO)) {
            EfuseControllerUtils.addModifiedFusesInAdvancedArray();
            this.handleSettingChange(16, this.getSharedConfig(), null, null);
        } else {
            this.handleSettingChange(8, this.getSharedConfig(), null, null);
        }
    }

    private void loadFuseWordsFromStorage(List<StorageFuseWord> stFuseWords) {
        for (StorageFuseWord stFuseWord : stFuseWords) {
            FuseWord fuseWord;
            String eccValue;
            ABaseUIComponentSetting eccComponent;
            boolean fuseWordPopulated = false;
            List stFuseFields = stFuseWord.getFieldsList();
            ABaseUIComponentSetting fuseWordComponent = EfuseUtils.getComponentSettingByFuseWord((IEfuseMcu)this.eFuseMcu, (String)stFuseWord.getId());
            if (fuseWordComponent != null) {
                EfuseControllerUtils.setUIComponentValue(fuseWordComponent, stFuseWord.getValue());
                fuseWordPopulated = true;
            }
            if ((eccComponent = EfuseUtils.getEccProtectedComponentSettingByFuseWord((IEfuseMcu)this.eFuseMcu, (String)stFuseWord.getId())) != null && (eccValue = Integer.toString(stFuseWord.isEccProtected() ? 1 : 0)) != null) {
                EfuseControllerUtils.setUIComponentValue(eccComponent, eccValue);
            }
            if (!fuseWordPopulated && (fuseWord = EfuseUtils.getFuseWordByID((List)this.eFuseMcu.getAllFuseWords(), (String)stFuseWord.getId())) != null) {
                fuseWord.setValueToWrite(Long.decode(stFuseWord.getValue()).longValue());
            }
            for (StorageFuseField stFuseField : stFuseFields) {
                ABaseUIComponentSetting fuseFieldComponent = null;
                fuseFieldComponent = EfuseUtils.isFuseFieldAssociatedWithMultipleComponents((IEfuseMcu)this.eFuseMcu, (String)stFuseField.getId()) ? EfuseControllerUtils.getComponentSettingBasedOnConstraints(stFuseWords, stFuseField.getId()) : EfuseUtils.getComponentSettingById((IEfuseMcu)this.eFuseMcu, (String)stFuseField.getId());
                if (fuseFieldComponent == null) continue;
                EfuseControllerUtils.setUIComponentValue(fuseFieldComponent, stFuseField.getValue());
            }
        }
    }

    public IEfuseMcu getEfuseMcu() {
        return this.eFuseMcu;
    }

    protected StorageEfuseTool storeTool() {
        StorageEfuseTool stEfuseTool = this.getSharedConfig().getTools().getEfuseTool();
        if (stEfuseTool == null) {
            stEfuseTool = new StorageEfuseTool();
            this.getSharedConfig().getTools().setEfuseTool(stEfuseTool);
        }
        return stEfuseTool;
    }

    public synchronized void dispose() {
        this.setDisposed(true);
        ISharedConfigurationListener listenerLoc = this.sharedConfigListener;
        if (listenerLoc != null) {
            this.getSharedConfig().removeListener(listenerLoc);
        }
    }

    public void forceCodeRegeneration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable Object inputObject, @Nullable String actionLabel) {
        ISharedConfiguration currentSharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        EfuseController efuseController = this;
        synchronized (efuseController) {
            IMcu currentMcu = this.getMcu();
            if (currentMcu != null && this.getShouldUpdateConfiguration().get() && this.isToolEnabled().get() && EfuseController.isMcuSupported((IMcu)currentMcu)) {
                if (eventOriginator != currentSharedConfig) {
                    StorageEfuseTool stEfuseTool = this.storeTool();
                    currentSharedConfig.getTools().setEfuseTool(stEfuseTool);
                    this.setDirty(currentSharedConfig, "eFUSE", stEfuseTool, actionLabel, IConfigChangeContext.ConfigChangeType.TOOL_SETTING_CHANGE);
                }
                this.setSaved(false);
            }
        }
        UIJobHelper.runNowOrInJob(() -> this.fireListeners(new ToolEvent.Builder(eventType).setObject(inputObject).setOriginator(eventOriginator).build()), (String)"Refresh eFUSE tool", (Display)this.display);
    }

    public EfuseXmlConfiguration getEfuseXmlConfig() {
        return this.eFuseXmlConfig;
    }

    public void setEfuseXmlConfig() {
        this.eFuseXmlConfig = this.eFuseMcu.getEfuseXmlConfig();
    }

    public void setHiddenBootInterfaceFuseField(List<FuseField> hiddenBootInterfaceFuseField) {
        this.hiddenBootInterfaceFuseField = hiddenBootInterfaceFuseField;
    }

    public List<FuseField> getHiddenBootInterfaceFuseField() {
        return this.hiddenBootInterfaceFuseField;
    }

    public EfuseProblemsManager getProblemsManager() {
        return (EfuseProblemsManager)this.problemsManager;
    }

    public void resetToProcessorDefaults() {
        this.getProblemsManager().clearAllProblems();
        EfuseControllerUtils.clearAdvancedFusesArray();
        this.loadEfuseConfiguration(ConfigChangeReason.CLEAR_CONFIG);
        this.handleSettingChange(4, (Object)this, null, UtilsText.safeString((String)Messages.Controller_Action_ResetToProcessorDefaults));
    }

    protected void reloadFromSharedConfig(ISharedConfiguration sharedConfiguration) {
    }

    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable String actionLabel) {
    }
}

