/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.osview;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.osview.Messages;
import org.eclipse.cdt.dsf.gdb.internal.ui.osview.OSResourcesView;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS2;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.BundleContext;

public class AttachProcessHandler
extends AbstractHandler {
    private static final String PROCESSES_CLASS = "processes";
    private static final String THREADS_CLASS = "threads";

    public void setEnabled(Object evaluationContext) {
        boolean state = false;
        if (evaluationContext instanceof IEvaluationContext) {
            OSResourcesView rview;
            ICommandControlService.ICommandControlDMContext sessionContext;
            IStructuredSelection sel2;
            Object p = ((IEvaluationContext)evaluationContext).getVariable("activePart");
            Object s = ((IEvaluationContext)evaluationContext).getVariable("selection");
            if (p instanceof OSResourcesView && s instanceof IStructuredSelection && !(sel2 = (IStructuredSelection)s).isEmpty() && sel2.getFirstElement() instanceof IGDBHardwareAndOS2.IResourcesInformation && (sessionContext = (rview = (OSResourcesView)((Object)p)).getSessionContext()) != null && (PROCESSES_CLASS.equals(rview.getResourceClass()) || THREADS_CLASS.equals(rview.getResourceClass()))) {
                state = this.isAttachSupported(sessionContext);
            }
        }
        this.setBaseEnabled(state);
    }

    private boolean isAttachSupported(final ICommandControlService.ICommandControlDMContext context) {
        DsfSession session = DsfSession.getSession((String)context.getSessionId());
        if (session == null) {
            return false;
        }
        Query<Boolean> canConnectQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                BundleContext c = GdbUIPlugin.getDefault().getBundle().getBundleContext();
                DsfServicesTracker tracker = new DsfServicesTracker(c, context.getSessionId());
                IProcesses procService = (IProcesses)tracker.getService(IProcesses.class);
                ICommandControlService commandControl = (ICommandControlService)tracker.getService(ICommandControlService.class);
                if (procService != null && commandControl != null) {
                    procService.isDebuggerAttachSupported((IDMContext)commandControl.getContext(), rm);
                } else {
                    rm.done((Object)false);
                }
            }
        };
        try {
            session.getExecutor().execute((Runnable)canConnectQuery);
            return (Boolean)canConnectQuery.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return false;
        }
    }

    public Object execute(ExecutionEvent event) throws org.eclipse.core.commands.ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && part instanceof OSResourcesView) {
            int pidColumn = -1;
            IGDBHardwareAndOS2.IResourcesInformation firstSelection = (IGDBHardwareAndOS2.IResourcesInformation)((IStructuredSelection)selection).getFirstElement();
            int i = 0;
            while (i < firstSelection.getColumnNames().length) {
                if ("pid".equalsIgnoreCase(firstSelection.getColumnNames()[i])) {
                    pidColumn = i;
                    break;
                }
                ++i;
            }
            if (pidColumn < 0) {
                GdbUIPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", "Missing 'pid' column to perform attach"));
                return null;
            }
            LinkedHashSet<String> process_ids = new LinkedHashSet<String>();
            for (Object sel : ((IStructuredSelection)selection).toList()) {
                IGDBHardwareAndOS2.IResourcesInformation ri = (IGDBHardwareAndOS2.IResourcesInformation)sel;
                if (pidColumn < 0) continue;
                String pid = ri.getContent()[0][pidColumn];
                try {
                    Integer.parseInt(pid);
                    process_ids.add(pid);
                }
                catch (NumberFormatException e) {
                    GdbUIPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", "Non-integer pid " + pid, (Throwable)e));
                }
            }
            final ICommandControlService.ICommandControlDMContext context = ((OSResourcesView)part).getSessionContext();
            final ArrayList<2> attach_steps = new ArrayList<2>(process_ids.size());
            for (final String p : process_ids) {
                attach_steps.add(new Sequence.Step(){

                    public void execute(RequestMonitor rm) {
                        AttachProcessHandler.this.attachToProcess(context, p, rm);
                    }

                    public String getTaskName() {
                        return MessageFormat.format(Messages.OSView_AttachTask, p);
                    }
                });
            }
            if (!attach_steps.isEmpty()) {
                Job.create((String)Messages.OSView_AttachJobName, (ICoreRunnable)new ICoreRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        DsfSession session = DsfSession.getSession((String)context.getSessionId());
                        Sequence sequence = new Sequence(session.getExecutor(), monitor, Messages.OSView_AttachJobName, ""){

                            public Sequence.Step[] getSteps() {
                                return attach_steps.toArray(new Sequence.Step[attach_steps.size()]);
                            }
                        };
                        session.getExecutor().execute((Runnable)sequence);
                        try {
                            sequence.get();
                        }
                        catch (InterruptedException | ExecutionException exception) {
                            // empty catch block
                        }
                    }
                }).schedule();
            }
        }
        return null;
    }

    private void attachToProcess(ICommandControlService.ICommandControlDMContext context, String pid, RequestMonitor rm) {
        BundleContext c = GdbUIPlugin.getDefault().getBundle().getBundleContext();
        DsfServicesTracker tracker = new DsfServicesTracker(c, context.getSessionId());
        try {
            IGDBProcesses procService = (IGDBProcesses)tracker.getService(IGDBProcesses.class);
            if (procService != null) {
                IProcesses.IProcessDMContext procDmc = procService.createProcessContext(context, pid);
                procService.attachDebuggerToProcess(procDmc, (DataRequestMonitor)new DataRequestMonitor<IDMContext>((Executor)DsfSession.getSession((String)context.getSessionId()).getExecutor(), rm){

                    protected void handleErrorOrWarning() {
                        IStatus status = this.getStatus();
                        if (status != null && !status.isOK()) {
                            IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler(status);
                            if (statusHandler != null) {
                                try {
                                    statusHandler.handleStatus(status, null);
                                }
                                catch (CoreException ex) {
                                    GdbUIPlugin.getDefault().getLog().log(ex.getStatus());
                                }
                            } else {
                                GdbUIPlugin.getDefault().getLog().log(status);
                            }
                        }
                        this.handleSuccess();
                    }
                });
            } else {
                rm.done();
                GdbUIPlugin.log(new Throwable("Could not retreive process service for context" + context));
            }
        }
        finally {
            tracker.dispose();
        }
    }
}

