/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.memory;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.model.IMemoryBlockAddressInfoRetrieval;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlock;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.gdb.internal.memory.GdbMemoryAddressInfoRegistersRetrieval;
import org.eclipse.cdt.dsf.gdb.internal.memory.GdbMemoryAddressInfoVariablesRetrieval;
import org.eclipse.cdt.dsf.gdb.memory.IGdbMemoryAddressInfoTypeRetrieval;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.core.model.IMemoryBlock;

public class GdbMemoryBlockAddressInfoRetrieval
implements IMemoryBlockAddressInfoRetrieval {
    private final DsfSession fSession;
    private final Set<IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener> fListeners = new HashSet<IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener>();

    public GdbMemoryBlockAddressInfoRetrieval(DsfSession session) {
        this.fSession = session;
        this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                GdbMemoryBlockAddressInfoRetrieval.this.fSession.addServiceEventListener((Object)GdbMemoryBlockAddressInfoRetrieval.this, null);
            }
        });
    }

    protected IGdbMemoryAddressInfoTypeRetrieval[] resolveMemoryAddressInfoProviders() {
        return new IGdbMemoryAddressInfoTypeRetrieval[]{new GdbMemoryAddressInfoVariablesRetrieval(this.fSession), new GdbMemoryAddressInfoRegistersRetrieval(this.fSession)};
    }

    public void getMemoryBlockAddressInfo(Object selection, final IMemoryBlock memBlock, final IMemoryBlockAddressInfoRetrieval.IGetMemoryBlockAddressInfoReq request) {
        IMemory.IMemoryDMContext memBlockContext = null;
        if (memBlock instanceof DsfMemoryBlock) {
            memBlockContext = ((DsfMemoryBlock)memBlock).getContext();
            if (selection instanceof IDMVMContext) {
                IDMContext context = ((IDMVMContext)selection).getDMContext();
                final IStack.IFrameDMContext frameCtx = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)context, IStack.IFrameDMContext.class);
                if (frameCtx != null) {
                    IRunControl.IContainerDMContext selectedContainerCtx = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)frameCtx, IRunControl.IContainerDMContext.class);
                    IRunControl.IContainerDMContext memoryContainerCtx = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)memBlockContext, IRunControl.IContainerDMContext.class);
                    if (memoryContainerCtx != null && memoryContainerCtx.equals(selectedContainerCtx)) {
                        this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                IGdbMemoryAddressInfoTypeRetrieval[] infoTypeProviders = GdbMemoryBlockAddressInfoRetrieval.this.resolveMemoryAddressInfoProviders();
                                if (infoTypeProviders == null || infoTypeProviders.length == 0) {
                                    request.done();
                                    return;
                                }
                                final CountingRequestMonitor crm = new CountingRequestMonitor((Executor)GdbMemoryBlockAddressInfoRetrieval.this.fSession.getExecutor(), null){

                                    protected void handleCompleted() {
                                        request.done();
                                    }
                                };
                                IGdbMemoryAddressInfoTypeRetrieval[] iGdbMemoryAddressInfoTypeRetrievalArray = infoTypeProviders;
                                int n = infoTypeProviders.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    final IGdbMemoryAddressInfoTypeRetrieval infoProvider = iGdbMemoryAddressInfoTypeRetrievalArray[n2];
                                    infoProvider.itemsRequest((IDMContext)frameCtx, memBlock, (DataRequestMonitor)new DataRequestMonitor<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[]>((Executor)GdbMemoryBlockAddressInfoRetrieval.this.fSession.getExecutor(), (RequestMonitor)crm){

                                        protected void handleCompleted() {
                                            if (this.isSuccess()) {
                                                request.setAddressInfoItems(infoProvider.getInfoType(), (IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[])this.getData());
                                            } else {
                                                request.setStatus(this.getStatus());
                                            }
                                            crm.done();
                                        }
                                    });
                                    ++n2;
                                }
                                crm.setDoneCount(infoTypeProviders.length);
                            }
                        });
                    } else {
                        request.done();
                    }
                } else {
                    request.done();
                }
            } else {
                request.done();
            }
        } else {
            request.done();
        }
    }

    public void dispose() {
        this.fListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAddressInfoUpdateListener(IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener listener) {
        Set<IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener> set = this.fListeners;
        synchronized (set) {
            this.fListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAddressInfoUpdateListener(IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener listener) {
        Set<IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener> set = this.fListeners;
        synchronized (set) {
            this.fListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DsfServiceEventHandler
    public void eventDispatched(IRegisters.IRegisterChangedDMEvent e) {
        Set<IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener> set = this.fListeners;
        synchronized (set) {
            for (IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener listener : this.fListeners) {
                listener.handleAddressInfoUpdate(IMemoryBlockAddressInfoRetrieval.EventType.VALUE_CHANGED, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DsfServiceEventHandler
    public void eventDispatched(IExpressions.IExpressionChangedDMEvent e) {
        Set<IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener> set = this.fListeners;
        synchronized (set) {
            for (IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener listener : this.fListeners) {
                listener.handleAddressInfoUpdate(IMemoryBlockAddressInfoRetrieval.EventType.VALUE_CHANGED, null);
            }
        }
    }
}

