/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.runtime.ui.memento;

import com.nxp.s32ds.ext.rcp.runtime.internal.ui.RuntimeUiActivator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public abstract class RcpMementos<T> {
    private final String mementoPrefix;
    private final String mementoId;

    public RcpMementos(String mementoPrefix, String mementoId) {
        this.mementoPrefix = mementoPrefix;
        this.mementoId = mementoId;
    }

    public void saveToMemento(T t) {
        this.saveToMemento(t, this.createMemento());
    }

    public void saveToMemento(T t, XMLMemento memento) {
        try {
            this.saveToMemento((IMemento)memento, t);
        }
        finally {
            this.saveMemento(memento);
        }
    }

    public T restoreFromMemento(T t) {
        XMLMemento memento = this.loadMemento();
        return this.restoreFromMemento((IMemento)memento, t);
    }

    public void removeMemento() {
        IPreferenceStore store = this.getPreferenceStore();
        if (!store.isDefault(String.valueOf(this.mementoPrefix) + this.mementoId)) {
            store.setToDefault(String.valueOf(this.mementoPrefix) + this.mementoId);
        }
    }

    protected abstract T restoreFromMemento(IMemento var1, T var2);

    protected abstract void saveToMemento(IMemento var1, T var2);

    protected abstract IPreferenceStore getPreferenceStore();

    protected XMLMemento createMemento() {
        return XMLMemento.createWriteRoot((String)"root");
    }

    protected void saveMemento(XMLMemento memento) {
        IPreferenceStore store = this.getPreferenceStore();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (StringWriter writer = new StringWriter();){
                memento.save((Writer)writer);
                store.setValue(String.valueOf(this.mementoPrefix) + this.mementoId, writer.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    protected XMLMemento loadMemento() {
        IPreferenceStore store = this.getPreferenceStore();
        String string = store.getString(String.valueOf(this.mementoPrefix) + this.mementoId);
        if (!string.isEmpty()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (StringReader reader = new StringReader(string);){
                    return XMLMemento.createReadRoot((Reader)reader);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (WorkbenchException e) {
                RuntimeUiActivator.getInstance().log(e.getStatus());
            }
        }
        return this.createMemento();
    }
}

