/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.debugger.connections.registry;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnection;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionAccessor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.internal.connections.registry.DebuggerConnectionsRegistryActivator;
import com.nxp.s32ds.cle.runtime.debugger.internal.connections.registry.Messages;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

public class DebuggerConnections {
    public static Collection<DebuggerConnectionDescriptor> getDebuggerConnectionDeviceDescriptors() {
        DebuggerConnection registry = DebuggerConnectionsRegistryActivator.getInstance().getRegistry();
        if (registry != null) {
            return registry.getConnectionDeviceDescriptors();
        }
        DebuggerConnectionsRegistryActivator.getInstance().logError(Messages.RegistryError_no_registry);
        return Collections.emptySet();
    }

    public static Collection<DebuggerConnectionDescriptor> getDebuggerConnectionDeviceDescriptors(String debuggerId) {
        return DebuggerConnections.getDebuggerConnectionDeviceDescriptors().stream().filter(descriptor -> descriptor.supportsDebuggerId(debuggerId)).collect(Collectors.toSet());
    }

    public static DebuggerConnectionDescriptor getDebuggerConnectionDescriptorByConnectionName(String name) {
        DebuggerConnection registry = DebuggerConnectionsRegistryActivator.getInstance().getRegistry();
        if (registry != null) {
            return registry.getDebuggerConnectionDeviceDescriptorByName(name);
        }
        DebuggerConnectionsRegistryActivator.getInstance().logError(Messages.RegistryError_no_registry);
        return null;
    }

    public static DebuggerConnectionAccessor getDebuggerConnectionAccessorByConnectionName(String name) {
        DebuggerConnection registry = DebuggerConnectionsRegistryActivator.getInstance().getRegistry();
        if (registry != null) {
            return registry.getDebuggerConnectionDeviceAccessorByName(name);
        }
        DebuggerConnectionsRegistryActivator.getInstance().logError(Messages.RegistryError_no_registry);
        return null;
    }
}

