/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.query;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryAnnotation;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryResult;
import com.nxp.swtools.provider.configuration.dependencies.DependencyResourceAnotation;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.query.FrameworkTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@DependencyQueryAnnotation(resources={@DependencyResourceAnotation(resourceType="Configuration", features={"value", "version", "name", "package", "family", "series", "SelectedCore"}), @DependencyResourceAnotation(resourceType="Tool", features={"enabled", "funcGroupNames", "initGroupNames"})})
public class GeneralConfigQuery
implements IDependencyQuery {
    private static final Logger LOGGER = LogManager.getLogger(GeneralConfigQuery.class);
    private static final String RESOURCE_PROCESSOR = "processor";
    private static final String RESOURCE_SDK = "SDK";
    private static final String UNKNOWN_FEATURE_MSG = "Unknown feature {0} for resourceId {1}";

    @Override
    public Collection<IDependencyQueryResult> query(ISharedConfiguration configuration, String resourceType, String resourceId, String featureName) {
        ArrayList<@NonNull IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        if (configuration.isEmpty()) {
            LOGGER.warning("GeneralConfigQuery asked for empty configuration.");
            return result;
        }
        FrameworkTool frameworkTool = FrameworkTool.getInstance();
        if ("Tool".equalsIgnoreCase(resourceType)) {
            if ("enabled".equalsIgnoreCase(featureName)) {
                StorageTool tool = configuration.getTools().getTool(resourceId);
                Boolean val = tool != null && tool.isEnabled();
                DependencyQueryResult answer = new DependencyQueryResult(val, frameworkTool, frameworkTool.getGlobalConfiguration());
                result.add(answer);
            } else if ("funcGroupNames".equalsIgnoreCase(featureName)) {
                IDependencyQueryResult funcGroupNamesResult = GeneralConfigQuery.answerFuncGroupQuery(configuration, resourceId, false);
                if (funcGroupNamesResult != null) {
                    result.add(funcGroupNamesResult);
                }
            } else if ("initGroupNames".equalsIgnoreCase(featureName)) {
                IDependencyQueryResult funcGroupNamesResult = GeneralConfigQuery.answerFuncGroupQuery(configuration, resourceId, true);
                if (funcGroupNamesResult != null) {
                    result.add(funcGroupNamesResult);
                }
            } else {
                LOGGER.log(Level.SEVERE, UNKNOWN_FEATURE_MSG, new Object[]{featureName, resourceId});
            }
        } else if ("Configuration".equalsIgnoreCase(resourceType)) {
            IMcuIdentification ident = configuration.getCommonConfig().getMcuIdentification();
            if (RESOURCE_PROCESSOR.equalsIgnoreCase(resourceId)) {
                if ("name".equalsIgnoreCase(featureName)) {
                    DependencyQueryResult answer = new DependencyQueryResult(ident.getMcu(), frameworkTool, frameworkTool.getGlobalConfiguration());
                    result.add(answer);
                } else if ("package".equalsIgnoreCase(featureName)) {
                    DependencyQueryResult answer = new DependencyQueryResult(ident.getPackage(), frameworkTool, frameworkTool.getGlobalConfiguration());
                    result.add(answer);
                } else if ("family".equalsIgnoreCase(featureName)) {
                    ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
                    DependencyQueryResult answer = new DependencyQueryResult(derivatives.getCpuFamily(ident.getMcu(), ident.getSdkVersion()), frameworkTool, frameworkTool.getGlobalConfiguration());
                    result.add(answer);
                } else if ("series".equalsIgnoreCase(featureName)) {
                    ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
                    IProcessorMasterToolInfo masterTool = derivatives.getProcessorMasterToolInfo(ident.getMcu(), ident.getSdkVersion());
                    if (masterTool != null) {
                        DependencyQueryResult answer = new DependencyQueryResult(masterTool.getSeries(), frameworkTool, frameworkTool.getGlobalConfiguration());
                        result.add(answer);
                    } else {
                        LOGGER.severe("Not found in supported derivatives processor from configuration");
                        assert (false) : "Not found in supported derivatives processor from configuration";
                    }
                } else if ("SelectedCore".equalsIgnoreCase(featureName)) {
                    ProcessorCore core = configuration.getCommonConfig().getSelectedCore();
                    String selectedCore = core != null ? core.getID() : null;
                    DependencyQueryResult answer = new DependencyQueryResult(selectedCore, frameworkTool, frameworkTool.getGlobalConfiguration());
                    result.add(answer);
                } else {
                    LOGGER.log(Level.SEVERE, UNKNOWN_FEATURE_MSG, new Object[]{featureName, resourceId});
                }
            } else if (RESOURCE_SDK.equalsIgnoreCase(resourceId)) {
                if ("version".equalsIgnoreCase(featureName)) {
                    DependencyQueryResult answer = new DependencyQueryResult(ident.getSdkVersion(), frameworkTool, frameworkTool.getGlobalConfiguration());
                    result.add(answer);
                } else {
                    LOGGER.log(Level.SEVERE, UNKNOWN_FEATURE_MSG, new Object[]{featureName, resourceId});
                }
            } else {
                LOGGER.log(Level.SEVERE, "Unknown resourceID:", resourceId);
            }
        } else {
            LOGGER.log(Level.SEVERE, "Unknown resourceType {0}", resourceType);
        }
        return result;
    }

    private static @Nullable IDependencyQueryResult answerFuncGroupQuery(ISharedConfiguration configuration, String resourceId, boolean defaultInitOnly) {
        DependencyQueryResult result = null;
        StorageTool tool = configuration.getTools().getTool(resourceId);
        if (tool != null) {
            if (tool.isEnabled()) {
                List<? extends @NonNull StorageToolBaseConfiguration> functionalGroups = tool.getFunctionalGroups();
                HashSet<@NonNull E> configNames = new HashSet();
                if (functionalGroups != null) {
                    functionalGroups.stream().filter(x -> !defaultInitOnly || x.isCalledFromInit()).forEach(x -> {
                        boolean bl = configNames.add(x.getName());
                    });
                    result = new DependencyQueryResult(configNames, tool, FrameworkTool.getInstance().getGlobalConfiguration());
                } else {
                    LOGGER.warning("No function groups found for " + resourceId + " Tool");
                }
            }
        } else {
            LOGGER.warning("Storage of " + resourceId + " tool not found");
        }
        return result;
    }
}

