/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.processors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.zip.ZipUtils;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISWToolsDataFolderInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.api.IBaseInfo;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.datalocation.Location;

public class DataPackage {
    public static final String PROPERTY_COMPONENTS = "components";
    public static final String PROPERTY_KITS = "kits";
    public static final String PROPERTY_BOARDS = "boards";
    public static final String PROPERTY_PROCESSORS = "processors";
    public static final String PROPERTY_DATA_VERSION = "data_version";
    public static final String PACKAGE_MANIFEST = "npidata.mf";
    public static final String[] LICENSE_DATA_FILES = new String[]{"ProductLicense.txt:License.txt", "DataSoftwareContentRegister.txt:SoftwareContentRegister.txt"};
    static final Logger LOGGER = LogManager.getLogger(DataPackage.class);

    static Collection<String> getFilesAndDirsToExport(Collection<ISWToolsDataFolderInfo> dataToExport, @Nullable File sourceBaseDir) {
        File compatibilityFile;
        ArrayList<@NonNull String> itemsToArchive = new ArrayList<String>();
        for (ISWToolsDataFolderInfo obj : dataToExport) {
            if (obj instanceof ITemplateInfo) {
                itemsToArchive.add(UtilsFile.getFilePath((String)((ITemplateInfo)obj).getRelFileName()));
                continue;
            }
            if (obj instanceof IProcessorMasterToolInfo) {
                itemsToArchive.add(((IProcessorMasterToolInfo)obj).getSubDir());
                continue;
            }
            assert (false) : "Unsupported object to export";
        }
        String dataDir = KExProcessorsProvider.getSupportedDerivatives().getDataDir();
        dataToExport.stream().map(ISWToolsDataFolderInfo::getSWToolsDataFolderID).distinct().filter(sdk -> new File(String.valueOf(dataDir) + File.separator + sdk + "_info.xml").exists() || sourceBaseDir != null && new File(String.valueOf(sourceBaseDir.getAbsolutePath()) + File.separator + sdk + "_info.xml").exists()).forEach(sdk -> {
            boolean bl = itemsToArchive.add(String.valueOf(sdk) + "_info.xml");
        });
        File file = compatibilityFile = sourceBaseDir != null ? new File(String.valueOf(sourceBaseDir.getAbsolutePath()) + File.separator + "configuration") : new File(String.valueOf(dataDir) + File.separator + "configuration");
        if (compatibilityFile.exists()) {
            itemsToArchive.add("configuration");
        }
        return itemsToArchive;
    }

    static Stream<String> getDirsForComponents(Collection<IConfigComponentInfo> components, File sourceBaseDir) {
        return components.stream().map(IConfigComponentInfo::getComponentDir).map(it -> sourceBaseDir.toPath().relativize(it.toPath()).toString());
    }

    static void addManifestToZipFile(ZipOutputStream zipOut, Collection<? extends ISWToolsDataFolderInfo> dataToExport, Map<String, Collection<IConfigComponentInfo>> componentsToExport) throws IOException {
        ZipEntry entry = new ZipEntry(PACKAGE_MANIFEST);
        zipOut.putNextEntry(entry);
        ArrayList<String> processors = new ArrayList<String>();
        ArrayList<String> boards = new ArrayList<String>();
        ArrayList<String> kits = new ArrayList<String>();
        Map<String, Collection<String>> components = componentsToExport.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Collection)e.getValue()).stream().map(IBaseInfo::getName).collect(Collectors.toList())));
        assert (components != null);
        for (ISWToolsDataFolderInfo iSWToolsDataFolderInfo : dataToExport) {
            if (iSWToolsDataFolderInfo instanceof ITemplateInfo) {
                ITemplateInfo templ = (ITemplateInfo)iSWToolsDataFolderInfo;
                if (templ.getTemplateType() == ITemplateInfo.TemplateType.ttBoard) {
                    boards.add(templ.getId());
                    continue;
                }
                kits.add(templ.getId());
                continue;
            }
            if (iSWToolsDataFolderInfo instanceof IProcessorMasterToolInfo) {
                processors.add(iSWToolsDataFolderInfo.getId());
                continue;
            }
            assert (false) : "Unsupported object to export";
        }
        DataPackage.createManifest((OutputStream)zipOut, processors, boards, kits, components);
        zipOut.closeEntry();
    }

    @Deprecated
    static void addManifestToZipFile(ZipOutputStream zipOut, Collection<? extends ISWToolsDataFolderInfo> dataToExport, Collection<IConfigComponentInfo> componentsToExport) throws IOException {
        HashMap<String, Collection<IConfigComponentInfo>> componentsMap = new HashMap<String, Collection<IConfigComponentInfo>>();
        componentsMap.put(SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getBaseApiVersion(), componentsToExport);
        DataPackage.addManifestToZipFile(zipOut, dataToExport, componentsMap);
    }

    public static void createManifest(OutputStream out, Collection<String> processors, Collection<String> boards, Collection<String> kits, Map<String, Collection<String>> components) throws IOException {
        Properties p = new Properties();
        p.setProperty(PROPERTY_DATA_VERSION, KExProcessorsProvider.getRestApiDataVersion());
        p.setProperty(PROPERTY_PROCESSORS, processors.stream().sorted().distinct().collect(Collectors.joining(",")));
        p.setProperty(PROPERTY_BOARDS, boards.stream().sorted().distinct().collect(Collectors.joining(",")));
        p.setProperty(PROPERTY_KITS, kits.stream().sorted().distinct().collect(Collectors.joining(",")));
        for (Map.Entry<String, Collection<String>> entry : components.entrySet()) {
            p.setProperty("components_" + entry.getKey(), entry.getValue().stream().sorted().distinct().collect(Collectors.joining(",")));
        }
        p.store(out, null);
    }

    @Deprecated
    public static void createManifest(OutputStream out, Collection<String> processors, Collection<String> boards, Collection<String> kits, Collection<String> components) throws IOException {
        HashMap<String, Collection<String>> componentsMap = new HashMap<String, Collection<String>>();
        componentsMap.put(KExProcessorsProvider.getRestApiDataVersion(), components);
        DataPackage.createManifest(out, processors, boards, kits, componentsMap);
    }

    public static @Nullable File findSystemFile(String relPath) {
        File sysDir;
        File file;
        Location location = Platform.getInstallLocation();
        if (location != null) {
            String loc = location.getURL().getPath();
            file = new File(String.valueOf(loc) + File.separator + relPath);
            if (file.exists()) {
                return file;
            }
            Path path = new Path(loc);
            file = new File(String.valueOf((path = path.removeLastSegments(1)).toString()) + File.separator + relPath);
            if (file.exists()) {
                return file;
            }
        }
        if ((file = new File(sysDir = new File(PEConfiguration.getSystemDirectory()), relPath)).exists()) {
            return file;
        }
        File sysDirUp = sysDir.getParentFile();
        if (sysDirUp != null && (file = new File(sysDirUp, relPath)).exists()) {
            return file;
        }
        return null;
    }

    public static void addLicenseSCR(ZipOutputStream zipOut) throws IOException {
        String[] stringArray = LICENSE_DATA_FILES;
        int n = LICENSE_DATA_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            String[] pair = file.split(":");
            if (pair.length == 2) {
                File f = DataPackage.findSystemFile(pair[0]);
                if (f != null && f.isFile()) {
                    ZipEntry entry = new ZipEntry(ZipUtils.fixZipPathEntry((String)pair[1]));
                    zipOut.putNextEntry(entry);
                    Files.copy(f.toPath(), zipOut);
                    zipOut.closeEntry();
                } else {
                    LOGGER.log(Level.SEVERE, "License file {0} not found", pair[0]);
                }
            } else {
                LOGGER.log(Level.SEVERE, "Wrong format of src:tgt of license file {0}", file);
                assert (false);
            }
            ++n2;
        }
    }

    public static @Nullable Properties getManifestAsproperties(File file, boolean archive) throws IOException {
        block55: {
            if (archive) {
                ZipEntry entry;
                Object var5_11;
                try {
                    Throwable throwable = null;
                    var5_11 = null;
                    try (ZipInputStream zip = new ZipInputStream(new FileInputStream(file));){
                        for (int cntr = 0; (entry = zip.getNextEntry()) != null && cntr < 5; ++cntr) {
                            if (!PACKAGE_MANIFEST.equals(entry.getName())) continue;
                            Properties properties = new Properties();
                            properties.load(zip);
                            return properties;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage());
                }
                try {
                    Throwable e = null;
                    var5_11 = null;
                    try (ZipFile zipFile = new ZipFile(file);){
                        Optional<ZipEntry> first = zipFile.stream().filter(p -> p.getName().matches(".*npidata.mf")).findFirst();
                        ZipEntry zipEntry = entry = first.isPresent() ? first.get() : null;
                        if (entry == null) break block55;
                        Properties properties = new Properties();
                        Throwable throwable = null;
                        Object var10_30 = null;
                        try (InputStream inputStream = zipFile.getInputStream(entry);){
                            if (inputStream != null) {
                                properties.load(inputStream);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        return properties;
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage());
                }
            } else {
                Throwable throwable = null;
                Object var3_18 = null;
                try (Stream<java.nio.file.Path> walk = Files.walk(Paths.get(file.toURI()), 1, new FileVisitOption[0]);){
                    Optional<java.nio.file.Path> first = walk.filter(f -> PACKAGE_MANIFEST.equals(Objects.requireNonNull(f.getFileName()).toString())).findAny();
                    if (!first.isPresent()) break block55;
                    Properties properties = new Properties();
                    Throwable throwable4 = null;
                    Object var8_25 = null;
                    try (FileInputStream inputStream = new FileInputStream(first.get().toFile());){
                        properties.load(inputStream);
                    }
                    catch (Throwable throwable5) {
                        if (throwable4 == null) {
                            throwable4 = throwable5;
                        } else if (throwable4 != throwable5) {
                            throwable4.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    }
                    return properties;
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean createDataPackage(ISupportedDerivativesForSwTools derivatives, OutputStream ous, Collection<ISWToolsDataFolderInfo> dataToExport, Map<String, Collection<IConfigComponentInfo>> components, IProgressMonitor monitor) throws IOException {
        var5_5 = null;
        var6_7 = null;
        try {
            zipFile = new ZipOutputStream(ous);
            try {
                DataPackage.addManifestToZipFile(zipFile, dataToExport, components);
                DataPackage.addLicenseSCR(zipFile);
                dataDirs = DataPackage.getFilesAndDirsToExport(dataToExport, null);
                var10_11 = null;
                var11_13 = null;
                try {
                    componentDirStream = DataPackage.getDirsForComponents((Collection<IConfigComponentInfo>)components.entrySet().stream().flatMap((Function<Map.Entry, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$10(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/util/stream/Stream;)()).collect(Collectors.toList()), new File(derivatives.getDataDir()));
                    try {
                        mergedDirs = Stream.concat(dataDirs.stream(), componentDirStream).collect(Collectors.toList());
                    }
                    finally {
                        if (componentDirStream != null) {
                            componentDirStream.close();
                        }
                    }
                }
                catch (Throwable var11_14) {
                    if (var10_11 == null) {
                        var10_11 = var11_14;
                        throw var10_11;
                    }
                    if (var10_11 == var11_14) throw var10_11;
                    var10_11.addSuppressed(var11_14);
                    throw var10_11;
                }
                subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)mergedDirs.size());
                var12_15 = mergedDirs.iterator();
                while (true) {
                    path = (String)var12_15.next();
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    ZipUtils.addFileToZipFile((ZipOutputStream)zipFile, (File)new File(derivatives.getDataDir()), (String)path);
                    subMon.worked(1);
                    break;
                }
            }
            finally {
                if (var12_15.hasNext()) ** continue;
                return true;
            }
        }
        catch (Throwable var6_8) {
            if (var5_5 == null) {
                var5_5 = var6_8;
                throw var5_5;
            }
            if (var5_5 == var6_8) throw var5_5;
            var5_5.addSuppressed(var6_8);
            throw var5_5;
        }
    }

    public static boolean createDataPackage(ISupportedDerivativesForSwTools derivatives, OutputStream ous, Collection<ISWToolsDataFolderInfo> dataToExport, Collection<IConfigComponentInfo> components, IProgressMonitor monitor) throws IOException {
        HashMap<String, Collection<IConfigComponentInfo>> componentsMap = new HashMap<String, Collection<IConfigComponentInfo>>();
        componentsMap.put(derivatives.getBaseApiVersion(), components);
        return DataPackage.createDataPackage(derivatives, ous, dataToExport, componentsMap, monitor);
    }

    public static void copyData(Collection<ISWToolsDataFolderInfo> dataToImport, Collection<IConfigComponentInfo> componentsToImport, File sourceBaseDir, File targetBaseDir, IProgressMonitor monitor) throws IOException {
        Collection<String> dataDirs = DataPackage.getFilesAndDirsToExport(dataToImport, sourceBaseDir);
        Stream<String> componentDirStream = DataPackage.getDirsForComponents(componentsToImport, sourceBaseDir);
        List mergedDirs = Stream.concat(dataDirs.stream(), componentDirStream).collect(Collectors.toList());
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)mergedDirs.size());
        for (String path : mergedDirs) {
            subMon.subTask(path);
            UtilsFile.copy((File)new File(sourceBaseDir, path), (File)new File(targetBaseDir, path), (boolean)true);
            subMon.worked(1);
        }
    }

    public static Collection<IConfigComponentInfo> getComponentsToUpgrade(Collection<IConfigComponentInfo> components, ISupportedDerivativesForSwTools derivatives, String apiVersion) {
        return components.stream().filter(it -> {
            IConfigComponentInfo localComponent = derivatives.getComponentById(it.getName(), it.getSdkVersion(), apiVersion);
            return localComponent == null || KExProcessorsProvider.isVersionHigher(it.getVersion(), localComponent.getVersion());
        }).collect(Collectors.toList());
    }

    public static Collection<IConfigComponentInfo> getComponentsToUpgrade(Map<String, Collection<IConfigComponentInfo>> components, ISupportedDerivativesForSwTools derivatives) {
        ArrayList<IConfigComponentInfo> result = new ArrayList<IConfigComponentInfo>();
        for (Map.Entry<String, Collection<IConfigComponentInfo>> entry : components.entrySet()) {
            entry.getValue().stream().filter(it -> {
                IConfigComponentInfo localComponent = derivatives.getComponentById(it.getName(), it.getSdkVersion(), (String)entry.getKey());
                return localComponent == null || KExProcessorsProvider.isVersionHigher(it.getVersion(), localComponent.getVersion());
            }).forEach(result::add);
        }
        return result;
    }

    public static Map<String, Collection<IConfigComponentInfo>> getComponentsForData(ISupportedDerivativesForSwTools derivatives, Collection<ISWToolsDataFolderInfo> data) {
        HashMap<String, Collection<IConfigComponentInfo>> result = new HashMap<String, Collection<IConfigComponentInfo>>();
        Set dataSdkVersions = data.stream().map(ISWToolsDataFolderInfo::getSWToolsDataFolderID).collect(Collectors.toSet());
        Set<@Nullable T> dataApiVersions = data.stream().filter(IProcessorMasterToolInfo.class::isInstance).map(IProcessorMasterToolInfo.class::cast).map(IProcessorMasterToolInfo::getFrozenApiVersion).filter(Objects::nonNull).collect(Collectors.toSet());
        dataApiVersions.add(derivatives.getBaseApiVersion());
        for (String api : derivatives.getAllComponentsApiVersions()) {
            if (!dataApiVersions.contains(api)) continue;
            Collection components = derivatives.getAllComponentsInfos(api).stream().filter(it -> dataSdkVersions.contains(it.getSdkVersion())).collect(Collectors.toList());
            result.put(api, components);
        }
        return result;
    }

    private static /* synthetic */ Stream lambda$10(Map.Entry e) {
        return ((Collection)e.getValue()).stream();
    }
}

