/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.importer;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.Messages;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.importer.YamlNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public interface IToolImporter {
    public @NonNull String getToolId();

    public @Nullable ISharedConfiguration parse(@NonNull InputStream var1, @NonNull StringBuffer var2, @NonNull ParseMode var3, @Nullable IMcuIdentification var4, @Nullable String var5) throws IOException, YamlNotFoundException;

    default public @NonNull StorageTool mergeStorageTools(@NonNull StorageTool storageTool1, @NonNull StorageTool storageTool2) {
        return this.mergeStorageTools(storageTool1, storageTool2, false);
    }

    public @NonNull StorageTool mergeStorageTools(@NonNull StorageTool var1, @NonNull StorageTool var2, boolean var3);

    public @NonNull List<@NonNull Pattern> getImportibleFilesRegexes();

    public boolean importConfigurationFromBitFieldState(@NonNull Collection<?> var1, @Nullable Map<@NonNull String, @NonNull String> var2);

    public boolean importConfigurationFromBitFieldState(@NonNull Collection<?> var1, @NonNull String var2, Map<@NonNull String, @NonNull String> var3);

    default public @NonNull List<@NonNull MergeOption> getSupportedMergeOptions() {
        return Arrays.asList(MergeOption.IMPORT_REPLACE, MergeOption.IMPORT_RENAME);
    }

    public static <T extends StorageToolBaseConfiguration> @NonNull List<@NonNull T> mergeFuncGroups(List<@NonNull T> funcGroups1, List<@NonNull T> funcGroups2) {
        ArrayList<@NonNull Object> newList = new ArrayList<Object>();
        newList.addAll(funcGroups1);
        for (StorageToolBaseConfiguration func : funcGroups2) {
            boolean duplicate = false;
            int i = 0;
            while (i < newList.size()) {
                if (((StorageToolBaseConfiguration)newList.get(i)).getName().equals(func.getName())) {
                    duplicate = true;
                    newList.set(i, func);
                    break;
                }
                ++i;
            }
            if (duplicate) continue;
            newList.add(func);
        }
        return newList;
    }

    public static enum MergeOption {
        IMPORT_REPLACE(() -> Messages.get().IToolImporter_MergeOptionOverwrite),
        IMPORT_RENAME(() -> Messages.get().IToolImporter_MergeOptionRename),
        IGNORE(() -> "ignore");

        @NonNull
        private final Supplier<String> name;

        private MergeOption(Supplier<String> name) {
            this.name = name;
        }

        public String getName() {
            return this.name.get();
        }
    }

    public static enum ParseMode {
        IMPORT_PROJECT,
        IMPORT_TO_CURRENT;

    }
}

