/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.provider.configuration.storage.tee.AStorageTeeGenericRdc;
import com.nxp.swtools.provider.configuration.storage.tee.AStorageTeeGenericRdcCheckerConfig;
import com.nxp.swtools.provider.configuration.storage.tee.AStorageTeeGenericRdcMasterConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeePdapConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeRdcMasterConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeRdcMasterDomainAssignment;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeRdcMrcConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="rdc", strict=false)
public class StorageTeeRdc
extends AStorageTeeGenericRdc<StorageTeeRdcMasterConfig, StorageTeeRdcMasterDomainAssignment> {
    @ElementList(name="masters", entry="master", type=StorageTeeRdcMasterConfig.class, inline=false, required=true)
    private ArrayList<StorageTeeRdcMasterConfig> masters = new ArrayList();
    @ElementList(name="pdaps", entry="pdap", type=StorageTeePdapConfig.class, inline=false, required=false)
    private ArrayList<StorageTeePdapConfig> pdaps = new ArrayList();
    @ElementList(name="mrcs", entry="mrc", type=StorageTeeRdcMrcConfig.class, inline=false, required=false)
    private ArrayList<StorageTeeRdcMrcConfig> mrcs = new ArrayList();

    @Override
    public List<StorageTeeRdcMasterConfig> getMasterConfigs() {
        return this.masters;
    }

    @Override
    public void setMasterConfigs(List<StorageTeeRdcMasterConfig> masters) {
        this.masters = new ArrayList<StorageTeeRdcMasterConfig>(masters);
    }

    public List<StorageTeePdapConfig> getPdapConfigs() {
        return this.pdaps;
    }

    public void setPdapConfigs(List<StorageTeePdapConfig> pacs) {
        this.pdaps = new ArrayList<StorageTeePdapConfig>(pacs);
    }

    public List<StorageTeeRdcMrcConfig> getMrcConfigs() {
        return this.mrcs;
    }

    public void setMrcConfigs(List<StorageTeeRdcMrcConfig> mrcs) {
        this.mrcs = new ArrayList<StorageTeeRdcMrcConfig>(mrcs);
    }

    public @Nullable StorageTeePdapConfig findPdapConfig(String checkerId) {
        return (StorageTeePdapConfig)CollectionsUtils.findAny(this.pdaps, pdap -> pdap.getCheckerId().equals(checkerId));
    }

    public @Nullable StorageTeeRdcMrcConfig findMrcConfig(String checkerId) {
        return (StorageTeeRdcMrcConfig)CollectionsUtils.findAny(this.mrcs, mrc -> mrc.getCheckerId().equals(checkerId));
    }

    @Override
    public void fillYamlStorable(IYamlStorable yaml) {
        YamlStorableList yamlStorable = new YamlStorableList("rdc", Boolean.FALSE);
        super.fillYamlStorable((IYamlStorable)yamlStorable);
        yaml.addYamlChild((IYamlStorable)yamlStorable);
        YamlStorableList mastersYaml = new YamlStorableList("masters", Boolean.FALSE);
        this.masters.forEach(each -> each.fillYamlStorable((IYamlStorable)mastersYaml));
        yamlStorable.addYamlChild((IYamlStorable)mastersYaml);
        YamlStorableList pdapsYaml = new YamlStorableList("pdaps", Boolean.FALSE);
        this.pdaps.forEach(each -> each.fillYamlStorable((IYamlStorable)pdapsYaml));
        yamlStorable.addYamlChild((IYamlStorable)pdapsYaml);
        YamlStorableList mrcsYaml = new YamlStorableList("mrcs", Boolean.FALSE);
        this.mrcs.forEach(each -> each.fillYamlStorable((IYamlStorable)mrcsYaml));
        yamlStorable.addYamlChild((IYamlStorable)mrcsYaml);
    }

    @Override
    public boolean updateFromYamlStorable(IYamlStorable yaml) {
        if (!yaml.getYamlId().equals("rdc") || !super.updateFromYamlStorable(yaml)) {
            return false;
        }
        ArrayList<Object> mastersLoc = new ArrayList<StorageTeeRdcMasterConfig>();
        ArrayList<Object> pdapsLoc = new ArrayList<StorageTeePdapConfig>();
        ArrayList<Object> mrcsLoc = new ArrayList<StorageTeeRdcMrcConfig>();
        Collection children = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)yaml);
        for (IYamlStorable childYaml : children) {
            Object config;
            Iterator iterator;
            String yamlId = childYaml.getYamlId();
            if (!(childYaml instanceof YamlStorableList)) continue;
            if (yamlId.equals("masters")) {
                ArrayList<Object> mastersFromYaml = new ArrayList<Object>();
                Collection mastersYamls = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)childYaml, (String)"masters");
                iterator = mastersYamls.iterator();
                while (iterator.hasNext()) {
                    config = new StorageTeeRdcMasterConfig();
                    IYamlStorable masterYaml = (IYamlStorable)iterator.next();
                    if (!((AStorageTeeGenericRdcMasterConfig)config).updateFromYamlStorable(masterYaml)) continue;
                    mastersFromYaml.add(config);
                }
                mastersLoc = mastersFromYaml;
                continue;
            }
            if (yamlId.equals("pdaps")) {
                ArrayList<Object> pdapsFromYaml = new ArrayList<Object>();
                Collection pdapsYamls = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)childYaml, (String)"pdaps");
                iterator = pdapsYamls.iterator();
                while (iterator.hasNext()) {
                    config = new StorageTeePdapConfig();
                    IYamlStorable pdapYaml = (IYamlStorable)iterator.next();
                    if (!((AStorageTeeGenericRdcCheckerConfig)config).updateFromYamlStorable(pdapYaml)) continue;
                    pdapsFromYaml.add(config);
                }
                pdapsLoc = pdapsFromYaml;
                continue;
            }
            if (!yamlId.equals("mrcs")) continue;
            ArrayList<Object> mrcsFromYaml = new ArrayList<Object>();
            Collection mrcsYamls = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)childYaml, (String)"mrcs");
            iterator = mrcsYamls.iterator();
            while (iterator.hasNext()) {
                config = new StorageTeeRdcMrcConfig();
                IYamlStorable mrcYaml = (IYamlStorable)iterator.next();
                if (!((AStorageTeeGenericRdcCheckerConfig)config).updateFromYamlStorable(mrcYaml)) continue;
                mrcsFromYaml.add(config);
            }
            mrcsLoc = mrcsFromYaml;
        }
        this.setMasterConfigs((List<StorageTeeRdcMasterConfig>)mastersLoc);
        this.setPdapConfigs(pdapsLoc);
        this.setMrcConfigs(mrcsLoc);
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.masters, this.mrcs, this.pdaps);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeRdc other = (StorageTeeRdc)obj;
        return Objects.equals(this.masters, other.masters) && Objects.equals(this.mrcs, other.mrcs) && Objects.equals(this.pdaps, other.pdaps);
    }

    public String toString() {
        return String.format("StorageTeeRdc [masters=%s, pdaps=%s, mrcs=%s]", this.masters.subList(0, Math.min(this.masters.size(), 3)), this.pdaps.subList(0, Math.min(this.pdaps.size(), 3)), this.mrcs.subList(0, Math.min(this.mrcs.size(), 3)));
    }
}

