/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeePinInterruptSecurity;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeePinMask;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeePinSecurity;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeePort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.ElementList;

public class StorageTeeIoPort
extends StorageTeePort {
    @ElementList(entry="pin_security", inline=true, required=false)
    @Nullable
    private @ElementList(entry="pin_security", inline=true, required=false) @Nullable List<StorageTeePinSecurity> pinSecurity;
    @ElementList(entry="pin_interrupt_security", inline=true, required=false)
    @Nullable
    private @ElementList(entry="pin_interrupt_security", inline=true, required=false) @Nullable List<StorageTeePinInterruptSecurity> pinInterruptSecurity;

    public StorageTeeIoPort() {
    }

    public StorageTeeIoPort(StorageTeePort port) {
        this.setId(port.getId());
        this.setPinMasks(new ArrayList<StorageTeePinMask>(port.getPinMasks()));
    }

    public @Nullable List<StorageTeePinSecurity> getPinSecurity() {
        return this.pinSecurity;
    }

    public void setPinSecurity(@Nullable List<StorageTeePinSecurity> pinSecurity) {
        this.pinSecurity = pinSecurity;
    }

    public @Nullable List<StorageTeePinInterruptSecurity> getPinInterruptSecurity() {
        return this.pinInterruptSecurity;
    }

    public void setPinInterruptSecurity(@Nullable List<StorageTeePinInterruptSecurity> pinInterruptSecurity) {
        this.pinInterruptSecurity = pinInterruptSecurity;
    }

    @Override
    public YamlStorableList<IYamlStorable> getYamlStorable() {
        List<StorageTeePinInterruptSecurity> pinInterruptSecurityLoc;
        List<StorageTeePinSecurity> pinSecurityLoc;
        YamlStorableList yaml = new YamlStorableList(this.getId(), Boolean.TRUE);
        if (!this.getPinMasks().isEmpty()) {
            this.getPinMasks().forEach(each -> each.fillYamlStorable((IYamlStorable)yaml));
        }
        if ((pinSecurityLoc = this.pinSecurity) != null && !pinSecurityLoc.isEmpty()) {
            pinSecurityLoc.forEach(each -> each.fillYamlStorable((IYamlStorable)yaml));
        }
        if ((pinInterruptSecurityLoc = this.pinInterruptSecurity) != null && !pinInterruptSecurityLoc.isEmpty()) {
            pinInterruptSecurityLoc.forEach(each -> each.fillYamlStorable((IYamlStorable)yaml));
        }
        return yaml;
    }

    @Override
    public boolean updateFromYamlStorable(IYamlStorable yaml) {
        IYamlStorable portLongForm = YamlStorableHelper.convertToLongForm((IYamlStorable)yaml, (String)"masked", (String)"pin");
        if (!super.updateFromYamlStorable(portLongForm)) {
            return false;
        }
        ArrayList<StorageTeePinSecurity> pinSecurityLoc = new ArrayList<StorageTeePinSecurity>();
        ArrayList<StorageTeePinInterruptSecurity> pinInterruptSecurityLoc = new ArrayList<StorageTeePinInterruptSecurity>();
        Collection children = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)yaml);
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            StorageTeePinInterruptSecurity intSecurity;
            StorageTeePinSecurity security = new StorageTeePinSecurity();
            IYamlStorable childYaml = (IYamlStorable)iterator.next();
            if (security.updateFromYamlStorable(childYaml)) {
                pinSecurityLoc.add(security);
            }
            if (!(intSecurity = new StorageTeePinInterruptSecurity()).updateFromYamlStorable(childYaml)) continue;
            pinInterruptSecurityLoc.add(intSecurity);
        }
        this.setPinSecurity(pinSecurityLoc);
        this.setPinInterruptSecurity(pinInterruptSecurityLoc);
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeIoPort other = (StorageTeeIoPort)obj;
        return Objects.equals(this.pinSecurity, other.pinSecurity) && Objects.equals(this.pinInterruptSecurity, other.pinInterruptSecurity);
    }
}

