/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import java.util.HashMap;
import java.util.Map;

public enum AccessType {
    ALLOW("1"),
    BLOCK("0");

    private static final Map<String, AccessType> abbreviationMap;
    private final String abbreviation;

    static {
        abbreviationMap = new HashMap<String, AccessType>(AccessType.values().length);
        AccessType[] accessTypeArray = AccessType.values();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessType accessType = accessTypeArray[n2];
            abbreviationMap.put(accessType.getAbbreviation(), accessType);
            ++n2;
        }
    }

    private AccessType(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public static @Nullable AccessType findBy(String abbreviation) {
        return abbreviationMap.get(abbreviation);
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String toString() {
        return this.getAbbreviation();
    }

    public static AccessType lessRestrictive(AccessType accessType1, AccessType accessType2) {
        return accessType1 == ALLOW ? ALLOW : accessType2;
    }

    public static @Nullable AccessType lessRestrictiveNullable(@Nullable AccessType accessType1, @Nullable AccessType accessType2) {
        if (accessType1 == ALLOW || accessType2 == ALLOW) {
            return ALLOW;
        }
        if (accessType1 == BLOCK || accessType2 == BLOCK) {
            return BLOCK;
        }
        return null;
    }

    public static @Nullable AccessType moreRestrictiveNullable(@Nullable AccessType accessType1, @Nullable AccessType accessType2) {
        if (accessType1 == BLOCK || accessType2 == BLOCK) {
            return BLOCK;
        }
        if (accessType1 == ALLOW || accessType2 == ALLOW) {
            return ALLOW;
        }
        return null;
    }

    public static AccessType moreRestrictive(AccessType accessType1, AccessType accessType2) {
        return accessType1 == BLOCK ? BLOCK : accessType2;
    }
}

