/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.pins;

import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@NonNullByDefault
@Root(strict=false, name="connected_board")
public class StorageConnectedBoard
implements Comparable<StorageConnectedBoard> {
    public static final char HEADERS_DELIMITER = '/';
    @Attribute(name="board", required=true)
    protected String boardId;
    @Attribute(name="header", required=true)
    protected String headerName;
    @Attribute(name="function", required=false)
    @Nullable
    protected @Attribute(name="function", required=false) @Nullable String functionName = null;
    @Attribute(name="identifier_mode", required=false)
    @Nullable
    protected @Attribute(name="identifier_mode", required=false) @Nullable String identifierModeId = null;

    StorageConnectedBoard() {
        this("", "", null, null);
    }

    public StorageConnectedBoard(String boardId, String headerName) {
        this.boardId = boardId;
        this.headerName = headerName;
    }

    public StorageConnectedBoard(String boardId, String headerName, @Nullable String functionName, @Nullable String identifierModeId) {
        this.boardId = boardId;
        this.headerName = headerName;
        this.functionName = functionName;
        this.identifierModeId = identifierModeId;
    }

    public String getBoardId() {
        return this.boardId;
    }

    public void setBoardId(String boardId) {
        this.boardId = boardId;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getFunctionName() {
        return UtilsText.safeString((String)this.functionName);
    }

    public String getIdentiferModeId() {
        return UtilsText.safeString((String)this.identifierModeId);
    }

    public void setIdentiferModeId(String identifierModeId) {
        this.identifierModeId = identifierModeId;
    }

    public void setFunctionName(@Nullable String functionName) {
        this.functionName = UtilsText.isEmpty((String)functionName) ? null : functionName;
    }

    public String toString() {
        String functionText = this.functionName != null ? ", function=" + this.functionName : "";
        String identifierModeText = this.identifierModeId != null ? ", identifierModeId=" + this.identifierModeId : "";
        return "StorageConnectedBoard [board=" + this.boardId + ", header=" + this.headerName + functionText + identifierModeText + "]";
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageConnectedBoard other = (StorageConnectedBoard)obj;
        if (this.boardId != other.boardId) {
            return false;
        }
        if (!this.headerName.equals(other.headerName)) {
            return false;
        }
        return Objects.equals(this.functionName, other.functionName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.boardId.hashCode();
        result = 31 * result + this.headerName.hashCode();
        result = 31 * result + Objects.hashCode(this.functionName);
        return result;
    }

    @Override
    public int compareTo(StorageConnectedBoard other) {
        long otherHeadersDepth;
        long thisHeadersDepth = this.headerName.chars().filter(ch -> ch == 47).count();
        if (thisHeadersDepth == (otherHeadersDepth = other.getHeaderName().chars().filter(ch -> ch == 47).count())) {
            return this.headerName.compareTo(other.getHeaderName());
        }
        return thisHeadersDepth < otherHeadersDepth ? -1 : 1;
    }
}

