/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.dependencies.DependencyFactory;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyFeature;
import com.nxp.swtools.provider.configuration.dependencies.IFeatureData;
import com.nxp.swtools.provider.configuration.storage.StorageDependencyFeatureData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(strict=false)
public class StorageDependencyFeature
implements IDependencyFeature {
    @NonNull
    public static final String FEATURE_EXISTS = "exists";
    @NonNull
    public static final String FEATURE_ROUTED = "routed";
    @NonNull
    public static final String FEATURE_ROUTED_TO_PIN_NR = "routedToPinNr";
    @NonNull
    public static final String FEATURE_ROUTED_TO_SIGNAL = "routedToSignal";
    @NonNull
    public static final String FEATURE_ROUTED_TO_PINS = "routedToPins";
    @NonNull
    public static final String FEATURE_CONFIGURED = "configured";
    @NonNull
    public static final String FEATURE_HAS_SIGNAL = "hasSignal";
    @NonNull
    public static final String FEATURE_ENABLED = "enabled";
    @NonNull
    public static final String FEATURE_FUNCTIONAL_GROUPS_NAMES = "funcGroupNames";
    @NonNull
    public static final String FEATURE_FUNCTIONAL_GROUP_PROPERTY = "funcGroupProperty";
    @NonNull
    public static final String FEATURE_INIT_FUNCTIONAL_GROUPS_NAMES = "initGroupNames";
    @NonNull
    public static final String FEATURE_INITIALIZED = "initialized";
    @NonNull
    public static final String FEATURE_FREQUENCY = "frequency";
    @NonNull
    public static final String FEATURE_VALUE = "value";
    @NonNull
    public static final String FEATURE_ELECTRICAL_PROPERTY = "electricalProperty";
    @NonNull
    public static final String FEATURE_ELECTRICAL_PROPERTY_EXISTS = "electricalPropertyExists";
    @NonNull
    public static final String FEATURE_CONFIGURED_VALUE = "configuredValue";
    @NonNull
    public static final String FEATURE_CONFIGURED_UI_VALUE = "configuredUIValue";
    @NonNull
    public static final String FEATURE_ASSIGNED_BITFIELD_VALUE = "assignedBitfieldValue";
    @NonNull
    public static final String FEATURE_ROUTABLE_TO_PINS = "routableToPins";
    @NonNull
    public static final String FEATURE_ROUTABLE_SIGNALS = "routableSignals";
    @NonNull
    public static final String FEATURE_ROUTED_UNIFIED_SIGNALS = "routedUnifiedSignals";
    @NonNull
    public static final String FEATURE_DIRECTION = "direction";
    @NonNull
    public static final String FEATURE_FEATURES = "features";
    @NonNull
    public static final String FEATURE_VERSION = "version";
    @NonNull
    public static final String FEATURE_REVISION = "revision";
    @NonNull
    public static final String FEATURE_NAME = "name";
    @NonNull
    public static final String FEATURE_PACKAGE = "package";
    @NonNull
    public static final String FEATURE_SERIES = "series";
    @NonNull
    public static final String FEATURE_FAMILY = "family";
    @NonNull
    public static final String FEATURE_ID = "id";
    @NonNull
    public static final String FEATURE_COUNT = "count";
    @NonNull
    public static final String FEATURE_MASTER = "master";
    @NonNull
    public static final String FEATURE_SELECTED_CORE = "SelectedCore";
    @Attribute
    @NonNull
    private String name = "";
    @Attribute(required=false, empty="")
    @NonNull
    private @Attribute(required=false, empty="") @NonNull String evaluation = "";
    @Attribute(required=false)
    @Nullable
    private @Attribute(required=false) @Nullable String configuration;
    @ElementList(inline=true, entry="data", type=StorageDependencyFeatureData.class)
    @NonNull
    private @ElementList(inline=true, entry="data", type=StorageDependencyFeatureData.class) @NonNull List<@NonNull IFeatureData> data = new ArrayList<IFeatureData>();
    @NonNull
    public static final String FEATURE_NAME_ROUTED = "routed";

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        this.name = name;
    }

    @Override
    public @NonNull String getEvaluation() {
        return this.evaluation;
    }

    public void setEvaluation(@NonNull String evaluation) {
        this.evaluation = evaluation;
    }

    @Override
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(@Nullable String configuration) {
        this.configuration = configuration;
    }

    public void setData(@NonNull List<@NonNull IFeatureData> data) {
        this.data = data;
    }

    @Override
    public @NonNull List<@NonNull IFeatureData> getData() {
        return this.data;
    }

    @Override
    public void addData(@NonNull String value, @Nullable String type, @Nullable String unit, @Nullable String minValue, @Nullable String maxValue) {
        this.data.add(DependencyFactory.createFeatureData(value, type, unit, minValue, maxValue));
    }

    public String toString() {
        return "StorageDependencyFeature [name=" + this.name + ", evaluation=" + this.evaluation + ", configuration=" + this.configuration + ", data(first " + 5 + ")=" + CollectionsUtils.firstN(this.data, (int)5) + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.evaluation.hashCode();
        result = 31 * result + Objects.hashCode(this.configuration);
        result = 31 * result + this.data.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageDependencyFeature other = (StorageDependencyFeature)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.evaluation.equals(other.evaluation)) {
            return false;
        }
        if (!Objects.equals(this.configuration, other.configuration)) {
            return false;
        }
        return this.data.equals(other.data);
    }
}

