/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.legacy;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.legacy.CompatibilityEntryPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="entry", strict=true)
public class CompatibilityEntry {
    @Attribute(name="source_name")
    private String sourceName = "";
    @Attribute(name="source_sdk")
    private String sourceSdk = "";
    @Attribute(name="source_package", required=false)
    @Nullable
    private @Attribute(name="source_package", required=false) @Nullable String sourcePackage;
    @Attribute(name="target_name")
    private String targetName = "";
    @Attribute(name="target_sdk")
    private String targetSdk = "";
    @ElementList(inline=true, empty=true, required=false)
    private ArrayList<CompatibilityEntryPackage> packages = new ArrayList();

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceSdk() {
        return this.sourceSdk;
    }

    public @Nullable String getSourcePackage() {
        return this.sourcePackage;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getTargetSdk() {
        return this.targetSdk;
    }

    public Collection<CompatibilityEntryPackage> getPackages() {
        return CollectionsUtils.unmodifiableCollection(this.packages);
    }

    public String toString() {
        return "CompatibilityEntry [sourceName=" + this.sourceName + ", sourceSdk=" + this.sourceSdk + ", sourcePackage=" + this.sourcePackage + ", targetName=" + this.targetName + ", targetSdk=" + this.targetSdk + "]";
    }

    public int hashCode() {
        return Objects.hash(this.sourceName, this.sourceSdk, this.sourcePackage, this.targetName, this.targetSdk, this.packages);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompatibilityEntry other = (CompatibilityEntry)obj;
        return Objects.equals(this.sourceName, other.sourceName) && Objects.equals(this.sourceSdk, other.sourceSdk) && Objects.equals(this.targetName, other.targetName) && Objects.equals(this.sourcePackage, other.sourcePackage) && Objects.equals(this.packages, other.packages) && Objects.equals(this.targetSdk, other.targetSdk);
    }
}

