/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider;

import com.nxp.swtools.common.ui.utils.services.PlatformServices;
import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.lang.HardReference;
import com.nxp.swtools.common.utils.logging.DoubleLoggingFilter;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.ExecutableExtensionProvider;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.AProcessorFilterForSwTools;
import com.nxp.swtools.expert.processordb.ExternalMcuDataHelper;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.PartInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.analytics.IAnalyticDataProvider;
import com.nxp.swtools.kex.analytics.IAnalytics;
import com.nxp.swtools.kex.analytics.NoAnalytics;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.IMcuSelection;
import com.nxp.swtools.kex.selector.McuSelectionFactory;
import com.nxp.swtools.provider.IWebUserContext;
import com.nxp.swtools.provider.analytics.AnalyticsReference;
import com.nxp.swtools.provider.analytics.CommandListenerAnalytics;
import com.nxp.swtools.provider.analytics.MouseListenerAnalytics;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.helper.CommonConfigImpl;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.toolui.ToolsUiInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.osgi.framework.Bundle;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

public class SWToolsPlatform {
    private static final Logger LOGGER = LogManager.getLogger(SWToolsPlatform.class);
    public static final String DEFAULT_DATA_VERSION = "ksdk2_0";
    public static final String NXP_MCUXPRESSO_SDK_PROJECT_NATURE = "com.nxp.mcuxpresso.core.datamodels.sdkNature";
    private static boolean toolInitialized = false;
    static Consumer<SwToolsProduct> setSelectedToolProxy;

    static {
        LOGGER.setFilter((Filter)new DoubleLoggingFilter());
        if (SWToolsPlatform.isRunningInMCUXpressoIde()) {
            assert (SWToolsPlatform.isRunningInEclipseIde());
            assert (!SWToolsPlatform.isRunningAsRcp()) : "eclipse and rcp plugins cannot be in the launch configuration at the same time";
        }
        if (SWToolsPlatform.isRunningAsRcp()) assert (!SWToolsPlatform.isRunningInEclipseIde()) : "eclipse and rcp plugins cannot be in the launch configuration at the same time";
        setSelectedToolProxy = tool -> {
            assert (false);
        };
    }

    public static ICommonConfig getMcuSelection() {
        ISharedConfiguration config = SharedConfigurationFactory.getSharedConfigurationSingleton();
        SWToolsPlatform.populateDefaultValues(config);
        ICommonConfig selection = config.getCommonConfig();
        return selection;
    }

    public static IAnalytics getAnalytics() {
        IAnalytics analytics = null;
        HardReference<IAnalytics> analyticsReference = SWToolsPlatform.getAnalyticsReference();
        if (analyticsReference != null && (analytics = (IAnalytics)analyticsReference.get()) == null) {
            analytics = new NoAnalytics();
            if (!SWToolsProperties.isHeadlessOn()) {
                LOGGER.warning("Analytics not available");
            }
        }
        if (analytics == null) {
            analytics = new NoAnalytics();
            LOGGER.warning("Analytics not available");
        }
        return analytics;
    }

    public static void setAnalytics(IAnalytics analytics) {
        try {
            AnalyticsReference analyticsReference = (AnalyticsReference)((Object)SWTFactoryProxy.INSTANCE.getSingletonInstance(AnalyticsReference.class));
            assert (analyticsReference != null);
            analyticsReference.set(analytics);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.log(Level.SEVERE, "cannot create singleton to analytics", e);
        }
    }

    public static void installHooksForAnalytics() {
        if (!SWToolsProperties.isHeadlessOn()) {
            HardReference<IAnalytics> analyticsRef = SWToolsPlatform.getAnalyticsReference();
            if (analyticsRef == null) {
                assert (false) : "analytics not initialized yet";
                return;
            }
            IAnalytics analytics = (IAnalytics)analyticsRef.get();
            if (analytics == null) {
                assert (false) : "analytics not initialized yet";
                return;
            }
            ICommandService commandService = PlatformServices.getCommandService();
            if (commandService != null) {
                commandService.addExecutionListener((IExecutionListener)new CommandListenerAnalytics(analytics));
            } else {
                LOGGER.log(Level.INFO, "ICommandService not available for analytics");
            }
            Display display = Display.getCurrent();
            if (display != null && !Rap.isActive()) {
                MouseListenerAnalytics mouseAnalytics = new MouseListenerAnalytics(analytics);
                analytics.addDataprovider((IAnalyticDataProvider)mouseAnalytics);
                display.addFilter(3, mouseAnalytics::mouseDown);
            }
        }
    }

    static @Nullable HardReference<IAnalytics> getAnalyticsReference() {
        try {
            AnalyticsReference analyticsReference = (AnalyticsReference)((Object)SWTFactoryProxy.INSTANCE.getSingletonInstance(AnalyticsReference.class));
            return analyticsReference;
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.log(Level.SEVERE, "cannot create singleton to analytics", e);
            return null;
        }
    }

    private static void populateDefaultValues(ISharedConfiguration config) {
        IMcuSelection onlineSelection;
        IMcuIdentification selection = config.getCommonConfig().getMcuIdentification();
        if (UtilsText.isEmpty((String)selection.getMcu()) && (onlineSelection = SWToolsPlatform.getOnlineMcuSelection()) != null) {
            config.setMcuIdentification(McuSelectionFactory.createMcuSelectionIdentification((IMcuSelection)onlineSelection));
            ((CommonConfigImpl)config.getCommonConfig()).setSessionIndex(onlineSelection.getSessionIndex());
        }
    }

    public static ISharedConfiguration getSharedConfigurationSingleton() {
        ISharedConfiguration config = SharedConfigurationFactory.getSharedConfigurationSingleton();
        SWToolsPlatform.getMcuSelection();
        return config;
    }

    public static @Nullable IMcuSelection getOnlineMcuSelection() {
        if (!Rap.isActive()) {
            return null;
        }
        @Nullable IWebUserContext webContext = (IWebUserContext)PlatformUI.getWorkbench().getService(IWebUserContext.class);
        if (webContext == null) {
            return null;
        }
        return webContext.getKexSelectedMCU();
    }

    public static String[] getAllToolchains() {
        assert (Rap.isActive());
        @Nullable IWebUserContext webContext = (IWebUserContext)PlatformUI.getWorkbench().getService(IWebUserContext.class);
        if (webContext == null) {
            return new String[0];
        }
        return webContext.getAllToolchains();
    }

    public static boolean areCoreListsEquivalent(Collection<ProcessorCore> cores1, Collection<ProcessorCore> cores2) {
        ProcessorCore[] sortedCores2;
        boolean equals;
        if (cores1.size() != cores2.size()) {
            return false;
        }
        ProcessorCore @NonNull [] sortedCores1 = (ProcessorCore[])cores1.stream().sorted((c1, c2) -> c1.getID().compareTo(c2.getID())).toArray(ProcessorCore[]::new);
        boolean bl = equals = sortedCores1.length == (sortedCores2 = (ProcessorCore[])cores2.stream().sorted((c1, c2) -> c1.getID().compareTo(c2.getID())).toArray(ProcessorCore[]::new)).length;
        if (equals) {
            int i = 0;
            while (i < sortedCores1.length) {
                if (!(equals &= sortedCores1[i].softEquals(sortedCores2[i]))) break;
                ++i;
            }
        }
        if (!equals) {
            LOGGER.warning("Updated core list in MEX because the IDs did not matched (probably project from old tools");
        }
        return equals;
    }

    public static @Nullable ProcessorCore findCoreOrGetMasterCore(Collection<ProcessorCore> cores, @Nullable ProcessorCore findCore) {
        if (cores.isEmpty()) {
            return null;
        }
        ProcessorCore result = SWToolsPlatform.findCoreByIdOrName(cores, findCore);
        if (result == null) {
            result = (ProcessorCore)CollectionsUtils.findAny(cores, c -> c.isMaster() && c.isMasterDefault());
        }
        return result != null ? result : (ProcessorCore)CollectionsUtils.first(cores);
    }

    public static @Nullable ProcessorCore findCoreByIdOrName(Collection<ProcessorCore> cores, @Nullable ProcessorCore findCore) {
        if (cores.isEmpty()) {
            return null;
        }
        ProcessorCore result = null;
        if (findCore != null && (result = (ProcessorCore)CollectionsUtils.findAny(cores, c -> c.getID().equals(findCore.getID()))) == null) {
            result = (ProcessorCore)CollectionsUtils.findAny(cores, c -> c.getName().equals(findCore.getName()));
        }
        return result;
    }

    public static void applyCores(ISharedConfiguration config, ISupportedDerivativesForSwTools derivatives) {
        ICommonConfig commonConfig = config.getCommonConfig();
        String mcu = UtilsText.safeString((String)commonConfig.getMcu());
        String sdk = UtilsText.safeString((String)commonConfig.getSdkVersion());
        CoresInfoLoader info = SWToolsPlatform.getCoresInfo(mcu, sdk, derivatives);
        ProcessorCore prevCore = commonConfig.getSelectedCore();
        if (info != null) {
            if (!info.cores.isEmpty() && !SWToolsPlatform.areCoreListsEquivalent(commonConfig.getCores(), info.cores)) {
                commonConfig.setCores(info.cores);
                if (commonConfig.getSelectedCore() == null) {
                    commonConfig.setSelectedCore(SWToolsPlatform.findCoreByIdOrName(commonConfig.getCores(), prevCore));
                }
            }
        } else if (SWToolsProperties.isVerificationOn()) {
            LOGGER.severe("Cannot find/open cores_info.xml for processor/sdk: " + mcu + "/" + sdk);
        }
        if (commonConfig.getCores().isEmpty()) {
            ProcessorCore core = SWToolsPlatform.createDefaultCoreInstance();
            commonConfig.setCores(Arrays.asList(core));
        }
    }

    public static ProcessorCore createDefaultCoreInstance() {
        return new ProcessorCore("core1", "Core #1", "", true, true);
    }

    public static @Nullable CoresInfoLoader getCoresInfo(String mcu, String sdkVersion, ISupportedDerivativesForSwTools derivatives) {
        String db;
        IProcessorMasterToolInfo master = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
        if (master != null && (db = derivatives.getDbFileName(master, master.getDefaultPartNumber(), AProcessorFilterForSwTools.DB_TYPE_CORES)) != null) {
            Object externalDataDir;
            File f = new File(derivatives.getDataDir(), db);
            if (!f.exists() && (externalDataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcu, sdkVersion)) != null) {
                f = new File((String)externalDataDir, db);
            }
            if (f.exists()) {
                try {
                    externalDataDir = null;
                    Object var7_9 = null;
                    try (InputStream is = UtilsDecryption.getFileInputStream((File)f);){
                        return SWToolsPlatform.getCoresInfo(is);
                    }
                    catch (Throwable throwable) {
                        if (externalDataDir == null) {
                            externalDataDir = throwable;
                        } else if (externalDataDir != throwable) {
                            ((Throwable)externalDataDir).addSuppressed(throwable);
                        }
                        throw externalDataDir;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "getCoresInfo", e);
                }
            }
        }
        return null;
    }

    public static @Nullable CoresInfoLoader getCoresInfo(InputStream is) {
        Persister serializer = new Persister();
        CoresInfoLoader info = new CoresInfoLoader();
        try {
            serializer.read((Object)info, is);
            return info;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Deserialize getCoresInfo from input stream", e);
            return null;
        }
    }

    public static @Nullable PartInfo getPartInfo(String mcu, String sdkVersion, String part, ISupportedDerivativesForSwTools derivatives) {
        File f;
        String db;
        IProcessorMasterToolInfo master = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
        if (master != null && (db = derivatives.getDbFileName(master, part, AProcessorFilterForSwTools.DB_TYPE_PART_INFO)) != null && (f = new File(derivatives.getDataDir(), db)).exists()) {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (InputStream is = UtilsDecryption.getFileInputStream((File)f);){
                    return SWToolsPlatform.getPartInfo(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "getPartInfo", e);
            }
        }
        return null;
    }

    public static @Nullable PartInfo getPartInfo(InputStream is) {
        Persister serializer = new Persister();
        PartInfo info = new PartInfo();
        try {
            serializer.read((Object)info, is);
            return info;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Deserialize getPartInfo from input stream", e);
            return null;
        }
    }

    public static boolean isPartDeprecated(String mcu, String sdkVersion, String part, ISupportedDerivativesForSwTools derivatives) {
        PartInfo partInfo = SWToolsPlatform.getPartInfo(mcu, sdkVersion, part, derivatives);
        return partInfo == null ? false : partInfo.isDeprecated();
    }

    public static boolean isPartRequiresNDA(String mcu, String sdkVersion, String part, ISupportedDerivativesForSwTools derivatives) {
        PartInfo partInfo = SWToolsPlatform.getPartInfo(mcu, sdkVersion, part, derivatives);
        return partInfo == null ? false : partInfo.isRequiresNDA();
    }

    public static boolean isMcuDeprecated(String mcu, String sdkVersion, ISupportedDerivativesForSwTools derivatives) {
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
        if (info == null) {
            return false;
        }
        for (String part : info.getPartNumbers()) {
            PartInfo partInfo = SWToolsPlatform.getPartInfo(mcu, sdkVersion, part, derivatives);
            if (partInfo == null) {
                return false;
            }
            if (partInfo.isDeprecated()) continue;
            return false;
        }
        return true;
    }

    public static boolean isMcuDeprecated(IProcessorMasterToolInfo masterTool, ISupportedDerivativesForSwTools derivatives) {
        return SWToolsPlatform.isMcuDeprecated(masterTool.getId(), masterTool.getSWToolsDataFolderID(), derivatives);
    }

    public static boolean isMcuRequiresNDA(String mcu, String sdkVersion, ISupportedDerivativesForSwTools derivatives) {
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
        if (info == null) {
            return false;
        }
        for (String part : info.getPartNumbers()) {
            PartInfo partInfo = SWToolsPlatform.getPartInfo(mcu, sdkVersion, part, derivatives);
            if (partInfo == null) {
                return false;
            }
            if (partInfo.isRequiresNDA()) continue;
            return false;
        }
        return true;
    }

    public static boolean isMcuRequiresNDA(IProcessorMasterToolInfo masterTool, ISupportedDerivativesForSwTools derivatives) {
        return SWToolsPlatform.isMcuRequiresNDA(masterTool.getId(), masterTool.getSWToolsDataFolderID(), derivatives);
    }

    static File getCoresInfoCacheDir() {
        String dirName = String.valueOf(SWToolsPlatform.getBaseUserConfigDir()) + File.separator + "cores_info_cache" + File.separator + KExProcessorsProvider.getRestApiDataVersion();
        File cacheDir = new File(dirName);
        if (!cacheDir.exists()) {
            try {
                cacheDir.mkdirs();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "failed creating cores info xml cache directory", e);
            }
        }
        return cacheDir;
    }

    /*
     * Loose catch block
     */
    public static synchronized @Nullable CoresInfoLoader getCoresInfoFromWeb(String mcu, String sdk, String apiVersion) {
        block35: {
            if (mcu.isEmpty() || sdk.isEmpty()) {
                LOGGER.warning("Cannot get core_infos.xml from web for empty processor/sdk");
                return null;
            }
            File cacheDir = SWToolsPlatform.getCoresInfoCacheDir();
            File cachedFile = new File(cacheDir, String.valueOf(mcu) + '_' + sdk + ".xml");
            if (cachedFile.exists()) {
                try {
                    Throwable throwable = null;
                    Object var6_11 = null;
                    try (FileInputStream is = new FileInputStream(cachedFile);){
                        return SWToolsPlatform.getCoresInfo(is);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Cannot read from cached cores info xml " + cachedFile.toString(), e);
                }
            }
            try {
                Throwable e = null;
                Object var6_13 = null;
                try (InputStream is = KExProcessorsProvider.getFile("/kex_tools/processors/" + mcu + "/" + sdk + "/common/cores_info.xml", apiVersion);){
                    if (is == null) break block35;
                    if (Files.isWritable(cacheDir.toPath())) {
                        CoresInfoLoader coresInfoLoader;
                        FileInputStream is2;
                        Throwable throwable;
                        block36: {
                            Files.copy(is, cachedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            throwable = null;
                            Object var9_19 = null;
                            is2 = new FileInputStream(cachedFile);
                            coresInfoLoader = SWToolsPlatform.getCoresInfo(is2);
                            if (is2 == null) break block36;
                            ((InputStream)is2).close();
                        }
                        return coresInfoLoader;
                        {
                            catch (Throwable throwable3) {
                                try {
                                    if (is2 != null) {
                                        ((InputStream)is2).close();
                                    }
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    }
                    return SWToolsPlatform.getCoresInfo(is);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                LOGGER.severe(e.getMessage());
            }
        }
        return null;
    }

    public static String getBaseUserConfigDir() {
        return String.valueOf(System.getProperty("user.home")) + File.separator + ".nxp" + File.separator + SWToolsProperties.getProductDirName() + File.separator + "14.0";
    }

    public static String getSdkVersionForSdkManifestVersion(String sdkManifestVersion) {
        return DEFAULT_DATA_VERSION;
    }

    public static String getSdkVersionForProcessor(String processor) {
        if (SwToolsProduct.isUctProduct()) {
            ISupportedDerivativesForSwTools derivatives;
            Collection list;
            String version = SWToolsPlatform.getMcuSelection().getSdkVersion();
            if (version.isEmpty() && !(list = (derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools()).getAllSwtoolsFolderIDsForMasterTool(processor)).isEmpty()) {
                return (String)CollectionsUtils.first((Collection)derivatives.getAllSwtoolsFolderIDsForMasterTool(processor));
            }
            return version;
        }
        return DEFAULT_DATA_VERSION;
    }

    public static @Nullable ToolsUiInfo getToolsUiInfo(String mcu, String sdkVersion, String part, ISupportedDerivativesForSwTools derivatives) {
        String db;
        IProcessorMasterToolInfo master = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
        if (master != null && (db = derivatives.getDbFileName(master, part, AProcessorFilterForSwTools.DB_TYPE_TOOLS_UI)) != null) {
            File f = new File(derivatives.getDataDir(), db);
            if (f.exists()) {
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (InputStream is = UtilsDecryption.getFileInputStream((File)f);){
                        return SWToolsPlatform.getToolsUiInfo(is);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Unable to get toolsUiInfo", e);
                }
            } else {
                LOGGER.log(Level.SEVERE, "Defined DB file not found:" + f.getPath());
            }
        }
        return null;
    }

    public static @Nullable ToolsUiInfo getToolsUiInfo(InputStream is) {
        Persister serializer = new Persister();
        ToolsUiInfo info = new ToolsUiInfo();
        try {
            serializer.read((Object)info, is);
            return info;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Deserialize getToolsUiInfo from input stream", e);
            return null;
        }
    }

    public static void setSelectedToolProxy(Consumer<SwToolsProduct> proxy) {
        assert (!Rap.isActive());
        if (Rap.isActive()) {
            return;
        }
        setSelectedToolProxy = proxy;
    }

    public static void setSelectedTool(SwToolsProduct tool) {
        assert (!Rap.isActive());
        if (Rap.isActive()) {
            return;
        }
        setSelectedToolProxy.accept(tool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initializeAllTools() {
        Serializable synchronizedObject;
        Serializable serializable = synchronizedObject = Rap.isActive() ? SharedConfigurationFactory.getSharedConfigurationSingleton() : SWToolsPlatform.class.getClass();
        synchronized (serializable) {
            if (toolInitialized && !Rap.isActive()) {
                LOGGER.warning("Duplicate tools initialization; ignored");
                return;
            }
            toolInitialized = true;
            ExecutableExtensionProvider provider = new ExecutableExtensionProvider("com.nxp.swtools.sharedconfiguration.startup", "startup", "class", null, null, "priority");
            for (IStartup ext : provider.getExtensions()) {
                ext.earlyStartup();
            }
        }
    }

    public static boolean isRunningAsRcp() {
        Bundle b = Platform.getBundle((String)"com.nxp.swtools.rcp");
        return b != null;
    }

    public static boolean isRunningInEclipseIde() {
        Bundle b = Platform.getBundle((String)"com.nxp.swtools.eclipse");
        return b != null;
    }

    public static boolean isRunningInMCUXpressoIde() {
        if (!SWToolsPlatform.isRunningInEclipseIde()) {
            return false;
        }
        Bundle b = Platform.getBundle((String)"com.nxp.mcuxpresso.core.datamodels.interfaces");
        return b != null;
    }

    public static boolean isRunningJUnitTest() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> list = Arrays.asList(stackTrace);
        for (StackTraceElement element : list) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    @Root(name="cores", strict=false)
    public static class CoresInfoLoader {
        @ElementList(inline=true, entry="core")
        public ArrayList<ProcessorCore> cores = new ArrayList();

        public @Nullable ProcessorCore findCore(String coreId) {
            return (ProcessorCore)CollectionsUtils.nullableOptionalGet(this.cores.stream().filter(c -> coreId.equals(c.getID())).findFirst());
        }

        public String toString() {
            return "CoresInfoLoader [cores=" + this.cores + "]";
        }
    }
}

