/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.wizards.importWizard;

import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.script.ClocksProfileInfo;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.wizards.importWizard.ClocksSrcImporter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksTool;
import com.nxp.swtools.provider.importer.IToolImporter;
import com.nxp.swtools.provider.importer.YamlNotFoundException;
import com.nxp.swtools.utils.scripting.FileYamlContent;
import com.nxp.swtools.utils.wizards.importWizard.ImportHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ClocksImporter
implements IToolImporter {
    private static final String CLOCK_CONFIG = "clock_config";
    private static final List<@NonNull Pattern> FILES_REGEX = CollectionsUtils.unmodifiableList((List)CollectionsUtils.asList((Object)Pattern.compile("clock_config.*\\.c")));
    private static final Logger LOGGER = LogManager.getLogger(ClocksImporter.class);

    public @NonNull String getToolId() {
        return "Clocks";
    }

    public @Nullable ISharedConfiguration parse(@NonNull InputStream inputStream, @NonNull StringBuffer outMessage, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IToolImporter.ParseMode mode, @Nullable IMcuIdentification targetMcuConfig, @Nullable String coreId) throws IOException, YamlNotFoundException {
        ISharedConfiguration result = null;
        byte[] fileContent = null;
        try {
            fileContent = UtilsFile.readStreamToByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "", e);
        }
        if (fileContent != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(fileContent);
            FileYamlContent<@NonNull ClocksProfileInfo, @NonNull StorageClocksConfiguration> ymlContent = ClocksSrcImporter.extractYaml("clock_config.c", is, (IProgressMonitor)new NullProgressMonitor(), false);
            if (ymlContent == null) {
                is = new ByteArrayInputStream(fileContent);
                ymlContent = ClocksSrcImporter.extractYaml("clock_config.c", is, (IProgressMonitor)new NullProgressMonitor(), true);
            }
            if (ymlContent == null) {
                outMessage.append(Messages.get().ClocksImporter_Error_ImportFailed);
                return null;
            }
            if (SWToolsProperties.isHeadlessOn()) {
                ImportHelper.checkOrDownloadDevice(ymlContent);
            }
            result = ymlContent.toConfiguration(targetMcuConfig);
            StorageClocksTool storage = new StorageClocksTool();
            storage.getClocksProfile().setProcessorVersion(((ClocksProfileInfo)ymlContent.getProfileInfo()).getProcessor_version());
            storage.setConfigurations(ymlContent.getFunctions());
            result.getTools().setTool((StorageTool)storage);
            ICommonConfig mcuSelection = result.getCommonConfig();
            if (UtilsText.isEmpty((String)mcuSelection.getName())) {
                result.setConfigurationName(mcuSelection.getMcu());
            }
        }
        return result;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull StorageTool mergeStorageTools(@NonNull StorageTool storageTool1, @NonNull StorageTool storageTool2, boolean mergeFcGrStorages) {
        StorageClocksTool result = new StorageClocksTool();
        if (storageTool1 instanceof StorageClocksTool && storageTool2 instanceof StorageClocksTool) {
            String processorVersion2;
            if (!storageTool1.isEnabled() && !storageTool2.isEnabled()) {
                result.setEnabled(false);
            }
            StorageClocksTool storageClocksTool1 = (StorageClocksTool)storageTool1;
            StorageClocksTool storageClocksTool2 = (StorageClocksTool)storageTool2;
            String processorVersion1 = storageClocksTool1.getClocksProfile().getProcessorVersion();
            if (!processorVersion1.equals(processorVersion2 = storageClocksTool2.getClocksProfile().getProcessorVersion())) {
                LOGGER.warning("Trying to merge clocks storages with different processor versions:" + processorVersion1 + "with" + processorVersion2);
            }
            @NonNull ArrayList funcGroups1 = storageClocksTool1.getConfigurations();
            @NonNull ArrayList funcGroups2 = storageClocksTool2.getConfigurations();
            @NonNull List newList = IToolImporter.mergeFuncGroups((List)funcGroups1, (List)funcGroups2);
            newList.stream().filter(StorageClocksConfiguration::isCalledFromInit).skip(1L).forEach(fg -> fg.setCalledFromInit(false));
            result.setConfigurations(newList);
            return result;
        }
        LOGGER.severe("Trying to merge clocks storages that are not instances of \"StorageClocksTool\"");
        assert (false);
        return result;
    }

    public List<@NonNull Pattern> getImportibleFilesRegexes() {
        return FILES_REGEX;
    }

    public boolean importConfigurationFromBitFieldState(@NonNull Collection<?> bitFieldInfo, @Nullable Map<String, String> specificSettings) {
        boolean isOverrideLocksAllowed = ClocksImporter.getOverrideLocksSetting(specificSettings);
        UiController.getInstance().loadConfigurationFromBitFieldState(bitFieldInfo, null, isOverrideLocksAllowed);
        return true;
    }

    public boolean importConfigurationFromBitFieldState(@NonNull Collection<?> bitFieldInfo, @NonNull String functionialGroupName, @Nullable Map<String, String> specificSettings) {
        boolean isOverrideLocksAllowed = ClocksImporter.getOverrideLocksSetting(specificSettings);
        UiController.getInstance().loadConfigurationFromBitFieldState(bitFieldInfo, functionialGroupName, isOverrideLocksAllowed);
        return true;
    }

    private static boolean getOverrideLocksSetting(@Nullable Map<String, String> specificSettings) {
        if (specificSettings != null) {
            String value = specificSettings.get("clocks_override_locked_values");
            if (Boolean.TRUE.toString().equals(value)) {
                return true;
            }
        }
        return false;
    }
}

