/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.platform.IPlatformSpecific;
import com.nxp.swtools.clocks.platform.PlatformSpecificFactory;
import com.nxp.swtools.clocks.ui.diagramsymbols.Color;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;

public class LineStyle {
    private int mThickness;
    @NonNull
    private Style mStyle;
    @NonNull
    private Color mColor;
    int mPrevSWTStyle;
    int mPrevThickness;
    @Nullable org.eclipse.swt.graphics.Color mPrevSWTColor;

    public LineStyle(@NonNull Style style, int thickness, @NonNull Color color) {
        this.mThickness = thickness;
        this.mStyle = style;
        this.mColor = color;
    }

    public void setThickness(int thickness) {
        this.mThickness = thickness;
    }

    public void setColor(@NonNull Color color) {
        this.mColor = color;
    }

    public void set(@NonNull PaintEvent e) {
        GC gc = e.gc;
        assert (gc != null);
        IPlatformSpecific platformSpecific = PlatformSpecificFactory.getPlatformSpecific();
        this.mPrevSWTColor = gc.getForeground();
        this.mPrevThickness = gc.getLineWidth();
        this.mPrevSWTStyle = platformSpecific.getLineStyle(gc);
        e.gc.setLineWidth(this.mThickness);
        switch (this.mStyle) {
            case SOLID: {
                platformSpecific.setLineStyleSolid(gc);
                break;
            }
            case DASH_LINE: 
            case DASH_LINE2: {
                platformSpecific.setLineStyleDash(gc);
                break;
            }
            default: {
                platformSpecific.setLineStyleSolid(gc);
            }
        }
        e.gc.setForeground(this.mColor.getSWTColor());
    }

    public void unset(@NonNull PaintEvent e) {
        GC gc = e.gc;
        assert (gc != null);
        if (this.mPrevSWTColor != null && !this.mPrevSWTColor.isDisposed()) {
            assert (this.mPrevSWTColor != null);
            gc.setForeground(this.mPrevSWTColor);
        }
        IPlatformSpecific platformSpecific = PlatformSpecificFactory.getPlatformSpecific();
        platformSpecific.setLineStyle(gc, this.mPrevSWTStyle);
        gc.setLineWidth(this.mPrevThickness);
    }

    public @NonNull Color getColor() {
        return this.mColor;
    }

    public @NonNull LineStyle makeCopy() {
        return new LineStyle(this.mStyle, this.mThickness, this.mColor.makeCopy());
    }

    public static enum Style {
        SOLID,
        UNUSED1,
        UNUSED2,
        DASH_LINE,
        DASH_LINE2;

    }
}

