/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.utils.resources.ToolsColors;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WidgetFactory {
    public static @NonNull Composite createComposite(@NonNull Composite parent, int horizontalAlignment, int verticalAlignment, int columns, boolean marginHorizontal, boolean marginVertical) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        if (!marginHorizontal) {
            layout.marginWidth = 0;
            layout.marginRight = 0;
            layout.marginLeft = 0;
        }
        if (!marginVertical) {
            layout.marginHeight = 0;
            layout.marginBottom = 0;
            layout.marginTop = 0;
        }
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(horizontalAlignment, verticalAlignment, true, true));
        return composite;
    }

    public static @NonNull Composite createComposite(@NonNull Composite parent, int horizontalAlignment, int verticalAlignment, int columns, boolean margin) {
        return WidgetFactory.createComposite(parent, horizontalAlignment, verticalAlignment, columns, margin, margin);
    }

    public static @NonNull Composite createComposite(@NonNull Composite parent, int horizontalAlignment, int verticalAlignment, int columns) {
        return WidgetFactory.createComposite(parent, horizontalAlignment, verticalAlignment, columns, true);
    }

    public static @NonNull Composite createComposite(@NonNull Composite parent, int horizontalAlignment, int verticalAlignment, boolean margin) {
        return WidgetFactory.createComposite(parent, horizontalAlignment, verticalAlignment, 1, margin);
    }

    public static @NonNull Composite createComposite(@NonNull Composite parent, int horizontalAlignment, int verticalAlignment) {
        return WidgetFactory.createComposite(parent, horizontalAlignment, verticalAlignment, 1);
    }

    public static @NonNull Composite createComposite(@NonNull Composite parent, boolean margin) {
        return WidgetFactory.createComposite(parent, 4, 4, margin);
    }

    public static @NonNull Composite createComposite(@NonNull Composite parent) {
        return WidgetFactory.createComposite(parent, 4, 4);
    }

    public static @NonNull SashForm createHorizontalSash(@NonNull Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        return sash;
    }

    public static @NonNull SashForm createVerticalSash(@NonNull Composite parent) {
        SashForm sash = new SashForm(parent, 512);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        return sash;
    }

    public static @NonNull Label createTitle(@NonNull Composite composite, @NonNull String text, @Nullable Color backgroundColor) {
        Label label = new Label(composite, 64);
        label.setText(text);
        if (backgroundColor != null) {
            label.setBackground(backgroundColor);
        }
        FontFactory.changeStyle((Control)label, (int)1);
        return label;
    }

    public static @NonNull Label createTitle(@NonNull Composite composite, @NonNull String text) {
        return WidgetFactory.createTitle(composite, text, ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.group_title_BG"));
    }

    public static @NonNull Label createTitleNoBackgroundColor(@NonNull Composite composite, @NonNull String text) {
        return WidgetFactory.createTitle(composite, text, null);
    }

    public static void setMargin(@NonNull GridLayout layout, int margin) {
        layout.marginWidth = layout.marginHeight = margin;
    }

    public static void setSpacing(@NonNull GridLayout layout, int spacing) {
        layout.horizontalSpacing = layout.verticalSpacing = spacing;
    }

    public static void setMarginAndSpacing(@NonNull GridLayout layout, int value) {
        WidgetFactory.setMargin(layout, value);
        WidgetFactory.setSpacing(layout, value);
    }

    public static void setMargin(@NonNull RowLayout layout, int margin) {
        layout.marginRight = layout.marginTop = margin;
        layout.marginLeft = layout.marginTop;
        layout.marginBottom = layout.marginTop;
        layout.marginHeight = layout.marginTop;
        layout.marginWidth = layout.marginTop;
    }
}

