/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.report;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.engine.ProblemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;

public class ReportGenerator {
    public static @NonNull String getHtmlFileName() {
        return "html_report_Clocks.html";
    }

    public static @NonNull String generateReport(@NonNull IClocksProfile clocksProfile) {
        StringBuilder report = new StringBuilder();
        report.append(com.nxp.swtools.utils.report.ReportGenerator.getIntro());
        IMcu mcu = clocksProfile.getMcu();
        ArrayList<@NonNull String> srcIDs = new ArrayList<String>();
        mcu.getSettings().getClockSources().forEach(x -> {
            boolean bl = srcIDs.add(x.getId());
        });
        ArrayList<@NonNull String> outputIDs = new ArrayList<String>();
        mcu.getSettings().getClockOutputs().forEach(x -> {
            boolean bl = outputIDs.add(x.getId());
        });
        ArrayList<@NonNull String> configElements = new ArrayList<String>();
        mcu.getSettings().getGlobalSettings().forEach(x -> {
            boolean bl = configElements.add(x.getId());
        });
        @NonNull List<@NonNull IClocksConfig> configs = clocksProfile.getConfigs();
        report.append(com.nxp.swtools.utils.report.ReportGenerator.getHeadings((String)"Clocks"));
        com.nxp.swtools.utils.report.ReportGenerator.appendText((StringBuilder)report, (int)2, (String)com.nxp.swtools.utils.report.ReportGenerator.getHeader((int)2, (String)Messages.get().ReportGenerator_ClocksReport), (boolean)true);
        for (IClocksConfig cfg : configs) {
            if (cfg.getError() == null) continue;
            report.append(com.nxp.swtools.utils.report.ReportGenerator.getProblemText((boolean)false, (int)4, (int)2, (String)(String.valueOf(Messages.get().ReportGenerator_Error_ErrorsPresent) + " " + cfg.getName())));
        }
        com.nxp.swtools.utils.report.ReportGenerator.appendText((StringBuilder)report, (int)2, (String)com.nxp.swtools.utils.report.ReportGenerator.getTableBeginning(), (boolean)true);
        com.nxp.swtools.utils.report.ReportGenerator.appendTabs((StringBuilder)report, (int)3);
        report.append("<tr><td></td><td></td>\n");
        Map<@NonNull String, @NonNull List<@NonNull IValidationProblem>> dependencies = UiController.collectValidationProblemsOnClocksTool();
        String message = ProblemUtils.getDependenciesWarningMessage(dependencies);
        for (IClocksConfig cfg : configs) {
            com.nxp.swtools.utils.report.ReportGenerator.appendTabs((StringBuilder)report, (int)4);
            if (!dependencies.isEmpty()) {
                report.append("<th style='background-color: " + com.nxp.swtools.utils.report.ReportGenerator.getHexColor((RGB)com.nxp.swtools.utils.report.ReportGenerator.COLOR_WARNING) + "' title='" + message + "'>");
            } else {
                report.append("<th>");
            }
            report.append(cfg.getName());
            report.append("</th>");
            report.append("\n");
        }
        com.nxp.swtools.utils.report.ReportGenerator.appendTabs((StringBuilder)report, (int)3);
        report.append("</tr>\n");
        report.append(ReportGenerator.getDescription(configs));
        ReportGenerator.writeSettings("Configuration", report, mcu, configElements, configs);
        ReportGenerator.writeSettings("Clock sources", report, mcu, srcIDs, configs);
        ReportGenerator.writeSettings("Clock outputs", report, mcu, outputIDs, configs);
        com.nxp.swtools.utils.report.ReportGenerator.appendTabs((StringBuilder)report, (int)2);
        report.append(com.nxp.swtools.utils.report.ReportGenerator.getTableEnding());
        if (UiController.getInstance().shouldIncludeDiagram()) {
            com.nxp.swtools.utils.report.ReportGenerator.appendText((StringBuilder)report, (int)2, (String)com.nxp.swtools.utils.report.ReportGenerator.getHeader((int)2, (String)Messages.get().ReportGenerator_ClocksDiagram), (boolean)true);
            ReportGenerator.appendImage(report, 2, "clocks_diagram.png", true);
        }
        report.append(com.nxp.swtools.utils.report.ReportGenerator.getEnd());
        return report.toString();
    }

    public static void appendImage(@NonNull StringBuilder report, int tabsIndent, @NonNull String fileName, boolean appendNewline) {
        com.nxp.swtools.utils.report.ReportGenerator.appendTabs((StringBuilder)report, (int)tabsIndent);
        report.append("<img src='").append(fileName).append("'").append(ReportGenerator.getImageStyle()).append(">");
        if (appendNewline) {
            report.append("\n");
        }
    }

    public static @NonNull String getImageStyle() {
        return "border='1' style='border: 2px solid #000000;' bgcolor='WHITE' width='1000px'";
    }

    private static void writeSettings(@NonNull String label, @NonNull StringBuilder writer, @NonNull IMcu mcu, @NonNull ArrayList<@NonNull String> idlist, @NonNull List<IClocksConfig> configs) {
        boolean first = true;
        for (String id : idlist) {
            @Nullable ISetting setting = SettingProvider.getSettingById(id, mcu);
            if (setting == null) continue;
            com.nxp.swtools.utils.report.ReportGenerator.appendTabs((StringBuilder)writer, (int)3);
            writer.append("<tr>");
            if (first) {
                writer.append("<th" + com.nxp.swtools.utils.report.ReportGenerator.TABLE_HEADER2_BGCOLOR + "rowspan='" + Integer.toString(idlist.size()) + "'>" + label + "</th>");
                first = false;
            }
            writer.append("<td><span style=\"font-weight:bold\">" + setting.getName() + "</span></td>");
            for (IClocksConfig cfg : configs) {
                SettingValue value = SettingProvider.getValueBySettingId(id, mcu, cfg.getSettingsConfig());
                if (value == null) continue;
                String error = cfg.getErrorsAsText(setting.getElement().getID());
                String warning = cfg.getWarningsAsText(setting.getElement().getID());
                writer.append("<td");
                if (error != null) {
                    writer.append(" title=\"Error: " + error + "\"" + " style=" + "\"" + "background-color:" + com.nxp.swtools.utils.report.ReportGenerator.getHexColor((RGB)com.nxp.swtools.utils.report.ReportGenerator.COLOR_ERROR) + "\"" + ";>(!) ");
                } else if (warning != null) {
                    writer.append(" title=\"Warning: " + warning + "\"" + " style=" + "\"" + "background-color:" + com.nxp.swtools.utils.report.ReportGenerator.getHexColor((RGB)com.nxp.swtools.utils.report.ReportGenerator.COLOR_WARNING) + "\"" + ";>(!) ");
                } else {
                    writer.append(">");
                }
                writer.append(String.valueOf(value.getUiValue()) + "</td>");
            }
            writer.append("</tr>\n");
        }
    }

    private static @NonNull String getDescription(@NonNull List<@NonNull IClocksConfig> configs) {
        StringBuilder report = new StringBuilder();
        com.nxp.swtools.utils.report.ReportGenerator.appendTabs((StringBuilder)report, (int)3);
        report.append("<tr>");
        report.append("<th" + com.nxp.swtools.utils.report.ReportGenerator.TABLE_HEADER2_BGCOLOR + "rowspan='1'>" + "Description" + "</th>");
        report.append("<td></td>");
        for (IClocksConfig cfg : configs) {
            report.append("<td max-width =\"250em\">" + cfg.getDescription());
            String errorText = cfg.getErrorText();
            String warningText = cfg.getWarning();
            if (errorText != null) {
                report.append("<br>" + com.nxp.swtools.utils.report.ReportGenerator.getProblemText((boolean)false, (int)0, (int)0, (String)("Error: " + errorText)));
            }
            if (warningText != null) {
                report.append("<br>" + com.nxp.swtools.utils.report.ReportGenerator.getProblemText((boolean)true, (int)0, (int)0, (String)("Warning: " + warningText)));
            }
            report.append("</td>");
        }
        report.append("</tr>\n");
        return report.toString();
    }
}

