/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.registers;

import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.registers.BitField;
import com.nxp.swtools.utils.registers.BitFieldInfo;
import com.nxp.swtools.utils.registers.IRegistersContentProvider;
import com.nxp.swtools.utils.view.IViewRefreshManager;
import com.nxp.swtools.utils.view.IViewRefreshManagerHandler;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ClocksBitFieldsContentProvider
implements IRegistersContentProvider,
IViewRefreshManagerHandler {
    @Nullable
    protected IEventListener listener;
    @Nullable
    protected IViewRefreshManager refreshManager;

    public @NonNull Collection<@NonNull BitFieldInfo> getContent() {
        return ClocksBitFieldsContentProvider.getBitFieldInfo();
    }

    public static @NonNull Collection<@NonNull BitFieldInfo> getBitFieldInfo() {
        IClocksConfig config = GuiController.getInstance().getProfile().getActiveConfig();
        if (config != null) {
            return ClocksBitFieldsContentProvider.getBitFieldInfo(config);
        }
        return Collections.emptyList();
    }

    public static @NonNull Collection<@NonNull BitFieldInfo> getBitFieldInfo(@NonNull IClocksConfig config) {
        ArrayList<@NonNull BitFieldInfo> bitFieldsInfo = new ArrayList<BitFieldInfo>();
        for (BitFieldElement bitField : ClocksBitFieldProvider.getBitFields(config.getMcu())) {
            long longValue = ClocksBitFieldProvider.getBitFieldValueOrResetValue(bitField, config).getValue();
            BigInteger value = BigInteger.valueOf(longValue);
            ISetting bitFieldSetting = SettingProvider.getBitFieldSetting(bitField, config.getMcu());
            boolean changed = bitFieldSetting != null && config.getSettingsConfig().isLastlyChanged(bitFieldSetting);
            BitFieldInfo bfInfo = new BitFieldInfo((BitField)bitField, value, changed);
            bitFieldsInfo.add(bfInfo);
        }
        return bitFieldsInfo;
    }

    public void setRefreshManager(@NonNull IViewRefreshManager refreshManager) {
        this.refreshManager = refreshManager;
    }

    public void create() {
        int eventTypes = 482;
        IEventListener listenerLoc = this.listener;
        if (listenerLoc != null) {
            UiController.getInstance().removeListener(listenerLoc);
        }
        listenerLoc = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                if (ClocksBitFieldsContentProvider.this.refreshManager != null) {
                    ClocksBitFieldsContentProvider.this.refreshManager.refresh();
                }
            }
        };
        UiController.getInstance().addListener(eventTypes, listenerLoc);
        this.listener = listenerLoc;
    }

    public void dispose() {
        IEventListener listenerLoc = this.listener;
        if (listenerLoc != null) {
            UiController.getInstance().removeListener(listenerLoc);
        }
    }
}

