/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.perspective;

import com.nxp.swtools.clocks.perspective.ClocksExtensionsReader;
import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.utils.perspective.ToolsBasePerspective;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;

public class ClocksPerspective
extends ToolsBasePerspective {
    private static final String MAIN_FOLDER = "mainPart";
    private static final String SHARED_FOLDER = "sharedPart";
    @NonNull
    public static final String ID = "com.nxp.swtools.clocks.clocks.perspective";

    public void createInitialLayout(IPageLayout layout) {
        super.createInitialLayout(layout);
        this.defineLayout(layout);
    }

    public void defineLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        IFolderLayout mainFolder = layout.createFolder(MAIN_FOLDER, 1, 0.75f, editorArea);
        @NonNull List<@NonNull String> mainFolderViews = Arrays.asList("com.nxp.swtools.clocks.TableView", "com.nxp.swtools.clocks.DiagramView");
        for (String view : ClocksExtensionsReader.orderViews(mainFolderViews)) {
            mainFolder.addView(view);
        }
        IFolderLayout sharedFolder = layout.createFolder(SHARED_FOLDER, 2, 0.25f, editorArea);
        @NonNull ArrayList<@NonNull String> sharedFolderViews = new ArrayList<String>();
        if (!Rap.isActive()) {
            sharedFolderViews.add("com.nxp.swtools.dashboard.DashboardView");
            sharedFolderViews.add("com.nxp.swtools.framework.SourcesView");
            sharedFolderViews.add("com.nxp.swtools.framework.RegistersView");
        }
        sharedFolderViews.add("com.nxp.swtools.clocks.DetailsView");
        if (!Rap.isActive()) {
            sharedFolderViews.add("com.nxp.swtools.clocks.ModuleClocksView");
        }
        for (String view : ClocksExtensionsReader.orderViews(sharedFolderViews)) {
            sharedFolder.addView(view);
        }
        if (!Rap.isActive()) {
            layout.addView("com.nxp.swtools.validation.problems.view", 4, 0.75f, "com.nxp.swtools.framework.SourcesView");
            ClocksPerspective.addCheatSheetViewPlaceholder((IPageLayout)layout);
            ClocksPerspective.addConsoleViewPlaceholder((IPageLayout)layout);
        }
        if (OSDetect.isMac()) {
            layout.getViewLayout("com.nxp.swtools.clocks.TableView").setMoveable(false);
            layout.getViewLayout("com.nxp.swtools.clocks.DetailsView").setMoveable(false);
        }
    }

    public List<@NonNull String> getDefinedViewIDs() {
        return CollectionsUtils.unmodifiableList((List)new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("com.nxp.swtools.clocks.TableView");
                this.add("com.nxp.swtools.clocks.DiagramView");
                this.add("com.nxp.swtools.clocks.DetailsView");
                this.add("com.nxp.swtools.framework.SourcesView");
                if (!Rap.isActive()) {
                    this.add("com.nxp.swtools.clocks.ModuleClocksView");
                    this.add("com.nxp.swtools.framework.RegistersView");
                    this.add("com.nxp.swtools.utils.logging.UserLogView");
                    this.add("com.nxp.swtools.validation.problems.view");
                    this.add("com.nxp.swtools.dashboard.DashboardView");
                }
            }
        });
    }
}

