/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.valueMaps;

import com.nxp.swtools.clocks.data.BitFieldsCache;
import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.valueMaps.AValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.IValueMap;
import com.nxp.swtools.clocks.data.valueMaps.IValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.RangeValueMap;
import com.nxp.swtools.clocks.expression.BitFieldsContext;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.verification.ExpressionVerificator;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import java.math.BigInteger;

public class RangeValueMapBuilder
extends AValueMapBuilder {
    @NonNull
    private static final Long LONG_ONE = 1L;
    @NonNull
    private static final Long LONG_ZERO = 0L;
    @NonNull
    private Expression reverseExpression;

    public RangeValueMapBuilder(@NonNull Expression expression, @NonNull Expression reverseExpression, @NonNull BitFieldsCache registers) {
        super(registers, expression);
        this.reverseExpression = reverseExpression;
    }

    @Override
    public @NonNull IValueMapBuilder addRequirement(@NonNull String expressionResult, @Nullable String uiValue, @Nullable Object controlValue) {
        return this;
    }

    @Override
    public @NonNull IValueMap build() {
        Range range = new Range(RangeValueMapBuilder.getMinValue(this.expression, this.registers, this.bitFields), RangeValueMapBuilder.getMaxValue(this.expression, this.registers, this.bitFields));
        range.setStep(new BigRational(RangeValueMapBuilder.getStepValue(this.expression, this.registers, this.bitFields)));
        RangeValueMap result = new RangeValueMap(this.expression, this.reverseExpression, range, this.fractionalBits, this.bitFields, this.registers);
        ExpressionVerificator.getInstance().addValueMap(result);
        return result;
    }

    private static @NonNull LongValues getMinBfValues(@NonNull BitFieldElement[] bitFields) {
        LongValues.Builder builder = new LongValues.Builder();
        int i = 0;
        while (i < bitFields.length) {
            builder.addValue(LONG_ZERO);
            ++i;
        }
        return builder.build();
    }

    private static @NonNull LongValues getSecondMinimalBfValues(@NonNull BitFieldElement[] bitFields) {
        LongValues.Builder builder = new LongValues.Builder();
        int i = 0;
        while (i < bitFields.length) {
            if (i == bitFields.length - 1) {
                builder.addValue(LONG_ONE);
            } else {
                builder.addValue(LONG_ZERO);
            }
            ++i;
        }
        return builder.build();
    }

    private static @NonNull LongValues getMaxBfValues(@NonNull BitFieldElement[] bitFields) {
        LongValues.Builder builder = new LongValues.Builder();
        BitFieldElement[] bitFieldElementArray = bitFields;
        int n = bitFields.length;
        int n2 = 0;
        while (n2 < n) {
            BitFieldElement bitField = bitFieldElementArray[n2];
            Long maxBitFieldValue = BigInteger.valueOf(2L).pow(bitField.getWidth()).subtract(BigInteger.ONE).longValue();
            builder.addValue(maxBitFieldValue);
            ++n2;
        }
        return builder.build();
    }

    private static long getMinValue(@NonNull Expression expression, @NonNull BitFieldsCache registers, @NonNull BitFieldElement @NonNull [] bitFields) {
        BitFieldsContext bfContext = new BitFieldsContext(registers, bitFields, RangeValueMapBuilder.getMinBfValues(bitFields), expression.getContext());
        IValue expressionResult = expression.resolve(bfContext);
        return expressionResult.getLong();
    }

    private static long getSecondValue(@NonNull Expression expression, @NonNull BitFieldsCache registers, @NonNull BitFieldElement @NonNull [] bitFields) {
        BitFieldsContext bfContext = new BitFieldsContext(registers, bitFields, RangeValueMapBuilder.getSecondMinimalBfValues(bitFields), expression.getContext());
        IValue expressionResult = expression.resolve(bfContext);
        return expressionResult.getLong();
    }

    private static long getMaxValue(@NonNull Expression expression, @NonNull BitFieldsCache registers, @NonNull BitFieldElement @NonNull [] bitFields) {
        BitFieldsContext bfContext = new BitFieldsContext(registers, bitFields, RangeValueMapBuilder.getMaxBfValues(bitFields), expression.getContext());
        IValue expressionResult = expression.resolve(bfContext);
        return expressionResult.getLong();
    }

    private static long getStepValue(@NonNull Expression expression, @NonNull BitFieldsCache registers, @NonNull BitFieldElement @NonNull [] bitFields) {
        long second;
        long min = RangeValueMapBuilder.getMinValue(expression, registers, bitFields);
        return min != (second = RangeValueMapBuilder.getSecondValue(expression, registers, bitFields)) ? second - min : 1L;
    }

    public static boolean isAlegible(@NonNull Expression expression, @NonNull BitFieldsCache registersDb) {
        long step;
        @NonNull BitFieldElement[] bitFields = RangeValueMapBuilder.findBitFields(expression, registersDb);
        long minValue = RangeValueMapBuilder.getMinValue(expression, registersDb, bitFields);
        long maxValue = RangeValueMapBuilder.getMaxValue(expression, registersDb, bitFields);
        long numberOfValues = (maxValue - minValue) / (step = RangeValueMapBuilder.getStepValue(expression, registersDb, bitFields)) + 1L;
        if (numberOfValues > 256L) {
            return true;
        }
        BitFieldElement[] bitFieldElementArray = bitFields;
        int n = bitFields.length;
        int n2 = 0;
        while (n2 < n) {
            BitFieldElement bitField = bitFieldElementArray[n2];
            long numberOfDefinedValues = 0L;
            IRegBitFieldValueAPI[] iRegBitFieldValueAPIArray = bitField.getValues();
            int n3 = iRegBitFieldValueAPIArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IRegBitFieldValueAPI values = iRegBitFieldValueAPIArray[n4];
                numberOfDefinedValues += values.numberOfValues();
                ++n4;
            }
            if (numberOfDefinedValues != 0L && (double)numberOfDefinedValues != Math.pow(2.0, bitField.getItemWidth())) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

