/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.elements.ClockSource;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.OutputFrequencySetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.expression.DependencyContextWrapper;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.utils.ExpressionUtils;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksSource;
import com.nxp.swtools.utils.registers.BitFieldProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ClockSourceSetting
extends OutputFrequencySetting {
    public ClockSourceSetting(@NonNull ClockSource element) {
        super(element);
        this.visible = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isInternal() {
        return this.getElement().isInternal();
    }

    public boolean isFixed() {
        return this.getElement().isFixed();
    }

    @Override
    public @NonNull ClockSource getElement() {
        assert (this.element instanceof ClockSource);
        return (ClockSource)this.element;
    }

    @Override
    public boolean isEnabled(IClocksConfig clocksConfig) {
        return this.getElement().isEnabled(clocksConfig);
    }

    @Override
    public boolean isEditable(IClocksConfig clocksConfig) {
        return clocksConfig.getSettingsConfig().isEditable(this) && this.isEnabled(clocksConfig);
    }

    @Override
    public List<@NonNull SettingValue> getValues(IClocksConfig clocksConfig) {
        List<@NonNull Frequency> frequencies = this.getElement().getFrequencies();
        Map<@NonNull Expression, @NonNull ValueMap> valuesMap = this.getElement().getValues();
        if (frequencies.isEmpty()) {
            return null;
        }
        ArrayList<@NonNull SettingValue> values = new ArrayList<SettingValue>();
        if (!valuesMap.isEmpty()) {
            ValueMap valueMap = (ValueMap)CollectionsUtils.first(valuesMap.values());
            return ClockSourceSetting.getSettingValuesFromValueMap(valueMap, frequencies);
        }
        for (Frequency freq : frequencies) {
            assert (freq != null);
            values.add(ClockSourceSetting.parseValue(freq));
        }
        return values;
    }

    private static List<@NonNull SettingValue> getSettingValuesFromValueMap(ValueMap valueMap, List<@NonNull Frequency> frequencies) {
        ArrayList<@NonNull E> settingValues = new ArrayList(frequencies.size());
        Collection<@NonNull String> uiValues = valueMap.getUiValues();
        uiValues.forEach(uiValue -> {
            Object value = valueMap.getControlValueByUiValue((String)uiValue);
            if (value instanceof Frequency) {
                settingValues.add(ClockSourceSetting.parseFreqValue((Frequency)value, uiValue));
            }
        });
        Comparator comparator = (a, b) -> {
            Object aValue = a.getValue();
            Object bValue = b.getValue();
            if (aValue instanceof Frequency && bValue instanceof Frequency) {
                return Integer.compare(frequencies.indexOf(aValue), frequencies.indexOf(bValue));
            }
            return 0;
        };
        return (List)settingValues.stream().sorted(comparator).collect(CollectorsUtils.toList());
    }

    @Override
    public @Nullable SettingValue parseUiValue(@NonNull String uiValue, @NonNull IClocksConfig clocksConfig) {
        Frequency frequencyValue = this.parseFrequency(uiValue, clocksConfig);
        List<@NonNull SettingValue> values = this.getValues(clocksConfig);
        if (frequencyValue != null && values == null && !BigRational.ZERO.equals((Object)frequencyValue.getValue())) {
            return ClockSourceSetting.parseValue(frequencyValue);
        }
        if (values != null) {
            for (SettingValue value : values) {
                if (!value.getUiValue().equals(uiValue)) continue;
                return value;
            }
        }
        return null;
    }

    public @Nullable SettingValue fromStorage(@NonNull StorageClocksSource source, @NonNull IClocksConfig clocksConfig) {
        SettingValue fromUiValue;
        String uiValue = source.getUiValue();
        if (uiValue != null && (fromUiValue = this.parseUiValue(uiValue, clocksConfig)) != null) {
            return fromUiValue;
        }
        Frequency frequency = Frequency.parseNonNull((String)source.getValue());
        if (frequency.compareTo((Frequency)SettingValue.FREQ_N_A.getValue()) == 0) {
            return SettingValue.FREQ_N_A;
        }
        return this.parseValue(frequency, clocksConfig);
    }

    @Override
    public boolean isValid(SettingValue settingValue, IClocksConfig clocksConfig) {
        if (this.getElement().isDisabled(clocksConfig)) {
            return true;
        }
        boolean elementValid = this.isElementValid(clocksConfig);
        return elementValid && !clocksConfig.getSettingsConfig().isInvalid(this);
    }

    private static @Nullable Range getRange(@NonNull Frequency freq, @NonNull ValueMap valueMap) {
        Optional<@NonNull Range> matchingRange = CollectionsUtils.getInstancesOf(valueMap.getControlValues(), Range.class).filter(x -> x.isFrequencyInRange(freq)).findFirst();
        return matchingRange.isPresent() ? matchingRange.get() : null;
    }

    @Override
    public @Nullable SettingValue parseBfValue(@NonNull Object value, @NonNull IClocksConfig clocksConfig) {
        return null;
    }

    @Override
    public SettingValue getDefaultValue(IClocksConfig clockConfig) {
        Frequency defaultFreq = this.getElement().getDefaultInput();
        return defaultFreq == null ? SettingValue.UNDEFINED : this.parseValue(defaultFreq, clockConfig);
    }

    public boolean isConnectedByDefault() {
        return this.getElement().isConnectedByDefault();
    }

    @Override
    public boolean isUserLockable() {
        return false;
    }

    @Override
    public boolean isLockedByDefault() {
        return true;
    }

    @Override
    public boolean isUserEnableable() {
        return !this.isInternal();
    }

    @Override
    public @NonNull SettingValue createCurrentValue(@NonNull IClocksConfig config) {
        if (this.getElement().isEnabledForModel(config)) {
            BitFieldElement[] bitFields;
            LongValues longValues;
            Object controlValue;
            ValueMap valueMap = this.getElement().getActiveValueMap(config);
            if (valueMap != null && valueMap.getBitFields().length != 0 && (controlValue = valueMap.getControlValueByBfValue(longValues = LongValues.fromConfig(config, bitFields = valueMap.getBitFields()))) instanceof Frequency) {
                return new SettingValue(controlValue);
            }
            LockState lockState = config.getSettingsConfig().getLockState(this);
            return lockState != null ? lockState.getValue() : super.createCurrentValue(config);
        }
        return SettingValue.FREQ_N_A;
    }

    @Override
    public @NonNull Collection<@NonNull String> getDependencies(@NonNull IMcu mcu) {
        Set<@NonNull Expression> caseExpressions = this.getElement().getValues().keySet();
        assert (caseExpressions != null);
        Collection<@NonNull String> relatedSettingIDs = ExpressionUtils.getRelatedSettingIDs(caseExpressions, mcu);
        relatedSettingIDs.addAll(this.getInfluencedSettings(mcu));
        EnableSetting enableSetting = this.getElement().getEnableSetting();
        if (enableSetting != null) {
            relatedSettingIDs.add(enableSetting.getId());
        }
        return relatedSettingIDs;
    }

    @Override
    public @NonNull Collection<@NonNull String> getInfluencedSettings(@NonNull IMcu mcu) {
        HashSet<@NonNull Expression> expressions = new HashSet<Expression>();
        this.getElement().getValues().values().forEach(x -> {
            boolean bl = expressions.add(x.getExpression());
        });
        return ExpressionUtils.getRelatedSettingIDs(expressions, mcu);
    }

    @Override
    public boolean canRead(@NonNull IClocksConfig config, @NonNull Collection<@NonNull String> resolvedSettingIds) {
        if (!this.getElement().isEnabledForModel(config)) {
            return true;
        }
        EnableSetting enableSetting = this.getElement().getEnableSetting();
        if (enableSetting != null && !resolvedSettingIds.contains(enableSetting.getId())) {
            return false;
        }
        ValueMap activeValueMap = this.getElement().getActiveValueMap(config);
        if (activeValueMap != null) {
            Expression caseExpr = ExpressionUtils.getCaseExpression(activeValueMap, this.getElement().getValues());
            return resolvedSettingIds.containsAll(ExpressionUtils.getUsedSettings(config, caseExpr)) && resolvedSettingIds.containsAll(ExpressionUtils.getUsedSettings(config, activeValueMap.getExpression()));
        }
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean canWrite(@NonNull IClocksConfig config, @NonNull Collection<@NonNull String> resolvedSettingIds) throws UnsupportedOperationException {
        Expression caseExpr;
        ValueMap activeValueMap = this.getElement().getActiveValueMap(config);
        if (activeValueMap != null && (caseExpr = ExpressionUtils.getCaseExpression(activeValueMap, this.getElement().getValues())) != null) {
            DependencyContextWrapper dependencyContextWrapper = ExpressionUtils.getDependencyContextWrapper(caseExpr, config);
            caseExpr.resolve(dependencyContextWrapper);
            return resolvedSettingIds.containsAll(dependencyContextWrapper.getAllUsedSettings(config));
        }
        return true;
    }

    @Override
    public @NonNull Map<@NonNull ISetting, @NonNull SettingValue> getBitFieldsToWrite(@NonNull IClocksConfig config, @NonNull SettingValue value) throws UnsupportedOperationException {
        HashMap<@NonNull ISetting, @NonNull SettingValue> bitFieldsToWrite = new HashMap<ISetting, SettingValue>();
        ValueMap activeValueMap = this.getElement().getActiveValueMap(config);
        if (activeValueMap != null) {
            Range range;
            Object controlValue = value.getValue();
            LongValues bitFieldValues = activeValueMap.getBfFromUiValue(value.getUiValue());
            if (bitFieldValues == null && controlValue instanceof Frequency && (range = ClockSourceSetting.getRange((Frequency)controlValue, activeValueMap)) != null) {
                bitFieldValues = activeValueMap.getBfFromControlValue(range);
            }
            if (bitFieldValues == null) {
                throw new UnsupportedOperationException();
            }
            BitFieldElement @NonNull [] bitFields = activeValueMap.getBitFields();
            int i = 0;
            while (i < bitFields.length) {
                ISetting bitFieldSetting;
                BitFieldElement bitField = bitFields[i];
                if (bitField != null && (bitFieldSetting = SettingProvider.getBitFieldSetting(bitField, config.getMcu())) != null) {
                    SettingValue bfSettingValue = bitFieldSetting.parseBfValue(bitFieldValues.getValue(i), config);
                    assert (bfSettingValue != null);
                    bitFieldsToWrite.put(bitFieldSetting, bfSettingValue);
                }
                ++i;
            }
        }
        return bitFieldsToWrite;
    }

    @Override
    public @NonNull Collection<@NonNull String> getUsedBitFields() {
        HashSet<@NonNull String> usedBitFields = new HashSet<String>();
        Set<Map.Entry<@NonNull Expression, @NonNull ValueMap>> valueEntries = this.getElement().getValues().entrySet();
        for (Map.Entry<Expression, ValueMap> valueEntry : valueEntries) {
            valueEntry.getKey().getBitFields().forEach(x -> {
                boolean bl = usedBitFields.add(BitFieldProvider.createBitFieldId((String)x.getRegisterName(), (String)x.getRegisterName()));
            });
            List<@NonNull BitFieldElement> bitFields = Arrays.asList(valueEntry.getValue().getBitFields());
            bitFields.forEach(x -> {
                boolean bl = usedBitFields.add(x.getID());
            });
        }
        return usedBitFields;
    }

    @Override
    public @NonNull Collection<@NonNull ISetting> getReadOnlySettings(@NonNull IClocksConfig config) {
        ValueMap activeValueMap = this.getElement().getActiveValueMap(config);
        Set<Map.Entry<Expression, ValueMap>> valueEntries = this.getElement().getValues().entrySet();
        if (activeValueMap != null) {
            for (Map.Entry<Expression, ValueMap> valueEntry : valueEntries) {
                Expression expression = valueEntry.getKey();
                if (!valueEntry.getValue().equals(activeValueMap) || expression == null) continue;
                return ExpressionUtils.getRelatedSettings(expression, config.getMcu());
            }
        }
        return new ArrayList<ISetting>();
    }

    @Override
    public boolean shouldBeSaved(@NonNull IClocksConfig currentConfig) {
        SettingValue currentValue = currentConfig.getSettingsConfig().getSettingValue(this);
        if (currentValue.isN_A()) {
            return this.isLockDifferent(currentConfig, currentConfig.getMcu().getDefaultConfig()) || this.isUserEnableDifferent(currentConfig, currentConfig.getMcu().getDefaultConfig());
        }
        return super.settingShouldBeSaved(currentConfig);
    }

    @Override
    public boolean isFindNearValueSupported() {
        return false;
    }
}

