/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.parser;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XsdValidationHandler
implements ErrorHandler {
    @NonNull
    private Logger logger = LogManager.getLogger(XsdValidationHandler.class);
    private boolean valid = true;
    private boolean errorless = true;
    @NonNull
    protected String fileName;

    public XsdValidationHandler(@NonNull Logger logger, @NonNull String fileName) {
        this.logger = logger;
        this.fileName = fileName;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.logger.log(Level.FINE, this.makeMessage(e));
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.logger.log(Level.INFO, this.makeMessage(e));
        this.valid = false;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.logger.log(Level.SEVERE, this.makeMessage(e));
        this.valid = false;
        this.errorless = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isErrorless() {
        return this.errorless;
    }

    protected @NonNull String makeMessage(SAXParseException e) {
        return "[" + this.fileName + ", " + e.getLineNumber() + "]" + " " + e.getMessage();
    }
}

