/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.model;

import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyUnit;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.Objects;
import java.util.logging.Logger;

public class Range {
    @NonNull
    public static final FrequencyUnit FREQUENCY_UNIT = FrequencyUnit.HERTZ;
    @NonNull
    final BigRational min;
    @NonNull
    final BigRational max;
    @Nullable
    BigRational step;
    boolean isFrequency;
    @NonNull
    private String description;
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(Range.class);

    public Range(@NonNull BigRational min, @NonNull BigRational max, boolean frequency, @NonNull String description) {
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException("Minimum must be lower than or equal to maximum");
        }
        this.min = min;
        this.max = max;
        this.isFrequency = frequency;
        this.description = description;
    }

    public Range(@NonNull BigRational min, @NonNull BigRational max) {
        this(min, max, false);
    }

    public Range(@NonNull BigRational min, @NonNull BigRational max, boolean frequency) {
        this(min, max, frequency, "");
    }

    public Range(int min, int max, boolean frequency) {
        this(new BigRational(min), new BigRational(max), frequency);
    }

    public Range(int min, int max) {
        this(new BigRational(min), new BigRational(max));
    }

    public Range(long min, long max, boolean frequency) {
        this(new BigRational(min), new BigRational(max), frequency);
    }

    public Range(long min, long max) {
        this(new BigRational(min), new BigRational(max));
    }

    public Range(@NonNull String min, @NonNull String max, @NonNull String description) {
        this(Converter.toHertz(Frequency.parseNonNull((String)min)), Converter.toHertz(Frequency.parseNonNull((String)max)), true, description);
    }

    public boolean isFrequency() {
        return this.isFrequency;
    }

    public @NonNull BigRational getMin() {
        return this.min;
    }

    public @NonNull BigRational getMax() {
        return this.max;
    }

    public @NonNull BigRational getStep() {
        return this.step != null ? this.step : BigRational.ONE;
    }

    public void setStep(@NonNull BigRational step) {
        if (this.step == null) {
            this.step = step;
        } else {
            LOGGER.warning("Step have been already set. Can not set the step more then once.");
        }
    }

    public void setDescription(@NonNull String description) {
        this.description = description;
    }

    public @NonNull String getDescription() {
        return this.description;
    }

    public boolean isInRange(BigRational num) {
        return this.min.compareTo(num) <= 0 && this.max.compareTo(num) >= 0;
    }

    public @Nullable BigInteger getSize() {
        BigRational locStep = this.step;
        if (locStep == null) {
            return null;
        }
        return this.max.subtract(this.min).divide(locStep).add(1).toBigInteger();
    }

    public boolean isFrequencyInRange(@NonNull Frequency freq) {
        BigRational num = Converter.toHertz(freq);
        return this.isFrequency() && this.min.compareTo(num) <= 0 && this.max.compareTo(num) >= 0;
    }

    public boolean isFixed() {
        return this.min.compareTo(this.max) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.isFrequency, this.max, this.min, this.step);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return this.isFrequency == other.isFrequency && Objects.equals(this.max, other.max) && Objects.equals(this.min, other.min) && Objects.equals(this.step, other.step);
    }

    public String toString() {
        String result;
        if (this.isFrequency) {
            Frequency minFreq = Converter.toNormalizedFrequency(this.min);
            Frequency maxFreq = Converter.toNormalizedFrequency(this.max);
            result = this.isFixed() ? minFreq.toString() : "[min=" + minFreq.toString() + ", max=" + maxFreq.toString() + "]";
        } else {
            result = this.isFixed() ? this.min.toString() : "[min=" + this.min.toString() + ", max=" + this.max.toString() + "]";
        }
        return result;
    }
}

