/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.model;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.ErrorHelper;
import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.dependencies.OrderedSettingValuesResolver;
import com.nxp.swtools.clocks.data.dependencies.SettingResolverResult;
import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.ClockSelect;
import com.nxp.swtools.clocks.data.elements.ComputationalModel;
import com.nxp.swtools.clocks.data.elements.FnPll;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.Pin;
import com.nxp.swtools.clocks.data.elements.SettingIdResolver;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.elements.Splitter;
import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.model.SettingsDB;
import com.nxp.swtools.clocks.data.settings.AGeneralSetting;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.BitFieldSetting;
import com.nxp.swtools.clocks.data.settings.ClockOutputSetting;
import com.nxp.swtools.clocks.data.settings.ClockSourceSetting;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.GlobalConfigElementSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.LocalConfigElementSetting;
import com.nxp.swtools.clocks.data.settings.OutputFrequencySetting;
import com.nxp.swtools.clocks.data.settings.PowerModeSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.model.ClockGeneratorRational;
import com.nxp.swtools.clocks.model.Consumer;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksIdValue;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksOutput;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksSource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ClocksConfig
implements IClocksConfig {
    private static final Logger LOGGER = LogManager.getLogger(ClocksConfig.class);
    @NonNull
    private final SettingsConfig settingsConfig;
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull List<@NonNull IClockElement>> paths = new HashMap<String, List<IClockElement>>();
    @NonNull
    private @NonNull Collection<@NonNull ClocksProblem> problems = new LinkedHashSet<ClocksProblem>();
    @Nullable
    private String errorText;
    @NonNull
    private String name = "";
    @NonNull
    private String description = "";
    @NonNull
    private String idPrefix = "";
    @Nullable
    private ComputationalModel model;
    @NonNull
    private IMcu mcu;
    @NonNull
    private final @NonNull Set<@NonNull String> elementsDisabledByDefault = new HashSet<String>();
    @NonNull
    private StorageClocksConfiguration storageConfig;
    @Nullable
    private IClocksProfile profile;
    private boolean calledFromDefaultInit;
    private boolean prefixUserDefined;
    private boolean isImportingBits;

    public ClocksConfig(@NonNull SettingsConfig settingsConfig, @NonNull IMcu mcu) {
        this.settingsConfig = settingsConfig;
        this.mcu = mcu;
        this.storageConfig = new StorageClocksConfiguration();
    }

    @Override
    public void setModel(@NonNull ComputationalModel model) {
        this.model = model;
        this.mcu = model.getMcu();
    }

    @Override
    public void setSettingValue(@NonNull ISetting setting, @NonNull SettingValue value, boolean recompute, boolean lock) {
        boolean change = false;
        SettingValue oldValue = this.settingsConfig.getSettingValue(setting);
        if (!oldValue.equals(value)) {
            ISetting powerSetting;
            SettingValue currentPowerMode;
            String text;
            List<SettingValue> values;
            this.settingsConfig.setSettingValue(setting, value);
            if (setting instanceof LocalConfigElementSetting) {
                values = setting.getValues(this);
                if (values != null && !values.contains(value)) {
                    text = UtilsText.safeString((String)MessageFormat.format(Messages.get().ClocksConfig_InvalidValueFor, setting.getName(), value.getUiValue()));
                    this.addError(setting.getElement().getID(), text, ClocksProblem.Type.LOCAL);
                }
            } else if (setting instanceof GlobalConfigElementSetting && (values = setting.getValues(this)) != null && !values.contains(value)) {
                text = UtilsText.safeString((String)MessageFormat.format(Messages.get().ClocksConfig_InvalidValueFor, setting.getName(), value.getUiValue()));
                this.addError(setting.getElement().getID(), text, ClocksProblem.Type.GLOBAL);
            }
            if ((currentPowerMode = SettingProvider.getValueBySettingId("powerMode", this.mcu, this.settingsConfig)) != null && (powerSetting = SettingProvider.getPowerModeSpecificSettingById(setting.getId(), currentPowerMode.getUiValue(), this.mcu)) != null) {
                this.settingsConfig.setSettingValue(powerSetting, value);
                this.settingsConfig.lockSetting(powerSetting);
            }
            change = true;
        }
        if (lock) {
            LockState lockState = this.settingsConfig.getLockState(setting);
            if (lockState != null) {
                if (!lockState.getValue().equals(value)) {
                    lockState = new LockState(lockState, value);
                    this.settingsConfig.setLockState(setting, lockState);
                    change = true;
                }
            } else {
                this.lockSetting(setting);
                change = true;
            }
        }
        if (change && setting instanceof PowerModeSetting) {
            String powerModeValue = value.getUiValue();
            this.mcu.getSettings().getPowerModeSpecificAllSettings().stream().filter(x -> Objects.equals(x.getPowerMode(), powerModeValue)).forEach(x -> {
                String settingID = UtilsText.safeString((String)x.getId().replaceFirst(String.valueOf(powerModeValue) + ":", ""));
                ISetting settingToChange = SettingProvider.getSettingById(settingID, this.mcu);
                if (settingToChange != null) {
                    this.setSettingValue(settingToChange, this.settingsConfig.getSettingValue((ISetting)x), false, this.isLocked((ISetting)x));
                    if (settingToChange.isUserEnableable()) {
                        this.settingsConfig.setUserEnabled(settingToChange, this.settingsConfig.isUserEnabled((ISetting)x));
                    }
                }
            });
        }
        if (recompute && change) {
            this.recompute(setting);
        }
    }

    @Override
    public boolean trySetSettingValue(@NonNull OutputFrequencySetting setting, @NonNull SettingValue value, boolean recompute, boolean lock) {
        if (!setting.isEnabled(this)) {
            return false;
        }
        boolean canSet = true;
        SettingValue oldValue = this.settingsConfig.getSettingValue(setting);
        LockState lockState = this.settingsConfig.getLockState(setting);
        if (!this.canChangeOutput(setting)) {
            canSet = false;
        } else {
            this.setSettingValue(setting, value, recompute, lock);
            if (!this.getProblems().isEmpty()) {
                canSet = false;
                this.setSettingValue(setting, oldValue, true, lock);
            }
            if (lockState != null && !canSet) {
                this.settingsConfig.setLockState(setting, lockState);
            } else {
                this.unlockSetting(setting, false);
            }
        }
        return canSet;
    }

    @Override
    public boolean isMainSettingLocked(@NonNull IElement element) {
        if (element instanceof IClockElement) {
            ISetting mainSetting = ((IClockElement)element).getMainSetting();
            return mainSetting != null && this.isLocked(mainSetting);
        }
        return false;
    }

    @Override
    public void recomputeWithLock(@NonNull ISetting setting) {
        this.recomputeWithLock(setting, null);
    }

    @Override
    public void recomputeWithLock(@NonNull ISetting setting, @Nullable BigRational accuracy) {
        LockState prevLockState = this.settingsConfig.getLockState(setting);
        this.settingsConfig.lockSetting(setting);
        if (accuracy != null) {
            this.settingsConfig.changeLockAccuracy(setting, accuracy);
        }
        this.recompute(setting);
        this.restoreLockState(setting, prevLockState);
    }

    private void clearErrors() {
        this.settingsConfig.clearInvalid();
        this.problems.clear();
        this.errorText = null;
    }

    @Override
    public void recompute(boolean auto, @Nullable ISetting prioritizedSetting) {
        this.recompute(auto, prioritizedSetting, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recompute(boolean forceAuto, @Nullable ISetting prioritizedSetting, @Nullable Map<@NonNull ISetting, @NonNull StorageClocksIdValue> storageValues) {
        ComputationalModel compModel;
        long recomputeStart = System.nanoTime();
        this.clearErrors();
        this.settingsConfig.clearChanges();
        this.elementsDisabledByDefault.clear();
        this.settingsConfig.clearNonEditableSettings();
        OrderedSettingValuesResolver resolver = new OrderedSettingValuesResolver(this);
        resolver.resolve(prioritizedSetting, true, storageValues);
        ComputationalModel computationalModel = compModel = this.getClocksModel();
        synchronized (computationalModel) {
            if (forceAuto || this.isSomeOutputLocked()) {
                this.autoCompute(compModel);
            } else {
                this.forwardCompute(compModel);
            }
        }
        SettingResolverResult result = resolver.resolve(prioritizedSetting, false);
        this.applyResoutionResult(result);
        this.collectElementConstraints();
        this.findInvalidSettings();
        this.collectErrorsOnPaths();
        this.findDisabledUnsatisfied();
        this.updateErrorStatus();
        ClocksConfig.logDuration("recompute", System.nanoTime() - recomputeStart);
        this.toStorageConfig();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void updateErrorStatus() {
        Map<ClocksProblem.Type, List<@NonNull ClocksProblem>> errorneous = this.problems.stream().filter(x -> x.getProblemLevel() == 2).collect(Collectors.groupingBy(ClocksProblem::getProblemType));
        List<@NonNull ClocksProblem> globalErrors = errorneous.get((Object)ClocksProblem.Type.GLOBAL);
        List<@NonNull ClocksProblem> localErrors = errorneous.get((Object)ClocksProblem.Type.LOCAL);
        List<@NonNull ClocksProblem> requirementErrors = errorneous.get((Object)ClocksProblem.Type.REQUIREMENT);
        Predicate<@NonNull Map.Entry> isOther = m -> !((ClocksProblem.Type)((Object)((Object)m.getKey()))).equals((Object)ClocksProblem.Type.GLOBAL) && !((ClocksProblem.Type)((Object)((Object)m.getKey()))).equals((Object)ClocksProblem.Type.LOCAL) && !((ClocksProblem.Type)((Object)((Object)m.getKey()))).equals((Object)ClocksProblem.Type.REQUIREMENT);
        @NonNull List others = (List)errorneous.entrySet().stream().filter(isOther).map(Map.Entry::getValue).collect(CollectorsUtils.toList());
        if (globalErrors != null && !globalErrors.isEmpty()) {
            this.errorText = MessageFormat.format(Messages.get().ClocksConfig_ConstraintsMustBeRepairedManually, this.elementsIdsToNames(ClocksConfig.extractElementIDs(globalErrors)));
        } else if (localErrors != null && !localErrors.isEmpty()) {
            this.errorText = MessageFormat.format(Messages.get().ClocksConfig_ConstraintsMustBeRepairedManually, this.elementsIdsToNames(ClocksConfig.extractElementIDs(localErrors)));
        } else if (requirementErrors != null && !requirementErrors.isEmpty()) {
            this.errorText = MessageFormat.format(Messages.get().ClocksConfig_RequirementsNotSatisfiable, this.elementsIdsToNames(ClocksConfig.extractElementIDs(requirementErrors)));
        } else if (!others.isEmpty()) {
            this.errorText = MessageFormat.format(Messages.get().ClocksConfig_InvalidSettingsOf, this.elementsIdsToNames(ClocksConfig.extractElementIDs((List)this.problems.stream().filter(x -> x.getProblemLevel() == 2).collect(CollectorsUtils.toList()))));
        }
    }

    private static @NonNull List<@NonNull String> extractElementIDs(@NonNull List<@NonNull ClocksProblem> problemList) {
        return (List)problemList.stream().map(ClocksProblem::getResource).distinct().collect(CollectorsUtils.toList());
    }

    private void applyResoutionResult(@NonNull SettingResolverResult result) {
        this.settingsConfig.setInvisivbleSettings(result.getInvisibles());
        result.getConflicts().forEach((x, y) -> {
            String text = MessageFormat.format(Messages.get().ClocksConfig_LockedValueInConflictWith, ClocksConfig.settingsToString(y));
            this.addError(x.getElement().getID(), UtilsText.safeString((String)text), ClocksProblem.Type.REQUIREMENT);
        });
    }

    private void findInvalidSettings() {
        for (ISetting setting : this.getMcu().getSettings().getAllConfigElementSettings()) {
            SettingValue settingValue;
            boolean softEnabled = setting.isEnabled(this);
            IElement element = setting.getElement();
            EnableSetting enableSetting = element.getEnableSetting();
            if (enableSetting != null) {
                EnableSetting.EnableType enableType = enableSetting.getEnableType(this);
                boolean bl = softEnabled = enableType == EnableSetting.EnableType.ENABLE || enableType == EnableSetting.EnableType.SOFT_DISABLE;
            }
            if (!softEnabled || setting.isValid(settingValue = this.settingsConfig.getSettingValue(setting), this)) continue;
            LockState lockState = this.settingsConfig.getLockState(setting);
            String uiValue = lockState != null ? lockState.getUiValue() : settingValue.getUiValue();
            String text = UtilsText.safeString((String)MessageFormat.format(Messages.get().ClocksConfig_InvalidValueFor, setting.getName(), uiValue));
            if (setting instanceof LocalConfigElementSetting) {
                this.addError(setting.getElement().getID(), text, ClocksProblem.Type.LOCAL);
                continue;
            }
            this.addError(setting.getElement().getID(), text, ClocksProblem.Type.GLOBAL);
        }
    }

    @Override
    public void recompute(@Nullable ISetting prioritizedSetting) {
        this.recompute(true, prioritizedSetting);
    }

    private void autoCompute(@NonNull ComputationalModel compModel) {
        Collection<@NonNull Object> erroneousBranches = Collections.emptyList();
        Set<@NonNull String> notFilledElements = compModel.fill(this, true).keySet();
        if (notFilledElements.isEmpty()) {
            Map<@NonNull String, EErrorType> errors = compModel.recomputeAuto();
            erroneousBranches = errors.keySet();
            this.loadFromModel(erroneousBranches);
        }
        this.clearErrors();
        this.forwardCompute(compModel);
        if (!erroneousBranches.isEmpty()) {
            this.addErrorsToLockedOutputs(erroneousBranches);
            this.addErrorsToLockedOutputFrequencySettings();
        }
    }

    private void collectElementConstraints() {
        this.collectClockElementConstraints();
        this.collectConfigElementsConstraints();
        this.collectComponentConstraints();
    }

    private void collectComponentConstraints() {
        for (IClockComponent component : this.mcu.getClockComponents().values()) {
            if (!component.isEnabled(this)) continue;
            List<@NonNull Constraint> violatedConstraints = component.evaluateConstraints(this);
            for (Constraint violatedConstraint : violatedConstraints) {
                this.createConstraintProblem(component.getID(), violatedConstraint, violatedConstraint.getDescription(), ClocksProblem.Type.SETTING);
            }
        }
    }

    private void collectClockElementConstraints() {
        for (IClockElement element : this.mcu.getAllElements().values()) {
            if (!element.isEnabledForModel(this)) continue;
            List<@NonNull Constraint> violatedConstraints = element.evaluateConstraints(this);
            for (Constraint violatedConstraint : violatedConstraints) {
                this.createConstraintProblem(element.getID(), violatedConstraint, violatedConstraint.getDescription(), ClocksProblem.Type.SETTING);
            }
        }
    }

    private void collectConfigElementsConstraints() {
        HashMap<@NonNull IConfigElement, @Nullable IClockElement> configElementsToEvaluate = new HashMap<IConfigElement, IClockElement>();
        for (IConfigElement iConfigElement : this.mcu.getAllGlobalConfigElements()) {
            configElementsToEvaluate.put(iConfigElement, null);
        }
        for (IClockElement iClockElement : this.mcu.getAllElements().values()) {
            if (!iClockElement.isEnabledForModel(this)) continue;
            List<@NonNull ISetting> localConfigElementSettings = iClockElement.getLocalConfigElementSettings();
            for (ISetting localConfigSetting : localConfigElementSettings) {
                IElement localConfigElement = localConfigSetting.getElement();
                if (!(localConfigElement instanceof IConfigElement)) continue;
                configElementsToEvaluate.put((IConfigElement)localConfigElement, iClockElement);
            }
        }
        for (Map.Entry entry : configElementsToEvaluate.entrySet()) {
            IConfigElement configElement = (IConfigElement)entry.getKey();
            IClockElement parentClockElement = (IClockElement)entry.getValue();
            for (Constraint constraint : configElement.getElementConstraints(this)) {
                if (constraint.isValid(this)) continue;
                if (parentClockElement != null) {
                    String message = MessageFormat.format(Messages.get().ClocksConfig_ErrorInNestedConfigElement, configElement.getName(), constraint.getDescription());
                    this.createConstraintProblem(configElement.getID(), constraint, message, ClocksProblem.Type.LOCAL);
                    continue;
                }
                this.createConstraintProblem(configElement.getID(), constraint, constraint.getDescription(), ClocksProblem.Type.GLOBAL);
            }
        }
    }

    private void collectErrorsOnPaths() {
        for (ClockOutput clockOutput : this.getOutputElements()) {
            ArrayList<@NonNull String> errorsOnPath = new ArrayList<String>();
            List<@NonNull IClockElement> path = Objects.requireNonNull(this.paths.get(clockOutput.getID()));
            for (IClockElement elementOnPath : path) {
                if (elementOnPath == clockOutput || elementOnPath.isValid(this)) continue;
                errorsOnPath.add(elementOnPath.getID());
            }
            errorsOnPath.remove(clockOutput.getID());
            if (!clockOutput.isEnabledForModel(this) || errorsOnPath.isEmpty()) continue;
            Collections.reverse(errorsOnPath);
            String errorMessage = MessageFormat.format(Messages.get().ClocksConfig_ErroneousElementsOnPathAre, String.join((CharSequence)", ", errorsOnPath));
            this.addWarning(clockOutput.getID(), errorMessage);
        }
    }

    private void findDisabledUnsatisfied() {
        for (ClockOutputSetting outputSetting : this.mcu.getSettings().getClockOutputs()) {
            LockState lockState;
            SettingValue outputValue = this.getSettingsConfig().getSettingValue(outputSetting);
            if (!outputValue.isN_A() || (lockState = this.getSettingsConfig().getLockState(outputSetting)) == null || lockState.getValue().isN_A()) continue;
            this.addError(outputSetting.getElement().getID(), Messages.get().ClocksConfig_NotPossibleToFulfillRequirements, ClocksProblem.Type.REQUIREMENT);
        }
    }

    private void addErrorsToLockedOutputs(@NonNull Collection<@NonNull String> branches) {
        Set<@NonNull ClockOutput> lockedOutputs = this.getLockedOutputElements();
        for (ClockOutput lockedClockOutput : lockedOutputs) {
            String sourceOfOutput = this.getInputIdFeeding(lockedClockOutput.getID());
            if (!branches.contains(sourceOfOutput)) continue;
            ISetting outFreqSetting = lockedClockOutput.getOutputFrequencySetting();
            BigRational accuracy = this.settingsConfig.getLockAccuracy(outFreqSetting);
            if (accuracy == null) {
                accuracy = BigRational.ZERO;
            }
            BigRational outFreq = Converter.toHertz((Frequency)this.settingsConfig.getSettingValue(outFreqSetting).getValue());
            LockState lockState = this.settingsConfig.getLockState(outFreqSetting);
            if (lockState == null) continue;
            BigRational reqOutFreq = Converter.toHertz((Frequency)lockState.getValue().getValue());
            if (reqOutFreq.compareTo(outFreq) < 0 ? reqOutFreq.multiply(BigRational.ONE.add(accuracy)).compareTo(outFreq) >= 0 : outFreq.multiply(BigRational.ONE.add(accuracy)).compareTo(reqOutFreq) >= 0) {
                this.addWarning(lockedClockOutput.getID(), Messages.get().ClocksConfig_NotPossibleToFulfillRequirementsWarning);
                continue;
            }
            this.addError(lockedClockOutput.getID(), Messages.get().ClocksConfig_NotPossibleToFulfillRequirements, ClocksProblem.Type.REQUIREMENT);
            this.settingsConfig.invalidate(outFreqSetting);
        }
    }

    private void addErrorsToLockedOutputFrequencySettings() {
        Set<@NonNull OutputFrequencySetting> lockedOutputs = this.getLockedOutputFrequencySettings();
        for (OutputFrequencySetting lockedClockOutput : lockedOutputs) {
            OutputFrequencySetting outFreqSetting = lockedClockOutput;
            BigRational accuracy = this.settingsConfig.getLockAccuracy(outFreqSetting);
            if (accuracy == null) {
                accuracy = BigRational.ZERO;
            }
            BigRational outFreq = Converter.toHertz((Frequency)this.settingsConfig.getSettingValue(outFreqSetting).getValue());
            LockState lockState = this.settingsConfig.getLockState(outFreqSetting);
            if (lockState == null) continue;
            BigRational reqOutFreq = Converter.toHertz((Frequency)lockState.getValue().getValue());
            if (reqOutFreq.compareTo(outFreq) < 0 ? reqOutFreq.multiply(BigRational.ONE.add(accuracy)).compareTo(outFreq) >= 0 : outFreq.multiply(BigRational.ONE.add(accuracy)).compareTo(reqOutFreq) >= 0) {
                this.addWarning(lockedClockOutput.getId(), Messages.get().ClocksConfig_NotPossibleToFulfillRequirementsWarning);
                continue;
            }
            this.addError(lockedClockOutput.getId(), Messages.get().ClocksConfig_NotPossibleToFulfillRequirements, ClocksProblem.Type.REQUIREMENT);
            this.settingsConfig.invalidate(outFreqSetting);
        }
    }

    @Override
    public void addError(@NonNull String element, @Nullable String message, @NonNull ClocksProblem.Type problemType) {
        this.createProblem(element, message, 2, problemType, null);
    }

    public void addErrorFromConstraint(@NonNull String element, @Nullable String message, @NonNull ClocksProblem.Type problemType, @NonNull Constraint constraint) {
        this.createConstraintProblem(element, constraint, message != null ? message : constraint.getDescription(), problemType);
    }

    @Override
    public void addWarning(@NonNull String element, @Nullable String message) {
        this.createProblem(element, message, 1, ClocksProblem.Type.OTHER, null);
    }

    public void addWarningFromConstraint(@NonNull String element, @Nullable String message, @NonNull Constraint constraint) {
        this.createConstraintProblem(element, constraint, message != null ? message : constraint.getDescription(), ClocksProblem.Type.OTHER);
    }

    private @NonNull ClocksProblem createProblem(@NonNull String elementID, @Nullable String message, int level, @NonNull ClocksProblem.Type problemType, @Nullable String constraintMessage) {
        String errorMessage = message;
        if (errorMessage == null || errorMessage.isEmpty()) {
            errorMessage = Messages.get().ClocksConfig_UnknownError;
        }
        String finalConstraintMessage = constraintMessage != null ? constraintMessage : errorMessage;
        ClocksProblem problem = new ClocksProblem(this, elementID, UtilsText.safeString((String)errorMessage), level, problemType, UtilsText.safeString((String)finalConstraintMessage));
        this.problems.add(problem);
        return problem;
    }

    private @NonNull ClocksProblem createConstraintProblem(@NonNull String elementID, @NonNull Constraint constraint, @NonNull String message, @NonNull ClocksProblem.Type problemType) {
        String resolvedMessage;
        int problemLevel = 2;
        switch (constraint.getLevel()) {
            case ERROR: {
                problemLevel = 2;
                break;
            }
            case WARNING: {
                problemLevel = 1;
                break;
            }
            default: {
                LOGGER.warning("Not recognized constraint problem level: " + (Object)((Object)constraint.getLevel()));
            }
        }
        String constraintToolTipMessage = resolvedMessage = SettingIdResolver.resolve(message, this.mcu);
        IClockElement relatedElement = this.getMcu().getClockElement(elementID);
        if (relatedElement != null) {
            int constraintIndex = this.getConstraintIndex(relatedElement.getElementConstraints(), constraint);
            if (constraintIndex != 0) {
                constraintToolTipMessage = String.valueOf(constraintToolTipMessage) + " (See constraint " + constraintIndex + ")";
            }
        } else if (this.getMcu().getAllGlobalConfigElements().stream().noneMatch(x -> elementID.equals(x.getID()))) {
            LOGGER.warning("Creating constraint problem for element '" + elementID + "', but no element with this ID found!");
        }
        return this.createProblem(elementID, resolvedMessage, problemLevel, problemType, constraintToolTipMessage);
    }

    private int getConstraintIndex(@NonNull List<@NonNull Constraint> constraints, @NonNull Constraint searchedConstraint) {
        int constraintIndex = 1;
        for (Constraint elementConstraint : constraints) {
            if (!elementConstraint.isApplicable(this)) continue;
            if (Objects.equals(elementConstraint, searchedConstraint)) {
                return constraintIndex;
            }
            ++constraintIndex;
        }
        return 0;
    }

    private void forwardCompute(@NonNull ComputationalModel compModel) {
        Level level = SWToolsProperties.isVerificationOn() ? Level.INFO : Level.FINE;
        LOGGER.log(level, "Performing forward-compute.");
        HashMap<@NonNull String, @NonNull String> errorsFound = new HashMap<String, String>(compModel.fill(this, false));
        errorsFound.putAll(compModel.recompute(this));
        HashSet<@NonNull K> errorElements = new HashSet(errorsFound.keySet());
        for (String string : errorElements) {
            IClockElement element = this.getMcu().getClockElement(string);
            if (element == null || element.isEnabledForModel(this)) continue;
            errorsFound.remove(string);
        }
        for (Map.Entry entry : errorsFound.entrySet()) {
            this.addError((String)entry.getKey(), (String)entry.getValue(), ClocksProblem.Type.SETTING);
        }
        this.loadFromModel();
        this.paths = compModel.loadPaths();
    }

    private @NonNull Map<@NonNull ClockOutput, @Nullable LockState> saveLockedOutputs() {
        HashMap<@NonNull ClockOutput, @Nullable LockState> lockedOutputValues = new HashMap<ClockOutput, LockState>();
        for (ClockOutput clockOutput : this.getLockedOutputElements()) {
            lockedOutputValues.put(clockOutput, this.settingsConfig.getLockState(clockOutput.getOutputFrequencySetting()));
        }
        return lockedOutputValues;
    }

    private void restoreLockedOutputs(@NonNull Map<@NonNull ClockOutput, @Nullable LockState> lockedOutputValues) {
        for (Map.Entry<ClockOutput, LockState> outputValueEntry : lockedOutputValues.entrySet()) {
            ClockOutput key = outputValueEntry.getKey();
            if (key == null) continue;
            ISetting setting = key.getOutputFrequencySetting();
            LockState lockState = outputValueEntry.getValue();
            this.restoreLockState(setting, lockState);
        }
    }

    private static void logDuration(@NonNull String methodName, long nanoTime) {
        Level level = SWToolsProperties.isVerificationOn() ? Level.INFO : Level.FINE;
        LOGGER.log(level, String.valueOf(methodName) + " finished in: " + nanoTime / 1000000L + " ms");
        if (SWToolsProperties.isVerificationOn() && nanoTime >= 300000000L) {
            LOGGER.warning("Recompute is executed for a long time (more than 300 ms).");
        }
    }

    private void loadFromModel() {
        this.loadFromModel(CollectionsUtils.emptySet());
    }

    private void loadFromModel(@NonNull Collection<@NonNull String> erroneousBranches) {
        Set<IClockElement> forbiddenElements = this.getElementsOnBranches(erroneousBranches);
        Collection<@NonNull IClockElement> elements = this.mcu.getAllElements().values();
        Map<@NonNull ClockOutput, @Nullable LockState> lockedOutputValues = this.saveLockedOutputs();
        elements.stream().filter(element -> !forbiddenElements.contains(element)).forEach(element -> element.configureConfig(this));
        this.invalidateInvalidFrequencies();
        this.restoreLockedOutputs(lockedOutputValues);
    }

    private @NonNull Set<@NonNull IClockElement> getElementsOnBranches(@NonNull Collection<@NonNull String> branches) {
        HashSet<@NonNull IClockElement> elementsOnBranches = new HashSet<IClockElement>();
        HashSet<@NonNull IClockElement> firstElements = new HashSet<IClockElement>();
        branches.forEach(x -> {
            boolean bl = CollectionsUtils.addIfNonNull((Object)this.mcu.getClockElement((String)x), (Collection)firstElements);
        });
        this.getAllSuccessorsRecursively(elementsOnBranches, firstElements);
        return elementsOnBranches;
    }

    private void getAllSuccessorsRecursively(Collection<@NonNull IClockElement> branchElements, Collection<@NonNull IClockElement> elementsToProcess) {
        for (IClockElement element : elementsToProcess) {
            if (element instanceof ClockSelect) {
                IClockElement predecessor;
                String activePredecessor = ((ClockSelect)element).getActivePredecessor(this);
                if (activePredecessor == null || (predecessor = this.mcu.getClockElement(activePredecessor)) == null || !branchElements.contains(predecessor)) continue;
                branchElements.add(element);
                this.getAllSuccessorsRecursively(branchElements, element.getSuccessors());
                continue;
            }
            branchElements.add(element);
            this.getAllSuccessorsRecursively(branchElements, element.getSuccessors());
        }
    }

    private void invalidateInvalidFrequencies() {
        for (ClockSourceSetting css : this.mcu.getSettings().getClockSources()) {
            this.invalidateInvalidFrequencies(css.getElement(), false, false);
        }
    }

    private void invalidateInvalidFrequencies(@NonNull IClockElement element, boolean force, boolean forceDisable) {
        ISetting outFSetting;
        boolean disable;
        boolean invalidate = force || !element.isValid(this);
        boolean bl = disable = forceDisable || element.isDisabled(this);
        if (disable) {
            outFSetting = element.getOutputFrequencySetting();
            this.settingsConfig.setSettingValue(outFSetting, SettingValue.FREQ_N_A);
            if (!element.isEnabledForModel(this)) {
                invalidate = false;
            }
        }
        if (invalidate) {
            outFSetting = element.getOutputFrequencySetting();
            this.settingsConfig.invalidate(outFSetting);
        }
        for (IClockElement successor : element.getSuccessors()) {
            if (successor instanceof ClockSelect) {
                boolean isSplitterSuccesorPredcessor;
                ClockSelect clockSelect = (ClockSelect)successor;
                String successorssPredcessorId = clockSelect.getActivePredecessor(this);
                Splitter splitter = element.getSplitter();
                boolean isSuccessorPredcessor = successorssPredcessorId == null || element.getID().equals(successorssPredcessorId);
                boolean bl2 = isSplitterSuccesorPredcessor = splitter != null && splitter.getID().equals(successorssPredcessorId);
                if (!isSuccessorPredcessor && !isSplitterSuccesorPredcessor) continue;
                this.invalidateInvalidFrequencies(successor, invalidate, disable);
                continue;
            }
            this.invalidateInvalidFrequencies(successor, invalidate, disable);
        }
    }

    private boolean isSomeOutputLocked() {
        for (ClockOutputSetting outputSetting : this.mcu.getSettings().getClockOutputs()) {
            if (!this.settingsConfig.isLocked(outputSetting)) continue;
            return true;
        }
        return false;
    }

    private @NonNull Set<@NonNull ClockOutput> getOutputElements() {
        HashSet<@NonNull ClockOutput> outputs = new HashSet<ClockOutput>();
        for (ClockOutputSetting outputSetting : this.mcu.getSettings().getClockOutputs()) {
            outputs.add(outputSetting.getClockOutput());
        }
        return outputs;
    }

    private @NonNull Set<@NonNull ClockOutput> getLockedOutputElements() {
        HashSet<@NonNull ClockOutput> outputs = new HashSet<ClockOutput>();
        for (ClockOutputSetting outputSetting : this.mcu.getSettings().getClockOutputs()) {
            if (!this.settingsConfig.isLocked(outputSetting)) continue;
            outputs.add(outputSetting.getClockOutput());
        }
        return outputs;
    }

    private @NonNull Set<@NonNull OutputFrequencySetting> getLockedOutputFrequencySettings() {
        HashSet<@NonNull OutputFrequencySetting> outputs = new HashSet<OutputFrequencySetting>();
        for (AGeneralSetting outputSetting : this.mcu.getSettings().getGeneralSettings()) {
            if (!(outputSetting instanceof OutputFrequencySetting) || !this.settingsConfig.isLocked(outputSetting)) continue;
            outputs.add((OutputFrequencySetting)outputSetting);
        }
        return outputs;
    }

    @Override
    public SettingsConfig getSettingsConfig() {
        return this.settingsConfig;
    }

    @Override
    public ClocksConfig clone(@NonNull ComputationalModel modelToUse) {
        SettingsConfig settingsClone = this.settingsConfig.clone();
        ClocksConfig copy = new ClocksConfig(settingsClone, this.mcu);
        copy.setModel(modelToUse);
        copy.paths.putAll(this.paths);
        ArrayList<@NonNull E> copyProblems = new ArrayList();
        this.problems.forEach(x -> {
            boolean bl = copyProblems.add(x.clone(copy));
        });
        copy.problems.addAll(copyProblems);
        copy.elementsDisabledByDefault.addAll(this.elementsDisabledByDefault);
        copy.name = this.name;
        copy.description = this.description;
        copy.calledFromDefaultInit = this.calledFromDefaultInit;
        copy.prefixUserDefined = this.prefixUserDefined;
        copy.idPrefix = this.idPrefix;
        copy.toStorageConfig();
        return copy;
    }

    @Override
    public List<@NonNull IClockElement> getPathTo(String elementId) {
        IClockElement element = this.mcu.getClockElement(elementId);
        if (element == null) {
            return Collections.emptyList();
        }
        for (List<IClockElement> list : this.paths.values()) {
            List<IClockElement> result;
            int elementIndex = list.indexOf(element);
            if (elementIndex < 0 || (result = list.subList(0, elementIndex + 1)) == null) continue;
            return CollectionsUtils.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    @Override
    public List<@NonNull IClockElement> getPathToOutput(String outputId) {
        List<@NonNull IClockElement> elementPaths = this.paths.get(outputId);
        if (elementPaths != null) {
            return CollectionsUtils.unmodifiableList(elementPaths);
        }
        return Collections.emptyList();
    }

    @Override
    public @NonNull Collection<@NonNull IClockElement> getOutputsFedBy(@NonNull String inputId) {
        ArrayList<@NonNull IClockElement> result = new ArrayList<IClockElement>();
        for (List<IClockElement> path : this.paths.values()) {
            if (path.isEmpty() || !path.get(0).getID().equals(inputId)) continue;
            IClockElement output = path.get(path.size() - 1);
            result.add(output);
        }
        return result;
    }

    @Override
    public @Nullable IClockElement getInputFeeding(@NonNull String elementId) {
        List<@NonNull IClockElement> path = this.getPathTo(elementId);
        if (!path.isEmpty()) {
            return path.get(0);
        }
        return null;
    }

    @Override
    public @NonNull Collection<@NonNull Collection<@NonNull IClockElement>> getAllOutputPaths() {
        Collection<List<IClockElement>> allPaths = this.paths.values();
        assert (allPaths != null);
        return CollectionsUtils.unmodifiableCollection(allPaths);
    }

    @Override
    public @Nullable String getErrorText() {
        return this.errorText;
    }

    @Override
    public @Nullable String getErrorsAsText(@NonNull String elementId) {
        return this.getProblemsOfElementAsText(elementId, 2);
    }

    @Override
    public @Nullable String getWarningsAsText(@NonNull String elementId) {
        return this.getProblemsOfElementAsText(elementId, 1);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable String getProblemsOfElementAsText(@NonNull String elementId, int level) {
        @NonNull @NonNull List problemsOfElement = (List)this.getProblemsOfElement(elementId, level).stream().map(ClocksProblem::getMessage).collect(CollectorsUtils.toList());
        if (problemsOfElement.isEmpty()) {
            return null;
        }
        return UtilsText.join((Collection)problemsOfElement, (String)"\n");
    }

    @Override
    public @NonNull List<@NonNull ClocksProblem> getProblemsOfElement(@NonNull String elementId, int level) {
        return (List)this.problems.stream().filter(x -> x.getResource().equals(elementId) && x.getProblemLevel() == level).collect(CollectorsUtils.toList());
    }

    @Override
    public @NonNull List<@NonNull ClocksProblem> getProblemsOfElement(@NonNull String elementId) {
        return (List)this.problems.stream().filter(x -> x.getResource().equals(elementId)).collect(CollectorsUtils.toList());
    }

    public @NonNull String elementsIdsToNames(@NonNull Collection<@NonNull String> elementsIds) {
        return ErrorHelper.elementsIdsToNames(elementsIds, this.mcu);
    }

    public static @NonNull String settingsToString(@NonNull Collection<@NonNull ISetting> settings) {
        return Text.collectionToString((Collection)settings.stream().map(ISetting::getName).collect(CollectorsUtils.toList()));
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull String getDescription() {
        return this.description;
    }

    @Override
    public void setName(@NonNull String name) {
        this.name = name;
        this.storageConfig.setName(name);
    }

    @Override
    public void setDescription(@NonNull String description) {
        this.description = description;
        this.storageConfig.setDescription(description);
    }

    @Override
    public void unlockSetting(@NonNull ISetting setting, boolean recompute) {
        this.settingsConfig.unlockSetting(setting);
        if (recompute) {
            this.recompute(null);
        }
    }

    @Override
    public void lockSetting(@NonNull ISetting setting) {
        this.settingsConfig.lockSettingIfNotLocked(setting);
    }

    @Override
    public boolean isLocked(@NonNull ISetting setting) {
        return this.settingsConfig.isLocked(setting);
    }

    private @NonNull StorageClocksConfiguration toStorageConfig() {
        StorageClocksConfiguration configuration = new StorageClocksConfiguration();
        configuration.setName(this.getName());
        configuration.setDescription(this.getDescription());
        Collection<@NonNull ClockOutputSetting> clockOutputs = this.mcu.getSettings().getClockOutputs();
        List<@NonNull StorageClocksIdValue> outputs = this.toStorageSettings(clockOutputs);
        Collections.sort(outputs, (value1, value2) -> value1.getId().compareTo(value2.getId()));
        configuration.setOutputs((List)CollectionsUtils.getInstancesOf(outputs, StorageClocksOutput.class).collect(CollectorsUtils.toList()));
        ArrayList<@NonNull ClockSourceSetting> clockSources = new ArrayList<ClockSourceSetting>(this.mcu.getSettings().getClockSources());
        clockSources.addAll(this.mcu.getSettings().getPowerModeSpecificClockSources());
        List<@NonNull StorageClocksIdValue> sources = this.toStorageSettings(clockSources);
        Collections.sort(sources, (value1, value2) -> value1.getId().compareTo(value2.getId()));
        configuration.setSources((List)CollectionsUtils.getInstancesOf(sources, StorageClocksSource.class).collect(CollectorsUtils.toList()));
        ArrayList<@NonNull AGlobalSetting> globalSettings = new ArrayList<AGlobalSetting>(this.mcu.getSettings().getGlobalSettings());
        Collections.sort(globalSettings, (setting1, setting2) -> setting1.getId().compareTo(setting2.getId()));
        ArrayList<@NonNull AGeneralSetting> generalSettings = new ArrayList<AGeneralSetting>(this.mcu.getSettings().getGeneralSettings());
        generalSettings.addAll(this.mcu.getSettings().getPowerModeSpecificSettings());
        Collections.sort(generalSettings, (setting1, setting2) -> setting1.getId().compareTo(setting2.getId()));
        ArrayList<@NonNull AGlobalSetting> otherSettings = new ArrayList<AGlobalSetting>(globalSettings);
        otherSettings.addAll(generalSettings);
        List<@NonNull StorageClocksIdValue> settings = this.toStorageSettings(otherSettings);
        configuration.setSettings(settings);
        configuration.setDependencies(this.getDependencies());
        configuration.setCalledFromInit(this.isCalledFromDefaultInit());
        configuration.setPrefixUserDefined(this.prefixUserDefined);
        configuration.setIdPrefix(this.prefixUserDefined ? this.idPrefix : "");
        this.storageConfig = configuration;
        return configuration;
    }

    private @NonNull List<@NonNull StorageClocksIdValue> toStorageSettings(@NonNull Collection<? extends @NonNull ISetting> settings) {
        ArrayList<@NonNull StorageClocksIdValue> storageVals = new ArrayList<StorageClocksIdValue>();
        for (ISetting iSetting : settings) {
            if (!iSetting.shouldBeSaved(this)) continue;
            StorageClocksIdValue storageVal = ClocksConfig.createStorageValue(iSetting, this.settingsConfig);
            storageVals.add(storageVal);
        }
        return storageVals;
    }

    private static @NonNull StorageClocksIdValue createStorageValue(@NonNull ISetting setting, @NonNull SettingsConfig settingsConfig) {
        StorageClocksIdValue storageVal = null;
        LockState lockState = settingsConfig.getLockState(setting);
        String value = setting.toString(lockState == null || setting.getElement() instanceof IConfigElement ? settingsConfig.getSettingValue(setting) : lockState.getValue());
        if (setting instanceof ClockOutputSetting) {
            StorageClocksOutput storageOutput = new StorageClocksOutput();
            BigRational currentAccuracy = settingsConfig.getLockAccuracy(setting);
            storageOutput.setAccuracy(setting.isUserLockable() && settingsConfig.isLocked(setting) && currentAccuracy != null ? currentAccuracy.toExactDecimalString() : "");
            storageVal = storageOutput;
        } else if (setting instanceof ClockSourceSetting) {
            StorageClocksSource storageSource = new StorageClocksSource();
            storageSource.setEnabled(setting.isUserEnableable() && settingsConfig.isUserEnabled(setting));
            String uiValue = settingsConfig.getSettingValue(setting).getUiValue();
            if (!uiValue.equals(value) && !uiValue.equals(SettingValue.FREQ_N_A.getUiValue())) {
                storageSource.setUiValue(uiValue);
            }
            storageVal = storageSource;
        } else {
            storageVal = new StorageClocksIdValue();
        }
        storageVal.setId(setting.getId());
        storageVal.setValue(value);
        storageVal.setLocked(setting.isUserLockable() && settingsConfig.isLocked(setting));
        return storageVal;
    }

    @Override
    public void changeLockAccuracy(@NonNull ISetting setting, @NonNull BigRational accuracy, boolean recompute) {
        this.settingsConfig.changeLockAccuracy(setting, accuracy);
        if (recompute) {
            this.recompute(setting);
        }
    }

    @Override
    public @NonNull IMcu getMcu() {
        return this.mcu;
    }

    @Override
    public void restoreLockState(@NonNull ISetting setting, @Nullable LockState lockState) {
        if (lockState != null) {
            this.settingsConfig.setLockState(setting, lockState);
        } else {
            this.unlockSetting(setting, false);
        }
    }

    @Override
    public boolean isDisabledByDefault(@NonNull IClockElement element) {
        return this.elementsDisabledByDefault.contains(element.getID());
    }

    @Override
    public void setDisabledByDefault(@NonNull IClockElement element) {
        this.elementsDisabledByDefault.add(element.getID());
    }

    @Override
    public void setEnabledByDefault(@NonNull IClockElement element) {
        this.elementsDisabledByDefault.remove(element.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable BigRational findAccuracyThatMeetsRequirement(@NonNull OutputFrequencySetting outputSetting) {
        ComputationalModel compModel;
        LockState prevLockState = this.settingsConfig.getLockState(outputSetting);
        this.lockSetting(outputSetting);
        BigRational accuracyFound = null;
        ComputationalModel computationalModel = compModel = this.getClocksModel();
        synchronized (computationalModel) {
            compModel.fill(this, true);
            IClockElement elementOfSetting = outputSetting.getElement();
            accuracyFound = compModel.findMatchingAccuracy(elementOfSetting);
        }
        this.restoreLockState(outputSetting, prevLockState);
        return accuracyFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @Nullable SettingValue findNearValue(@NonNull ISetting setting) {
        ComputationalModel compModel;
        SettingValue value = null;
        if (!(setting instanceof OutputFrequencySetting)) {
            String settingClassName = setting.getClass().getSimpleName();
            LOGGER.warning("Method is supported only for output frequency settings. Setting type: " + settingClassName);
            return value;
        }
        OutputFrequencySetting outputSetting = (OutputFrequencySetting)setting;
        ComputationalModel computationalModel = compModel = this.getClocksModel();
        synchronized (computationalModel) {
            this.checkConstraints(outputSetting, compModel);
            IClockElement elementOfSetting = outputSetting.getElement();
            if (elementOfSetting instanceof FnPll) {
                FnPll fnPll = (FnPll)elementOfSetting;
                boolean mulLocked = this.isLocked(fnPll.getDivSetting());
                boolean numLocked = this.isLocked(fnPll.getNumSetting());
                boolean denomLocked = this.isLocked(fnPll.getDenomSetting());
                LockState prevLockState = this.settingsConfig.getLockState(outputSetting);
                if (prevLockState == null) {
                    return null;
                }
                Frequency frequency = (Frequency)prevLockState.getValue().getValue();
                BigRational requiredFreq = Converter.toHertz(frequency);
                Node node = fnPll.getComputationNode(this);
                assert (node instanceof ClockGeneratorRational);
                ClockGeneratorRational fnPllnode = (ClockGeneratorRational)node;
                BigRational result = fnPllnode.findNearFrequency(requiredFreq, mulLocked, numLocked, denomLocked);
                Frequency resultFreq = Converter.toNormalizedFrequency(result);
                value = outputSetting.parseValue(resultFreq, this);
                if (value != null) {
                    prevLockState = new LockState(prevLockState, value);
                }
                this.restoreLockState(outputSetting, prevLockState);
                this.recompute(null);
            } else {
                Frequency frequency;
                BigRational accuracy = this.findAccuracyThatMeetsRequirement(outputSetting);
                if (accuracy == null) return value;
                LockState prevLockState = this.settingsConfig.getLockState(outputSetting);
                this.settingsConfig.lockSettingIfNotLocked(outputSetting);
                this.settingsConfig.changeLockAccuracy(outputSetting, accuracy);
                compModel.fill(this, true);
                String sourceOfOutput = this.getInputIdFeeding(elementOfSetting.getID());
                if (!compModel.recomputeAuto().containsKey(sourceOfOutput) && (frequency = elementOfSetting.getOutputFrequency(this)) != null && (value = outputSetting.parseValue(frequency, this)) != null) {
                    if (prevLockState != null) {
                        prevLockState = new LockState(prevLockState, value);
                    } else if (setting instanceof ClockSourceSetting) {
                        prevLockState = new LockState(outputSetting, value, SettingsConfig.DEFAULT_ACCURACY);
                    }
                }
                this.restoreLockState(outputSetting, prevLockState);
                this.recompute(null);
            }
            return value;
        }
    }

    private void checkConstraints(@NonNull OutputFrequencySetting setting, @NonNull ComputationalModel localModel) {
        Frequency minFreq;
        Frequency maxFreq;
        String textValue;
        IClockElement settingElement = setting.getElement();
        Node settingNode = localModel.getNode(settingElement.getID());
        if (settingNode == null) {
            return;
        }
        BigRational maxValue = settingNode instanceof Consumer ? settingNode.getMaxInputFreq() : settingNode.getMaxOutputFreq();
        BigRational minValue = settingNode instanceof Consumer ? settingNode.getMinInputFreq() : settingNode.getMinOutputFreq();
        LockState lockState = this.settingsConfig.getLockState(setting);
        String string = textValue = lockState != null ? lockState.getValue().getValue().toString() : null;
        if (textValue == null) {
            LOGGER.warning("Tried to find near value for unlocked setting");
            return;
        }
        Frequency setFreq = Frequency.parseNonNull((String)textValue);
        if (maxValue != null && setFreq.compareTo(maxFreq = Converter.toNormalizedFrequency(maxValue)) == 1) {
            this.setSettingValue(setting, new SettingValue(maxFreq), true, true);
        }
        if (minValue != null && setFreq.compareTo(minFreq = Converter.toNormalizedFrequency(minValue)) == -1) {
            this.setSettingValue(setting, new SettingValue(minFreq), true, true);
        }
    }

    @Override
    public @Nullable String getInputIdFeeding(@NonNull String elementId) {
        IClockElement sourceOfOutput = this.getInputFeeding(elementId);
        return sourceOfOutput == null ? null : sourceOfOutput.getID();
    }

    @Override
    public @NonNull ComputationalModel getClocksModel() {
        ComputationalModel compModel = this.model;
        if (compModel == null) {
            throw new IllegalStateException("Computational model has not been set yet. Use ClocksConfig#setModel.");
        }
        return compModel;
    }

    @Override
    public StorageClocksConfiguration getStorageConfig() {
        return this.storageConfig;
    }

    @Override
    public @NonNull List<@NonNull IDependency> getDependencies() {
        ArrayList<@NonNull IDependency> dependencies = new ArrayList<IDependency>(this.getPinDependencies());
        return dependencies;
    }

    private @NonNull List<@NonNull IDependency> getPinDependencies() {
        ArrayList<@NonNull IDependency> dependencies = new ArrayList<IDependency>();
        for (Pin pin : this.mcu.getAllPins().values()) {
            if (!pin.isEnabled(this)) continue;
            dependencies.add((IDependency)this.createRoutedDependency(pin));
            if (pin.getDirection() == Pin.Direction.UNDEFINED) continue;
            dependencies.add((IDependency)this.createDirectionDependency(pin));
        }
        return dependencies;
    }

    private @NonNull StorageDependency createDirectionDependency(@NonNull Pin pin) {
        return pin.createDirectionDependency(this);
    }

    private @NonNull StorageDependency createRoutedDependency(@NonNull Pin pin) {
        return pin.createRoutedDependency(this);
    }

    @Override
    public boolean isSomeSettingLocked() {
        SettingsDB settingsDB = this.mcu.getSettings();
        for (ISetting setting : settingsDB.getAllSettings()) {
            if (!setting.isUserLockable() || !this.isLocked(setting)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull Collection<@NonNull ClocksProblem> getProblems() {
        return CollectionsUtils.unmodifiableCollection(this.problems);
    }

    @Override
    public @Nullable IClocksProfile getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(@Nullable IClocksProfile profile) {
        this.profile = profile;
    }

    @Override
    public boolean isCalledFromDefaultInit() {
        return this.calledFromDefaultInit;
    }

    @Override
    public void setCalledFromDefaultInit(boolean called) {
        this.calledFromDefaultInit = called;
        this.storageConfig.setCalledFromInit(called);
    }

    public @Nullable String getError() {
        return this.errorText;
    }

    public @Nullable String getWarning() {
        return null;
    }

    public boolean isRemovable() {
        IClocksProfile profileLoc = this.getProfile();
        return profileLoc == null ? true : profileLoc.getConfigs().size() > 1;
    }

    public boolean canBeCalledFromDefaultInit() {
        return true;
    }

    public String getUiName() {
        return this.name;
    }

    public @NonNull String getSettingsSummary() {
        StringJoiner info = new StringJoiner("\n<br/>");
        Collection<@NonNull AGlobalSetting> globalSettings = this.mcu.getSettings().getGlobalSettings();
        globalSettings.forEach(x -> {
            StringJoiner stringJoiner2 = info.add(String.valueOf(x.getName()) + ": " + this.settingsConfig.getSettingValue((ISetting)x).getUiValue());
        });
        return UtilsText.safeToString((Object)info);
    }

    @Override
    public boolean canChangeOutput(ISetting setting) {
        IElement element = setting.getElement();
        if (this.isMainSettingLocked(element)) {
            return false;
        }
        if (element instanceof AClockElement) {
            FnPll fnPll;
            List<@NonNull IClockElement> internals = ((AClockElement)element).getInternalElements();
            if (internals != null) {
                for (IClockElement internal : internals) {
                    if (!this.isMainSettingLocked(internal)) continue;
                    return false;
                }
            }
            if (element instanceof FnPll && (this.isLocked((fnPll = (FnPll)element).getDivSetting()) || this.isLocked(fnPll.getDenomSetting()) || this.isLocked(fnPll.getNumSetting()))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void lockBitFieldDependencies() {
        this.modifyLocksOnBitfieldDependencies(true);
    }

    @Override
    public void unlockBitFieldDependencies() {
        this.modifyLocksOnBitfieldDependencies(false);
    }

    private void modifyLocksOnBitfieldDependencies(boolean lock) {
        Collection<@NonNull ISetting> allSettings = this.mcu.getSettings().getAllSettings();
        Set lockedBitfields = this.settingsConfig.getLockedSettings().keySet().stream().filter(x -> x instanceof BitFieldSetting).collect(Collectors.toSet());
        block0: for (ISetting setting : allSettings) {
            if (!setting.isUserLockable()) continue;
            Collection<String> influencedIds = setting.getInfluencedSettings(this.mcu);
            for (ISetting lockedBitfield : lockedBitfields) {
                if (!influencedIds.contains(lockedBitfield.getId())) continue;
                if (lock) {
                    this.lockSetting(setting);
                    continue block0;
                }
                this.unlockSetting(setting, false);
                continue block0;
            }
        }
    }

    public String toString() {
        return "ClocksConfig [name=" + this.name + "]";
    }

    @Override
    public void removeProblems(@NonNull Collection<@NonNull ClocksProblem> problemsToRemove) {
        this.problems.removeAll(problemsToRemove);
        if (this.problems.isEmpty()) {
            this.clearErrors();
        }
    }

    @Override
    public void recompute(boolean forceAuto, @Nullable ISetting prioritizedSetting, boolean isImporting) {
        this.isImportingBits = isImporting;
        this.recompute(forceAuto, prioritizedSetting, null);
        this.isImportingBits = false;
    }

    @Override
    public boolean isImporting() {
        return this.isImportingBits;
    }

    @Override
    public void enableElementsOnPath(ClockOutput output) {
        List<IClockElement> pathElements = this.getPathToOutput(output.getID());
        for (IClockElement element : pathElements) {
            this.tryEnable(element);
        }
    }

    private void tryEnable(IClockElement element) {
        List<IClockElement> internals = element.getInternalElements();
        if (internals != null) {
            for (IClockElement internal : internals) {
                this.tryEnable(internal);
            }
        }
        if (!element.isEnabledForModel(this)) {
            ISetting mainSetting = element.getMainSetting();
            if (mainSetting == null) {
                return;
            }
            SettingValue settingValue = element.getEnableValue(this);
            if (settingValue != null) {
                this.setSettingValue(mainSetting, settingValue, true, false);
            }
        }
    }

    @Override
    public @NonNull String getIdPrefix() {
        return this.idPrefix;
    }

    @Override
    public void setIdPrefix(@NonNull String idPrefix) {
        this.idPrefix = idPrefix;
        this.storageConfig.setIdPrefix(this.isPrefixUserDefined() ? idPrefix : "");
    }

    @Override
    public boolean isPrefixUserDefined() {
        return this.prefixUserDefined;
    }

    @Override
    public void setPrefixUserDefined(boolean prefixUserDefined) {
        this.prefixUserDefined = prefixUserDefined;
        this.storageConfig.setPrefixUserDefined(prefixUserDefined);
    }
}

