/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.ui.viewers;

import com.nxp.s32ds.cle.uct.core.Messages;
import com.nxp.s32ds.cle.uct.internal.core.ProjectPropertiesManager;
import com.nxp.s32ds.cle.uct.internal.core.SDKProjectHandler;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentTypeEnum;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.s32ds.cle.uct.ui.viewers.ComponentPeripheralsDialog;
import com.nxp.s32ds.cle.uct.ui.viewers.ComponentsDialog;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.sdkproject.ToolchainProjectFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class ManageComponents
extends AbstractHandler {
    private static final Logger LOGGER = LogManager.getLogger(ManageComponents.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.manageComponents(HandlerUtil.getActiveShell((ExecutionEvent)event), this.getProject(event));
        return null;
    }

    private void manageComponents(Shell shell, IProject project) {
        if (project != null) {
            ComponentsDialog dialog = new ComponentsDialog(shell, project);
            if (dialog.open() == 0) {
                this.handleResult(project, dialog);
            }
        } else {
            MessageDialog.openWarning((Shell)shell, (String)Messages.ComponentsDialog_ManageSDKComp, (String)Messages.ComponentsDialog_NoProjectFound);
        }
    }

    private IProject getProject(ExecutionEvent event) {
        String currentPerspective = UtilsText.safeString((String)PerspectivesHelper.getActivePerspectiveId());
        if (SwToolsProductConfiguration.getRegisteredProductForPerspective((String)currentPerspective) == null) {
            return this.getProjectFromSelection(event);
        }
        return ToolchainProjectFactory.getEclipseProjectFromToolchainProject();
    }

    private IProject getProjectFromSelection(ExecutionEvent event) {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection == null || currentSelection.isEmpty()) {
            currentSelection = this.getEditorLinkedSelection(HandlerUtil.getActiveEditorInput((ExecutionEvent)event));
        }
        return this.findProject(currentSelection);
    }

    private ISelection getEditorLinkedSelection(IEditorInput activeEditorInput) {
        if (activeEditorInput instanceof FileEditorInput) {
            IProject project = ((FileEditorInput)activeEditorInput).getFile().getProject();
            return new StructuredSelection((Object)project);
        }
        return null;
    }

    private IProject findProject(ISelection selection) {
        IResource resource;
        Object obj;
        if (selection != null && !selection.isEmpty() && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && (resource = (IResource)Adapters.adapt((Object)obj, IResource.class)) != null) {
            return resource.getProject();
        }
        return null;
    }

    private void handleResult(IProject project, ComponentsDialog dialog) {
        List<ComponentType> components = dialog.getResult();
        List<ComponentType> projectComponents = dialog.getProjectComponents();
        List<ComponentTypeEnum> availableTypes = dialog.getAVAILABLE_TYPES();
        if (projectComponents != null) {
            try {
                SDKProjectHandler handler = new SDKProjectHandler(project);
                ISDKManifest manifestInst = dialog.getManifest();
                LinkedList<String> addIds = new LinkedList<String>();
                List<String> remIds = new ArrayList<String>();
                ArrayList<ComponentType> addComponents = new ArrayList<ComponentType>(components);
                addComponents.removeAll(projectComponents);
                LinkedList compDependencies = new LinkedList();
                for (ComponentType component : addComponents) {
                    if (manifestInst == null) continue;
                    manifestInst.getDependencies(component, compDependencies);
                }
                compDependencies.forEach(comp -> {
                    boolean bl = addIds.add(comp.getId());
                });
                addComponents.forEach(comp -> {
                    boolean bl = addIds.add(comp.getId());
                });
                for (ComponentType component : projectComponents) {
                    if (!component.isUserVisible() || components.contains(component) || !availableTypes.contains(component.getType())) continue;
                    remIds.add(component.getId());
                }
                remIds = this.scanDependencies(remIds, addComponents, projectComponents, dialog.getManifest());
                boolean componentsRemoved = handler.remComponent(remIds, false);
                boolean componentsAdded = handler.addComponent(addIds, dialog.isStandalone(), dialog.isOtherFiles(), true, false);
                boolean syncWithPeriph = ProjectPropertiesManager.getSyncWithPeriphToolPreferencesStatus((IProject)project);
                if (syncWithPeriph && project.equals((Object)ToolchainProjectFactory.getEclipseProjectFromToolchainProject())) {
                    if (componentsRemoved) {
                        this.removePeripheralComponents(project, remIds);
                    }
                    if (componentsAdded) {
                        this.addPeripheralComponents(project, addIds);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private boolean isCMSIS(ComponentType component) {
        return component.getType().equals((Object)ComponentTypeEnum.CMSIS) && component.getId().equals("CMSIS_Include") || component.getType().equals((Object)ComponentTypeEnum.CMSIS_INCLUDE) || component.getId().equals("platform.Include_common");
    }

    private List<String> scanDependencies(List<String> remIds, List<ComponentType> addComponents, List<ComponentType> projectComponents, ISDKManifest manifest) {
        ArrayList<String> ids = new ArrayList<String>();
        HashMap<ComponentType, Integer> counts = new HashMap<ComponentType, Integer>();
        for (ComponentType component : projectComponents) {
            if (remIds.contains(component.getId()) || !component.isUserVisible() || this.isCMSIS(component)) continue;
            this.addDependencies(remIds, manifest, counts, component, 1);
        }
        for (ComponentType component : addComponents) {
            if (remIds.contains(component.getId()) || this.isCMSIS(component)) continue;
            this.addDependencies(remIds, manifest, counts, component, 1);
        }
        for (String id : remIds) {
            if (!ids.contains(id)) {
                ids.add(id);
            }
            List components = manifest.getComponentsById(id, true);
            ArrayList dependencies = new ArrayList();
            for (ComponentType component : components) {
                try {
                    manifest.getDependencies(component, dependencies);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            for (ComponentType component : dependencies) {
                if (this.isCMSIS(component) || counts.containsKey(component) && (Integer)counts.get(component) > 1 || ids.contains(component.getId())) continue;
                ids.add(component.getId());
            }
        }
        return ids;
    }

    private void addDependencies(List<String> remIds, ISDKManifest manifest, Map<ComponentType, Integer> counts, ComponentType component, int initCount) {
        if (!remIds.contains(component.getId())) {
            Integer value = initCount;
            if (counts.containsKey(component)) {
                value = counts.get(component);
                value = value + 1;
            }
            if (component.isUserVisible()) {
                value = value + 1;
            }
            counts.put(component, value);
        }
        ArrayList dependencies = new ArrayList();
        try {
            manifest.getDependencies(component, dependencies);
        }
        catch (Exception exception) {}
        for (ComponentType dep : dependencies) {
            if (remIds.contains(dep.getId())) continue;
            Integer value = 0;
            if (counts.containsKey(dep)) {
                value = counts.get(dep);
                value = value + 1;
            }
            counts.put(dep, value);
        }
    }

    private void addPeripheralComponents(IProject project, List<String> addIds) {
        Map peripheralsComponents;
        Controller controllerInstance = Controller.getInstance();
        if (controllerInstance.isMcuSupported() && !(peripheralsComponents = controllerInstance.getPeripheralsForComponents(addIds)).isEmpty()) {
            LinkedHashMap selectedPeripherals = new LinkedHashMap();
            peripheralsComponents.keySet().forEach(x -> {
                if (peripheralsComponents.get(x) == null) {
                    selectedPeripherals.put(x, null);
                }
            });
            if (peripheralsComponents.size() == selectedPeripherals.size()) {
                controllerInstance.createComponentInstance(selectedPeripherals);
            } else {
                Shell parentShell = Display.getDefault().getActiveShell();
                ComponentPeripheralsDialog addDialog = new ComponentPeripheralsDialog(parentShell, peripheralsComponents);
                if (addDialog.open() == 0) {
                    controllerInstance.createComponentInstance(addDialog.getResult());
                }
            }
        }
    }

    private void removePeripheralComponents(IProject project, List<String> remIds) {
        Controller controllerInstance = Controller.getInstance();
        if (controllerInstance.isMcuSupported()) {
            controllerInstance.removeComponentsSwCompInstances(remIds);
        }
    }
}

