/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.wizards.processordata;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISWToolsDataFolderInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.framework.ui.newconfig.ProcessorMergeHelper;
import com.nxp.swtools.framework.ui.newconfig.ProcessorNode;
import com.nxp.swtools.framework.ui.newconfig.ProcessorProvider;
import com.nxp.swtools.framework.ui.newconfig.ProductSupportsProcessor;
import com.nxp.swtools.framework.ui.newconfig.containers.ProcessorSelectionContainer;
import com.nxp.swtools.provider.processors.OnlineDataInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class ExportImportProcessorDataUtils {
    public static final String[] ZIP_EXTENSIONS = new String[]{"*.zip"};
    public static final String DEFAULT_ARCHIVE_NAME = "exported_data.zip";

    private static ProductSupportsProcessor getProductSupportsProcessorProvider() {
        return master -> {
            ProcessorMergeHelper helper = new ProcessorMergeHelper(SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools(), new OnlineDataInfo());
            return helper.isProcessorForProduct(master);
        };
    }

    public static CheckboxTreeViewer createTreeWithProcessorData(Composite parent, @Nullable ISupportedDerivativesForSwTools initialInput) {
        CheckboxTreeViewer viewer = new CheckboxTreeViewer(parent);
        Tree tree = viewer.getTree();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)viewer);
        tree.setToolTipText("");
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        ProcessorProvider processorProvider = new ProcessorProvider(new OnlineDataInfo(), p -> true, b -> true, b -> false, ExportImportProcessorDataUtils.getProductSupportsProcessorProvider(), true);
        viewer.setContentProvider((IContentProvider)processorProvider);
        ProcessorSelectionContainer.createNameColumn((TreeViewer)viewer, SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools());
        ProcessorSelectionContainer.createSdkVersionColumn((TreeViewer)viewer);
        viewer.setAutoExpandLevel(2);
        if (initialInput != null) {
            viewer.setInput((Object)initialInput);
        }
        return viewer;
    }

    public static Object[] getSelection(CheckboxTreeViewer viewer) {
        return Arrays.stream(viewer.getCheckedElements()).filter(Objects::nonNull).filter(o -> !(o instanceof ProcessorNode)).toArray();
    }

    public static Collection<@NonNull ISWToolsDataFolderInfo> convertSelectionToSWToolsData(Object[] selection, ISupportedDerivativesForSwTools derivatives) {
        ArrayList<ISWToolsDataFolderInfo> dataToExport = new ArrayList<ISWToolsDataFolderInfo>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                Object obj;
                block9: {
                    obj = objectArray[n2];
                    if (!(obj instanceof ITemplateInfo)) break block9;
                    ITemplateInfo template = (ITemplateInfo)obj;
                    switch (template.getTemplateType()) {
                        case ttBoard: {
                            derivatives.getAllBoardsInfos().stream().filter(b -> template.getId().equals(b.getId())).forEach(dataToExport::add);
                            break block10;
                        }
                        case ttKit: {
                            derivatives.getAllKitsInfos().stream().filter(k -> template.getId().equals(k.getId())).forEach(dataToExport::add);
                            break block10;
                        }
                        default: {
                            assert (false) : "unsupported type";
                            break block10;
                        }
                    }
                }
                if (obj instanceof IProcessorMasterToolInfo) {
                    IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)obj;
                    derivatives.getProcessorMasterToolInfos(info.getId()).filter(p -> p.getSWToolsDataFolderID().equalsIgnoreCase(info.getSWToolsDataFolderID())).forEach(dataToExport::add);
                } else assert (false) : "Unsupported object to export";
            }
            ++n2;
        }
        return dataToExport;
    }

    @Deprecated
    public static Collection<IConfigComponentInfo> getComponentsForData(Collection<IConfigComponentInfo> components, Collection<ISWToolsDataFolderInfo> data) {
        Set sdkVersions = data.stream().map(ISWToolsDataFolderInfo::getSWToolsDataFolderID).collect(Collectors.toSet());
        return components.stream().filter(it -> sdkVersions.contains(it.getSdkVersion())).collect(Collectors.toList());
    }
}

